static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  萔̈l                                           *
*                                                                             *
*      ֐@@@F@int cl_const_mem_get( pCnCB ,Len )			          *
*                      (O)ConstCB	*pCnCB	                                  *
*                      (I)int		Len                                       *
*                                                                             *
*            F@Ȃ                                                   *
*                                                                             *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

extern CLPRTBL *pCLprocTable;

/****************************************/
/*										*/
/****************************************/
char *cl_const_malloc(Len)
int		Len;
{
	if (!pCLprocTable->ConstCt) {
		pCLprocTable->ConstCt = cl_const_ct_new();
		if (!pCLprocTable->ConstCt) return NULL;
	}
	return akxm_cct_malloc(pCLprocTable->ConstCt,Len);
}

/****************************************/
/*										*/
/****************************************/
char *cl_const_ct_malloc(ConstCt,Len)
ConstantCt *ConstCt;
int		Len;
{
	return akxm_cct_malloc(ConstCt,Len);
}

/****************************************/
/*										*/
/****************************************/
ConstantCt *cl_const_ct_new()
{
	return akxm_cct_mem_new(0);
/*	return akxm_cct_mem_new_opt(0,1);	*/
}

/****************************************/
/*										*/
/****************************************/
ConstantCt *cl_const_ct_new_opt(opt)
int opt;
{
	return akxm_cct_mem_new_opt(0,opt);
}

static ConstantCt TmpConstCt = {NULL,NULL,AKX_CNBD_SIZE};
static ConstantCt *pTmpConstCt = NULL;

/****************************************/
/*										*/
/****************************************/
int cl_tmp_const_ct_set(pConstCt)
ConstantCt *pConstCt;
{
	pTmpConstCt = pConstCt;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static char *_tmp_const_malloc_opt(mem,len,opt)
char *mem;
int len,opt;
{
	ProcCT *proc;

	if (!pTmpConstCt) {
		if (proc = cl_search_proc_ct()) {
			if (!(pTmpConstCt = proc->pTmpConstCt)) {
				if (!(pTmpConstCt = cl_const_ct_new_opt(0))) return NULL;
/*
printf("_tmp_const_malloc_opt: pTmpConstCt=%08x\n",pTmpConstCt);
*/
				proc->pTmpConstCt = pTmpConstCt;
			}
		}
		else pTmpConstCt = &TmpConstCt;
	}
DEBUGOUTL3(195,"cl_tmp_const_malloc: pTmpConstCt=%08x len=%d opt=%08x",pTmpConstCt,len,opt);
	if (opt == 1)
		akxm_cct_mem_reget(pTmpConstCt,len,&mem);
	else if (opt == 2)
		akxm_cct_mem_put(pTmpConstCt,mem);
	else
		mem = akxm_cct_malloc(pTmpConstCt,len);
	if (pTmpConstCt == &TmpConstCt) pTmpConstCt = NULL;
	return mem;
}

/****************************************/
/*										*/
/****************************************/
char *cl_tmp_const_malloc(len)
int len;
{
	return _tmp_const_malloc_opt(NULL,len,0);
}

/****************************************/
/*										*/
/****************************************/
char *cl_tmp_const_remalloc(mem,len)
char *mem;
int len;
{
	return _tmp_const_malloc_opt(mem,len,1);
}

/****************************************/
/*										*/
/****************************************/
char *cl_tmp_const_free(mem)
char *mem;
{
	return _tmp_const_malloc_opt(mem,0,2);
}

/****************************************/
/*										*/
/****************************************/
int cl_tmp_const_clear(iopt)
int iopt;	/* 0/1/2:no free/free/free TmpConstCt */
{
	tdtCMBCTL *cmb,*cmb1;
	ProcCT *proc;
	int n,len=0;
	tdtCONSTCT *pConstCtW;

	if (iopt == 2) {
		pConstCtW = pTmpConstCt;
		pTmpConstCt = &TmpConstCt;
	}
	else if (!pTmpConstCt) {
		if (proc = cl_search_proc_ct()) pTmpConstCt = proc->pTmpConstCt;
		else pTmpConstCt = &TmpConstCt;
	}

	cmb = pTmpConstCt->cct_top;
	while (cmb) {
		n = cmb->cbc_rem;
		cmb1 = cmb->cbc_next;
		if (iopt >= 1) {
			len += n;
			Free(cmb);
		}
		else {
			len += cmb->cbc_msize - n;
			cmb->cbc_rem = cmb->cbc_msize;
		}
		cmb = cmb1;
	}
	if (iopt >= 1) {
		pTmpConstCt->cct_top  = NULL;
		pTmpConstCt->cct_cur  = NULL;
	}
	if (iopt == 2) pTmpConstCt = pConstCtW;
	if (pTmpConstCt == &TmpConstCt) pTmpConstCt = NULL;
	return len;
}

/****************************************/
/*										*/
/****************************************/
char *cl_scr_const_malloc(no,iLen)
int no,iLen;
{
	char *p = NULL;
	ScrPrCT *scrprct;
	ConstantCt *pCt,**ppCt;

	if (scrprct = cl_search_src_ct()) {
/*
printf("cl_scr_const_malloc: no=%d iLen=%d scr=%08x\n",no,iLen,scrprct);
*/
		if (no==1) ppCt=&scrprct->ConstCt;
		else if (no==2) ppCt=&scrprct->LeafConstCt;
		else return cl_tmp_const_malloc(iLen);
		pCt = *ppCt;
		if (!pCt) {
			if (pCt = cl_const_ct_new()) {
				*ppCt = pCt;
/*
printf("cl_scr_const_malloc: pCt=%08x ConstCt=%08x LeafConstCt=%08x\n",
pCt,scrprct->ConstCt,scrprct->LeafConstCt);
*/
			}
			else {
				return NULL;
			}
		}
		p = cl_const_ct_malloc(pCt,iLen);
	}
	else {
		p = cl_tmp_const_malloc(iLen);
	}
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *cl_scr_malloc(iLen)
int iLen;
{
	return cl_scr_const_malloc(1,iLen);
}

/****************************************/
/*										*/
/****************************************/
char *cl_leaf_malloc(iLen)
int iLen;
{
	return cl_scr_const_malloc(2,iLen);
}

/****************************************/
/*										*/
/****************************************/
char *cl_opt_malloc(im,iLen)
int im,iLen;
{
	char *p;

	if (iLen <= 0) return NULL;
	if      (im == D_OPT_ALC_LEAF  ) p = cl_leaf_malloc(iLen);		/* 0 */
	else if (im == D_OPT_ALC_CONST ) p = cl_const_malloc(iLen);		/* 1 */
	else if (im == D_OPT_ALC_SCR   ) p = cl_scr_malloc(iLen);		/* 2 */
	else if (im == D_OPT_ALC_TMP   ) p = cl_tmp_const_malloc(iLen);	/* 3 */
	else if (im == D_OPT_ALC_MALLOC) p = Malloc(iLen);				/* 4 */
	else p = NULL;
DEBUGOUTL3(200,"cl_opt_malloc:im=%d p=%08x len=%d",im,p,iLen);
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *clmemdup(s,slen,im)
char *s;
int  slen,im;
{
	char *p;

	if (s) {
		if (p = cl_opt_malloc(im,slen+1))
			memzcpy(p,s,slen);
	}
	else p = NULL;
	return p;
}

/****************************************/
/*										*/
/****************************************/
char *clstrdup(s,im)
char *s;
int  im;
{
	if (s)
		return clmemdup(s,strlen(s),im);
	else
		return NULL;
}

/****************************************/
/*										*/
/****************************************/
int cl_opt_mem_used(im)
int im;
{
	ConstantCt *p;
	ScrPrCT *scrprct;
	int len;

	len = 0;
	p = NULL;
	if (im==D_OPT_ALC_LEAF || im==D_OPT_ALC_SCR) {
		if (scrprct=cl_search_src_ct()) {
			if (im == D_OPT_ALC_LEAF) p = scrprct->LeafConstCt;
			else p = scrprct->ConstCt;
		}
	}
	else if (im == D_OPT_ALC_CONST) p = pCLprocTable->ConstCt;
	else if (im == D_OPT_ALC_TMP) p = pTmpConstCt;
	else if (im == D_OPT_ALC_MALLOC) len = akxm_stat_memory(0,NULL);
	else len = -1;
	if (p) len = akxm_cct_mem_used(p);
/*
printf("cl_opt_mem_used: im=%d len=%d\n",im,len);
*/
	return len;
}

/****************************************/
/*										*/
/****************************************/
int cl_mem_used(n,lena)
int n,lena[];
{
	int i,rc,len;

	rc = 0;
	if (lena) {
		for (i=0;i<n;i++) {
			len = cl_opt_mem_used(i);
			rc += X_MAX(0,len);
			lena[i] = len;
		}
	}
	else rc = -1;
	return rc;
}
