static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akalib2.c
 *
 *        coded by A.Kobayashi 96/1/29
 *
 *************************************************/
#include "akacommon.h"

extern int akb_head_check();

tdtMSG_CTL          tMsgCtl     = {-1};
tdtCLASS_CTLHead    tClassHead  = {0,0,NULL};
tdtSTATISTICS      tStatistics,tStat2;
tdtHYP_CHANNEL      tHypChannel;

static tdtCOMM_PACK_HEAD  *gtpChannelWPH;
static char *nullstring="";
static char *nullname=AKX_NULL_PRINT;
static void (*gpAlarmFunc)() = SIG_ERR;
static void (*gpBPipeFunc)() = SIG_ERR;
static tdtGENERAL_DATA gtDataQueUsed;
static int giMemCtl = 0;

static void instance_free();
static void class_free();
static int _close_sd_func();
static int  set_up_recv_proc_id();
static int  sys_init_ch_open();
static int  sys_memory_class();

void aka_wait_packet_free();
INT4 aka_get_pr_host_id();

/********************************************************/
/*                                                      */
/********************************************************/
int aka_initialize_p(nParm,iParm)
int nParm,iParm[];
{
	int  iSd           ;	/* ڑ\Pbg̔ԍ */
	int  iProcNumber   ;	/* vZXԍ */
	int  iMaxThreadTotal;	/* NX̃bZ[W鑽dx̍vől
	                     	   ÔƂ́ANX̐ݒɏ] */
	int iRc,i;
	char cProcName[D_RECORD_BUFSIZE];
	int n,parm[2],*pp;
	tdtCHANNEL *pCh;

	if (tMsgCtl.sd>=0) return -18502101;
	iSd  = iProcNumber = iMaxThreadTotal = 0;
	if (nParm > 0) iSd             = iParm[0];
	if (nParm > 1) iProcNumber     = iParm[1];
	if (!iSd && iProcNumber<=0) iProcNumber = 100;	/* dummy */
	if (iSd<0 || iProcNumber<1 || iProcNumber>D_PRID_MAX) return -18502102;
	memset(&tMsgCtl,0,sizeof(tdtMSG_CTL));
	if (nParm > 2) iMaxThreadTotal = iParm[2];
	if (nParm > 3) tMsgCtl.msg_opt = iParm[3];
	tMsgCtl.sd = -1;
/*
	if (!(tMsgCtl.host_id = aka_get_pr_host_id())) return -18502103;
*/
	tMsgCtl.host_id = aka_get_pr_host_id();
	if (!(tMsgCtl.my_host_id = aka_get_my_host_id())) return -18502108;
	if ((iRc = akb_get_my_apsys_id())<0) return -18502109;
	tMsgCtl.apsys_id = iRc;
	iRc = aka_get_regist_pid();
	if (iRc <= 0) aka_set_regist_pid(iProcNumber);
	else if (iRc != iProcNumber) return -18502107;
	tMsgCtl.sd           = iSd;
	tMsgCtl.proc         = iProcNumber;
	tMsgCtl.us_proc        = iProcNumber;
	tMsgCtl.regist_dest_pid = aka_get_regist_dest_pid();

	aka_init_status(AKA_IST_INITIALIZED,1);

#if 0	/* 2000.7.31 Koba */
	tMsgCtl.start_tv_sec = 0;
#else
	if (!(tMsgCtl.timer_ctl = akxe_timer_new())) return -18502106;
#endif
	if (aka_get_msec(0)<0) return -18502105;
	tMsgCtl.send_msg_time_out = 30000;	/* milli second */
	tMsgCtl.send_msg_min_wait = -1;	/* milli second */
	tMsgCtl.get_msg_wait_time = 0;
	timerclear(&tMsgCtl.get_msg_time_out);
	tMsgCtl.wqsuspend = 0;
	tMsgCtl.shut_mode = 0;
	tMsgCtl.shut_suspend = 0;
	tMsgCtl.rsv1 = 0;	/* message read/write flag */
	tMsgCtl.rsv2 = 0;	/* PRINTOUT LEVEL */
	if (!(tMsgCtl.spool_dir = akb_akb_home(0)))
		tMsgCtl.spool_dir = nullstring;

	/* RWQueTimeOut̐ݒ */
	pp = NULL;
	if ((n = aka_rwque_get_akb_time_out(parm)) > 0) {
		if (n >= 2) pp = parm;
		tMsgCtl.msg_opt |= AKA_MSO_RWQ_TIMEOUT;
	}
	if (tMsgCtl.msg_opt & AKA_MSO_RWQ_TIMEOUT) {
		tMsgCtl.rwqtime_out =
			aka_rwque_time_out_new(AKA_CHANNEL_INIT,pp /* ,akb_rwqttimer */);
	}

	tMsgCtl.channel_max = 0;
	iRc = aka_expand_tables(AKA_CHANNEL_INIT);
	if (iRc) -18502110;

	aka_init_zero(iSd);
	if (pCh = tMsgCtl.channel_pa[0]) {
		pCh->head_check = akb_head_check;
		pCh->head_len = sizeof(tdtCOMM_PACK_HEAD);
		pCh->status = 1;
		tMsgCtl.channel_used = 1;
	}

	/* HyperChannel Initialize */
	tMsgCtl.hyp_channel = &tHypChannel;
	memset(tMsgCtl.hyp_channel,-1,sizeof(tdtHYP_CHANNEL));
	tMsgCtl.hyp_channel->hyp_cha_used = 0;

	/* New Ring Buff */
	tMsgCtl.rb_rctl  = akxs_rb_init(0,0);
	tMsgCtl.rb_wctl  = akxs_rb_init(0,0);
	tMsgCtl.rb_wwctl = akxs_rb_init(0,0);
	tMsgCtl.rb_dwctl = akxs_rb_init(0,0);

	/* New Read Wait L[ */
	tMsgCtl.que_rwctl = akxs_que_init(0,0);

	if (!tMsgCtl.rb_rctl || !tMsgCtl.rb_wctl || !tMsgCtl.rb_wwctl ||
	    !tMsgCtl.que_rwctl) return -18502104;

	tClassHead.max_thread_total = iMaxThreadTotal;
	tClassHead.class       = NULL;

	memset(&tStatistics,0,sizeof(tdtSTATISTICS));
	memset(&tStat2,0,sizeof(tdtSTATISTICS));

	if (iRc = aka_regist_sys_class()) return iRc;

	if (!akb_log_get_proc_name()) {
		akb_log_set_proc_name(akb_get_proc_name(iProcNumber,cProcName));
	}

	aka_set_up_msg_time_out(akb_log_get_proc_name());

	gpAlarmFunc = signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	gpBPipeFunc = signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_init_zero(iSd)
int iSd;
{
	tdtRW_QUE     *pRQ,*pWQ;
	tdtCHANNEL *pCh;
	struct stat tStat;
	int fd;

	if (iSd < 0) return -18503501;
	if (!(pCh = tMsgCtl.channel_pa[0]))  return -18503502;
	if (!(pRQ = tMsgCtl.read_que_pa[0]))  return -18503503;
	if (!(pWQ = tMsgCtl.write_que_pa[0])) return -18503504;

	if (pRQ->rwq_sd>=0 || pWQ->rwq_sd>=0) return -18503505;

	tMsgCtl.sd = pCh->sd = iSd;
	if (!(fd=iSd)) {
		iSd = -1;
		if (!fstat(fd,&tStat)) {
			if (S_ISSOCK(tStat.st_mode)) iSd = 0;
		}
	}
	pRQ->rwq_sd = pWQ->rwq_sd = iSd;
	if (!tMsgCtl.host_id) tMsgCtl.host_id = tMsgCtl.my_host_id;

	if (tMsgCtl.host_id != tMsgCtl.my_host_id) {
		pRQ->rwq_option = AKB_RQUE_OPT_XTOF;
		pWQ->rwq_option = AKB_WQUE_OPT_MAKE_XPACK;
	}
	else {
		pRQ->rwq_option = AKB_RQUE_OPT_INDIR;
		pWQ->rwq_option = AKB_WQUE_OPT_MAKE_INDIR;
	}

	if (tMsgCtl.msg_opt & AKA_MSO_NEED_REPLY) {
		pRQ->rwq_option |= AKB_RWQUE_OPT_NEED_REPLY;
		pWQ->rwq_option |= AKB_RWQUE_OPT_NEED_REPLY;
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
void  aka_terminate()
{
	int i;
	tdtCHANNEL *pCh,**ppCh;
	tdtRW_QUE     **ppRQ,**ppWQ,*pQT;

	if (tMsgCtl.sd<0) return;

	tMsgCtl.sd   = -1;
	tMsgCtl.proc = 0;
	tMsgCtl.us_proc = 0;
	aka_init_status(AKA_IST_INITIALIZED,-1);

	/* NX\̊J */
	class_free(tClassHead.class);
	tClassHead.class = NULL;

	ppCh = tMsgCtl.channel_pa;
	ppRQ = tMsgCtl.read_que_pa;
	ppWQ = tMsgCtl.write_que_pa;
	for (i=0;i<tMsgCtl.channel_max;i++,ppCh++,ppRQ++,ppWQ++) {
		/* `lN[YƊJ */
		if (pCh = *ppCh) {
			if (i>0 && pCh->status && pCh->sd > 0) {
				aka_channel_close(i);
			}
#ifndef NO_CHANNEL_QUE
			akxs_que_free(pCh->wpack_que);
#endif
			aka_channel_free(pCh,1);
		}
		/* L[obt@̊J */
		if (pQT = *ppRQ) {
			akb_free_que(1,pQT);
			Free(pQT);
		}
		if (pQT = *ppWQ) {
			akb_free_que(1,pQT);
			Free(pQT);
		}
	}
	if (tMsgCtl.channel_pa)  Free(tMsgCtl.channel_pa);
	if (tMsgCtl.read_que_pa)  Free(tMsgCtl.read_que_pa);
	if (tMsgCtl.write_que_pa) Free(tMsgCtl.write_que_pa);
	tMsgCtl.channel_pa  = NULL;
	tMsgCtl.read_que_pa  = NULL;
	tMsgCtl.write_que_pa = NULL;

	/* Oobt@ƃO̊J */
	akxs_rb_all_free(tMsgCtl.rb_rctl);
	akxs_rb_all_free(tMsgCtl.rb_wctl);
	akxs_rb_all_free(tMsgCtl.rb_wwctl);
	akxs_rb_all_free(tMsgCtl.rb_dwctl);

	/* WaitL[̊J */
	akxs_que_all_free(tMsgCtl.que_rwctl);

	tMsgCtl.rb_rctl  = NULL;
	tMsgCtl.rb_wctl  = NULL;
	tMsgCtl.rb_wwctl = NULL;
	tMsgCtl.que_rwctl = NULL;

	if (tMsgCtl.timer_ctl) {
		akxe_timer_free(tMsgCtl.timer_ctl);
		tMsgCtl.timer_ctl = NULL;
	}

	if (gpAlarmFunc != SIG_ERR) signal(SIGALRM, gpAlarmFunc);
	if (gpBPipeFunc != SIG_ERR) signal(SIGPIPE, gpBPipeFunc);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_register_class(pFuncName,iClassId,iInstanceDataSize,iMaxThread,iOption)
int (*pFuncName)();
int  iClassId     ;
int  iInstanceDataSize;
int  iMaxThread   ;
int  iOption      ;
{
	return aka_register_class3(pFuncName,iClassId,iInstanceDataSize,iMaxThread,
	                         iOption,nullname,NULL);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_register_class2(pFuncName,iClassId,iInstanceDataSize,iMaxThread,iOption,
                     cpClassName)
int (*pFuncName)();
int  iClassId     ;
int  iInstanceDataSize;
int  iMaxThread   ;
int  iOption      ;
char *cpClassName ;
{
	return aka_register_class3(pFuncName,iClassId,iInstanceDataSize,iMaxThread,
	                         iOption,cpClassName,NULL);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_register_class3(pFuncName,iClassId,iInstanceDataSize,iMaxThread,iOption,
                     cpClassName,cpUserArea)
int (*pFuncName)();	/* bZ[W֐ւ̃|C^ */
int  iClassId     ;	/* ֐̃NXʔԍ
                                0:	ʃvbgtH[piݒsj
                    65280 - 65535:	boeR}hp */
int  iInstanceDataSize;	/* P̏ŎgpϐGÃTCYioCgj */
int  iMaxThread   ;	/* bZ[W鑽dx̍ől */
int  iOption      ;	/* Prbg@PԐMpPbg󂯂Ȃ */
char *cpClassName;	/* NX */
char *cpUserArea;	/* [Ü */
{
	tdtCLASS_CTL *curr,*next;
	tdtINSTANCE *tpIns;
	int i,ret,iFUNC2;

	if (tMsgCtl.sd<0) return -18502301;

	if (!(iOption & AKA_RCO_SYS_CLASS) && !pFuncName) {
		ERROROUT("֐mtkk");
		return -18502302;
	}
	iFUNC2 = iClassId & AKA_CLASS_ADDFUNC2;
	iClassId &= ~AKA_CLASS_ADDFUNC2;
	if (iClassId<=0 || iClassId>AKA_CLASS_BASE) {
		ERROROUT("NXhc͈͊O");
		return -18502303;
	}
	if (iInstanceDataSize<0) {
		ERROROUT("CX^Xf[^TCY");
		return -18502304;
	}
#if 1	/* add 2002.9.27 Koba */
	if (iMaxThread<1 && !iFUNC2) {
#else
	if (iMaxThread<1) {
#endif
		if (tClassHead.max_thread_total<1) {
			ERROROUT("sns`kdxP");
			return -18502305;
		}
		iMaxThread = tClassHead.max_thread_total;
	}
	next = tClassHead.class;
	while (next) {
		curr = next;
		if (curr->class_id == iClassId) break;
		next = curr->class_next;
	}
	if (next) {
#if 1	/* add 2002.9.27 Koba */
		if (iFUNC2) {
			tpIns = next->instance;	/* 2008.10.31 Koba */
			if ((iInstanceDataSize > 0) || (iMaxThread > next->max_thread)) {
				if (tpIns) {
					for (i=0;i<next->max_thread;i++) aka_instance_buf_free(&tpIns[i]);
				}
				if (iMaxThread > next->max_thread) {
					if (tpIns) Free(tpIns);
					if (!(tpIns = (tdtINSTANCE *)Malloc(iMaxThread*
					                  sizeof(tdtINSTANCE)))) return -18502307;
					next->instance = tpIns;
					next->max_thread = iMaxThread;
				}
				for (i=0;i<next->max_thread;i++) {
					ret = aka_instance_init(0,&tpIns[i],
					 ((next->instance_data_size+15) & ~0x0f)+iInstanceDataSize);
					if (ret) return ret;
				}
			}
			if (iOption >= 0) next->option = iOption;
			next->func_name2 = pFuncName;
			if (cpClassName) next->class_name2 = Strdup(cpClassName);
			next->instance_data_size2 = iInstanceDataSize;
			tpIns[0].recv_msg_com->msg_disp = AKA_REGIST_CLASS;
			ret = pFuncName(iClassId,cpUserArea,tpIns[0].recv_msg_com);
			return ret;
		}
#endif
		if (next->instance)
			instance_free(next->instance,next->max_thread);
	}
	else {
#if 1	/* add 2002.9.27 Koba */
		if (iFUNC2) return -18502313;
#endif
		if (!(next=(tdtCLASS_CTL *)Malloc(sizeof(tdtCLASS_CTL)))) {
			return -18502306;
		}
		memset(next,0,sizeof(tdtCLASS_CTL));	/* add 2000.4.10 Koba */
		if (!tClassHead.class) tClassHead.class = next;
		else curr->class_next = next;
	}
	next->func_name         = pFuncName;
	next->class_id          = iClassId;
	next->instance_data_size = iInstanceDataSize;
	next->max_thread        = iMaxThread;
	next->option           = iOption;
/*	next->cpClassName       = cpClassName;	 add 2000.9.1 Koba */
	if (cpClassName) next->class_name = Strdup(cpClassName);
											/* add 2002.9.27 Koba */
/*** del 2000.4.10 Koba
	next->class_next       = NULL;
***/
	next->packet_number     = 0;
	next->used_count        = 0;
#ifdef TP_MON
	next->max_exec_thread   = next->max_thread;
	next->used_exec_count   = 0;
	if (!(next->msg_que = akxs_rb_init(0,0))) return -18502311;
#endif
	if (!(tpIns = (tdtINSTANCE *)Malloc(iMaxThread*sizeof(tdtINSTANCE)))) {
		return -18502307;
	}
	next->instance = tpIns;
	for (i=0;i<iMaxThread;i++) {
#if 0	/* del 2000.3.30 Koba */
		tpIns[i].used = 0;
		tpIns[i].wait_next = NULL;
		tpIns[i].to_free   = NULL;
#ifndef NO_RECVMSG
		if (!(tpIns[i].pRbToFree  = akxs_rb_init(0,0))) return -18502312;
#endif
		if (iInstanceDataSize>0) {
			if (!(tpIns[i].instance_data = Malloc(iInstanceDataSize))) {
				return -18502308;
			}
		}
		else tpIns[i].instance_data = NULL;
		if (!(tpIns[i].recv_msg_com =
		       (AKAMSGCOM *)Malloc(sizeof(AKAMSGCOM)+256*sizeof(char *)))) {
			return -18502309;
		}
		memset(tpIns[i].recv_msg_com,0,sizeof(AKAMSGCOM));
		if (!(tpIns[i].pack_head =
		        (tdtCOMM_PACK_HEAD *)Malloc(sizeof(tdtCOMM_PACK_HEADA)))) {
			return -18502310;
		}
#else
		if (ret = aka_instance_init(0, &tpIns[i], iInstanceDataSize)) return ret;
#endif
	}
	if (next->option & AKA_RCO_RECVPROC) {
		if (set_up_recv_proc_id(next,akb_log_get_proc_name()) < 0) return -18502313;
	}

	tpIns[0].recv_msg_com->msg_disp = AKA_REGIST_CLASS;
/*
printf("RegisterClass3: iClassId=%d cpUserArea=%08x\n",iClassId,cpUserArea);
if (cpUserArea) printf("                cpUserArea=[%s]\n",cpUserArea);
*/
	ret = pFuncName(iClassId,cpUserArea,tpIns[0].recv_msg_com);

	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_instance_buf_free(tpIns)
tdtINSTANCE *tpIns;
{
	char *p;
	tdtWAIT_METHOD *pNext,*pWait;

	if (!tpIns) return -1;
	if (tpIns->instance_data) Free(tpIns->instance_data);
	aka_wait_packet_free(tpIns->wait_next);
	if (tpIns->recv_msg_com)   Free(tpIns->recv_msg_com);
	if (tpIns->pack_head)     Free(tpIns->pack_head);
	if (tpIns->to_free)       Free(tpIns->to_free);
	if (tpIns->rb_com_object) {
		while (p=akxs_rb_get_n(tpIns->rb_com_object)) aka_free_com_object_sub(p,0);
		akxs_rb_free(tpIns->rb_com_object);
	}
	if (tpIns->comment)      Free(tpIns->comment);
	pWait = tpIns->wait_method;
	while (pWait) {
		pNext = pWait->wait_method;
		Free(pWait);
		pWait = pNext;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static void instance_free(tpIns,iMaxThread)
tdtINSTANCE *tpIns;
int         iMaxThread;
{
	int i;

	for (i=0;i<iMaxThread;i++) {
		aka_instance_buf_free(&tpIns[i]);
	}
	Free(tpIns);
}

/********************************************************/
/*                                                      */
/********************************************************/
static void	class_free(tpClass)
tdtCLASS_CTL *tpClass;
{
	if (tpClass) {
		class_free(tpClass->class_next);
		if (tpClass->class_name)  Free(tpClass->class_name);
		if (tpClass->class_name2) Free(tpClass->class_name2);
		if (tpClass->method) Free(tpClass->method);
		if (tpClass->instance)
			instance_free(tpClass->instance,tpClass->max_thread);
#ifdef TP_MON
		if (tpClass->msg_que) akxs_rb_free(tpClass->msg_que);
#endif
		Free (tpClass);
	}
}

/********************************************************/
/*                                                      */
/********************************************************/
void aka_wait_packet_free(tpWait)
tdtWAIT_PACKET *tpWait;
{
	if (tpWait) {
		aka_wait_packet_free(tpWait->wait_next);
		if (tpWait->wait_packet) Free(tpWait->wait_packet) ;
		Free(tpWait);
	}
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_expand_tables(iAdd)
int iAdd;
{
	tdtRW_QUE         *pQue;
	tdtCHANNEL     *pCh;
	tdtCOMM_PACK_HEAD  *pHead;
	int iMax,iSize,i,n;
	tdtRWQ_TIME_OUT *p;

	if (!tMsgCtl.read_que_pa)  {
		if (!(tMsgCtl.read_que_pa=
			(tdtRW_QUE **)(Malloc(n=sizeof(tdtRW_QUE **)*AKA_CHANNEL_MAX))))
			return -1;
		memset(tMsgCtl.read_que_pa,0,n);
	}
	if (!tMsgCtl.write_que_pa) {
		if (!(tMsgCtl.write_que_pa=
			(tdtRW_QUE **)(Malloc(n=sizeof(tdtRW_QUE **)*AKA_CHANNEL_MAX))))
			return -1;
		memset(tMsgCtl.write_que_pa,0,n);
	}
	if (!tMsgCtl.channel_pa)  {
		if (!(tMsgCtl.channel_pa=
			(tdtCHANNEL **)(Malloc(n=sizeof(tdtCHANNEL **)*AKA_CHANNEL_MAX))))
			return -1;
		memset(tMsgCtl.channel_pa,0,n);
	}

	if (iAdd <= 0) return -1;
	iMax = tMsgCtl.channel_max;
	if (iMax >= AKA_CHANNEL_MAX) return -18502902;
	iSize = iMax + iAdd;
	if (iSize >= AKA_CHANNEL_MAX) {
		iSize = AKA_CHANNEL_MAX;
		iAdd = iSize - iMax;
	}

	for (i=iMax;i<iSize;i++) {
		/* qL[Ǘe[u */
		if (!(pQue=akb_rwque_new(1,1))) goto Err;
		tMsgCtl.read_que_pa[i] = pQue;

		/* vL[Ǘe[u */
		if (!(pQue=akb_rwque_new(1,1))) goto Err;
		tMsgCtl.write_que_pa[i] = pQue;

		/* `lǗe[u */
		if (!(pCh=aka_channel_new(1))) goto Err;
		tMsgCtl.channel_pa[i] = pCh;
		pCh->index = i;
#ifndef NO_CHANNEL_QUE
		if (i > 0) {
			if (!(pCh->wpack_que = akxs_que_init(0,0))) {
				aka_channel_free(pCh,1);
				goto Err;
			}
		}
#endif
	}

/*
	tMsgCtl.iReadQueMax  = iSize;
	tMsgCtl.iWriteQueMax = iSize;
*/
	tMsgCtl.channel_max = iSize;

	if (p=tMsgCtl.rwqtime_out) {
		p->rwt_clsf = _close_sd_func;
		p->rwt_rqto.qto_qmax = tMsgCtl.channel_max;
		p->rwt_rqto.qto_ppqu   = tMsgCtl.read_que_pa;
		p->rwt_wqto.qto_qmax = tMsgCtl.channel_max;
		p->rwt_wqto.qto_ppqu   = tMsgCtl.write_que_pa;
		for (i=0;i<p->rwt_rqto.qto_qmax;i++)
			p->rwt_rqto.qto_ppqu[i]->rwq_wtime = p->rwt_rqto.qto_wait;
		for (i=0;i<p->rwt_wqto.qto_qmax;i++)
			p->rwt_wqto.qto_ppqu[i]->rwq_wtime = p->rwt_wqto.qto_wait;
		gtDataQueUsed.gd_dlen = sizeof(short);
		gtDataQueUsed.gd_scale = 0;
		gtDataQueUsed.gd_resv = 0;
		gtDataQueUsed.gd_data   = (char *)&tMsgCtl.channel_used;
		p->rwt_rqto.qto_used = &gtDataQueUsed;
		p->rwt_wqto.qto_used = &gtDataQueUsed;
	}

	return 0;
Err:
	akb_rwque_time_out_free(tMsgCtl.rwqtime_out);
	return -1;
}

/********************************************************/
/* iOpt = 0 : NAƗ̈m                          */
/* iOpt = 1 : NÂ                                */
/* iOpt = 2 : ̈mۂĂȂmۂ        */
/*             NA͂Ȃ                           */
/********************************************************/
int aka_instance_init(iOpt, tpIns, iInstanceDataSize)
int         iOpt;
tdtINSTANCE *tpIns;
int         iInstanceDataSize;
{
	int iFlg;

	if (iOpt != 2) memset(tpIns,0,sizeof(tdtINSTANCE));
	if (iOpt == 1) return 0;
/***
	iFlg = 1;
	if (iOpt==2 && tpIns->rb_com_object) iFlg = 0;
	if (iFlg) {
		if (!(tpIns->rb_com_object = akxs_rb_init(0,0))) return -18503001;
	}
***/
	if (iInstanceDataSize>0) {
		iFlg = 1;
		if (iOpt==2 && tpIns->instance_data) iFlg = 0;
		if (iFlg) {
			if (!(tpIns->instance_data = Malloc(iInstanceDataSize))) {
				return -18503002;
			}
		}
	}
	iFlg = 1;
	if (iOpt==2 && tpIns->recv_msg_com) iFlg = 0;
	if (iFlg) {
		if (!(tpIns->recv_msg_com =
		       (AKAMSGCOM *)Malloc(sizeof(AKAMSGCOM)+256*sizeof(char *)))) {
			return -18503003;
		}
		memset(tpIns->recv_msg_com,0,sizeof(AKAMSGCOM));
	}
	iFlg = 1;
	if (iOpt==2 && tpIns->pack_head) iFlg = 0;
	if (iFlg) {
		if (!(tpIns->pack_head =
	   	     (tdtCOMM_PACK_HEAD *)Malloc(sizeof(tdtCOMM_PACK_HEADA)))) {
			return -18503004;
		}
		memset(tpIns->pack_head,0,sizeof(tdtCOMM_PACK_HEADA));
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_conv_inst_hndl2(lInstanceHandle, tpInstHndl, iOpt)
long        lInstanceHandle;
tdtINST_HNDL *tpInstHndl;
int         iOpt;
{
	int             iThread,iClassId;
	tdtCLASS_CTL     *tpClass;
	tdtINSTANCE     *tpIns;
	tdtINST_HNDL2    *tpInstHndl2;

	if (!tpInstHndl) return -1;
	memset(tpInstHndl,0,sizeof(tdtINST_HNDL));
	if (lInstanceHandle) {
		/* NXƃXbhm̎o */
#ifdef LINUX
		tpInstHndl->thread  = iThread  = (lInstanceHandle>>16) & 0xff;
		tpInstHndl->class_id = iClassId = lInstanceHandle & 0xffff;
#else
		tpInstHndl2 = (tdtINST_HNDL2 *)tpInstHndl;
		tpInstHndl2->instance_handle = lInstanceHandle;
		iThread  = tpInstHndl->thread;
		iClassId = tpInstHndl->class_id;
#endif
#ifdef DEBUG
printf("aka_conv_inst_hndl2: iClassId=%d iThread=%d\n",iClassId,iThread);
#endif
		if (iOpt & 0x10) {
/*
printf("aka_conv_inst_hndl2: call aka_srch_class2(%d,0x%02x)\n",
iClassId,iOpt & 0x01);
*/
			tpInstHndl->class = tpClass = aka_srch_class2(iClassId,iOpt & 0x01);
			if (!tpClass) return -2;
			if (iThread<1 || iThread>tpClass->max_thread) return -3;
			tpInstHndl->instance = tpIns = &tpClass->instance[iThread-1];
			if (!tpIns->used) return -4;
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_conv_inst_hndl(lInstanceHandle, tpInstHndl)
long        lInstanceHandle;
tdtINST_HNDL *tpInstHndl;
{
	return aka_conv_inst_hndl2(lInstanceHandle,tpInstHndl,0x11);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_initialize(iSd,iProcNumber,iMaxThreadTotal)
int  iSd           ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber   ;	/* vZXԍ */
int  iMaxThreadTotal;	/* NX̃bZ[W鑽dx̍vől
                     	   ÔƂ́ANX̐ݒɏ] */
{
	int P[4];

	P[0] = iSd;
	P[1] = iProcNumber;
	P[2] = iMaxThreadTotal;
	P[3] = (aka_get_regist_option() & AKB_REG_OPT_NEED_REPLY) ?
	       AKA_MSO_NEED_REPLY : 0;
/*
printf("aka_initialize: iOption=%08x\n",P[3]);
*/
	return aka_initialize_p(4,P);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_initialize2(iSd,iProcNumber,cpMsg,lMsgLen,iMaxThreadTotal,iMsgOpt)
int  iSd           ;	/* ڑ\Pbg̔ԍ */
int  iProcNumber   ;	/* vZXԍ */
char *cpMsg;
int  lMsgLen;
int  iMaxThreadTotal;	/* NX̃bZ[W鑽dx̍vől
                     	   ÔƂ́ANX̐ݒɏ] */
int  iMsgOpt;
{
#if 0
	int iRc,P[4];

	if (iRc=aka_regist2(iSd,iProcNumber,cpMsg,lMsgLen))
		ERROROUT1("aka_initialize2: aka_regist2 ret=",iRc);
	else {
		P[0] = iSd;
	/*	P[1] = iProcNumber;	*/
		P[1] = aka_get_regist_pid();
		P[2] = iMaxThreadTotal;
		P[3] = iMsgOpt;
		iRc = aka_initialize_p(4,P);
	}
	return iRc;
#else
	long parm2[6];

	if (iSd <= 0) return -1;
	parm2[0] = iSd;
	parm2[1] = iProcNumber;
	parm2[2] = iMaxThreadTotal;
	parm2[3] = iMsgOpt;
	parm2[4] = (long)cpMsg;
	parm2[5] = lMsgLen;
	return aka_initialize3(6,parm2);
#endif
}

/********************************************************/
/*                                                      */
/********************************************************/
void  aka_terminate_ret(iRet)
int  iRet;
{
	if (aka_init_status(AKA_IST_INITIALIZED,0)) aka_terminate();
	if (aka_init_status(AKA_IST_REGISTED,0)) aka_cancel_ret(iRet);
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _close_sd_func(p,iRW,pQT,iTbl)
tdtRWQ_TIME_OUT *p;
tdtQUE_TIME_OUT *pQT;
int iRW,iTbl;
{
	tdtRW_QUE *pQ;
	tdtCHANNEL *pCh;
	int iEvent,iRc=0;

	if (pCh = aka_channel_get(iTbl)) {
		if (iRW == 1) iEvent = 19;
		else iEvent = 20;
		if (pCh->exception) {
			iRc = pCh->exception(iTbl,iEvent);
		}
		if (iRc < 0) iRc = aka_channel_close(iTbl);
		else {
			if (pQ = pQT->qto_ppqu[iTbl]) {
				if (iRc > 0) akb_clear_rwque(pQ,pQ->rwq_sd);
				else  pQ->rwq_tcount = 255;
			}
		}
	}
	else ERROROUT2("_close_sd_func:`lE|C^擾G[ RW=%d Ch=%d",iTbl,iRW);

	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
void  aka_terminate_all(iRet)
int  iRet;
{
	aka_terminate_ret(iRet);
	if (aka_init_status(AKA_IST_CONNECTED,0)) aka_shut_down2();
	if (giMemCtl) PRINTOUT1("nofree=%d\n",Nofree(0));
}

/********************************************************/
/*                                                      */
/********************************************************/
static char *_mk_msg(cpMsg,ipMsgLen,cpProc)
char *cpMsg;
int  *ipMsgLen;
char *cpProc;
{
	char *p,*key;
	int msglen,len,keylen;

	key = "program:";
	keylen = strlen(key);
	p = cpMsg;
	if (ipMsgLen) msglen = *ipMsgLen;
	if (!ipMsgLen || msglen<0) {
		if (p) msglen = strlen(p);
		else msglen = 0;
	}
	if (p) {
		if (akxs_in_mem_opt(p,msglen,key,keylen,0x01)) return p;
	}
	if (!cpProc) cpProc = AKX_NULL_PRINT;
	len = msglen + strlen(cpProc) + keylen + 2;
	if (p = Malloc(len)) {
		sprintf(p,"%s%s\n",key,cpProc);
		if (cpMsg) memzcpy(p+len-1,cpMsg,msglen);
		if (ipMsgLen) *ipMsgLen = len;
	}
	else p = cpMsg;
	return p;
}

/********************************************************/
/*                                                      */
/********************************************************/
/*	parm[ 0]:	iSd										*/
/*	parm[ 1]:	iProc									*/
/*	parm[ 2]:	iMaxThread								*/
/*	parm[ 3]:	iOpt									*/
/*	parm[ 4]:	cpMsg									*/
/*	parm[ 5]:	iMsgLen									*/
/*	parm[ 6]:	user init Func							*/
/*	parm[ 7]:	cpUserArea								*/
/*	parm[ 8]:	Meminit file name						*/
/*	parm[ 9]:	Connect Host name						*/
/*======================================================*/
int aka_initialize_all(argc,argv,nparm,parm)
int   argc;
char *argv[];
int   nparm;
long  parm[];
{
	int  iSd;	/* ڑ\Pbg̔ԍ */
	int  iProc;	/* vZXԍ */
	char *cpProc,*cpHost,*p,proc_buf[33];
	int  iMaxThread,iMsgLen,iOpt,P[4],iCmd;
	char *cpMsg,*cpUserArea,*service,buf[12],mem_parm[128];
	int  iRc,opt;
	int  (*pFuncName)();
	long parm2[7];

	aka_init_status(0,2);
/*	if (!argv) return -18514201;	*/
	if (nparm>3 && parm) iOpt = parm[3];
	else iOpt = 0;
	cpProc = "";
	iProc = 100;
	if (argc>0 && argv) {
		/****************************************************/
		/* vZXǗNꂽƂ́Aȉn */
		/*   argv[1]:ڑς݂̃\Pbgԍ (Sd)            */
		/*   argv[2]:vZXԍ           (ProcId)        */
		/*   argv[3]:vZX             (ProcName)      */
		/*   argv[4]:p[^             (Parm)          */
		/****************************************************/
		if (argv[0]) cpProc = akxt_get_last_name("\\/",argv[0]);
		if (argc < 3) {
			aka_usage(cpProc);
			if (iOpt & AKA_MSO_NOT_EXIT_USAGE) return -1;
			exit(1);
		}
		if (!argv[1] || !argv[2]) return -18514202;
		if (iRc=akxcgcvn(argv[1],strlen(argv[1]),&iSd)) {
			ERROROUT2("aka_initialize_all: SocketId akxcgcvn(%s) ret=%d",argv[1],iRc);
			return -18514203;
		}
		if (iSd >= 0) {
			if (iRc=akxcgcvn(argv[2],strlen(argv[2]),&iProc)) {
				ERROROUT2("aka_initialize_all: ProcId akxcgcvn(%s) ret=%d",argv[2],iRc);
				return -18514204;
			}
		}
		else service = argv[2];
		if (argc>=4 && argv[3]) cpProc = argv[3];
	}
	else if (nparm>=2 && parm) {
		iSd = parm[0];
		if (iSd >= 0) iProc = parm[1];
		else {
			sprintf(buf,"%d",parm[1]);
			service = buf;
		}
	}
	else return -18514205;

	if (nparm>8 && parm && parm[8]) {
#if 1
		if (parm[8] == -1) {
			if (p=cpProc) opt = 1;
			else if (iProc > 0) {
				opt = 2;
				p = (char *)iProc;
			}
			else opt = -1;
		}
		else {
			opt = 0;
			p = (char *)parm[8];
		}
		if (opt >= 0) akxm_mem_init_opt(opt,p,0);
#else
		if (parm[8] == -1) {
			if (cpProc || iProc>0) {
				if (cpProc) strnzcpy(proc_buf,proc,sizeof(proc_buf)-1);
				else sprintf(proc_buf,"%d",iProc);
				sprintf(mem_parm,
				        "afhash:500\nafdump:mem_%s.log\nnfdump:nof_%s.log\n",
				        proc_buf,proc_buf);
				akxm_mem_initMsg(mem_parm,strlen(mem_parm));
			}
		}
		else Meminit((char *)parm[8]);
#endif
		giMemCtl = 1;
	}

/*	if (*cpProc) */
		akb_log_set_up_name(cpProc);

	iMaxThread = 0;
/*	iOpt = 0;	*/
	iMsgLen = -1;
	cpMsg = NULL;
	pFuncName = NULL;
	cpUserArea = cpProc;
	if (parm) {
		if (nparm > 2) iMaxThread = parm[2];
	/*	if (nparm > 3) iOpt       = parm[3];	*/
		if (nparm > 4) cpMsg   = (char *)parm[4];
		if (nparm > 5) iMsgLen = parm[5];
		if (cpMsg && iMsgLen<0) iMsgLen = strlen(cpMsg);
		if (nparm>6 && parm[6]) pFuncName = (int(*)())parm[6];
		if (nparm > 7) {
			if (!(cpUserArea=(char *)parm[7])) cpUserArea = cpProc;
		}
	}
	cpMsg = _mk_msg(cpMsg,&iMsgLen,cpProc);

	akb_set_sys_com_time_out(cpProc,iOpt & AKA_MSO_SET_TIMEOUT);
/*
	if (*cpProc && (iOpt & AKA_MSO_SET_TIMEOUT)) akb_set_com_time_out(cpProc);
*/
	if (iSd == 0) {
		if (nparm>10 && parm) cpHost = (char *)parm[9];
		else cpHost = NULL;
		iSd = akb_connect_prom_host(0,0,cpHost);
		PRINTOUT1("aka_initialize_all: akb_connectPrmn ret=%d",iSd);
		if (iSd <= 0) return -18514206;
	}

	if (iSd > 0) {
		DEBUGOUT2("aka_initialize_all:Socket=%d, ProcId=%d",iSd,iProc);
		aka_set_connect_sd(iSd);
	}

	if (pFuncName && !(iOpt & AKA_MSO_USER_INIT_LAST)) {
		if (iRc=pFuncName(argc,argv,cpUserArea)) return iRc;
	}

	parm2[0] = iSd;
	parm2[1] = iProc;
	parm2[2] = iMaxThread;
	parm2[3] = iOpt;
	parm2[4] = (long)cpMsg;
	parm2[5] = iMsgLen;
	parm2[6] = (long)service;
	iRc = aka_initialize3(7,parm2);
	if (pFuncName && !iRc && (iOpt & AKA_MSO_USER_INIT_LAST)) {
		iRc = pFuncName(argc,argv,cpUserArea);
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
/*	parm[ 0]:	iSd										*/
/*	parm[ 1]:	iProc									*/
/*	parm[ 2]:	iMaxThread								*/
/*	parm[ 3]:	iOpt									*/
/*	parm[ 4]:	cpMsg									*/
/*	parm[ 5]:	iMsgLen									*/
/*	parm[ 6]:	service									*/
/********************************************************/
int aka_initialize3(nparm,parm)
int   nparm;
long  parm[];
{
	int  iSd;
	int  iProc;
	int  iMaxThread,iMsgLen,iOpt,P[4],iCmd,iRc,iRegOpt;
	char *cpMsg,*service,*p;
	AKAMSGCOM tSendMsg;

	if (nparm<2 || !parm) return -1;

	iMaxThread = 0;
	iOpt = 0;
	iMsgLen = -1;
	cpMsg = NULL;
	service = NULL;
	iSd = parm[0];
	iProc = parm[1];
	if (nparm > 2) iMaxThread = parm[2];
	if (nparm > 3) iOpt       = parm[3];
	if (nparm > 4) cpMsg   = (char *)parm[4];
	if (nparm > 5) iMsgLen = parm[5];
	if (nparm > 6) service = (char *)parm[6];

	if (iSd < 0) {
	/*	iProc = 100;	*/
		iCmd = -iSd;
		iSd  = 0;
		aka_init_status(AKA_IST_STANDALONE,1);
	/*	if (iCmd & AKA_ISD_DETACH) akb_detach(0);	*/
		if (!(p=service)) p = AKX_NULL_PRINT;
		PRINTOUT3("aka_initialize_all:Stand alone process Cmd=%02x, Port=[%s], ProcId=%d",iCmd,p,iProc);
	}
	else iCmd = 0;

	iRegOpt = (iOpt & AKA_MSO_NEED_REPLY) ? AKB_REG_OPT_NEED_REPLY : 0;
	iOpt &= ~AKA_MSO_NEED_REPLY;
	if (iOpt & AKA_MSO_REG_DO_CHA_RB) iRegOpt |= AKB_REG_OPT_DO_CHA_RB;
	if (iSd>0 && !(iOpt & AKA_MSO_INNER_REGIST)) {
		if ((iRc=aka_regist_host(iSd,iProc,cpMsg,iMsgLen,0,iRegOpt)) < 0)
			return iRc;
		iProc = aka_get_regist_pid();
		iOpt |= (aka_get_regist_option() & AKB_REG_OPT_NEED_REPLY) ?
		        AKA_MSO_NEED_REPLY : 0;
	}

	P[0] = iSd;
	P[1] = iProc;
	P[2] = iMaxThread;
	P[3] = iOpt;
	if (!(iRc = aka_initialize_p(4,P))) {
		if (iSd>0 && (iOpt & AKA_MSO_INNER_REGIST)) {
			memset(&tSendMsg,0,sizeof(AKAMSGCOM));
			tSendMsg.msg_clid = AKA_CLASS_REGIST;
			tSendMsg.msg_pmsg     = cpMsg;
			tSendMsg.msg_mlen   = iMsgLen;
			iRc = aka_send_msg(0,&tSendMsg);
		}
		if (!iRc && (iCmd & AKA_ISD_LISTEN)) iRc = sys_init_ch_open(iCmd,service);
		if (!iRc && (iCmd & AKA_ISD_DETACH)) akb_detach(0);
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
#if 0
static int _setRecvProcId(c1,section,na1,na2,argv,n,tpClass)
char c1,*section,*na1,*na2,**argv;
int  n;
tdtCLASS_CTL *tpClass;
{
	int i,n,m;
	ushort *usR;

	if (n < 0) return n;
	else if (n > 1) {
		if (!tpClass->recv_proc_id) {
			if (!(usR = (ushort *)Malloc(n*2*sizeof(ushort))))
				return -1;
			tpClass->recv_proc_id = usR;
		}
		usR += 2;
		for (i=1,m=0;i<n;i++,usR+=2) {
			akxtget2vsep(argv[i],parm,NULL,0,'-',0);
			usR[0] = atoi(parm[0]);
			usR[1] = atoi(parm[1]);
			if (!usR[1]) usR[1] = usR[0];
			if (!usR[0]) usR[0] = usR[1];
			if (usR[0] && usR[1]) m++;
/*
printf("_setRecvProcId: m=%d usR[0]=%d usR[1]=%d\n",m,usR[0],usR[1]);
*/
		}
		*(tpClass->recv_proc_id) = m;
	}
	return n;
}
#endif
static int  set_up_recv_proc_id(tpClass,cpProcName)
tdtCLASS_CTL *tpClass;
char *cpProcName;
{
	int len,i,n,m;
	char buf[128],*argv[66],*parm[2],*namv[3];
	ushort *usR;

	if (len=strlen(cpProcName)) {
		if (len+2 <= sizeof(buf)) {
			sprintf(buf,"%s.%d",cpProcName,tpClass->class_id);
			namv[0] = D_SECTION_AKB_SYSTEM;
			namv[1] = "RECVPROC";
			namv[2] = buf;
			n = akb_gs_akb_stpl_func(namv,'.',
#if 1
			                     "4 2 3 1 ",argv,66,NULL,NULL);
#else
			                     "4-2-3-1-",argv,66,_setRecvProcId,tpClass);
#endif
			if (n < 0) return n;
			else if (n > 1) {
				if (!(usR = (ushort *)Malloc(n*2*sizeof(ushort))))
					return -1;
				tpClass->recv_proc_id = usR;
				usR += 2;
				for (i=1,m=0;i<n;i++,usR+=2) {
					akxtget2vsep(argv[i],parm,NULL,0,'-',0);
					usR[0] = atoi(parm[0]);
					usR[1] = atoi(parm[1]);
					if (!usR[1]) usR[1] = usR[0];
					if (!usR[0]) usR[0] = usR[1];
					if (usR[0] && usR[1]) m++;
/*
printf("set_up_recv_proc_id: m=%d usR[0]=%d usR[1]=%d\n",m,usR[0],usR[1]);
*/				}
				*(tpClass->recv_proc_id) = m;
			}
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _init_exception(iCh,iEvent)
int iCh,iEvent;
{
	ERROROUT3("Channel Exception: channel=%d event=%d %s",
	          iCh,iEvent,aka_channel_event_msg(iEvent,0));
	return -1;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _init_connect(pCh,iSd)
tdtCHANNEL *pCh;
int iSd;
{
	tdtCHANNEL_OPEN tChannel;
	int iRc,iCmd=0;

	PRINTOUT1("_init_connect: accepted iSd=%d",iSd);
	if (pCh->parm) {
		memcpy(&iCmd,pCh->parm,sizeof(int));
	}
	if (iCmd & AKA_ISD_CH_OPEN) {
		memset(&tChannel,0,sizeof(tdtCHANNEL_OPEN));
		tChannel.sd   = iSd;
		tChannel.opt = AKA_CHSO_USE_AKB_HEAD;
		tChannel.exception = _init_exception;
		if ((iRc = aka_channel_open(&tChannel)) <= 0) {
			ERROROUT1("_init_connect: aka_channel_open ret=%d",iRc);
			if (!iRc) iRc = -1;
		}
		else PRINTOUT1("_init_connect: ChannelOpen Ok. iCh=%d",iRc);
	}
	else {
		if (iRc = aka_init_zero(iSd))
			ERROROUT1("_init_connect: aka_init_zero ret=%d",iRc);
		else PRINTOUT("_init_connect: InitZero Ok.");
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int sys_init_ch_open(iCmd,service)
int iCmd;
char *service;
{
	static int iCmdS;
	tdtCHANNEL_OPEN tChannel;
	int iRc;

	iCmdS = iCmd;
	memset(&tChannel,0,sizeof(tdtCHANNEL_OPEN));
	tChannel.host_name = "*";
	tChannel.service = service;
	tChannel.head_check = _init_connect;
	tChannel.head_len  = 0;	/* bind error retry */
	tChannel.exception = _init_exception;
	tChannel.parm    = (char *)&iCmdS;
	if ((iRc = aka_channel_open(&tChannel)) <= 0) {
		ERROROUT1("sys_init_ch_open: aka_channel_open ret=%d",iRc);
		if (!iRc) iRc = -1;
		return iRc;
	}
	else PRINTOUT1("sys_init_ch_open: ChannelOpen Ok. iCh=%d",iRc);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_register_method(iClassId,iMaxMethod,tpMethod,iMaxMethodParm,iOption)
int iClassId;
int iMaxMethod;
tdtMETHOD *tpMethod;
int iMaxMethodParm,iOption;
{
	int iRc,i;
	tdtCLASS_CTL *tpClass;
	char *p;

	if (!tpMethod) return -18503101;
	if (iMaxMethod <= 0) return 0;
	if (!(tpClass=aka_srch_class(iClassId))) return -18503102;
	if (!(tpClass->method=
		(tdtMETHOD *)Memdup(tpMethod,sizeof(tdtMETHOD)*iMaxMethod)))
		return -18503103;
	tpClass->max_method = iMaxMethod;
	if (iMaxMethodParm < 0) iMaxMethodParm = 0;
	tpClass->max_method_parm = iMaxMethodParm;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_nofree(iSet,level)
int iSet,level;
{
	if (tMsgCtl.sd<0) return -18503201;

	if (iSet) {
		tMsgCtl.msg_opt |= AKA_MSO_EXEC_NOFREE;
		tMsgCtl.rsv2 = level;
	}
	else tMsgCtl.msg_opt &= ~AKA_MSO_EXEC_NOFREE;

	return 0;
}
