static char sccsid[]="%Z% %M% %I% %E% %U%";
/************************************************************************
*   : fZ												*
*   : int cl_cmpt_complex											*
*   : (O)long        *pAns       :								*
*         (I)char        *pOprtr     :						*
*         (I)tdtINFO_PARM *pInfoParm1 :						*
*         (I)tdtINFO_PARM *pInfoParm2 :						*
*         (O)int         iParm[]     :									*
*  ԋp : ERROR															*
*         NORMAL														*
*************************************************************************/
/********************************************/
/*	  coded by A.Kobayashi() 2022.07.01		*/
/*	  error code : -215250101`-215259999	*/
/********************************************/
#include <colmn.h>

extern GlobalCt  *pGlobTable;
extern int giOptions[];

/****************************************/
/*	05									*/
/****************************************/
static int _set_complex(pComplex,pInfoParm1)
tdtINFO_PARM *pComplex,*pInfoParm1;
{
	tdtINFO_PARM	*pm[2],tInfoParm,*pInfo;

	pInfo = &tInfoParm;
	cl_set_parm_long(pInfo,0);
	if (pInfoParm1->pi_scale & D_DATA_IMAGE) {
		pm[0] = pInfo;
		pm[1] = pInfoParm1;
	}
	else {
		pm[0] = pInfoParm1;
		pm[1] = pInfo;
		pInfo->pi_scale |= D_DATA_IMAGE;
	}
	return cl_gx_range_set(pComplex,2,pm,0);
}

/****************************************/
/*	04									*/
/****************************************/
static int _inner_product(pInfoParmW,pInfoR,pInfoI)
tdtINFO_PARM	*pInfoParmW,*pInfoR,*pInfoI;
{
	int ret;

	tdtINFO_PARM	tInfoW1,tInfoW2;

	if ((ret=cl_cmpt_math_real(&tInfoW1,"*",pInfoR,pInfoR)) < 0) return ret;
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_inner_product: Enter tInfoW1=",&tInfoW1,0,0);
*/
	if ((ret=cl_cmpt_math_real(&tInfoW2,"*",pInfoI,pInfoI)) < 0) return ret;
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_inner_product: Enter tInfoW2=",&tInfoW2,0,0);
*/
	ret = cl_cmpt_math_real(pInfoParmW,"+",&tInfoW1,&tInfoW2);
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_inner_product: Enter pInfoParmW=",pInfoParmW,0,0);
*/
	return ret;
}

/****************************************/
/*	06									*/
/****************************************/
static int _complex_abs_bouble(pInfoParmW,pInfoR,pInfoI)
tdtINFO_PARM	*pInfoParmW,*pInfoR,*pInfoI;
{
	double dVal1,dVal2;
	int ret,iParm[5];

	if ((ret=cl_get_parm_double_opt(pInfoR,&dVal1,"_complex_abs1",iParm,0)) < 0) return ret;
	if ((ret=cl_get_parm_double_opt(pInfoI,&dVal2,"_complex_abs2",iParm,0)) < 0) return ret;
	/* dVal1=1e300, dVal2=1e300 ̂ƂłI[o[t[A1.4142`e300 Ԃ */
	dVal1 = sqrt(dVal1*dVal1 + dVal2*dVal2);
	cl_set_parm_double(pInfoParmW,dVal1);
	return ret;
}

/****************************************/
/*	03	** p							*/
/****************************************/
static int _complex_power(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtINFO_PARM	*pInfoParmW;
char *pOperator;
tdtINFO_PARM	*pInfoParm1;
tdtINFO_PARM	*pInfoParm2;
{
	int ret,iParm[5],iCOMPLEX1,iCOMPLEX2,iIMAGE1,iIMAGE2;
	long lValz[NMPA_LONG],*lVal,lValue;
	char op;

	iCOMPLEX1 = pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA;
	iCOMPLEX2 = pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA;
	if (iCOMPLEX1 || iCOMPLEX2) {	/*  */
		if (iCOMPLEX1 && iCOMPLEX2) {	/* (a+bi)**(c+di) */
			ret = -215250396;
		}
		else if (iCOMPLEX1) {	/* (a+bi)**fȊO */
			iIMAGE2 = pInfoParm2->pi_scale & D_DATA_IMAGE;
			if (iIMAGE2) {	/* (a+bi)** */
				ret = -215250391;
			}
			else {	/* (a+bi)** */
				if (cl_is_zero(pInfoParm2)) return cl_set_parm_long(pInfoParmW,1);
				ret = -215250392;
			}
		}
		else {	/* fȊO**(c+di) */
			iIMAGE1 = pInfoParm1->pi_scale & D_DATA_IMAGE;
			ret = -215250393;
		}
	}
	else {	/* fȊO**fȊO */
		iIMAGE2 = pInfoParm2->pi_scale & D_DATA_IMAGE;
		if (iIMAGE2) {	/* fȊO** */
			ret = -215250394;
		}
		else {	/* fȊO** */
			if (cl_is_zero(pInfoParm2)) return cl_set_parm_long(pInfoParmW,1);
			lVal = cl_get_tmpMPA(lValz);
			iParm[0] = 0;
			if ((ret=cl_get_parm_mpa_opt(pInfoParm2,lVal,"cl_cmpt_math_info(**)",iParm,0)) < 0) return ret;
			if (iParm[0] == DEF_ZOK_BINA) {	/* fȊO** */
				lValue = CL_GET_VAL_BIN(lVal);
				if ((ret=cl_cmpt_math(lVal,pOperator,pInfoParm1,pInfoParm2,iParm)) >= 0) {
					ret=cl_set_parm(pInfoParmW,lVal,0,iParm);
					lValue %= 4;
					if (lValue == 0) ;
					else if (lValue == 1) pInfoParmW->pi_scale |= D_DATA_IMAGE;
					else if (lValue == 2) cl_sign_reverse(pInfoParmW);
					else if (lValue == 3) {
						pInfoParmW->pi_scale |= D_DATA_IMAGE;
						cl_sign_reverse(pInfoParmW);
					}
				}
			}
			else {	/* fȊO**ȊO */
				ret = -215250395;
			}
		}
	}
	return ret;
}

/****************************************/
/*	02									*/
/****************************************/
static int _cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtINFO_PARM	*pInfoParmW;
char *pOperator;
tdtINFO_PARM	*pInfoParm1;
tdtINFO_PARM	*pInfoParm2;
{
	tdtINFO_PARM *pComplex,tInfo,*ppParm[3],tCmplx[2];
	tdtINFO_PARM *pInfo1,*pInfo2,tCmplx1,tCmplx2;
	tdtINFO_PARM tInfoW1,tInfoW2,tInfoW3,tInfoA;
	tdtINFO_PARM tInfoR1,tInfoI1,tInfoR2,tInfoI2;
	long lValrz[NMPA_LONG],*lValr,lValiz[NMPA_LONG],*lVali;
	int ret,iVal[2],iParm[5],iCOMPLEX1,iCOMPLEX2,iIMAGE1,iIMAGE2;
	char op;

	if (!strcmp(pOperator,"**")) {
		/* ** ͂Ŏs */
		return _complex_power(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
	}

	iCOMPLEX1 = pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA;
	iCOMPLEX2 = pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA;
	op = *pOperator;
	pInfo1 = pInfoParm1;
	pInfo2 = pInfoParm2;
	if (!iCOMPLEX1) {
		pComplex = &tCmplx1;
		if ((ret=_set_complex(pComplex,pInfoParm1)) < 0) return ret;
		pInfo1 = pComplex;
	}
	if (pInfoParm1 == pInfoParm2)
		pInfo2 = pInfo1;
	else {
		if (!iCOMPLEX2) {
			pComplex = &tCmplx2;
			if ((ret=_set_complex(pComplex,pInfoParm2)) < 0) return ret;
			pInfo2 = pComplex;
		}
	}
	ppParm[0] = &tInfoR1;
	ppParm[1] = &tInfoI1;
	ppParm[2] = &tInfo;
	if ((ret=cl_get_range_info(pInfo1,ppParm,iVal,0)) < 0) return ret;
	/* ABŜƂ́ApInfoParm1==pInfoParm2Ȃ̂ŁApInfoParm1g */
	if (!stricmp(pOperator,"ABS")) {
		if (ppParm[0]->pi_attr==DEF_ZOK_FLOA || ppParm[1]->pi_attr==DEF_ZOK_FLOA)
			ret = _complex_abs_bouble(pInfoParmW,ppParm[0],ppParm[1]);
		else {
			if ((ret=_inner_product(&tInfoA,ppParm[0],ppParm[1])) < 0) return ret;
			ppParm[0] = &tInfoA;
			ret = func_math2(pInfoParmW,"SQRT",1,ppParm,D_FUC_SQRT);
		}
		return ret;
	}
	ppParm[0] = &tInfoR2;
	ppParm[1] = &tInfoI2;
	if ((ret=cl_get_range_info(pInfo2,ppParm,iVal,0)) < 0) return ret;
	lValr = cl_get_tmpMPA(lValrz);
	lVali = cl_get_tmpMPA(lValiz);
	if (op=='+' || op=='-') {	/* (a+jb)+-(c+jd)=a+-c+j(b+-d) */
		/*  */
		if ((ret=cl_cmpt_math_real(&tCmplx[0],pOperator,&tInfoR1,&tInfoR2)) < 0) return ret;
		/*  */
		if ((ret=cl_cmpt_math_real(&tCmplx[1],pOperator,&tInfoI1,&tInfoI2)) < 0) return ret;
	}
	else if (op == '*') {	/* (R1+jI1)*(R2+jI2)=(R1*R2-I1*I2)+j(R1*I2+I1*R2) */
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[0],"-",&tInfoW1,&tInfoW2)) < 0) return ret;
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[1],"+",&tInfoW1,&tInfoW2)) < 0) return ret;
	}
	else if (op == '/') {	/* (R1+jI1)/(R2+jI2)= (R1*R2+I1*I2)/A+j(I1*R2-I2*R1)/A, A=(R2*R2+I2*I2) */
		/*  */
#if 1
		if ((ret=_inner_product(&tInfoA,&tInfoR2,&tInfoI2)) < 0) return ret;
#else
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR2,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoA,"+",&tInfoW1,&tInfoW2)) < 0) return ret;
#endif
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoR1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI1,&tInfoI2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW3,"+",&tInfoW1,&tInfoW2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[0],"/",&tInfoW3,&tInfoA)) < 0) return ret;
		/*  */
		if ((ret=cl_cmpt_math_real(&tInfoW1,"*",&tInfoI1,&tInfoR2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW2,"*",&tInfoI2,&tInfoR1)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tInfoW3,"-",&tInfoW1,&tInfoW2)) < 0) return ret;
		if ((ret=cl_cmpt_math_real(&tCmplx[1],"/",&tInfoW3,&tInfoA)) < 0) return ret;
	}
	/* f */
	ppParm[0] = &tCmplx[0];
	ppParm[1] = &tCmplx[1];
	ppParm[1]->pi_scale |= D_DATA_IMAGE;
	if (!(cl_get_option(2,0) & 0x80)) {
		if (cl_is_zero(ppParm[1])) {
			cl_gx_copy_info(pInfoParmW,ppParm[0]);
			return 0;
		}
		if (cl_is_zero(ppParm[0])) {
			cl_gx_copy_info(pInfoParmW,ppParm[1]);
			return 0;
		}
	}
	ret = cl_gx_range_set(pInfoParmW,2,ppParm,0);
	return ret;
}

/****************************************/
/*	01									*/
/****************************************/
int cl_cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2)
tdtINFO_PARM	*pInfoParmW;
char *pOperator;
tdtINFO_PARM	*pInfoParm1;
tdtINFO_PARM	*pInfoParm2;
{
	int ret,iParm[5],iCOMPLEX,iIMAGE1,iIMAGE2,ope;
	long lValz[NMPA_LONG],*lVal;
	char op;

DEBUGOUTL1(120,"cl_cmpt_complex: pOperator=[%s]",pOperator);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_cmpt_complex: Enter pInfoParm1=",pInfoParm1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"                       pInfoParm2=",pInfoParm2,0,0);

	op = *pOperator;
	if (!stricmp(pOperator,"ABS")) ;
	else if (op=='+' || op=='-' || op=='*' || op=='/') ;
	else {
		ERROROUT2(FORMAT(245),"cl_comp_complex",pOperator);	/* %s: Zq(%s)Ɍ肪܂B*/
		return ECL_SCRIPT_ERROR;
	}
	iCOMPLEX = ope = 0;
	if (op=='*' && pOperator[1]=='*') ope = 30;
	if ((pInfoParm1->pi_alen & D_AULN_COMPLEX_DATA) || (pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA)) {
		iCOMPLEX = 2;
	}
	else {
		iIMAGE1 = pInfoParm1->pi_scale & D_DATA_IMAGE;
		iIMAGE2 = pInfoParm2->pi_scale & D_DATA_IMAGE;
		if (iIMAGE1 || iIMAGE2) {
			if (ope!=30 && iIMAGE1 && iIMAGE2) iCOMPLEX = 1;
			else iCOMPLEX = 2;
		}
	}
/*
printf("cl_cmpt_complex: pOperator=[%s] iCOMPLEX=%d\n",pOperator,iCOMPLEX);
*/
	if (iCOMPLEX == 2) {
		ret = _cmpt_complex(pInfoParmW,pOperator,pInfoParm1,pInfoParm2);
	}
	else {
		lVal = cl_get_tmpMPA(lValz);
		if ((ret=cl_cmpt_math(lVal,pOperator,pInfoParm1,pInfoParm2,iParm)) >= 0) {
			ret=cl_set_parm(pInfoParmW,lVal,0,iParm);
			if (iCOMPLEX == 1) {
				if (iIMAGE1 && iIMAGE2) {
					if (op == '*') cl_sign_reverse(pInfoParmW);
					else if (op != '/') pInfoParmW->pi_scale |= D_DATA_IMAGE;
				}
				else {
					pInfoParmW->pi_scale |= D_DATA_IMAGE;
					if (op == '/') cl_sign_reverse(pInfoParmW);
				}
			}
		}
	}
	return ret;
}
