#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# ﾏﾙﾁｽﾚｯﾄﾞｻｰﾊﾞｰ用 openCV ｽﾄﾘｰﾐﾝｸﾞ ﾌｨﾙﾀｰｻﾝﾌﾟﾙ(bottle用)
#
# filter,module は、bottle/flask 共通です。
# subapp は、
#     bottle は、Bottle ｵﾌﾞｼﾞｪｸﾄを、merge ﾒｿｯﾄﾞで
#     flask  は、Blueprint ｵﾌﾞｼﾞｪｸﾄを、register_blueprint ﾒｿｯﾄﾞで
# 組み込んでいます。

import time
import cv2

from datetime import datetime

WHITE	= (255, 255, 255)					# BGR形式
YELLOW	= (  0, 255, 255)

#############################################################################################
class PutText :
	# ｵﾌﾞｼﾞｪｸﾄﾃｽﾄ用の設定
	def __init__(self):
		self.scale = None					# ﾘｻｲｽﾞ用

	#############################################################################################
	# filterｸﾗｽとしては必須ﾒｿｯﾄﾞ
	def filter(self, image):
		'''
			openCvの image を入力して､加工処理を行い､image を返します｡

			:param  image : 入力ｲﾒｰｼﾞ
			:return	:	加工処理が行われたｲﾒｰｼﾞ
		'''
		try :
			# ﾙｰﾌﾟは回っているが､これが入ると表示に時間がかかる｡
			if self.scale is not None :
				image = cv2.resize(image,dsize=None,fx=self.scale,fy=self.scale)	# ﾘｻｲｽﾞ

			now = datetime.today()
			ymd = now.strftime( '%Y/%m/%d %H:%M:%S' )			# 年/月/日 時:分:秒

			# 本来は文字の表示領域のﾋﾟｸｾﾙを求めて計算すべきだが…
			h,w,c = image.shape[:3]								# height, width, channels
			fsize = w/3/180										# 180pxが､ｻｲｽﾞ 1 基準で､1/3領域に表示する
			hpos  = int(20*fsize)								# 表示位置は､ｻｲｽﾞ 1 基準で､20px で計算する

			# 時間表示	画像 ,文字,座標(x,y),ﾌｫﾝﾄ                  ,ｻｲｽﾞ ,色    ,太さ,線の種類
			cv2.putText(image,ymd ,(0,hpos) ,cv2.FONT_HERSHEY_PLAIN,fsize,WHITE ,2   ,cv2.LINE_AA)	# 少し太い文字で背景を書く
			cv2.putText(image,ymd ,(0,hpos) ,cv2.FONT_HERSHEY_PLAIN,fsize,YELLOW,1   ,cv2.LINE_AA)	# その中に､本来の文字を書けば見やすくなる｡

			return image

		except Exception as ex:
			print( 'process 実行中に例外が発生しました｡' )
			raise ex											# 例外を投げる｡

	#############################################################################################
	# bottle/flask からﾙｰﾃｨﾝｸﾞされるﾒｿｯﾄﾞ
	def action(self,actDic):
		''' json辞書から、scaleを取り出す'''
		sca = actDic.get( 'scale' )								# 未設定の場合は､None
		print('scale=' + str(sca))
		if sca : self.scale = float(sca)

	#############################################################################################
	# 終了時に呼ばれるﾒｿｯﾄﾞ(無くてもよい)
	def close(self):
		''' 内部変数を初期化します｡ '''
		pass

#############################################################################################
# ogServer.py で、bottle/flask に組み込むためのﾌｯｸ
def new_obj():
	'''
		filter/module/subapp処理を行うｸﾗｽのｲﾝｽﾀﾝｽを生成します｡

		:return	:	(filterｲﾝｽﾀﾝｽ,moduleｲﾝｽﾀﾝｽ,subappｲﾝｽﾀﾝｽ)の辞書
	'''
	import json									# ajaxﾃﾞｰﾀ
	import bottle								# ｱﾌﾟﾘｹｰｼｮﾝｻｰﾊﾞｰ
#	import flask								# ｱﾌﾟﾘｹｰｼｮﾝｻｰﾊﾞｰ

	filter = PutText()
	subapp = bottle.Bottle()
#	subapp = flask.Blueprint( 'test_filter',__name__ )

	###### ajax 通信 #####
	@subapp.route('/test' , method='POST')		# bottleは､『method』に、文字列
#	@subapp.route('/test' , methods=['POST'])	# flaskは、『methods』に、ﾘｽﾄ
	def filterAction():
		# /filter ﾘｸｴｽﾄ時に送られてきた JSON形式を辞書に変換
		actDic = json.load(bottle.request.body)
#		# /filter ﾘｸｴｽﾄ時に送られてきた JSONは、request.get_json() でJSONｵﾌﾞｼﾞｪｸﾄで受ける
#		actDic = flask.request.get_json()		# flask
		filter.action(actDic)
		return ''								# 非同期通信なので､処理完了時点で値は拾えない

	return {'filter':filter,'module':filter,'subapp':subapp }

################################################
# mjpg-streamer の input_opencv.so filterの 互換処理
#def init_filter():
#	'''
#		filter処理を行うﾒｿｯﾄﾞを返します｡
#
#		:return	:	filterﾒｿｯﾄﾞ
#	'''
#	filter = PutText()
#	return filter.filter

################################################
# 動作確認用のテストプログラムです。
def main(argDic):

	fname = argDic.get('fname')					# ﾌﾟﾛｸﾞﾗﾑ名=Windows画面名
	devno = int(argDic.get('devno'))			# ﾃﾞﾊﾞｲｽNoの設定

	filter = PutText()							# ｵﾌﾞｼﾞｪｸﾄ生成
	filter.action(argDic)						# scale の設定

	cap = cv2.VideoCapture(devno)

	try:
		while True:
			_,img = cap.read()
			img = filter.filter(img)
			cv2.imshow(fname,img)

			key = cv2.waitKey(10)				# ミリ秒単位で表される遅延時間
			if key == 27:						# ESCを押した時
				break

			time.sleep( 0.1 )					# CPU処理の軽減化

	except KeyboardInterrupt  : 				# Ctl+Cが押されたらループを終了
		print( "\nCtl+C Stop" )
	except Exception as ex:
		print( ex )								# 例外処理の内容をコンソールに表示
		import traceback
		traceback.print_exc()					# Exception のトレース
	finally :
		if cap is not None : cap.release()
		cv2.destroyAllWindows()
		print( "終了" )

################################################
# main関数を呼び出します
################################################
if __name__=='__main__':
	print( 'python test_filter.py [scale(=None)] [devno(=0)]' )

	argDic = {'fname':None , 'scale':None , 'devno':'0'}

	import sys								# 引数の読み込み用
	args = sys.argv
	argDic['fname'] = args[0]
	if len(args) > 1 : argDic['scale'] = args[1]
	if len(args) > 2 : argDic['devno'] = args[2]

	main(argDic)
