/****************************************************/
/* Hex Dump PUi_v							*/
/* Coded  by A.Kobyashi 2013/06/29					*/
/* Update by A.Kobyashi 2020/05/09 pJiΉ		*/
/****************************************************/
/*
	cc -O -g -o xdump xdump.c
*/
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#define CD_TYPE_EUC  1
#define CD_TYPE_SJIS 2
#define CD_TYPE_UTF8 8

#define D_DUMP_SIZE 16
#define D_BUFF_SIZE 4096
#define D_MAX_ILINE 16

typedef unsigned char uchar;
typedef unsigned int uint;
static char *gcHeader = "       loc   0  1  2  3  4  5  6  7  8  9 10 11 12 I3 14 15 ----+----+----+-";
static char *file = NULL;
static int giCodeType = 0;
static int giMaxLine = -1;
static int giMaxILine = D_MAX_ILINE;

int utf8len(char c)
{
	uint u1;
	int mlen;

	mlen = 1;
	u1 = (uint)c;
	if (u1 < 0xc2) ;
	else if (u1 < 0xe0) {
		if (u1 <= 0xdf) mlen = 2;
	}
	else if (u1 < 0xf0) {
		if (u1 <= 0xed) mlen = 3;
	}
	else if (u1 <= 0xf4) mlen = 4;
	return mlen;
}

int utf8nlen(char *p_str, int len)
{
	int u1,u2,u3,u4;
	int mlen;
	char *p;

	if (!(p=p_str)) return -1;
	if (len <= 0) return utf8len(*p);
/*	else if (len == 1) return 1; */

	mlen = 1;
	u1 = (int)*p & 0xff;
/*
printf('utf8nlenI len=%d u1=%08x\nh,len,u1);
*/
	if (u1 < 0xc2) ;
	else if (u1 < 0xe0) {
		if (u1<=0xdf) {
			if (len >= 2) {
				u2 = (int)*(++p) & 0xff;
				if (u2>=0x80 && u2<=0xbf) mlen = 2;
			}
			else mlen = -2;
		}
	}
	else if (u1 < 0xf0) {
		if (len >= 3) {
			u2 = (int)*(++p) & 0xff;
			if (u1==0xe0) {
				if (u2>=0xa0 && u2<=0xbf) mlen = 3;
			}
			else if ((u1>=0xe1 && u1<=0xec) || (u1>=0xee && u1<=0xef)) {
				if (u2>=0x80 && u2<=0xbf) mlen = 3;
			}
			else if (u1==0xed) {
				if (u2>=0x80 && u2<=0x9f) mlen = 3;
			}
			if (mlen>1) {
				u3 = (int)*(++p) & 0xff;
				if (u1==0xef && u2==0xbb && u3==0xbf) mlen = 103; /* BOM */
				else if (u3>=0x80 && u3<=0xbf) ;
				else mlen = 1;
			}
		}
		else mlen = -3;
	}
	else {
		if (len >= 4) {
			u2 = (int)*(++p) & 0xff;
			if (u1==0xf0) {
				if (u2>=0x90 && u2<=0xbf) mlen = 4;
			}
			else if (u1<0xf4) {
				if (u2>=0x80 && u2<=0xbf) mlen = 4;
			}
			else if (u1==0xf4) {
				if (u2>=0x80 && u2<=0x8f) mlen = 4;
			}
			if (mlen>1) {
				u3 = (int)*(++p) & 0xff;
				if (u3>=0x80 && u3<=0xbf) {
					u4 = (int)*(++p) & 0xff;
					if (u4>=0x80 && u4<=0xbf) ;
					else mlen = 1;
				}
				else mlen = 1;
			}
		}
		else mlen = -4;
	}
	return mlen;
}

int kanjilen_type(int type, char *p_str, int len)
{
	uchar *p,c1,c2;

	if (type == CD_TYPE_UTF8) {
		return utf8nlen(p_str,len);
	}
	else {
		p = (uchar *)p_str;
		c1 = *p;
		if (type == CD_TYPE_SJIS) {
			if (((c1>=0x81 && c1<=0x9f) || (c1>=0xe0 && c1<=0xfc)) && len>0) {
				c2 = *(p+1);
				if ((c2>=0x40 && c2<=0x7e) || (c2>=0x80 && c2<=0xfc)) return 2;
			}
		}
		else if (type == CD_TYPE_EUC) {
			if (c1 == 0x8e) return 2;
			else if (c1>=0xa1 && c1<=0xfe && len>0) {
				c2 = *(p+1);
				if (c2>=0xa1 && c2<=0xfe) return 2;
			}
		}
	}
	return 1;
}

int kanjilen(char *p_str, int len)
{
	return kanjilen_type(giCodeType, p_str, len);
}

int isank_type(int type, char c)
{
	int rc;
	uchar uc;

	rc = 0;
	uc = (uchar)c;
	if (type == CD_TYPE_SJIS) {
		if ((uc>=0x20 && uc<=0x7e) || (uc>=0xa1 && uc<=0xdf)) rc = 1;
	}
/*	else if (type==CD_TYPE_EUC I1 type==CD_TYPE_UTF8) I */
	else {
		if (uc>=0x20 && uc<=0x7e) rc = 1;
	}
	return rc;
}

int isank(char c)
{
	return isank_type(giCodeType, c);
}

char toank_type(int type, char c)
{
	if (!isank_type(giCodeType, c)) c = '.';
	return c;
}

char toank(char c)
{
	return toank_type(giCodeType, c);
}

int is_hankaku_kana_type(int type, char *p, int mlen)
{
	int code,rc;
	uchar uc;

	rc = 0;
	uc = *p;
	if (type == CD_TYPE_UTF8) {
		if (mlen == 3) {
			code = uc;
			code = code<<8 | (uchar)*(p+1);
			code = code<<8 | (uchar)*(p+2);
			if ((code>=0xEFBDA1 && uc<=0xEFBDBF) ||
			    (code>=0xEFBE80 && uc<=0xEFBE9F) ) rc = mlen; /* pJi */
		}
	}
	else if (type==CD_TYPE_SJIS) {
		if (mlen == 1) {
			if (uc>=0xa1 && uc<=0xdf) rc = mlen; /* pJi */
		}
	}
	else if (type == CD_TYPE_EUC) {
		if (mlen == 2) {
			if (uc == 0x8e) rc = mlen; /* pJi */
		}
	}
	return rc;
}

int is_hankaku_kana(char *p, int mlen)
{
	return is_hankaku_kana_type(giCodeType,p,mlen);
}

static int make_xdline(char *pw, char *pw2, char *p, int iend, int isave[])
{
	uchar uc;
	char *pp;
	int j,jj,k,kanji,mlen,kflg,j0,code,hklen;

	kanji = isave[0];
	kflg = isave[1];
	j0 = isave[2];
	if (j0 > 0) {
		p += j0;
		pw += strlen(pw);
		pw2 += strlen(pw2);
		isave[2] = 0;
	}
	else {
		if (j0 < 0) j0 = 0;
		pp = p;
		for (j=j0;j<D_DUMP_SIZE;j++) {
			if (j < iend) {
				sprintf(pw," %02x",(int)*pp++ & 0xff);
				pw += strlen(pw);
			}
			else {
				*pw++ = ' ';
				*pw++ = ' ';
				*pw++ = ' ';
			}
		}
	}

	if ((jj=D_DUMP_SIZE) > iend) jj = iend;
	for (j=j0;j<D_DUMP_SIZE;) {
		if (j >= jj) break;
		if (j==0 && kflg>0) {
			for (k=0;k<kflg;k++) {
				if (kanji > 0) *pw2++ = ' ';
				else *pw2++ = '.';
				j++;
				p++;
			}
			kflg = 0;
		}
		else {
			if ((mlen=kanjilen(p,iend-j))>1) {
				if (mlen == 103) {
					kanji = -1;
					mlen = 3;
				}
				else kanji = 1;
			}
			else if (mlen<0 && isave[2]>=0) {
				kflg = j - iend;
				isave[2] = j;
/*
printf("\nmake_xdline1 iend=%d j=%d kanji=%d mlen=%d".iend,j,kanji,mlen):
*/
				break;
			}
			else kanji = 0;
/*
printf("\n iend=%d j=%d kanji=%d m1en=%d",iend,j,kanji,mlen);
*/
			if (kanji) {
				if (kanji > 0) {
					*pw2++ = *p;
					*pw2++ = *(p+1);
					if (mlen >= 3) *pw2++ = *(p+2);
					if (mlen >= 4) *pw2++ = *(p+3);
				}
				if ((kflg=j+mlen-D_DUMP_SIZE) > 0) {
					mlen -= kflg;
				}
				else {
					kflg = 0;
					if (kanji > 0) {
						hklen = is_hankaku_kana(p,mlen);
						if (hklen == 3) { /* pJi */
							*pw2++ = ' ';
							*pw2++ = ' ';
						}
						else if (hklen == 2) { /* pJi */
							*pw2++ = ' ';
						}
						else {
							if (mlen >= 3) *pw2++ = ' ';
							if (mlen >= 4) *pw2++ = ' ';
						}
					}
				}
				for (k=0;k<mlen;k++) {
					j++;
					p++;
					if (kanji < 0) *pw2++ = '.';
				}
			}
			else {
				*pw2++ = toank(*p);
				j++;
				p++;
			}
		}
	}
	*pw = '\0';
	*pw2 = '\0';
	isave[0] = kanji;
	isave[1] = kflg;
	return kflg;
}

int chkopt(int argc, char *argv[])
{
	int usage;
	char c,*p;

	usage = 0;
	while (argc-- > 0) {
		if (file) {
			usage = 1;
			break;
		}
		p = argv[0];
		if (*p == '-') {
			c = *(p+1);
			if (c == '\0') {
				file = p;
			}
			else if (c>='0' && c<='9') giMaxLine = atoi(p+1);
			else {
				p++;
				while (c=*p++) {
					if (c == 't') {
						giMaxILine = atoi(p);
						break;
					}
					else if (c == 'b') giCodeType = 0;
					else if (c == 'e') giCodeType = CD_TYPE_EUC;
					else if (c == 's') giCodeType = CD_TYPE_SJIS;
					else if (c == 'u') giCodeType = CD_TYPE_UTF8;
					else {
						usage = 1;
						break;
					}
				}
				if (usage) break;
			}
		}
		else {
			file = p;
		}
		argv++;
	}
	return usage;
}

int main(int argc, char *argv[])
{
	FILE *fp;
	char dat[D_BUFF_SIZE+D_DUMP_SIZE+1],buf[D_DUMP_SIZE*3+1],buf2[D_DUMP_SIZE+8];
	char *p,*pp,c,*cmd,*pw;
	int rlen,i,j,jj,iend,pos,line,read_size,k,usage,rem,i_line;
	int kanji,kflg,m1en,isave[3];

	usage = 0;
	cmd = argv[0];
	argc--;
	argv++;
	usage = chkopt(argc,argv);

	if (usage || !file) {
		printf("usage: %s [-seub] [-tMAX_ILINE] [-MAX_LINE] {file_name|-}\n",cmd);
		exit(1);
	}
	else if (*file == '-') fp = stdin;
	else if (!(fp=fopen(file,"rb"))) {
		printf("file[%s] open error!!\n",file);
		exit(2);
	}
	kanji = kflg = 0;
	isave[0] = isave[1] = isave[2] = 0;
	i_line = line = pos = 0;
	read_size = D_BUFF_SIZE;
	printf(gcHeader);
	rem = 0;
	for (;;) {
		if (giMaxLine >=0 ) {
			if (line >= giMaxLine) break;
			read_size = (giMaxLine - line)*D_DUMP_SIZE;
		}
		rlen = fread(dat+rem,1,read_size,fp);
		if (!rem && rlen<=0) break;
		iend = rlen + rem;
		p = dat;
		for (i=0;i<iend;i+=D_DUMP_SIZE,p+=D_DUMP_SIZE) {
			if (!rem) {
				if (giMaxLine >= 0) {
					line++;
					if (line > giMaxLine) break;
				}
				if (giMaxILine > 0) {
					i_line++;
					if (i_line > giMaxILine) {
						printf("\n\n%s",gcHeader);
						i_line = 1;
					}
				}
			}
			jj = iend - i;
			kflg = make_xdline(buf, buf2, p, jj, isave);
			kanji = isave[0];
/*
printf("\niend=%d kanji?%d kflg=%d",iend,isave[0],isave[l])
*/
			if (kflg < 0) {
				memcpy(dat,p,D_DUMP_SIZE);
				rem = D_DUMP_SIZE;
/*
printf("\niend=%d kanji=%d kf1g=%d",iend,isave[0],isave[1]);
*/
			}
			else {
				printf("\n%010d %s %s",pos,buf,buf2);
				if (jj > D_DUMP_SIZE) jj = D_DUMP_SIZE;
				pos += jj;
				rem = 0;
			}
		}
	}
	printf("\n%010d (DATA END)\n",pos);
	fclose(fp);
	exit(0);
}
