static  char    sccsid[]="%Z% %M% %I% %D% %T%";

#include	"akbcommon.h"

void akbLogPrint();
void akb_log_print_sub();
static int print_logfile();

static char *gcpLogOutBuf=NULL;
static unsigned char gucLogFlg[4]={0x03,0x00,0x00,0x00};
static char *gcLogFile[4]={NULL,NULL,NULL,NULL};

#define	BUF_SIZE		100

/* pPbg̕ */
#define D_STR_DIR_READ			"<-"
#define D_STR_DIR_WRITE			"->"
#define D_STR_DIR_UNKNOWN		"??"

/* G[ԕ */
#define	D_STR_STATUS_READ		"read"
#define	D_STR_STATUS_WRITE		"write"
#define	D_STR_STATUS_PRE		"pre"
#define	D_STR_STATUS_UNKNOWN	"unknown"

/* G[u */
#define	D_STR_MANAGE_EXIT		"exit"
#define	D_STR_MANAGE_CLOSE		"close"
#define	D_STR_MANAGE_RESEND		"resend"
#define	D_STR_MANAGE_EXTINCT	"extinct"
#define	D_STR_MANAGE_UNKNOWN	"unknown"

/* Ot@C */
#define COMMERR		"commerr.log"		/* PvIɃG[Oct@C */
#define COMMERRTMP	"commerrtmp.log"	/* ꎞIɃG[Ocׂ̃t@Ci[U) */
#define COMMWRN		"comwrn.log"		/* xOt@C */

static char *gcpProcName=NULL;

/**********************************************************************/
/*                                                                    */
/*                  Ot@Co͊֐                              */
/*                                                                    */
/**********************************************************************/
void
akbLogPrint(level,dir,src_pid,dest_pid,stat,manage)
int				level;			/* G[ or [jOw */
int				dir;			/* pPbg̕ */
long			src_pid;		/* vZXhc*/
long			dest_pid;		/* vZXhc*/
int				stat;			/* G[ */
int				manage;			/* G[u */
{
	int		i;
	char	*time_buf;
	char	stat_buf[BUF_SIZE];
	char	manage_buf[BUF_SIZE];
	char	rec_buf[BUF_SIZE];
	char	dir_buf[BUF_SIZE];
	char   *cpPath;

	/* VXeԂ̎擾 */
	time_buf = akb_log_time();

	/* pPbg̕ */
	switch(dir)
	{
		case D_DIR_READ:
			strcpy(dir_buf,D_STR_DIR_READ);
			break;
		case D_DIR_WRITE:
			strcpy(dir_buf,D_STR_DIR_WRITE);
			break;
		default:
			strcpy(dir_buf,D_STR_DIR_UNKNOWN);
			break;
	}

	/* G[Ԃ̐ݒ */
	switch (stat)
	{
		case D_STATUS_READ:
			strcpy(stat_buf,D_STR_STATUS_READ);
			break;
		case D_STATUS_WRITE:
			strcpy(stat_buf,D_STR_STATUS_WRITE);
			break;
		case D_STATUS_PRE:
			strcpy(stat_buf,D_STR_STATUS_PRE);
			break;
		default:
			strcpy(stat_buf,D_STR_STATUS_UNKNOWN);
			break;
	}

	/* G[u̐ݒ */
	switch (manage)
	{
		case D_MANAGE_EXIT:
			strcpy(manage_buf,D_STR_MANAGE_EXIT);
			break;
		case D_MANAGE_CLOSE:
			strcpy(manage_buf,D_STR_MANAGE_CLOSE);
			break;
		case D_MANAGE_RESEND:
			strcpy(manage_buf,D_STR_MANAGE_RESEND);
			break;
		case D_MANAGE_EXTINCT:
			strcpy(manage_buf,D_STR_MANAGE_EXTINCT);
			break;
		default:
			strcpy(manage_buf,D_STR_MANAGE_UNKNOWN);
			break;
	}

	/* PR[h쐬 */
	sprintf(rec_buf,"%s,%ld%s%ld,%s,%s\n",time_buf,src_pid,dir_buf,dest_pid,stat_buf,manage_buf);

	/* Ot@Cւ̏ */
	switch (level)
	{
		case D_ERROR_LOG:
		/*
			cpPath = akb_akb_home_add(COMMERRTMP);
			if (print_logfile(cpPath,rec_buf))
			{
				fprintf(stderr,"Log File Error!!(No.2)\n");
			}
		*/
			cpPath = akb_akb_home_add(COMMERR);
			if (print_logfile(cpPath,rec_buf))
			{
				fprintf(stderr,"Log File Error!!(No.3)\n");
			}
			break;
		case D_WARNING_LOG:
			cpPath = akb_akb_home_add(COMMWRN);
			if (print_logfile(cpPath,rec_buf))
			{
				fprintf(stderr,"Log File Error!!(No.4)\n");
			}
			break;
		default:
				fprintf(stderr,"Log File Error!!(No.5)\n");
	}
}

static int
print_logfile(fname,str)
char	*fname;
char	*str;
{
	int		fd;

	if ((fd = open(fname , O_RDWR|O_CREAT|O_APPEND , 0666)) == -1)
	{
#ifdef NOTICE
		fprintf(stderr,"%s open error\n",fname);
#endif
		return(-1);
	}
	fchmod(fd,0666);
/*******
	if (flock(fd , LOCK_EX) == 1)
	{
		fprintf(stderr,"%s lock error\n",fname);
		close(fd);
		return(-1);
	}
*******/
	if (write(fd , str , strlen(str)) == -1)
	{
#ifdef NOTICE
		fprintf(stderr,"%s write error\n",fname);
#endif
	/**********
		if (flock(fd , LOCK_UN) == 1)
			fprintf(stderr,"%s lock error\n",fname);
	*******/
		close(fd);
		return(-1);
	}
/**********
	if (flock(fd , LOCK_UN) == 1)
	{
		fprintf(stderr,"%s lock error\n",fname);
		close(fd);
		return(-1);
	}
***********/
	/* I */
	close(fd);
	return(0);
}

akb_error_outFile(error_file,file,line,format,msg,rcmsg)
char *error_file,*file,*msg,*rcmsg,*format;
int  line;
{
	FILE   *fp;
	char   *buf, *cpPath, *cpProc;

	if (!(cpProc=gcpProcName)) cpProc = "";

	if (gucLogFlg[0] & 0x02) {
		cpPath = akb_akb_home_add(error_file);
		fp = fopen(cpPath, "a");
		if (fp) {
			buf = akb_log_time();
			if (*buf){
				fprintf(fp,"%s ",buf);
			}
			fprintf(fp, "%s/%s(%d): ", cpProc, file, line);
			fprintf(fp, format, msg, rcmsg);
			fprintf(fp, "\n");
			fclose(fp);
		}
#ifdef NOTICE
		else  printf("%s(%d): LOG file open error\n", file, line);
#endif
	}
	if (gucLogFlg[0] & 0x01) {
		if (gcpProcName) printf("[%s] ", cpProc);
		else printf("%s(%d): ", file, line);
		printf(format, msg, rcmsg);
		printf("\n");
	}
	return 0;
}

akb_error_out_m(file,line,format,msg,rcmsg)
char *file,*msg,*rcmsg,*format;
int  line;
{
	char *p;

	p = akb_log_set_file_name(0, NULL);
	if (!p) p = akb_log_set_file_name(0, ERROR_LOG_FILE);
	return akb_error_outFile(p,file,line,format,msg,rcmsg);
}

akb_error_out(file,line,msg)
char *file,*msg;
int  line;
{
	akb_error_out_m(file,line,"%s",msg,"");
	return 0;
}

akb_error_outRc(file,line,msg,rc)
char *file,*msg;
int  line,rc;
{
	char rcmsg[20];

	sprintf(rcmsg,"%d",rc);
	akb_error_out_m(file,line,"%s %s",msg,rcmsg);
	return 0;
}

akb_error_outS(file,line,format,msg)
char *file,*msg,*format;
int  line;
{
	akb_error_out_m(file,line,format,msg,"");
	return 0;
}

akb_debug_input(file,line,msg,x,pi)
char *file,*msg;
int  line, x, *pi;
{
	char buf[64];

    printf("%s(%d): %s %d ==> ", file, line, msg, x);
	gets(buf);
	if (pi && *buf) *pi = atoi(buf);
	return 0;
}

int akb_log_flg(i,f)
int i,f;
{
	if (i>=0 && i<=3) {
		if (f >= 0) gucLogFlg[i] = f;
	}
	else {
		return -1;
	}

	return gucLogFlg[i];
}

akb_log_out(msg)
char *msg;
{
	FILE   *fp;
	char   *buf, *p, *cpProc;

	if (!(cpProc=gcpProcName)) cpProc = "";

	if (!msg) msg = gcpLogOutBuf;
	if (gucLogFlg[1] & 0x02) {
		p = akb_log_set_file_name(1, NULL);
		if (!p) p = akb_log_set_file_name(1, PRINT_LOG_FILE);
		if (fp=fopen(akb_akb_home_add(p, "a"))) {
			buf = akb_log_time();
			if (*buf){
				fprintf(fp,"%s ",buf);
			}
			fprintf(fp, "%s: %s\n", cpProc, msg);
			fclose(fp);
		}
	}
	if (gucLogFlg[1] & 0x01) {
		if (gcpProcName) printf("[%s] %s\n", cpProc,msg);
		else printf("%s\n",msg);
	}

	return 0;
}

char *akb_log_buf(len)
int len;
{
	if (len > 0) {
		if (gcpLogOutBuf) {
			gcpLogOutBuf = Realloc(gcpLogOutBuf,len);
		}
		else {
			gcpLogOutBuf = Malloc(len);
		}
	}
	return gcpLogOutBuf;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace_check(ucTrace,iRW,sCmd)
unsigned char *ucTrace;
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
short sCmd;
{
	pCOMM_PACK_HEAD pHead;
	int iTrace, iFlag;

	iTrace = ucTrace[sCmd];
	if (sCmd == CM_CMD_SEND) sCmd = 0;
	iFlag = 0;
	if (!sCmd && ((iTrace & 0x03)==0x03)) {
		if ((!(iTrace & 0x04) && (iRW==0 || iRW==2)) ||
		    (iTrace & 0x04)) iFlag = 1;
	}
	else {
		if ((!iRW && (iTrace & 0x01)) ||
		    ( iRW && (iTrace & 0x02))) iFlag = 1;
	}
	if (iFlag && iTrace & 0x08) iFlag = 2;
	return iFlag;
}

/********************************************/
/*                                          */
/********************************************/
int akb_trace(ucTrace,fname,iRW,cpPacket)
unsigned char *ucTrace;
char *fname;
int iRW;    /* 0/1/2=Read/Write/cpPrMain reply for Send */
char *cpPacket;
{
	pCOMM_PACK_HEAD pHead;
	short sCmd;
	int iFlag;
	char *p;

	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd = pHead->cph_prt.prt_cmnd & 0x00ff;

	if (iFlag=akb_trace_check(ucTrace,iRW,sCmd)) {
		if (iFlag == 2) p = NULL;
		else p = (char *)(pHead + 1);
		akb_dump(fname,iRW,pHead,p);
	}
	return 0;
}

void akb_log_set_proc_name(cpName)
char *cpName;
{
	int len;

	if (!cpName) {
		if (gcpProcName) {
			Free(gcpProcName);
			gcpProcName = NULL;
		}
		return;
	}
	len = strlen(cpName) + 1;
	if (gcpProcName) {
		gcpProcName=Realloc(gcpProcName,len);
	}
	else {
		gcpProcName=Malloc(len);
	}
	if (gcpProcName) strcpy(gcpProcName,cpName);
	return;
}

char *akb_log_get_proc_name()
{
	return gcpProcName;
}

akb_error_akb_dump(iRW,pHead)
int  iRW;
pCOMM_PACK_HEAD pHead;
{
	char *p;

	p = akb_log_set_file_name(0, NULL);
	if (!p) p = akb_log_set_file_name(0, ERROR_LOG_FILE);
	return akb_dump(p,iRW,pHead,pHead+1);
}

char *akb_log_set_file_name(i, cpFile)
int  i;
char *cpFile;
{
	int len;
	char *p=NULL;

	if (i>=0 && i<=3) {
		p = gcLogFile[i];
		if (cpFile) {
			len = strlen(cpFile) + 1;
			if (p) {
				p = Realloc(p,len);
			}
			else {
				p = Malloc(len);
			}
			if (p) {
				strcpy(p,cpFile);
				gcLogFile[i] = p;
			}
		}
	}

	return p;
}

int akb_get_log_time(buf,len,format)
char *buf,*format;
int  len;
{
	time_t  tt;
	struct  tm *tm_str;

	if (!buf) return -1;
	if (len <= 0) return -2;
	tt=time(NULL);
	tm_str=localtime(&tt);
	if (!format) format = "%Y/%m/%d %T";
	return strftime(buf,len,format,tm_str);
}

char *akb_log_time()
{
	static char buf[64];

	*buf = '\0';

	akb_get_log_time(buf,sizeof(buf),NULL);

	return buf;
}
