/*
 Copyright (C) 2022 Momi-g
 Copyright 2005 The Geany contributors

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=emsnip section=3 repnl=\040

@name emsnip
@_brief geany plugin, snippet complete with end match instead of word match
@_syno -
@tl_dr
		@(code)@
	// build shared lib, emsnip.so
	~$ cc emsnip.c -o emsnip.so -shared -fPIC `pkg-config --cflags geany`
	~$ cp emsnip.so ~/.config/geany/plugins/	#mkdir if /plugins isnt
	
	//plugin_load: run geany >> menubar >> tool >> plugins and set keybind
	//test working  'else if[tab]' and 'helloif[tab]'
		@()@
@_desc
	geany uses snippet complete with word match and needs leading 
	blankchar (whitechar).
	--
		@(code)
	eg) hello for[tab]	>> hello for(;;){} (replace)
	    hellofor[tab] >> hellofor (no replace)
		@()
	--
	this plugin allows you to use end match complete.
	--
		@(code)
	eg) hello for[tab]	>> hello for(;;){}
	    hellofor[tab] >> hellofor(;;){}
		@()
	--
	conflicting keybinds priority is undefined. maybe exec after default 
	keybindings. --
	geany srccode editor.c >> on_key_press_event() uses glib foreach() which
	uses liner list search. --
	--
	restrictions: --
	- snippet trigger strsz is hardcoded, must be less than 6 bytes --
	- dont set keybinding to 'space key'
@_eg
		@(code)@
	--snippets.conf
	...
	({=(){}
	
	--editor
	main({[tab]    >> main(){}
	myfunc({[tab]  >> myfunc(){}
	(dfl needs leading space, 'main ({[tab]' >> 'main (){}' )
		@()@

@return_value -
@notes	-
@conforming_to POSIX.1-2001+, needs 'pkg-config' 'geanyplugin.h'
@COPYRIGHT
	Copyright 2022 momi-g, GPLv3+ --
	Copyright 2005 The Geany contributors
@_ver 2022-06-08 v1.0.3 (2022-05-13 v1.0.0)
@_see
	https://raw.githubusercontent.com/geany/geany/master/HACKING
	https://www.geany.org/manual/reference/
//SH_docE*/
#ifndef emsnip_f483408eb181
#define emsnip_f483408eb181

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#endif /* emsnip_f483408eb181 */
