#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[/][/*]SH_'		;O=${0##*[/]};R=`dirname $0`/;R0=$R$O;Re=eval\ ;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGext"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d;:l
n;p;b l"<$R0>$Rm;$Rp"$Rm"';Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;b l"<$R0';Cw="(R=LS
$Rw;$Rw>&3;R=HD;$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';RB=$($R"s/${C}OP//p"\
<$R0|(F=mw;while read -r a b;do B=${a%:};F=`$Rp"$F"|$R"s#$B:*##;p"`${a%_};$Rp"
C$B=\$(cat<<'E'$O$b${O}E$O)";done;$Rp"R1=$F"));$Re"$RB";while getopts $R1 R;do
case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac;done
[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit #END  GPLv3+*/

/*SH_LS*/
/*
 Copyright (C) 2022 Momi-g
 Copyright 2005 The Geany contributors

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

/*SH_doc
title=*SH_bn* section=3 repnl=\040

@name *SH_bn*
@_brief geany plugin, snippet complete with end match instead of word match
@_syno -
@tl_dr
		@(code)@
	// build shared lib, emsnip.so
	~$ cc emsnip.c -o emsnip.so -shared -fPIC `pkg-config --cflags geany`
	~$ cp emsnip.so ~/.config/geany/plugins/	#mkdir if /plugins isnt
	
	//plugin_load: run geany >> menubar >> tool >> plugins and set keybind
	//test working  'else if[tab]' and 'helloif[tab]'
		@()@
@_desc
	geany uses snippet complete with word match and needs leading 
	blankchar (whitechar).
	--
		@(code)
	eg) hello for[tab]	>> hello for(;;){} (replace)
	    hellofor[tab] >> hellofor (no replace)
		@()
	--
	this plugin allows you to use end match complete.
	--
		@(code)
	eg) hello for[tab]	>> hello for(;;){}
	    hellofor[tab] >> hellofor(;;){}
		@()
	--
	conflicting keybinds priority is undefined. maybe exec after default 
	keybindings. --
	geany srccode editor.c >> on_key_press_event() uses glib foreach() which
	uses liner list search. --
	--
	restrictions: --
	- snippet trigger strsz is hardcoded, must be less than 6 bytes --
	- dont set keybinding to 'space key'
@_eg
		@(code)@
	--snippets.conf
	...
	({=(){}
	
	--editor
	main({[tab]    >> main(){}
	myfunc({[tab]  >> myfunc(){}
	(dfl needs leading space, 'main ({[tab]' >> 'main (){}' )
		@()@

@return_value -
@notes	-
@conforming_to POSIX.1-2001+, needs 'pkg-config' 'geanyplugin.h'
@COPYRIGHT
	Copyright 2022 momi-g, GPLv3+ --
	Copyright 2005 The Geany contributors
@_ver 2022-06-08 v1.0.3 (2022-05-13 v1.0.0)
@_see
	https://raw.githubusercontent.com/geany/geany/master/HACKING
	https://www.geany.org/manual/reference/
//SH_docE*/
/*SH_ED*/

/*SH_HD*/
#ifndef emsnip_f483408eb181
#define emsnip_f483408eb181

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#endif /* emsnip_f483408eb181 */
/*SH_ED*/


/*SH_SC*/
/* tool macros */
#ifndef ERRact
#include <stdio.h>
 #if (199901L <= __STDC_VERSION__ +0)	/* nealy 200112L, _POSIX_C_SOURCE	c99*/
	#include <sys/types.h>
	#include <unistd.h>
	#define ERRactag	__func__, getpid()
 #else
	#define ERRactag	"func:c99+", 0
 #endif
 #include <string.h>
 #include <errno.h>
 #define ERRact(xpr, msg, act)	if(xpr){ int en_=errno; fprintf(stderr, \
	"ERR: %s %d %s() pid:%d %s msg:%s sys:%s\n",__FILE__,__LINE__, ERRactag \
	, "hit(" #xpr ")", msg, strerror(en_) ); act; }
 #define STOP(xpr, msg)	ERRact(xpr, msg, fputs("STOP\n",stderr);exit(1) )
#endif

#define loop(a)		for(int lpcnt=1;lpcnt<=(a);lpcnt++)
/*tool end*/

#ifdef TEST
# include <assert.h>
# include "*SH_bn*.h"
# include "hcut.h"
# include "msgp.h"
# include "laptime.h"
# define qu(...)		Qsub(__VA_ARGS__)
# define Qsub(...)	#__VA_ARGS__
#endif

#include <geany/geanyplugin.h>	/*SH_co* `pkg-config --cflags geany --libs geany` */

//dbgtool
#define gpf(...) gpf_impl( __LINE__, __VA_ARGS__)
#define gpf_impl(...) gpf_impl_(__VA_ARGS__)
#define gpf_impl_(n, ...) {char sbuf[100]={0};snprintf((void*)sbuf, 99, __VA_ARGS__); strcat(sbuf, " :" #n); dialogs_show_msgbox(GTK_MESSAGE_INFO, (void*)sbuf);}

//trigger maxsz
#define EMAX 6

// plugin connector
static gboolean fs_load(GeanyPlugin* obj, gpointer udata);
static void fs_unload(GeanyPlugin* obj, gpointer udata);
static void fs_helpcb(GeanyPlugin* obj, gpointer udata);
//static void fs_cfgcb(GeanyPlugin* obj, gpointer udata);
//static void fs_act(guint keyid);
static gboolean fs_act(GeanyKeyBinding* key, guint keyid, gpointer user_data);

void geany_load_module(GeanyPlugin* pobj){
	pobj->info->name = "*SH_bn*";
	pobj->info->description = "snippets complete with end match instead of word match";
	pobj->info->version = "*SH_ver*"+1;
	pobj->info->author = "momi-g <dmy@dmy.dmy>";

	pobj->funcs->init = fs_load;	
	pobj->funcs->cleanup = fs_unload;
	pobj->funcs->configure = NULL; //fs_cfgcb;
	pobj->funcs->help = fs_helpcb;	
	pobj->funcs->callbacks = NULL;

	GEANY_PLUGIN_REGISTER(pobj, 226);
	return;
}

static const char* hmsg =
/*SH_lit*/
/*SH_rf* 0 *SH_bn*.3.txt */
/*SH_litE*/
;

static void showhelp(const char* s){
    GtkWidget *tx, *w, *scr_v;
    GtkTextBuffer* tbuf;

    w = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_default_size(GTK_WINDOW(w), 600, 400);
    
    scr_v = gtk_scrolled_window_new(NULL, NULL); 
    tx = gtk_text_view_new();

    tbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(tx));
    gtk_text_buffer_set_text(tbuf, s, -1);

    gtk_container_add(GTK_CONTAINER(scr_v), tx);
    gtk_container_add(GTK_CONTAINER(w), scr_v);
    gtk_widget_show_all(w);
}



static void fs_helpcb(GeanyPlugin* pobj, gpointer udata){
	showhelp(hmsg);
//	dialogs_show_msgbox(GTK_MESSAGE_INFO, hmsg);
}

static gboolean fs_load(GeanyPlugin* pobj, gpointer udata){
	GeanyKeyGroup *key_group;
	key_group = plugin_set_key_group(pobj, "*SH_bn*", 1, NULL);
	keybindings_set_item_full(key_group		/* GeanyKeyGroup* */
		, 0 /* groupid, 0,1,2... above ag3 idx */
		, 0	/* dfl-key GDK_KEY_j etc.  but set 0 to avoid user keybind conflict */
		, 0	/* dfl-mod GDK_CONTROL_MASK */
		, "*SH_bn*"	/* namestr: APIname to use in config.ini "str" == myf() bindings */
		, "run *SH_bn*"	/* label: desc in keybind config window */
		, NULL	/* additionally, GtkWidget* (btn etc) exec this kb. set NULL if nouse */
		, fs_act	/* gboolean f(GeanyKeyBinding *key, guint keyid, gpointer user_data) */
		, pobj	/* void* udata you want to pass the cb */
		, NULL	/* destructor, free() etc */ 
	);
	return TRUE;
}
static void fs_unload(GeanyPlugin* obj, gpointer udata){ ; }

static int f_emsnip_act(int keyid, GeanyPlugin* pobj);
gboolean fs_act(GeanyKeyBinding* kobj, guint keyid, gpointer udata){
//	dialogs_show_msgbox(GTK_MESSAGE_INFO, "123");
	GeanyPlugin* pobj = udata;
	int rc = f_emsnip_act(keyid, pobj);
// true/false == eat/fall-through 
// https://www.geany.org/manual/reference/keybindings_8h.html
	if(rc){return FALSE;}
	return TRUE;
}
//plugin connector end


//emsnip code 

#include "*SH_bn*.h"
//#include "msgp.h"

extern GeanyMainWidgets		main_widgets;
extern GeanyEditorPrefs		editor_prefs;
extern GeanyKeyGroup* keybindings_get_core_group(guint id);
extern GeanyKeyBinding* keybindings_lookup_item(guint group_id, guint key_id);

static GHashTable *snippet_hash = NULL;
static gboolean at_eol(ScintillaObject *sci, gint pos);
static int do_replace(GeanyEditor* editor, gint pos, char** kv);

//static int f_emsnip_act(int keyid, GeanyPlugin* pobj);
static char** emsnip_word_stem(GeanyDocument* doc, char* extstr);
static char* f_gettail(GeanyDocument *doc);


// copied: keybindings.c/cb_func_editor_action()
static int f_emsnip_act(int keyid, GeanyPlugin* pobj){
//keyid doesnt use
	snippet_hash = g_hash_table_new_full(
		g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_hash_table_destroy
	);

	GeanyDocument *doc = document_get_current();
	GtkWidget *focusw = gtk_window_get_focus(
		GTK_WINDOW(pobj->geany_data->main_widgets->window)
	);
//skip if sci_widget has no nofocus
	if (doc == NULL || focusw != GTK_WIDGET(doc->editor->sci) ){ return 1; }

//copied: keybindings.c/check_snippet_completion(doc);
	ScintillaObject *sci = doc->editor->sci;
	gint pos = sci_get_current_position(sci);
	if(! pobj->geany_data->editor_prefs->complete_snippets){return 1;}	//skip if nouse flg: snippet 

//copied: editor.c/editor_complete_snippet()
	if (sci_has_selection(sci)){ return 1;}	//skip if cursor stat is 'str_select'

//specialcase: kb==spc: works only at eol or while_flg
// useless geany API and doc. omit spc keybind flg
//keybindings.h
//plugin API lookup_item >> get_item
//	int b_spc = (keybindings_lookup_item(GEANY_KEY_GROUP_EDITOR
//		, GEANY_KEYS_EDITOR_COMPLETESNIPPET)->key == GDK_KEY_space);
//	GeanyKeyGroup* g = keybindings_get_core_group(GEANY_KEY_GROUP_EDITOR);
//	int b_spc = (keybindings_get_item(g, GEANY_KEYS_EDITOR_COMPLETESNIPPET)->key == GDK_KEY_space);

//原因不明だがflg,eol系はスキップしないと中途補完がきかないようだ。
//	int b_spc=0;
//	int b_wflg = editor_prefs.complete_snippets_whilst_editing;
//	int b_wflg = pobj->geany_data->editor_prefs->complete_snippets_whilst_editing;
//	int b_eol  = at_eol(sci, pos);
//	while(b_spc){
//		if(b_eol){break;}
//		if(b_wflg){break;}
//		return 1;
//	}
// skip_end
//--core_code: editor.c/editor_complete_snippet()
//get geany snippet hash
	int extid = doc->editor->document->file_type->id;
	GeanyFiletype* ft = filetypes_index(extid);

//get ematch snip
	char** kv = emsnip_word_stem(doc, ft->name);
	if(kv==NULL){ kv = emsnip_word_stem(doc, "Default"); }
	if(kv==NULL){ return 1;}		//no snippet

//do replace
	sci_start_undo_action(sci);	/* needed because we insert a space separately from construct */
	do_replace(doc->editor, pos, kv);
	sci_end_undo_action(sci);

//suc
	return 0;
}	

//get endstr matching snippet. check both XXX.ext/"Default" hash
//editor.c/editor_read_word_stem()
static char** emsnip_word_stem(GeanyDocument* doc, char* extstr){
	static char* kv[2] = {NULL, NULL};
	
	char* key = NULL;
	char* val = NULL;
	char** rp = NULL;
	
	if(0){
lb_RTN:;
		if(val){
			kv[0] = key;
			kv[1] = val;
			rp = (char**)kv;
		}
		return rp;
	}

	char* s = f_gettail(doc);
	int lsz = strlen(s);
	if( lsz==0 ){ goto lb_RTN; }
	key = s + lsz;

	void* tp = NULL;
	if(strcmp(extstr, "Default") ){tp = doc->editor;}
	for(;;){
//gpf("@%s/%s\n", key, val);
		key--;
		if(key<s){break;}
		val = (char*)editor_find_snippet(tp, key); // p=NULL >> default, not null>>ext
		if(val){break;}
	}
	goto lb_RTN;
}

//editor.c/read_current_word(), get current line
char* f_gettail(GeanyDocument *doc){
	ScintillaObject *sci = doc->editor->sci;
	int cpos = sci_get_current_position(sci);
	int lnum = sci_get_line_from_position(sci, cpos);
	//	int lpos = sci_get_position_from_line(sci, lnum);
	char* p = sci_get_line(sci, lnum);

	int spos = sci_get_position_from_line(sci, lnum);
	int lpos = cpos - spos;

	char* ep = p + lpos;
	if(*ep=='\n'){ep--;}
	if(*ep=='\r'){ep--;}
	
	if(ep-p+1>EMAX){ p = ep-EMAX+1; }
	static char sbuf[EMAX+1]={0};
	int sz=ep-p+1;
	memcpy(sbuf, p, sz);
	sbuf[sz]=0;
	return sbuf;
}

//copied: editor.c / at_eol()
static gboolean at_eol(ScintillaObject *sci, gint pos){
	gint lnum = sci_get_line_from_position(sci, pos);
	for(;;pos++) {
		gchar c = sci_get_char_at(sci, pos);
		if(c != ' ' && c != '\t'){ break; }
	}
	return (pos == sci_get_line_end_position(sci, lnum) );
}

// copied: editor.c/snippets_complete_constructs()
static int do_replace(GeanyEditor* editor, gint pos, char** kv){
	ScintillaObject *sci = editor->sci;
	char* src = kv[0];
	char* rep = kv[1];
	int srcsz = strlen(src);
	
	sci_set_selection_start(sci, pos - srcsz);
	sci_set_selection_end(sci, pos);
	sci_replace_sel(sci, "");
	pos -= srcsz;

	editor_insert_snippet(editor, pos, rep);
	sci_scroll_caret(sci);
 	return 0;
}

#ifdef TEST
HCUT_ADD(t_0) {
	eq_i(1, 1, "msg");
}
#endif

/*SH_SMP
#include "*SH_bn*.h"	//SH_co* -static *
#include <stdio.h>

int main(int argc, char** argv) {
	puts("hw");
	return 0;
}
//~$ gcc src.c
//SH_SMPE*/

#ifdef TEST
HCUT_RUN("stderr", 1,
		 t_0)
#endif

/*
 change log
 --
2022-06-08	Momi-g	<dmy@dmy.dmy>

	* configure.ac: fix autotools files

2022-06-01	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: cmtout _act() >> space+at_eol skipcode

2022-05-28	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: improve gettail(), do_replace()

2022-05-25	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: refactoring. v1.0.1

2022-05-18	Momi-g	<dmy@dmy.dmy>

	* *SH_bn*.sh.c: init
*/

/*SH_ED*/

/*SH_OP _ set -e;a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
/*SH_OP	h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
/*SH_OP	f sed -ne "/${C}DF/q;/;/d;/^[a-zA-Z].*)/p"<$R0 #*/
/*SH_OP t $e"$CW";ftt "$@";$p'cc -O0 -static -Wall -pedantic -Wfatal-errors -g -pg -ggdb3 $Rm `fOI $Rs $tf` `fg $Rs $tf` `fL`'|fv	#*/
/*SH_OP T $e"$CW";ftt "$@";$p'cc -O3 $Rm `fOI $Rs $tf ` `fg $Rs $tf ` `fL`'|fv	#*/
/*SH_OP s $e"$CB";fgr0 "${C}SMP" "${C}SMPE"<$Rs|fbn>eg.c;$p'cc eg.c `fg eg.c` `fOI eg.c`'|fv #*/

/*SH_OP L $p"valgrind --leak-check=full --show-leak-kinds=all --track-origins=yes --verbose ./a.out 2>&1|sed -e '/SUMMA/!d;n;n;n;n'"|fv #*/
/*SH_OP M $p"fM ./a.out"|fv	 #*/
/*SH_OP P $p'valgrind --tool=callgrind --callgrind-out-file=log.out ./a.out;kcachegrind log.out'|fv	 #*/

/*SH_OP b $e"$CW";$p'cc -c $Rs -pedantic -O2 -Wall -g `fg $Rs` `fI $Rs`'|fv;$p"$bn.o" #*/
/*SH_OP B $e"$Cb";$p"ar -r lib$bn.a $bn.o `fO $Rs`"|fv;$p"lib$bn.a"	#*/
/*SH_OP A $e"$CB";$p'fA lib$bn.a `fg $Rh $Rs|fu|grep '[.]a$'|fU`'|fv;$p"lib$bn.a" #*/
/*SH_OP S $e"$CW";$p"cc -shared -fPIC -o lib$bn.so $bn.c `fOI $Rs` `fg $Rs`"|fv;$p"lib$bn.so" #*/
/*SH_OP W $e"$Cm$O$Cw">/dev/null;fborn;$p"$Rs $Rh $tf"	#*/

/*SH_OP o $e"$CW";$p'fman $Rh 3'|fv		#*/

/*SH_OP z fgr0 '^[/][/*]SH_doc' '^[/][/*]SH_docE'<./hw_geany.h >hw_geany.3	#*/

/*SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 man -Tutf8 /dev/stdin<$bn.$2|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt
 "|fv
)

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv|flit)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()($e\$p`sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"`|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

# fO src.o from inc"src.abc" etc. kick self
fO()(set -- `fdp "$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
	buf="";for i;do test -f $i&&buf="$buf $i";done;$p"$buf"
)
fI()(fdp "$@"|sed -e 's/[^/]*$//g'|fu|sed -e '/./s/^/ -I/g'|fu|grep -v '^\-I$'|fU)
fL()(find -L `dirname $R0` -type d|sed -e 's/^/-L/g'|fU)
# inc""系.h,hpp,oをパス付きで羅列 OIはfdpが重複するので高速化でまとめる 複数file_ok
fOI()(
set -- `fdp "$@"`
s="-I./ "`$p"$@"|sed -e 's/[^/]*$//g'|fu|sed -e 's/^/ -I/g'|fu|grep -v '^\-I$'|fU`
set -- `$p"$@"|awk '$0~/[.](h|hpp)$/{print}'|sed -e 's/[.][^.]*$/.c/'|fU`
buf="";for i;do test -f $i&&buf="$buf $i";done;
$p"$buf $s"
)

# 依存inc""を再帰的に取得./以下全て self系はkick
fdp()( l="$*"; paths="$@"; all=""; used=""
 while :;do
	all=`$p$all $paths|fU`	#差分を追加 repの始末 差分たちからaaa.hを取得 partial path
	buf=`(cat $paths|sed -ne 's@^[ \t]*#inc[^"]*.\([a-zA-Z0-9._]*\)".*@\1@p')|sort -u`
	ch=`$p$used $buf|tr -s ' ' '\n'|sort|uniq -u`	#使用済は外す
	used="$used $ch"	#リスト更新
	paths=`fsvy $ch|sort -u`	#ls検索 name系のみのはず
	buf=`$p"$all" "$paths"|fU`	#増えたらloop
	[ ${#all} = ${#buf} ]&&break
 done
# initを除く
 set -- $all
 for i;do a=${i##*[/]}; a=${a%%.*};[ "${l##*$a*}" = "$l" ]&&set -- "$@" $i;shift;done
 $p"$@"
)

# corecode:search + depthck + uniq
fsvy()(c="find -L ./ -false"
	for i; do c="$c -o -path '*'$i";done; l=`$e"$c"`
	for i; do $p"$l"|grep -F "$i"|awk '{sv=$0;print gsub("[/]","") " " sv}'|
	sort -k 1.1,1n -k 2.2,2|awk '{print $2;exit}'; done
)

# libをまとめる
fA()(n=0;dir=`dirname $0`/tmpdir;mkdir $dir;cd $dir;
 for i;do
 	n=$((n+1))
 	cp ../$i $i
 	ar -x $i
 	for ii in *.o;do mv "$ii" "p${n}_$ii";done
 	ar -r lib$bn.aa *.o
 	rm *.o
 done
 $p'mv lib$bn.aa ../lib$bn.a'|fv
 cd ..;rm -r $dir
)

#-- yacc
# /*SH_OP y $e"$CW";fy
# /*SH_OP Y $e"$Cy";fU $( ($p"lib$bn.a";fg $Rs $Rh)|$n|grep '[.]a$'|$U)
fy()(
cat<<'EEE'|fv
fgr0 "${C}YACC" "${C}YACCE"<$Rs>myyacc.y
fgr0 "${C}LEX" "${C}LEXE"<$Rs>mylex.l
lex mylex.l; yacc -p zz -dv myyacc.y
cat y.tab.c lex.yy.c > $Rs
gcc -c y.tab.c lex.yy.c -lfl `fA $Rs $Rh`
rm mylex.l myyacc.y lib$bn.a
ar r lib$bn.a `fo $Rs` y.tab.o lex.yy.o
$p"lib$bn.a"
EEE
)

#-- longcmd
frf()(
 # *sh_rf* 0 a.txt b.txt ...でcat纏めて出力 top0でsrcinfoは無し出力
 awk -v tg="${C##*]}rf" 'index($0,tg){
 s=substr($0, index($0,tg)+length(tg)+1);split(s, a)
 m="[ -f \"%s\" ]&&(echo \"/*--copyfrom %s*\"/;cat \"%s\";echo \"/*--copyend %s*\"/)"
 mm="[ -f \"%s\" ]&&(_=\"%s\"/;cat \"%s\";_=\"%s\")"
 for(i=1;i in a;i++){v=a[i];if(v==0){m=mm;continue};system(sprintf(m,v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")
flit()(sed -ne "/${C}lit/bl;p;d;:l;n;/${C}litE/d;"'s/[\]/&&/g;s/"/\\"/g;s@.*@"&\\n"@g;p;bl')

fte(){
 cat > $Rm-
 a="`sed -ne 's@^HCUT_ADD(\([^)]*\).*@\1, @p' $Rm-|tr -d '\n'`NULL"
 if [ $# != 0 ];then	a=""; for i;do a="$a $i,";done; a="$a NULL"; fi
 sed -ne "p;/_RUN/bl;d;:l;/[)]/{c\\$O $a)$O p;d};n;bl" $Rm-
 rm $Rm-
}
ftt()(fte "$@"<$tf>$Rm;mv $Rm $tf; cat $Rs $tf>$Rm)
fborn(){
 fgr0 "^#ifdef TEST" "^#endif"<$R0|fbn>$tf
 fgR "^#ifdef TEST_" "^#endif"<$R0 |fgr0 "^#ifdef TEST" "^#endif"|fbn|fte>tests.code
 fgR "^#ifdef TEST" "^#endif"<$Rs|fbn>$Rm;mv $Rm $Rs;fbn<$Rh>$Rm;mv $Rm $Rh
}
fM()(
 valgrind -q --tool=massif --massif-out-file=./vmem.buf --stacks=yes --trace-children=yes $1>/dev/null
 ms_print ./vmem.buf|sed -ne '/[KMG]B/bl;d;:l;/snap/q;p;n;bl';rm ./vmem.buf)

/*SH_DE*/
