static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/**********************************************************************
*                                                                     *
*      ړI@@F  rZ 	@                            *
*                                                                     *
*      ֐@@@F@int cl_if_comp_ctl( pLeaf )		              *
*                                                                     *
*            F@(I)Leaf          * pLeaf                       *
*                                                                     *
*                                                                     *
*      ߂l@@@F@ERROR                                          *
*                      NORMAL                                         *
*                                                                     *
*      Tv@@F@                                               *
*                                                                     *
**********************************************************************/
#include <colmn.h>

extern GlobalCt  *pGlobTable;
extern CLCOMMON  CLcommon;
extern int giOptions[];

static int iEROUT_NDEF;

int cl_if_comp_ctl(pLeaf,proc)
Leaf    *pLeaf;
ProcCT  *proc;
{
	int  	Flag;

	if (pLeaf->cmd.prmnum > 0) {
		if ((Flag = cl_if_comper(pLeaf,proc)) < NORMAL)
			return ERROR;
	}
	else {
		ERROROUT1(FORMAT(44),"cl_if_comp_ctl");	/* %s: p[^KvłB */
		Flag  = ERROR;
	}

	return Flag;
}

int cl_is_true(pInfoParm)
tdtInfoParm *pInfoParm;
{
	int rc,Ans,atr;
	double dVal;
	char *pWork;

DEBUGOUT_InfoParm(190,"cl_is_true: ",pInfoParm,0,0);

	atr   = pInfoParm->pi_attr;
	pWork = pInfoParm->pi_data;
	if (pInfoParm->pi_dlen == 0) rc = L_OFF;
	else if (atr == DEF_ZOK_BINA) {
		Ans = cl_get_data_long(pInfoParm);
		if (Ans) rc = L_ON;
		else rc = L_OFF;
	}
	else if (atr == DEF_ZOK_FLOA) {
		memcpy(&dVal,pWork,sizeof(double));
		if (dVal == 0.0) rc = L_OFF;
		else rc = L_ON;
	}
	else if (atr == DEF_ZOK_DECI) {
		if (m_is_mpa0((MPA *)pWork)) rc = L_OFF;
		else rc = L_ON;
	}
	else {
		rc = L_ON;
	}
	return rc;
}

int cl_if_compare_sub(nparm,prmp,Obj)
int nparm;
parmList *prmp[];
int      *Obj;
{
	int rc,Ans;
	double dVal;
	char *pWork;
	tdtInfoParm InfoParm1;

#if 1	/* 2021.9.29 */
	rc = cl_gx_exp_tree_obj(nparm,prmp,Obj,&InfoParm1);
#else
	rc = cl_gx_exp_obj(nparm,prmp,Obj,&InfoParm1);
#endif
	pWork = InfoParm1.pi_data;
	if (!rc) {
#if 1	/* 2019.4.7 */
		rc = cl_is_true(&InfoParm1);
#else
		if (InfoParm1.pi_dlen == 0) rc = L_OFF;
		else if (InfoParm1.pi_attr == DEF_ZOK_BINA) {
			Ans = cl_get_data_long(&InfoParm1);
			if (Ans) rc = L_ON;
			else rc = L_OFF;
		}
		else if (InfoParm1.pi_attr == DEF_ZOK_FLOA) {
			memcpy(&dVal,pWork,sizeof(double));
			if (dVal == 0.0) rc = L_OFF;
			else rc = L_ON;
		}
		else if (InfoParm1.pi_attr == DEF_ZOK_DECI) {
			if (m_is_mpa0((MPA *)pWork)) rc = L_OFF;
			else rc = L_ON;
		}
		else {
			rc = L_ON;
		}
#endif
	}
	else if (rc == 100) rc = L_OFF;
	return rc;
}

int cl_if_comper(pLeaf,proc)
Leaf    *pLeaf;
ProcCT  *proc;
{
	return cl_if_compare_sub(pLeaf->cmd.prmnum,pLeaf->cmd.prmp,proc->Obj);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp_tree_obj(nparm,prmp,Obj,pInfoParmW)
int nparm;
parmList  *prmp[];
tdtInfoParm **Obj;
tdtInfoParm *pInfoParmW;
{
DEBUGOUTL2(150,"cl_gx_exp_obj: nparm=%d prmp[0]->opt=0x%08x",nparm,prmp[0]->opt);
	return cl_gx_exp_tree_obj_opt(nparm,prmp,Obj,pInfoParmW,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp_tree_obj_opt(nparm,prmp,Obj,pInfoParmW,opt)
int nparm;
parmList  *prmp[];
tdtInfoParm **Obj;
tdtInfoParm *pInfoParmW;
int opt;
{
	GWPRM_S gwprm;
	MCAT mcat;
	SSPL_S ssp;
	int rc,i,len;
	char wrk[4096],*p;
	GXObject  **bxobj;

DEBUGOUTL2(150,"cl_gx_exp_obj_opt:Enter prmp[0]->opt=0x%08x opt=0x%08x",prmp[0]->opt,opt);

	ssp.sp=0;
	ssp.wd=wrk;
	ssp.wdmax = sizeof(wrk);
	if (prmp[0]->opt & D_GX_OPT_NO_USE_OBJ) bxobj = NULL;
	else bxobj = &prmp[0]->bxobj;

	gwprm.nparam = nparm;
	gwprm.maxlen = sizeof(wrk)-1;
	gwprm.parmLp = prmp;
	gwprm.iparam = 0;
	rc = cl_gx_exp_gp_tree_obj_opt(&gwprm,&ssp,bxobj,Obj,pInfoParmW,opt);

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_exp_obj_opt:Exit rc=%d",pInfoParmW,rc,0);

	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_exp_gp_tree_obj_opt(pgwprm,pssp,bxobj,Obj,pInfoParmW,opt)
GWPRM_S *pgwprm;
SSPL_S  *pssp;
GXObject *bxobj[];
tdtObjHead *Obj;
tdtInfoParm *pInfoParmW;
int opt;
{
	static char *name="cl_gx_exp_gp_obj_opt";
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	int rc,do_compile,i,im,imw,n,nob0,cnt,ix,ntr,nnest,nest[10],nest_flg[10];
	GXObjectExpand bxObjExpand;
	MCAT Ms_obj,Ms_obj0,Ms_da;
	GXObject bxObj,*pbxObj;
	ProcCT *proc;
	tdtInfoParm **pObj0,*pInfo,**Obj0;
	WHERE_TREE tree[100];

DEBUGENT2("bxobj=0x%08x Obj=0x%08x",bxobj,Obj);

DEBUGOUTL2(160,"cl_gx_exp_gp_obj_opt: bxobj=0x%08x Obj=0x%08x",bxobj,Obj);

	if (pInfoParmW) memset(pInfoParmW,0,sizeof(tdtInfoParm));
	do_compile = 1;
	rc = 0;
	if (bxobj) {
		if (pbxObj=bxobj[0]) {
			if (pbxObj->nobj > 0) do_compile = 0;
DEBUGOUTL2(161,"cl_gx_exp_gp_obj_opt: pbxObj=0x%08x nobj=%d",pbxObj,pbxObj->nobj);
		}
	}
	else {
		pbxObj = NULL;
		opt = (opt & ~D_GX_OPT_ALC_MASK) | D_GX_OPT_ALC_TMP;
	}

	if (CLcommon.dbgopt[2] & 0x01) do_compile = 1;

	if (do_compile) {
		if (pgwprm->iparam >= 0) {
			mcat.mc_ipos = 0;
			if ((rc=cl_mk_gp_parm(&mcat,pgwprm,pgwprm->nparam,pgwprm->parmLp)) < 0) return rc;
		}
		cl_gx_init_expand(&Ms_obj,"BJ",sizeof(short),MAX_OBJECT);
		cl_gx_init_expand(&Ms_obj0,"J0",sizeof(tdtInfoParm *),MAX_PMSTK);
		cl_gx_init_expand(&Ms_da,"DA",sizeof(char *),MAX_PMSTK);
		cl_gx_expand(&Ms_obj,0,NULL);
		cl_gx_expand(&Ms_da,0,NULL);
		cl_gx_expand(&Ms_obj0,0,NULL);
		bxObjExpand.ms_obj  = &Ms_obj;
		bxObjExpand.ms_da   = &Ms_da;
		bxObjExpand.ms_obj0 = &Ms_obj0;
		bxObjExpand.index0  = 0;
		if (pbxObj) opt = (opt & ~D_GX_OPT_ALC_MASK) | D_GX_OPT_ALC_TMP;
		rc=cl_gx_compile_gp_opt(pgwprm,pssp,opt,&bxObjExpand);
		if (rc!=C_DO_OPTIMIZE && rc) {
DEBUGOUTL1(150,"cl_gx_exp_gp_obj_opt:cl_gx_compile_gp_opt rc=%d",rc);
			switch (rc) {
				case ECL_SYNTAX_ERROR:
					/* SYNTAXG[B */
					ERROROUT1(FORMAT(171),name);
					break;
				case ECL_MAX_DA_ERROR:
					/* ev[EI[ot[B */
					ERROROUT1(FORMAT(172),name);
					break;
				case ECL_MAX_OBJ_ERROR:
					/* IuWFNgEI[ot[B */
					ERROROUT1(FORMAT(173),name);
					break;
				case ECL_MALLOC_ERROR:
					/* malloc error. */
					ERROROUT1(FORMAT(174),name);
					break;
				case -6:
					/* G[(ANVlsł)B */
					ERROROUT1(FORMAT(175),name);
					break;
				default:
					break;
			}
		}
		else {
			bxObj.nobj  = bxObjExpand.nobj;
			bxObj.nda   = bxObjExpand.nda;
			bxObj.nobj0 = bxObjExpand.nobj0;
			cl_gx_expand(&Ms_da,-1,&bxObj.da);
			cl_gx_expand(&Ms_obj,-1,&bxObj.obj);
			cl_gx_expand(&Ms_obj0,-1,&bxObj.obj0);
			bxObj.index0 = bxObjExpand.index0;
			if (opt & D_GX_OPT_PARMINFO2) bxObj.index0 |= 0x04;
/*
printf("%s: index0 = %08x\n",name,bxObj.index0);
*/
			if (rc == C_DO_OPTIMIZE) {
				rc = cl_gx_iif_optimize(bxObj.obj,bxObj.nobj,bxObj.obj0);
				if (rc > 0) {
					if (rc == C_CAN_NOT_OPTIMIZE)
						ERROROUT1(FORMAT(176),name);
					rc = 0;
				}
				else if (rc == ECL_OPTIMIZE_ERROR)
					ERROROUT1(FORMAT(177),name);
				else if (rc == ECL_SYNTAX_ERROR)
					ERROROUT1(FORMAT(171),name);
			}
if (DEBUGOUTCHECK(155)) {
short *objw;
objw = bxObj.obj;
for (i=0;i<bxObj.nobj;i++) {
DEBUGOUTL2(155,"optimized obj[%2d]=%d",i,objw[i]);
}
}
			pObj0 = bxObj.obj0;
			if (bxobj) {
				im = (opt & D_GX_OPT_ALC_MASK)>>12;
				if (!pbxObj) {
					bxobj[0] = pbxObj = (GXObject *)cl_opt_malloc(im,sizeof(GXObject));
					memset(pbxObj,0,sizeof(GXObject));
				}
DEBUGOUTL2(150,"cl_gx_exp_gp_obj_opt: im=%d pbxObj=0x%08x",im,pbxObj);
				pbxObj->nobj = bxObj.nobj;
				pbxObj->nda  = bxObj.nda;
				pbxObj->nobj0 = nob0 = bxObj.nobj0;
				pObj0 = pbxObj->obj0;
				if (bxObj.nobj) {
					n = sizeof(short)*bxObj.nobj + sizeof(tdtInfoParm *)*nob0;
					pbxObj->obj  = (short *)cl_opt_malloc(im,n);
					pbxObj->da   = (char **)cl_opt_malloc(im,sizeof(char **)*bxObj.nda);
					pbxObj->obj0 = (tdtInfoParm **)(pbxObj->obj + bxObj.nobj);
					pbxObj->index0 = bxObj.index0;
					memcpy((char *)pbxObj->obj,(char *)bxObj.obj,sizeof(short)*bxObj.nobj);
					memcpy((char *)pbxObj->da,(char *)bxObj.da,sizeof(char **)*bxObj.nda);
					memcpy((char *)pbxObj->obj0,(char *)bxObj.obj0,sizeof(tdtInfoParm *)*nob0);
					pObj0 = pbxObj->obj0;
					if (nob0) {
						if (Obj) {
							if (!(Obj=_add_obj0(Obj,pbxObj))) return ECL_MALLOC_ERROR;
							if (_re_set_obj0(Obj,pbxObj)) return -1;
							Obj0 = Obj->Obj0;
							pObj0 = &Obj0[pbxObj->maxobj0-1];	/* 2021.4.1 add -1 */
						/*	_clear_obj_addr(pbxObj,NULL,pbxObj->obj0);	*/
						}
					}
				}
			}
			else pbxObj = &bxObj;
			ntr = cl_gx_cr_tree(bxObj.obj,bxObj.nobj,tree);
			for (i=0;i<ntr;i++) {
				printf("i=%d mcode=%d t1=%d t2=%d\n",i,tree[i].mcode,tree[i].t1,tree[i].t2);
			}
			nnest = 0;
			if (ntr > 0) {
				nnest = cl_gx_cr_nest0(tree,nest,nest_flg);
				if (nnest < 0) return nnest;
			}
		}
	}
	else {
		if (nob0=pbxObj->nobj0) {
			if (Obj) {
				if (!(Obj=_check_add_obj0(Obj,pbxObj))) return ECL_MALLOC_ERROR;
				if (_re_set_obj0(Obj,pbxObj)) return -1;	/* 2021.1.31 */
				Obj0 = Obj->Obj0;
				pObj0 = &Obj0[pbxObj->maxobj0-1];	/* 2021.4.1 add -1 */
			}
			else {
				pObj0 = pbxObj->obj0;
			/*	_clear_obj_addr(pbxObj,NULL,pObj0);	*/
			}
		}
if (DEBUGOUTCHECK(155)) {
char **daw;
short *objw;
int    nob,nda,nob0;
tdtInfoParm **objw0,**Objw0;
objw = pbxObj->obj;
daw = pbxObj->da;
nob = pbxObj->nobj;
nda = pbxObj->nda;
nob0 = pbxObj->nobj0;
if (Obj) {
	Objw0 = Obj->Obj0;
	objw0 = &Objw0[pbxObj->maxobj0-1];	/* 2021.4.1 add -1 */
}
else objw0 = pbxObj->obj0;
for (i=0;i<nob;i++) {
DEBUGOUTL2(155,"saved obj[%2d]=%d",i,objw[i]);
}
DEBUGOUTL1(155,"index0=%d",pbxObj->index0);
for (i=0;i<nob0;i++) {
DEBUGOUTL2(155,"saved obj0[%2d]=0x%08x",i,objw0[i]);
DEBUGOUT_InfoParm(165,"",objw0[i],0,0);
}
for (i=0;i<nda;i++) {
DEBUGOUTL2(155,"saved da[%2d]=[%s]",i,daw[i]);
}
}
	}
	if (rc == 0) {
		rc = cl_gx_ex_tree(tree,pObj0,pbxObj,pInfoParmW,opt);
	/*	rc=cl_gx_ex_obj(pObj0,pbxObj,pInfoParmW,opt);	*/
DEBUGOUT_InfoParm(150,"cl_gx_exp_gp_obj_opt:cl_gx_ex_obj rc=%d",pInfoParmW,rc,0);
		if (rc) {
			switch (rc) {
			case -3:
				/* ZX^bNEI[ot[B */
				ERROROUT1(FORMAT(181),name);
				break;
			case -4:
				/* G[(Zqlsł)B */
				ERROROUT1(FORMAT(182),name);
				break;
			case -5:
				/* f[^܂B */
				ERROROUT1(FORMAT(183),name);
				break;
			case -6:
				/* IuWFNgIĂ܂B */
				ERROROUT1(FORMAT(184),name);
				break;
			case -7:
				/* IuWFNgEf[^NULLłB */
				ERROROUT1(FORMAT(186),name);
				break;
			case 100:
											/* ܂B */
				if (!(pGlobTable->options[3] & 0x01)) ERROROUT1(FORMAT(185),name);
				if (pGlobTable->options[3] & 0x02) rc = 0;
				if (pGlobTable->options[3] & 0x04) rc = ECL_EX_LET;
				break;
			default:
				break;
			}
		}
	}
DEBUGRET1("rc=%d",rc);
	return rc;
}

#define DEBUG_EX_TREE

int cl_gx_ex_tree(tree,pObj0,pGxObj,pInfoParmW,iOpt)
WHERE_TREE *tree;
tdtInfoParm **pObj0;
GXObject *pGxObj;
tdtInfoParm *pInfoParmW;
int iOpt;
{
	int mc1,mc2;
	int a1,a2;
	int a,b,j,v,t;
	char *ap,*bp,w1[13],w2[13];
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	static char *name="cl_gx_ex_tree";
	int ida;
	char **da,**obj_stack;
	short *obj;
	int iob;
	int irs,ir2s,irs_max;
	int iMAX_PMSTK,iMAX_STACK;
	MCAT Ms_pp2stk,Ms_ppmstk,Ms_pmstk,Ms_ppmstack,Ms_stack,Ms_dastk;
	MCAT *Msa[7];
	tdtInfoParm **pp2stk;
	tdtInfoParm **ppmstk;
	tdtInfoParm *pmstk,**ppmstack;
	short *stack;
	char **dastk;
	char *da1,*da2,*da3,id,id2,*p1,*p2;
	int i,scale,rc,opt0,optW,opt1,im,val,opt2,val1;
	char pOperator[32], *pWork, *p, c;
	tdtInfoParm InfoParm1,*pInfoParm1,InfoParmW2[2];
	tdtInfoParm InfoParm2,*pInfoParm2,*pInfoParm,**obj0;
	tdtInfoParm InfoParm3,*pInfoParm3;
	parmList  *prmL, qprmL;
	int sp,atr,attr0,i1,i2,amc,mc,atrn,iFN_level,iAR_level,len,len1,len2,aux1,iDEF_ZOK_DATA,type;
	int ib,ib0,kind,iva[10];
	tdtArrayIndex *pIndex;

	if (!pGxObj) return -1;
	iob = pGxObj->nobj;
DEBUGOUTL3(110,"cl_gx_ex_obj: *** start nobj=%d iOpt=%08x pInfoParmW=%08x",iob,iOpt,pInfoParmW);
	if (iob<1) return 100;
	obj = pGxObj->obj;
	if (iob>=1 && obj[0]==99) return 100;
/*	da  = pGxObj->da;
	obj0 = pObj0;	*/

	iMAX_PMSTK = (iob+1)/2;
	iMAX_STACK = iMAX_PMSTK;
	if (rc=_mk_obj_stack(pGxObj)) return rc;
	obj_stack = pGxObj->stack;
	pp2stk = (tdtInfoParm **)obj_stack[0];
	ppmstk = (tdtInfoParm **)obj_stack[1];
	pmstk = (tdtInfoParm *)obj_stack[2];
	ppmstack = (tdtInfoParm **)obj_stack[3];
	stack = (short *)obj_stack[4];
	dastk = (char **)obj_stack[5];
DEBUGOUTL2(120,"cl_gx_ex_obj: pGxObj->index0=%08x dastk=%08x",pGxObj->index0,dastk);
/*	if (pGxObj->index0) {
		if (pGxObj->index0 & 0x01)	*/
			cl_gx_init_set_expand(&Ms_pp2stk,"P2",sizeof(tdtInfoParm *),iMAX_PMSTK,pp2stk);
	/*	if (pGxObj->index0 & 0x02) {	*/
			cl_gx_init_set_expand(&Ms_ppmstack,"PS",sizeof(tdtInfoParm *),iMAX_PMSTK,ppmstack);
			cl_gx_init_set_expand(&Ms_stack,"ST",sizeof(short),iMAX_STACK,stack);
	/*	}
		if (pGxObj->index0 & 0x04) {	*/
			cl_gx_init_set_expand(&Ms_ppmstk,"PM",sizeof(tdtInfoParm *),iMAX_PMSTK,ppmstk);
			cl_gx_init_set_expand(&Ms_pmstk,"MS",sizeof(tdtInfoParm),iMAX_PMSTK,pmstk);
			cl_gx_init_set_expand(&Ms_dastk,"DS",sizeof(char *),iMAX_PMSTK,dastk);
	/*	}
	}	*/
	Msa[0] = &Ms_pp2stk;
	Msa[1] = &Ms_ppmstk;
	Msa[2] = &Ms_pmstk;
	Msa[3] = &Ms_ppmstack;
	Msa[4] = &Ms_stack;
	Msa[5] = &Ms_dastk;
	Msa[6] = &mcat;

	if (!pInfoParmW) pInfoParmW = InfoParmW2;
	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	if (iOpt & D_GX_OPT_PARMINFO2) memset(pInfoParmW+1,0,sizeof(tdtInfoParm));
	stack[0]=0;
	mem_set_int(iva,0,8);

	rc = cl_gx_ex_tree_sub(0,tree,pObj0,pGxObj,pInfoParmW,iOpt,Msa,iva);

	return rc;
}

int cl_gx_ex_tree_sub(is,tree,pObj0,pGxObj,pInfoParmW,iOpt,Msa,iva)
int is;
WHERE_TREE *tree;
tdtInfoParm **pObj0;
GXObject *pGxObj;
tdtInfoParm *pInfoParmW;
int iOpt,iva[];
MCAT *Msa[];
{
	static char *name="cl_gx_ex_tree_sub";
	int mc,mc1,mc2,i1,i2,rc;
	long Value1,Value2;
	tdtInfoParm tInfoParm1,tInfoParm2;

	mc = tree[is].mcode;
	i1 = tree[is].t1;
	i2 = tree[is].t2;

printf("cl_gx_ex_tree_sub:Enter is=%d mc=%d i1=%d i2=%d\n",is,mc,i1,i2);

	if (i1) mc1 = tree[i1].mcode;
	else mc1 = 0;

	if (i2) mc2 = tree[i2].mcode;
	else mc2 = 0;

printf("cl_gx_ex_tree_sub: mc1=%d tree[i1].t1=%d mc2=%d tree[i2].t1=%d\n",mc1,tree[i1].t1,mc2,tree[i2].t1);
printf("Enter any key.");getchar();
	if (mc1==91 || mc1==92) {
printf("cl_gx_ex_tree_sub: mc1=%d tree[i1].lv=%d\n",mc1,tree[i1].lv);
		iva[0] = mc1;
		iva[1] = tree[i1].lv;
		if ((rc=cl_gx_ex_obj_sub(pObj0,pGxObj,&tInfoParm1,iOpt,Msa,iva)) < 0) return rc;
	}
	else if (mc1) {
		if ((rc=cl_gx_ex_tree_sub(i1,tree,pObj0,pGxObj,&tInfoParm1,iOpt,Msa,iva)) < 0) return rc;
		if (mc==51 || mc==52) {	/* && || */
			cl_get_logic_val(&Value1,&tInfoParm1);
			if (mc==51 && !Value1) {
				cl_set_parm_bin(pInfoParmW,0);
				rc = 1;
			}
			else if (mc==52 && Value1) {
				cl_set_parm_bin(pInfoParmW,1);
				rc = 1;
			}
		}
	}
	if (mc2==91 || mc2==92) {
printf("cl_gx_ex_tree_sub: mc2=%d tree[i2].lv=%d\n",mc2,tree[i2].lv);
		iva[0] = mc2;
		iva[1] = tree[i2].lv;
		if ((rc=cl_gx_ex_obj_sub(pObj0,pGxObj,&tInfoParm2,iOpt,Msa,iva)) < 0) return rc;
	}
	else if (rc!=1 && mc2) {
		if ((rc=cl_gx_ex_tree_sub(i2,tree,pObj0,pGxObj,&tInfoParm2,iOpt,Msa,iva)) < 0) return rc;
		if (mc==51 || mc==52) {	/* && || */
			cl_get_logic_val(&Value2,&tInfoParm2);
			if (mc==51 && !Value2) {
				cl_set_parm_bin(pInfoParmW,0);
				rc = 1;
			}
			else if (mc==52 && Value2) {
				cl_set_parm_bin(pInfoParmW,1);
				rc = 1;
			}
		}
	}
	if (rc == 1) mc = 53;	/* 2 SET */
	iva[0] = mc;
	rc = cl_gx_ex_obj_sub(pObj0,pGxObj,pInfoParmW,iOpt,Msa,iva);
	return rc;
}
