# mq-why-guarded.sh
# ------------------------------------------------------------------------------
#
# Supplementary shell script fragment; it implements the "why_guarded" awk
# function to facilitate its incorporation within a dynamically constructed
# awk program script.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2018, 2019, Keith Marshall
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ------------------------------------------------------------------------------
#
  mq_function_why_guarded='
    function why_guarded( reason, key, active ) {
      for( key = 2; NF >= key; key++ )
      { active = 0; switch( substr( $key, 1, 2 ) )
	{ case "#+": active = ! guard[substr( $key, 3 )]; break;
	  case "#-": active = guard[substr( $key, 3 )];
	}
	if( active ) reason = reason " \47" substr( $key, 2 ) "\47";
      }
      return reason;
    }'
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
