# mq-series-index.sh
# ------------------------------------------------------------------------------
#
# Supplementary shell script fragment; it implements an index-to-patch-name
# look-up capability, for incorporation within a dynamically constructed awk
# program script.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ------------------------------------------------------------------------------
#
mq_series_index_lookup='
  switch( lookup = $1 ) { case /^[0-9][0-9]*$/: $1 = 0 + $1; }
  if( ! ($1 in entry) && ($1 in series) ) $0 = series[$1];
  if( (reject_qparent || ($1 != "qparent")) && (! ($1 in entry)) )
  { switch( lookup )
    { case /^[0-9][0-9]*$/:
	errout( "fatal", "there is no patch number " lookup " in the series" );
      default:
	errout( "fatal", "there is no patch \47" lookup "\47 in the series" );
    }
  }'

mq_error_handler='
  function errout( severity, message, keep_alive )
  { print "'"$mq_facility"': " severity ": " message > "/dev/stderr";
    if( ! keep_alive ) switch( severity )
    { case "error": exit status = 1;
      case "fatal": exit status = 2;
    }
  }'
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
