# mq-select-backend.sh
# ------------------------------------------------------------------------------
#
# Back-end processing script fragment, invoked via "mq_require", to handle the
# effects of the "--pop" and "--reapply" options to the "qselect" command.
#
# ------------------------------------------------------------------------------
#
# $Id$
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2019, Keith Marshall
#
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ------------------------------------------------------------------------------
#
# The actions associated with the "--pop" and "--reapply" options require
# parsing of all of the guards, series, and status files; ensure that path
# name references for all three have been mapped.
#
  mq_map_control_file_refs "$mq_patchdir" guards series status

# Parse the three control files, applying a customized interpretation
# for the status file content, to identify, and set as function arguments,
# the names of the first guarded, applied patch (if any), preceded by its
# immediate applied predecessor (if any), and followed by the topmost
# applied patch (if any); in the case of each of these which cannot
# be identified, substitute a default placeholder of "..".
#
  eval set -- `awk "$mq_guards $mq_series"'
    BEGIN { FS = "[ :]"; applied = -1; pop = skip = ".." }
    FILENAME ~ /status$/ {
      if( state[$2] == "U" ) state[$2] = "A";
      if( entry[$2] > applied ) applied = entry[$2];
    }
    END {
      for( idx = 0; applied >= idx; idx++ )
      { $0 = series[idx]; if( state[$1] == "A" ) pop = $1;
	else if( state[$1] == "G" ) { skip = $1; break; }
      }
      if( applied < 0 ) $0 = "..";
      else if( applied > idx ) $0 = series[applied];
      printf "\42%s\42 \42%s\42 \42%s\42\n", pop, skip, $1;
    }' "$mq_guards_file" "$mq_series_file" "$mq_status_file"`

# When any guarded, applied patch has been identified, pop the patch
# stack back to its immediate predecessor, if that has been identified,
# (or otherwise pop all applied patches).
#
  test "$2" = ".." || {
    mq_pop_guarded() {
      echo "$mq_facility: popping guarded patches"
      test "$1" = ".." && { shift; mq_push_pop_all=true; }
      mq_require $mq_pop_option ${1+"$@"}
    }
    mq_pop_guarded "$1"

# Finally, if the "--reapply" option has also been specified, and
# provided the original topmost patch has also been identified, and
# has not become guarded, push any intervening unguarded patches,
# until the original patch again becomes topmost.
#
    test ${mq_reapply_option+set} && {
      echo "$mq_facility: reapplying unguarded patches"
      mq_cannot_push="cannot reapply" mq_guarded_by="it is guarded by"
      mq_require $mq_reapply_option "$3"
    }
  }
#
# ------------------------------------------------------------------------------
# $RCSfile$: end of file
