.nr HY 0
.TH GIT\-QSERIES 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qseries \- list all entries from the patch queue series file
.
.
.SH SYNOPSIS
.BR git\ qseries \ [ \-v \ |\  \-\-verbose ]\ [ \-s \ |\  \-\-summary ]\ [\c
.BR \-m \ |\  \-\-missing ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qseries
command displays, in series order,
the names of all patches which have been registered as members of the active
.B Git\-MQ
patch series.
.LP
If the
.B \-\-verbose
option is specified,
each patch name is preceded by its sequence number in the series,
and a single character flag, indicating its status to be one of:\(em
.RS 3n
.TP 3n 4n
.B A
applied:\ the patch has been applied.
.TP 3n
.B U
unapplied:\ the patch has
.I not
been applied.
.TP 3n
.B G
guarded:\ the patch has
.I not
been applied, and is guarded to prevent its application
in the current
.B git\ qselect
state.
.RE
.LP
If the
.B \-\-summary
option is specified,
the commit summary line, if available in the patch header,
is displayed following each patch name.
.LP
If the
.B \-\-missing
option is specified,
instead of listing
.I registered
patches,
.B git\ qseries
displays a list of patches which are present in the active
.B Git\-MQ
patch directory,
but which are
.I not
registered in the series file; if the
.B \-\-verbose
option is also specified,
no sequence number is displayed for such patches,
and the status is indicated by the
.B D
flag.
.
.
.SH OPTIONS
.TP 8n
.BR -m ,\  --missing
List patches which lack a series file entry.
.
.TP
.BR -s ,\  --summary
Include summary lines from patch headers.
.
.TP
.BR -v ,\  --verbose
Include patch sequence numbers and status flags.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qseries
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qseries
command exhibits fundamentally the same behaviour as its
.B hg\ qseries
counterpart.
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qapplied (1),
.BR git\-qguard (1),
.BR git\-qnext (1),
.BR git\-qprev (1),
.BR git\-qselect (1),
.BR git\-qtop (1),
.BR git\-qunapplied (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
