.nr HY 0
.TH GIT\-QAPPLIED 1 @DATE@ "Git-MQ @PACKAGE_VERSION@" "Git-MQ Commands"
.\" ----------------------------------------------------------------------------
.\"
.\" $Id$
.\"
.\" Written by Keith Marshall <keith@users.osdn.me>
.\" Copyright (C) 2019, Keith Marshall
.\"
.\"
.\" This man page file is part of the Git-MQ program suite.
.\"
.\" Permission is granted to copy, distribute and/or modify this document
.\" under the terms of the GNU Free Documentation Licence, Version 1.3 or any
.\" later version published by the Free Software Foundation; with no Invariant
.\" Sections, no Front-Cover Texts, and no Back-Cover Texts, but subject to
.\" the restriction that all existing author attribution, and all existing
.\" copyright notices, shall be preserved.  A copy of the licence is
.\" included in the Git-MQ source distribution.
.\"
.\" ----------------------------------------------------------------------------
.
.na
.SH NAME
git\-qapplied \- list applied entries from the patch queue series file
.
.
.SH SYNOPSIS
.BR git\ qapplied \ [ \-v \ |\  \-\-verbose ]\ [\c
.BR \-s \ |\  \-\-summary ]\ [ \-1 \ |\  \-\-last ]
.
.
.ad b
.SH DESCRIPTION
The
.B git\ qapplied
command displays, in series order,
the names of all patches which have been registered
as members of the active
.B Git\-MQ
patch series,
.I and
which are currently in the
.I applied
state,
(i.e.\ all registered and applied patches,
in series order,
up to and including the topmost applied patch,
as indicated by the
.B git\ qtop
command).
.LP
If the
.B \-\-verbose
option is specified,
the list is extended to include any
.I unapplied
patches which precede the topmost applied patch,
in series order;
each patch name is preceded by its sequence number in the series,
and a single character flag, indicating its status,
as described for the
.B git\ qseries
command.
.LP
If the
.B \-\-summary
option is specified,
the commit summary line, if available in the patch header,
is displayed following each patch name.
.LP
If the
.B \-\-last
option is specified,
the output is reduced to the display of only the
.I one
patch, if any,
which is the
.I applied
predecessor of the topmost applied patch;
this is effectively equivalent to the output of the
.B git\ qprev
command.
.
.
.SH OPTIONS
.TP 4n
.BR \-1 ,\  \-\-last
Show only the predecessor of the current topmost patch.
.TP
.BR \-s ,\  \-\-summary
Include summary lines from patch headers.
.TP
.BR \-v ,\  \-\-verbose
Show patch sequence numbers and status flags.
.
.
.SH EXIT STATUS
On successful completion,
.B git\ qapplied
reports an exit status code of 0.
Any \%non\(hyzero exit status code indicates that an error occurred.
.
.
.SH COMPARISON WITH MERCURIAL QUEUES
Inspired by,
and for the most part based on behavioural observation of
.BR Mercurial \(aqs\  MQ
extension,
the
.B git\ qapplied
command exhibits fundamentally the same behaviour as its
.B hg\ qapplied
counterpart,
.I except
in the case when the
.B \-\-last
option is specified,
.I and
the patch immediately the topmost is
.IR guarded ;
(see the
.B CAVEATS AND BUGS
section, below).
.
.
.SH CAVEATS AND BUGS
The output,
when using the
.B \-\-last
option is not particularly useful;
as implemented,
it simply mimics the behaviour of the
.B git\ qprev
command,
reporting the
.I most recently applied
predecessor of the topmost \%currently\(hyapplied patch.
This differs from the behaviour of Mercurial\(aqs
.B hg\ qapplied\ \-\-last
command,
which reports information relating to the
.I immediate
predecessor of the topmost applied patch,
.I regardless
of whether that predecessor is
.IR applied ,
.IR unapplied ,
or
.IR guarded ,
but (unhelpfully) displays nothing at all,
if the
.B \-\-verbose
option is not specified,
when the predecessor is either
.IR unapplied ,
or
.IR guarded .
.
.
.SH AUTHOR
Copyright (C) 2019, by Keith Marshall
.
.LP
This man page was written by
Keith\ Marshall\ <keith@users.osdn.me>,
to accompany the
.B Git\-MQ
program suite.
It is published under the terms of the GNU Free Documentation Licence,
version\~1.3,
(or any later version published by the Free Software Foundation),
with no Invariant Sections,
no Front\(hyCover Texts, and no Back\(hyCover Texts.
.
.LP
The
.B Git\(hyMQ
program suite itself is distibruted under the terms of the
GNU General Public Licence, version\~3,
(or any later version published by the Free Software Foundation).
.
.LP
Copies of the GNU Free Documentation Licence,
and of the GNU General Public Licence,
are included within the
.B Git\(hyMQ
source distribution,
in the files
.BR FDL\-1.3 ,
and
.BR LICENCE ,
respectively.
.
.
.na
.SH SEE ALSO
.BR git\-qprev (1),
.BR git\-qseries (1),
.BR git\-qtop (1),
.BR git\-qunapplied (1)
.
.\" ----------------------------------------------------------------------------
.\" $RCSfile$: vim:set ft=groff: end of file
