static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <cllex.c>														*/
/*																*/
/*			p̈ύX										*/
/*			񒷃`FbNύX								*/
/********************************************************************/
#include "colmn.h"

#define YEN '\\'
#define WKBUFLEN	BUFLEN*8
#define WKBUFMAX	WKBUFLEN-1

extern CLCOMMON CLcommon;
extern GlobalCt *pGlobTable;
extern int giOptions[];
extern XHASHB *xhp_main_def;
#if 0
extern condList  CLcList;	/* 񃊃Xg */
extern CLNCB     CLSTCB;	/* ^O̍\͂s߂̗̈ */
#endif
static int _parmset();
static int _kugiri();

static XHASHB *sqp_lex_def=NULL;
static XHASHB *xhp_lex_def=NULL;
static char comstr[24];
static char cM_QUOTE1, cM_QUOTE2;
static char *def_sep=" \t'\";(){}[]";

typedef struct {
	int  pra_opt;	/* 0:rep_def, 1:include */
	char *pra_defkey;
	SSPL_S pra_sspl;
	condList pra_cList;	/* 񃊃Xg */
} tdtPragmaStack;

#define CLISTSTACKMAX	20
static int iListStack=0;
static int iListStack0=0;
static tdtPragmaStack tPragmaStack[CLISTSTACKMAX+1];

#define MAXIFNEST	20
static int ifnest_cnt,ifnest[MAXIFNEST],iftrue[MAXIFNEST];

#define DEF_OPTC_ICASE	'*'
#define DEFICASEMAX	20

/************************************/
/* cl_chk_pos						*/
/************************************/
static int _chk_pos(y,psspl,pos)
condList *y;
SSPL_S *psspl;
int pos;
{
	int i,len,l,rc,lend;
	char *buf,*p;

	buf = psspl->wd;
	i   = psspl->sp;
	len = psspl->wdmax;

DEBUGOUTL4(LEX_LOG_GROUP+255,"_chk_pos enter:pos=%d i=%d len=%d attr[3]=%d",pos,i,len,psspl->attr[3]);

	if (i>=len && psspl->attr[3]) return -1;
	if (i+pos >= len) {
		l = len - i;
		if (l>0 && i>0) {
			memcpy(buf,buf+i,l);
			len = l;
		}
		else len = 0;
		buf[len] = '\0';
		psspl->sp = 0;
		i = psspl->sp + pos;
		p = buf + len;
		while (i>=len && !psspl->attr[3]) {
			if (len>0 && *p=='\n') {
				len--;
				*(--p) = '\n';
			}
			rc = cl_get_str(y,p);
			if (rc) {
				psspl->attr[3] = 1;		/* File End */
				if (!len) return -1;
			}
			else {
				l = strlen(p);
				len += l;
				p   += l;
			}
			 
		}
		psspl->wdmax = len;

DEBUGOUTL4(LEX_LOG_GROUP+124,"_chk_pos ret  :i=%d len=%d attr[3]=%d buf=[%s]",i,len,psspl->attr[3],buf);

	}
	return psspl->sp;
}

static int cl_chk_pos(y,psspl,pos)
condList *y;
SSPL_S *psspl;
int pos;
{
	int i;

	if ((i=_chk_pos(y,psspl,pos)) < 0) {
		i = ECL_END_OF_FILE;
	}
	return i;
}

/************************************/
/* _alloc_cmd_parl					*/
/************************************/
static int _alloc_cmd_parl(y)
condList *y;
{
	char *p;
	cmdInfo *cmd;

	cmd = y->cmd;
	if (!cmd->parnum) {
		if (!(cmd->parl=(ParList *)cl_const_ct_malloc(y->ConstCt,sizeof(ParList)*MAX_PARL))) {
 			ERROROUT("Malloc CLcList_parl");
			return ECL_MALLOC_ERROR;
		}
		cmd->parnum = MAX_PARL;
		memset(cmd->parl,0,sizeof(ParList)*cmd->parnum);
		cmd->parl[1].par = y->fullname;
		cmd->parl[1].parlen = 0;
/*
DEBUGOUTL1(LEX_LOG_GROUP+120,"_lex_cmd_init: y->fullname=[%s]",y->fullname);
*/
	}
	return 0;
}

/************************************/
/* cl_lex_snln						*/
/************************************/
char *cl_lex_snln(y)
condList *y;
{
	static char *fmt="at script=[%s] line=%d";
	static char wrk[128],*p0=NULL;
	char *buf,*name,sname[33];
	int len;

	if (!(buf=y->fullname)) buf = y->fname;
	name = akxt_get_last_name("\\/",buf);
	len = strlen(name) + 30;
	if ((len=akxmemwork(len,&buf,&p0,wrk,sizeof(wrk))) <= 0) {
		buf = wrk;
		strncpy(sname,name,32);
		name = sname;
	}
DEBUGOUTL1(LEX_LOG_GROUP+120,"cl_lex_snln: name=[%s]",name);
	sprintf(buf,fmt,name,y->line);
	return buf;
}

/***************************************************/
/* _parmset (\ cmdInfo ւ̃p[^̐ݒ)  */
/***************************************************/
static int _parmset(y,pp,len,opt)
condList *y;
char *pp;
int  len,opt;
{
	parmList *lp;
	int rc;
	cmdInfo *cmd;

	cmd = y->cmd;
	if (cmd->prmnum+2 >= y->max_prmnum) {
		y->max_prmnum += 64;	/*PM_MAX;*/
		if (!(cmd->prmp=(parmList **)Realloc(cmd->prmp,sizeof(parmList *)*(y->max_prmnum)))) {
			ERROROUT("Realloc CLcList_prmp");
			return ECL_MALLOC_ERROR;
		}
/*
printf("_parmset: CLcList.max_prmnum=%d\n",CLcList.max_prmnum);
*/
	}
	lp = (parmList *)cl_const_ct_malloc(y->ConstCt,sizeof(parmList));
	if (!lp) {
		ERROROUT2("cllex:malloc error.%s parm[%s]",cl_lex_snln(y),pp);
		return ECL_MALLOC_ERROR;
	}
	memset(lp,0,sizeof(parmList));
	lp->prmlen = len;
	lp->prp = (char *)pp;
/*
printf("_parmset: prmnum=%d len=%d pp=[%s]\n",CLcList.cmd.prmnum,len,pp);
*/
	cmd->prmp[cmd->prmnum] = lp;
	cmd->prmnum++;
	if (opt) {
		if (y->mcat->mc_ipos > 0) {
			rc = akxtmcats(y->mcat," ");
		}
		else rc = 0;
		if (rc >= 0) rc = akxtmcat(y->mcat,pp,len);
		if (rc < 0) {
			ERROROUT2("cllex:malloc error.%s parm[%s]",cl_lex_snln(y),pp);
			return ECL_MALLOC_ERROR;
		}
	}
	rc = _alloc_cmd_parl(y);
	return rc;
}

/************************************/
/* clparmset						*/
/************************************/
int clparmsetopt(y,wkstr, parmlen, opt)
condList *y;
char *wkstr;
int parmlen,opt;
{
	char *parm;
	int rc;

	parm = cl_const_ct_malloc(y->ConstCt,parmlen+1);
	if (parm) {
		memzcpy(parm,wkstr,parmlen);
		parmlen = strlen(parm);
		rc = _parmset(y,parm,parmlen,opt);
	}
	else {
		ERROROUT2("cllex:malloc error.%s parm[%s]",cl_lex_snln(y),wkstr);
		rc = ECL_MALLOC_ERROR;
	}
	return rc;
}

int clparmset(y,wkstr, parmlen)
condList *y;
char *wkstr;
int parmlen;
{
	return clparmsetopt(y,wkstr,parmlen,0);
}

/************************************/
/* clparmset2						*/
/************************************/
int clparmset2(y)
condList *y;
{
	char *p;
	int len,lenc,rc=0;
	cmdInfo *cmd;

	cmd = y->cmd;
	lenc = strlen(comstr);
	len = y->mcat->mc_ipos;
	p = cl_const_ct_malloc(y->ConstCt,len+lenc+2);
	if (p) {
		if (rc=_alloc_cmd_parl(y)) return rc;
		memzcpy(p,y->mcat->mc_bufp,len);
		cmd->parl[0].par = p;
		cmd->parl[0].parlen = len;
		y->mcat->mc_ipos = 0;
		p += len + 1;
		memzcpy(p,comstr,lenc);
		cmd->parl[2].par = p;
		cmd->parl[2].parlen = lenc;
/*
printf("clparmset2: parl[2].par=[%s]\n",p);
*/
	}
	else {
		ERROROUT2("cllex:malloc error.%s parm[%s]",cl_lex_snln(y),y->mcat->mc_bufp);
		rc = ECL_MALLOC_ERROR;
	}
	return rc;
}

/***************************************************/
/* clparmclr (\ cmdInfo ̃p[^̏)@ */
/***************************************************/
int clparmclr(y)
condList *y;
{
	int i;

	y->cmd->prmnum = 0;
	y->mcat->mc_ipos = 0;
	return 0;
}

/***************************************************/
/* cl_syn_main                                     */
/***************************************************/
int cl_syn_main(y)
condList *y;
{
	int rc;
	char *pCmdLine;

if (DEBUGOUTCHECK(LEX_LOG_GROUP+120)) {
	if (!cl_get_cmd_line(y->cmd,&pCmdLine)) DEBUGOUTL1(LEX_LOG_GROUP+120,"cl_syn_main:[%s]",pCmdLine);
}
	rc = cl_tree_main(y);	/* ؍\쐬 */
	if (rc) {
		ERROROUT2("cllex:Create tree error=%d %s",rc,cl_lex_snln(y));
		if (!cl_get_cmd_line(y->cmd,&pCmdLine)) {
			if (!pCmdLine) pCmdLine = "";
			ERROROUT1(" ---> [%s]",pCmdLine);
		}
	}
	return rc;
}

/************************************/
/* _to_han_type						*/
/*  flag :  = 0 : pɕϊꂽ	*/
/*			= 1 : Sp̂܂܎g	*/
/************************************/
static int _to_han_type(moji,quote,wrk,type)
char *moji,quote,*wrk;
int  type;
{
	int flag=1;	/*  */
	char c;

	if (!(pGlobTable->options[8] & 0x02)) {
		if (akxctohan_type_opt(1,moji,wrk,type,0x10) == 1) {
			c = wrk[0];
			wrk[1] = '.';
			if (pGlobTable->options[8] & 0x01) flag = 0;	/* SẲpL𔼊pɕϊ */
			else if (!quote/* || c=='\'' || c=='"'*/) flag = 0;
		}
	}
	return flag;
}
#if 0	/* 2021.4.5 */
/************************************/
/* _to_han							*/
/************************************/
static int _to_han(moji,quote,wrk)
char *moji,quote,*wrk;
{
	return _to_han_type(moji,quote,wrk,CD_TYPE_SJIS);
}
#endif
/************************************/
/* _is_han_type						*/
/************************************/
static char _is_han_type(moji,quote,wrk,type)
char *moji,quote,*wrk;
int  type;
{
	int lenc,c;

	if (lenc=akxqismbs(type,moji)) {
		c = '\0';
		if (!_to_han_type(moji,quote,wrk+1,type)) c = wrk[1];
	}
	else {
		lenc = 1;
		c = moji[0];
	}
	wrk[0] = lenc;
/*
printf("_is_han: lenc=%d c=%c\n",lenc,c);
*/
	return c;
}
#if 0	/* 2021.4.5 */
/************************************/
/* _is_han							*/
/************************************/
static char _is_han(moji,quote,wrk)
char *moji,quote,*wrk;
{
	return _is_han_type(moji,quote,wrk,CD_TYPE_SJIS);
}
#endif
/************************************/
/* _skip_line						*/
/************************************/
static int _skip_line(y,buf,psspl)
condList *y;
char *buf;
SSPL_S *psspl;
{
	int len,flg,rc,i;
	char c1;

	len = psspl->wdmax;
/*
printf("_skip_line:Enter len=%d\n",len);
*/
	flg = 1;
	while (flg) {
		if ((c1=buf[len-1])=='\n' || c1=='\r') flg = 0;
		rc = cl_get_str(y,buf);	/* ݍŝĂāA̍sǍ */
		if (rc != 0) {
			return ECL_END_OF_FILE;	/* File End */
		}
		len = strlen(buf);
/*
printf("_skip_line: len=%d buf=[%s]\n",len,buf);
*/
	}
	i = 0;
	psspl->wdmax = len;
	return i;
}

/************************************/
/* ̃X^bNɂǗ		*/
/************************************/
#define _SP_EXT	64
static int _sp_max=0;
static int *_stack=NULL;
static int _sp=0;

/****************************/
/* _push					*/
/****************************/
static int _push(x)
int x;
{
	if (_sp >= _sp_max) {
		_sp_max += _SP_EXT;
		if (_stack) _stack = (int *)Realloc(_stack,_sp_max*sizeof(int));
		else        _stack = (int *)Malloc(_sp_max*sizeof(int));
		if (!_stack) return -4;
	}
	_stack[_sp++] = x;
	return 0;
}

/****************************/
/* _pop						*/
/****************************/
static int _pop()
{
	if (_sp <= 0) return -5;
	return _stack[--_sp];
}

/****************************/
/* _peek					*/
/****************************/
static int _peek()
{
	if (_sp <= 0) return 0;
	return _stack[_sp-1];
}

/****************************/
/* _chk_act					*/
/****************************/
static int _chk_act(c)
char c;
{
	int i,j,rc;

	if (c < 0) {
		_sp = 0;
		return 0;
	}

	if      (c == '(') j = 1;
	else if (c == '{') j = 2;
	else if (c == '[') j = 3;
	else if (c == ')') j = 4;
	else if (c == '}') j = 5;
	else if (c == ']') j = 6;
	else return -2;

	rc = 0;
	if (j <= 3) rc = _push(j);
	else {
		i = _peek();
		if (i<1 || i>3) rc = -3;
		else if (i == j-3) rc = _pop();
		else rc = -11;
	}
	if (rc > 0) rc = 0;
	return rc;
}

/****************************/
/* _is_sjis_hankaku_kana	*/
/****************************/
static int _is_sjis_hankaku_kana(c)
uchar c;
{
	int rc;

	if (c>=161 && c<=223) rc = 1;
	else rc = 0;
	return rc;
}

/************************************/
/* cl_lex (flk^O)		*/
/************************************/
int cl_lex(y)
condList *y;
{
	int   kugiri_flg = 0;
	char  buff[BUFLEN*2];
	char  wkstr[BUFLEN*8];
	int	exit_flag=0, line_cont;
	ushort sjis;
	char  comstr[24],wrk[4];
	char  *parm,*p;
	int   len,cut;
	int   rc,rc_def;
	int   i,ii,tree,h,parmlen,cnum,j,flag,lenc,len8,ex_opt,sc_code,cmnd,iKUGIRI;
	char  code,info,quote,c,c1,quote1,quote2;
	unsigned char uc;
	int   new_lex = 0;
	int   moji_const = 0;	/* BEXP $a = '//null/%s';//RgɂȂ */
	SSPL_S sspl;
	int   cm_level=0;	/* ^@^`̃Rg̃lXgx */
	int   kk_level=0;	/* ()̃lXgx */
	int   k2_level=0;	/* {}̃lXgx */
	int   k3_level=0;	/* []̃lXgx */
	int   def_parm;
	ScrPrCT *scrptct;
	int   inter_mode;

	if (y->fp == NULL) return(-1);
	y->rbuf = buff;
	rc = cl_get_str(y,buff);
	if (rc) {
		ERROROUT(FORMAT(40));	/* cllex:XNvgEt@CłB */
		goto FEND2;					/* File End */
	}
	if (!memcmp(buff,"#!",2)) {
		rc = cl_get_str(y,buff);		/* ݍŝĂāA̍sǍ */
		if (rc != 0) goto FEND2;	/* File End */
	}
	len = strlen(buff);
	def_parm = 0;
	h = 0;
	i = 0;
	info  = 'N';					/* NewLine */
	quote1 = quote2 = quote = '\0';
	clparmclr(y);
	y->clstcb->nestLev1 = NULL;
	y->clstcb->nestLev2 = NULL;
	cl_cmd_init(y->cmd);		/* ݒ */
	y->mcat->mc_ipos = 0;
	if (y->option & D_SCRPT_NEW_LEX) new_lex = 1;

	if (scrptct = cl_search_src_ct()) inter_mode = scrptct->pFlag & D_SCRPT_INTERACTIVE;
	else inter_mode = 0;

	cM_QUOTE1 = pGlobTable->Quot[0];
	cM_QUOTE2 = pGlobTable->Quot[1];

	if ((rc=_alloc_cmd_parl(y)) < 0) return rc;

	if (y->option & D_CLST_OPT_USE_DTYPE) {
		sc_code = (y->option & D_CLST_OPT_DTYPE)>>16;
/*
printf("cllex: y->option=%08x sc_code=%d\n",y->option,sc_code);
*/
	}
	else {
		sc_code = CD_TYPE_SJIS;
		ex_opt = cl_get_option(21,0);
/*
printf("cllex: ex_opt=%08x\n",ex_opt);
*/
		ex_opt = (ex_opt>>20) & CD_TYPE_CODE;	/* file */
		if (ex_opt) sc_code = ex_opt;
/*
printf("cllex: sc_code=%d\n",sc_code);
*/
	}

	_chk_act(-1);
	sspl.wd = buff;
	sspl.wdmax = len;
	sspl.attr[3] = 0;
	while (!exit_flag) {
		if (h > BUFLEN*8) break;
/*
printf("cllex:1 len=%d h=%d i=%d c=%c\n",len,h,i,buff[i]);
*/
		ii = i;
		sspl.sp = i;
		if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;		/* File End */
/*
printf("cllex:2 len=%d h=%d i=%d c=%c\n",len,h,i,buff[i]);
*/
#ifdef CYGWIN_U8	/* 2020.5.5 */
		uc = *(buff+i);
		if (lenc=akxqismbs(sc_code,buff+i)) {
#else
		if (lenc=iskanji(buff+i)) {
#endif
			flag = 1;
			if (h > BUFLEN*8-2) exit_flag = 1;
			else {
				if (!cm_level || (pGlobTable->options[8] & 0x03)==1) {
					flag = _to_han_type(buff+i,quote1,wrk,sc_code);
					c = wrk[0];
/*
printf("cllex: lenc=%d flag=%d wrk=%02x %02x\n",lenc,flag,wrk[0] & 0xff,wrk[1] & 0xff);
*/
					if (sc_code == CD_TYPE_SJIS) {
						if (flag) {	/* ͒l̂܂܎g */
							sjis = *(buff+i);
							sjis = sjis<<8 | (uchar)*(buff+i+1);
							len8 = akxc_sj_to_utf8(sjis,wkstr+h,NULL);
/*
printf("cllex:zenkaku flga=%d len8=%d\n",flag,len8);
*/
							h += len8;
						}
						else if (_is_sjis_hankaku_kana(c)) {
							sjis = uc;
							len8 = akxc_sj_to_utf8(sjis,wkstr+h,NULL);
/*
printf("cllex:_hankaku_kana flga=%d len8=%d\n",flag,len8);
*/
							h += len8;
							i += lenc;
							continue;
						}
					}
					else {
						if (flag) {	/* ͒l̂܂܎g */
							memcpy(wkstr+h,buff+i,lenc);
							h += lenc;
						}
					}
				}
				i += lenc;
			}
			if (flag) continue;
		}
#ifdef CYGWIN_U8	/* 2020.5.6 */
		else if (!cm_level && sc_code==CD_TYPE_SJIS && _is_sjis_hankaku_kana(uc=*(buff+i))) {
			sjis = uc;
			len8 = akxc_sj_to_utf8(sjis,wkstr+h,NULL);
/*
printf("cllex:_hankaku_kana len8=%d\n",len8);
*/
			h += len8;
			i++;
			continue;
		}
#endif
		else {
			c = buff[i++];
		}
		len = sspl.wdmax;

DEBUGOUTL3(LEX_LOG_GROUP+255,"cllex:len=%d h=%d i=%d",len,h,i);
DEBUGOUTL3(LEX_LOG_GROUP+255,"cllex:c=%c %c%c",c,buff[i],buff[i+1]);
DEBUGOUTL4(LEX_LOG_GROUP+255,"cllex:def_parm=%d kk_level=%d k2_level=%d k3_level=%d",def_parm,kk_level,k2_level,k3_level);
/*
if (CLcList.option & D_SCRPT_MEMORY) printf("cllex: len=%d h=%d i=%d c=%c\n",len,h,i,c);
*/
		switch(c) {
			case '#':
				if (cm_level) break;
				else if (!quote && (info=='N')) {
					sspl.sp = i;
					if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;	/* 1-->0 2021.5.16 */
					len = sspl.wdmax;
					c1 = _is_han_type(buff+i,'\0',wrk,sc_code);
					if (c1=='!') {
						if ((i=_skip_line(y,buff,&sspl)) < 0) goto FEND;
						break;
					}
					else if (strchr(M_PRAGMA,c1)) {
						wrk[0] = c;
						wrk[1] = c1;
						wrk[2] = '\0';
						ERROROUT2(FORMAT(318),"cl_lex",wrk);	/* %s: %s͎gpł܂B*/
						rc = ECL_LEX;
						h = memzcpy(wkstr,buff+ii,akxnskipto(buff+ii,len-ii,"\r\n"));
						goto ERR;
					}
				}
				wkstr[h++] = c;
				break;
			case '*':
				sspl.sp = i;
				if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;	/* 1-->0 2021.5.16 */
				len = sspl.wdmax;
				c1 = _is_han_type(buff+i,quote,wrk,sc_code);
				if (!quote && c1=='/') {
					if (cm_level > 0) {
						cm_level--;
/*
printf("cllex:i=%d len=%d buf=[%s] cm_level=%d(end)\n",i,len,buff,cm_level);
*/
						i += wrk[0];
					/*	i++;	*/
					}
					else {
						ERROROUT1("cllex: unpaired '*/' at line=%d",y->line);
						return ECL_LEX;
					}
				}
				else if (!cm_level) {
					wkstr[h++] = c;
				}
				break;
			case '/':
				sspl.sp = i;
				if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;
				len = sspl.wdmax;
				c1 = _is_han_type(buff+i,quote,wrk,sc_code);

DEBUGOUTL4(LEX_LOG_GROUP+255,"cllex:i=%d len=%d c1=%c buff=[%s]",i,len,c1,buff);
DEBUGOUTL2(LEX_LOG_GROUP+255,"cllex:moji_const=%d quote=%02x",moji_const,quote);

				if (moji_const || quote || (c1!='/' && c1!='*')) {
					if (!cm_level) {
						wkstr[h++] = c;
					}
					break;
				}
				if (c1 == '*') {
/*
printf("cllex:i=%d len=%d buf=[%s] cm_level=%d(start)\n",i,len,buff,cm_level);
*/
					cm_level++;
					i += wrk[0];
					break;
				}
				if (!cm_level) {
					new_lex = 1;
					y->option |= D_SCRPT_NEW_LEX;
				}
			case M_COMMENT:
				if (new_lex && quote) {
					wkstr[h++] = c;
					break;
				}
				if ((i=_skip_line(y,buff,&sspl)) < 0) goto FEND;
				break;
			case ')':
			case '}':
			case ']':
				if (!cm_level) {
					if (!quote) {
						rc = 0;
						if (c==')' && kk_level>0) {
							kk_level--;
						/*
							if (!kk_level && y->cmd->cid==C_TRY) {
								wkstr[h++] = c;
								rc = _kugiri(y,M_KUGIRI,h,wkstr,&info);
								h = 0;
								moji_const = 0;
								break;
							}
						*/
						}
						else if (c=='}' && k2_level>0 && !def_parm) k2_level--;
						else if (c==']' && k3_level>0 && !def_parm) k3_level--;
						else rc = -11;
						if (!rc && (c==')' || !def_parm)) rc = _chk_act(c);
						if (rc) {
							ERROROUT3("cllex: unpaired '%c' %s rc=%d",c,cl_lex_snln(y),rc);
							return ECL_LEX;
						}
						if (!kk_level && !k2_level && !k3_level) {
							sspl.sp = i;
							if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;	/* 1-->0 2021.5.16 */
							len = sspl.wdmax;
						/*	c1 = buff[i];	*/
							c1 = _is_han_type(buff+i,'\0',wrk,sc_code);
/*
printf("cllex:i=%d c1=%c kk_level=%d k2_level=%d k3_level=%d\n",i,c1,kk_level,k2_level,k3_level);
*/
#if 1	/* 2022.1.5 */
							if (info == 'C') {
								cmnd = y->cmd->cid;
#if 1	/* 2022.1.5 */
								if (cmnd == C_LET) ;
								else if (c1!=' ' && (cmnd==C_IF || cmnd==C_ELSEIF ||
								     cmnd==C_LOOP ||/* cmnd==C_FOR || cmnd==C_WHILE || cmnd==C_UNTIL ||*/
								     cmnd==C_DO || cmnd==C_SWITCH)) {
									iKUGIRI = 1;
#else
								c1 = akxcupper(c1);
								if ((cmnd==C_IF || cmnd==C_ELSEIF) && c1=='T') iKUGIRI = 1;
								else if ((cmnd==C_LOOP || cmnd==C_FOR || cmnd==C_WHILE || cmnd==C_UNTIL) && (c1=='D'|| c1=='A')) iKUGIRI = 1;
								else if ((cmnd==C_DO || cmnd==C_SWITCH) && c1=='A') iKUGIRI = 1;
								if (iKUGIRI) {
#endif
									wkstr[h++] = c;
									if (rc = _kugiri(y,' ',h,wkstr,&info)) return rc;
									h = 0;
									moji_const = 0;
									break;
								}
							}
#else
							if (c1=='T' || c1=='t' || c1=='D' || c1=='d') {
								wkstr[h++] = c;
								if (rc = _kugiri(y,' ',h,wkstr,&info)) return rc;
								h = 0;
								moji_const = 0;
								break;
							}
#endif
						}
					}
					wkstr[h++] = c;
				}
				break;
			case '{':
				if (!cm_level) {
					if (!quote && !def_parm) {
						k2_level++;
						if (rc=_chk_act(c)) goto ERR;
					}
					wkstr[h++] = c;
				}
				break;
			case '\n':
			case '\r':
/*
printf("cllex:CR/LF: new_lex=%d inter_mode=%d i=%d len=%d c=%c buff=[%s]\n",new_lex,inter_mode,i,len,c,buff);
*/
				if (!new_lex) break;
				if (len==1 && inter_mode) goto FEND;
			case '\t':
			case '(':
			case '[':
			case M_SPACE:
			case M_KUGIRI:
				if (cm_level) break;
				if (!quote) {
					if (c=='(' || c=='[') {
						if (c == '(') kk_level++;
						else if (c=='[') k3_level++;
						if (rc=_chk_act(c)) goto ERR;
					}
				}
/*
printf("cllex:i=%d h=%d c=%c kk_level=%d\n",i,h,c,kk_level);
*/
				if (quote || (info=='C' && (c=='[' || c=='('))) {
				/*	if (buff[i] == '\t')
						buff[i] = ' ';	*/
					wkstr[h++] = c;
				}
				else if (c==M_KUGIRI && kk_level>0) {
					wkstr[h++] = c;
				}
				else {
					if (info=='C' && y->cmd->cid==C_DO &&
					    !y->cmd->prmnum && stricmp(wkstr,"AS")) {
						if (rc = _kugiri(y,';',0,wkstr,&info)) return rc;
					}
					rc = _kugiri(y,c,h,wkstr,&info);
					if (rc == C_PARM_CONTINUE) {
						wkstr[h++] = c;
					}
					else if (rc == C_PARM_START) {
						h = 0;
						wkstr[h++] = c;
						moji_const = 0;
					}
					else if (rc) return rc;
					else {
						h = 0;
						moji_const = 0;	/* add 2001.8.20 Koba */
					}
				}
				break;
			case M_QUOTE1:	/* ' */
			case M_QUOTE2:	/* " */
#if 1	/* 2022.3.10 */
				if (cm_level) {
					if ((c==cM_QUOTE2 && quote==cM_QUOTE2) ||
					    (c==cM_QUOTE1 && quote==cM_QUOTE1)) {
						sspl.sp = i;
						if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;	/* 1-->0 2021.5.16 */
						len = sspl.wdmax;
						/* pp̎Spp̂Ƃ́AA锼ppƌȂB */
						/* ׂ̈quoteł͂Ȃ'\0'w肵Ĕpɕϊ悤ɂB */
						c1 = _is_han_type(buff+i,'\0',wrk,sc_code);
						if (c1 == cM_QUOTE1) ;
						else {
							quote = quote2;
							quote1 = quote2 = '\0';
						}
					}
					else {
						if (!quote) {
							quote = c;
							if (c != cM_QUOTE2) quote1 = quote;
						}
						else if (quote==cM_QUOTE2 && !quote2 && c==cM_QUOTE1) {
							quote2 = quote;
							quote1 = quote = c;
						}
					}
					break;
				}
#endif
				if (c==cM_QUOTE1) {
					if (cm_level) break;
					if (!new_lex) {
						if (h == 0) moji_const = 1;	/* add 2001.8.20 Koba */
						wkstr[h++] = c;
						break;
					}
				}
				if (cm_level) break;
/*
printf("cllex:i=%d c=[%c]\n",i,c);
*/
				if ((c==cM_QUOTE2 && quote==cM_QUOTE2) ||
				    (c==cM_QUOTE1 && quote==cM_QUOTE1)) {
					if (c == cM_QUOTE1) {
						wkstr[h++] = c;
						if (h >= BUFLEN*8) {
							exit_flag = 1;
							break;
						}
						sspl.sp = i;
						if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;	/* 1-->0 2021.5.16*/
						len = sspl.wdmax;
					/*	c1 = buff[i];	*/
						/* pp̎Spp̂Ƃ́AA锼ppƌȂB */
						/* ׂ̈quoteł͂Ȃ'\0'w肵Ĕpɕϊ悤ɂB */
						c1 = _is_han_type(buff+i,'\0',wrk,sc_code);
/*
printf("cllex:i=%d len=%d c1=%c buff+i=[%s]\n",i,len,c1,buff+i);
*/
						if (c1 == cM_QUOTE1) {
						/*	wkstr[h++] = buff[i++];	*/
							wkstr[h++] = c1;
							i += wrk[0];
							break;
						}
#if 1	/* 2021.10.31 *//* 0 -> 1 */
						else {
							quote = quote2;
							quote1 = quote2 = '\0';
/*
printf("cllex:1 i=%d c=[%c] quote=[%c] quote2=[%c]\n",i,c,quote,quote2);
*/
							if (quote)  break;
							else if (c1!='\t' && c1!=M_SPACE && c1!=M_KUGIRI) {
								moji_const = 0;
							/*	quote = '\0';	*/
/*
printf("cllex:moji_const=%d quote=%02x\n",moji_const,quote);
*/
#if 1	/* 2022.1.6 */
								if (info == 'C') {
									cmnd = y->cmd->cid;
									if (cmnd == C_LET) break;
									else if (c1!=' ' && (cmnd==C_IF || cmnd==C_ELSEIF ||
									     cmnd==C_LOOP ||/* cmnd==C_FOR || cmnd==C_WHILE || cmnd==C_UNTIL ||*/
									     cmnd==C_DO || cmnd==C_SWITCH)) ;
									else break;
								}
								else 
#endif
								break;
							}
						}
#endif
						c = c1;
					}
/*
printf("cllex:moji_const=%d info=[%c] h=%d\n",moji_const,info,h);
*/
					if (info == 'N') {	/* R}h */
						if (rc = _kugiri(y,c,h,wkstr,&info)) return rc;
					}
					else {
						parmlen = h;
						wkstr[h] = '\0';
						if (rc = clparmsetopt(y,wkstr,parmlen,1)) return rc;
					}
					h = 0;
					moji_const = 0;	/* add 2001.8.20 Koba */
					quote = '\0';
				}
				else {
					if (!quote) {
						if (h>0 && (c==cM_QUOTE2 ||
						            (c==cM_QUOTE1 && info=='N' && new_lex))) {
							wkstr[h] = '\0';
							if (rc = _kugiri(y,c,h,wkstr,&info)) return rc;
							h = 0;
							moji_const = 0;	/* add 2001.8.20 Koba */
						}
						quote = c;
						if (c == cM_QUOTE2) {
							break;
						}
						else quote1 = quote;
					}
					else if (quote==cM_QUOTE2 && !quote2 && c == cM_QUOTE1) {
						quote2 = quote;
						quote1 = quote = c;
					}
/*
printf("cllex:2 i=%d c=[%c] quote=[%c] quote2=[%c]\n",i,c,quote,quote2);
*/
					wkstr[h++] = c;
				}
				break;
			case YEN:
				sspl.sp = i;
				if ((i=cl_chk_pos(y,&sspl,0)) < 0) goto FEND;	/* 2-->0 2021.5.16 */
				len = sspl.wdmax;
				if (i < len) {
					if (iskanji(buff+i)) break;
					c=buff[i];
					if (new_lex) {
						if (quote==cM_QUOTE1) {
							if (c=='\r' || c=='\n') i++;
							else if (!cm_level) wkstr[h++] = YEN;
						}
						else {
							if (c=='\r' || c=='\n') i++;
							else {
								if (!cm_level) {
									wkstr[h++] = c;
								}
								i++;
							}
						}
					}
					else {
						if (c!='\t' && c!='\n' && c!=M_SPACE) {
							if (!cm_level) {
								wkstr[h++] = c;
							}
							i++;
						}
					}
				}
				break;
			default:
				if (!cm_level) {
					wkstr[h++] = c;
				}
				break;
		}
	}
	ERROROUT2("cllex:String too long.[%s] %s", wkstr,cl_lex_snln(y));
	return ECL_LEX;
FEND:
	p = cl_lex_snln(y);
	if (kk_level || k2_level || k3_level) {
					/* cllex: JbR('(')Ă܂(%s)Bkk_level=%d */
		if (kk_level) ERROROUT2(FORMAT(31),p,kk_level);
					/* cllex: JbR('{')Ă܂(%s)Bk2_level=%d */
		if (k2_level) ERROROUT2(FORMAT(38),p,k2_level);
					/* cllex: JbR('[')Ă܂(%s)Bk3_level=% */
		if (k3_level) ERROROUT2(FORMAT(39),p,k3_level);
		return ECL_LEX;
	}
	else if (cm_level) {
		/* cllex: RgĂ܂(%s)Bcm_level=%d */
		ERROROUT2(FORMAT(32),p,cm_level);
		return ECL_LEX;
	}
	else if (quote) {
		/* "cllex: p(%c)Ă܂(%s)B */
		ERROROUT2(FORMAT(33),quote,p);
		return ECL_LEX;
	}
	else if (info=='C' || h>0) {
		if (h>0) {
			wkstr[h] = '\0';
			clparmsetopt(wkstr,h,1);
		}
		ERROROUT1(FORMAT(34),p);	/* cllex: IĂ܂(%s)B */
		if (!cl_get_cmd_line(&y->cmd,&parm)) ERROROUT1(" ---> [%s]",parm);
		else ERROROUT1(FORMAT(35),wkstr);	/* cllex: [%s]͗Lȕł͂܂B */
		return ECL_LEX;
	}
FEND2:
	cl_cmd_init(y->cmd);
	clparmclr(y);
	y->cmd->cid = C_FEND;	/* t@CI */
	y->cmd->type = 0;
	rc = cl_syn_main(y);
/*
printf("cllex: cl_syn_main rc=%d\n",rc);
*/
	cl_cmd_init(y->cmd);
	clparmclr(y);
	y->clstcb->nestLev1 = NULL;
	y->clstcb->nestLev2 = NULL;
	info = 'N';
	return rc;
ERR:
	ERROROUT2("cllex:rc=%d %s",rc,cl_lex_snln(y));
	wkstr[h] = '\0';
	if (cl_get_cmd_line(y->cmd,&parm)) parm = "";
	if (parm) ERROROUT2(" ---> [%s %s]",parm,wkstr);
	else ERROROUT1(" ---> [%s]",wkstr);
	return rc;
}

/************************************/
/* _kugiri							*/
/************************************/
static int _kugiri(y,kc,h,wkstr,pinfo)
condList *y;
char kc,*wkstr,*pinfo;
int  h;
{
	int rc,parmlen,cnum,cid,no_kugiri,n,i,thenl,elsel,cmd_count,scno,pos;
	cmdTable *pcmd;
	char *p,wrk[2];
	cmdInfo *cmd;

	cmd = y->cmd;
	parmlen = h;
	wkstr[parmlen] = '\0';

DEBUGOUTL5(LEX_LOG_GROUP+124,"_kugiri: kc=%c h=%d wkstr=[%s] info=%c cid=%08x",kc,h,wkstr,*pinfo,cmd->cid);

/*
printf("_kugiri: kc=%c h=%d wkstr=[%s] info=%c cid=%08x\n",kc,h,wkstr,*pinfo,cmd->cid);
*/
/*
printf("_kugiri: cid=%08x thenl_level=%d\n",cid,thenl_level);
*/
	if (*pinfo == 'N') cmd->cid = C_UNKNOWN;
	thenl = 0;
	elsel = 0;
	if (parmlen>0 || (!parmlen && (kc=='(' || kc=='['))) {
		if (*pinfo == 'N'){	/* R}h */
			cl_cmd_init(cmd);
			pcmd = cl_cmd_chk(wkstr);
			if (pcmd->cmdid == C_UNKNOWN) {
				strcpy(comstr,"LET");
				pcmd = cl_cmd_chk(comstr);
				cmd->cid = cid = pcmd->cmdid;
				cmd->type = pcmd->type;
				cmd->rc  =  y->line;
				*pinfo = 'C';
				if (kc=='[' || kc=='(') return C_PARM_CONTINUE;
				if (rc=clparmsetopt(y,wkstr, parmlen,1)) return rc;
			}
			else {
				cmd->cid = cid = pcmd->cmdid;
				cmd->type = pcmd->type;
				cmd->rc  =  y->line;/*add 95.1.4 Koba*/
				*pinfo = 'C';
				strcpy(comstr,wkstr);
				if (kc == '(') return C_PARM_START;
				if ((cid==C_ELSE || cid==C_DEFAULT/* || cid==C_FINALLY*/) &&
				    (kc==' ' || kc=='\t' || kc=='\n')) {
					kc = M_KUGIRI;
				}
			}
		}
		else {	/* p[^ */
			no_kugiri = 1;
			cid = cmd->cid;
			if (cid==C_IF || cid==C_ELSEIF) {
				if (!stricmp(wkstr,"THEN")) {
					no_kugiri = 0;
					kc = M_KUGIRI;
				}
			}
			else if ((cid==C_LOOP/* || cid==C_FOR || cid==C_WHILE || cid==C_UNTIL*/) &&
			     !stricmp(wkstr,"DO")) {
				no_kugiri = 0;
				kc = M_KUGIRI;
				cmd->sub_cid = C_LOOP_DO;
			}
		/*
			else if (cid == C_TRY) {
				pos= akxnskipin(wkstr,strlen(wkstr)," \t");
				if (!cmd->prmnum && wkstr[pos]!='(') {
					if ((rc=_kugiri(y,M_KUGIRI,0,wrk,pinfo)) < 0) return rc;
					return _kugiri(y,kc,h,wkstr,pinfo);
				}
			}
		*/
			if (no_kugiri) {
				if (rc=clparmsetopt(y,wkstr,parmlen,1)) return rc;
			}
		}
	}
	if (kc==M_KUGIRI && cmd->cid!=C_UNKNOWN) {
/*
printf("_kugiri: comstr=[%s] at line=%d\n",comstr,y->line);
*/
		if (rc = clparmset(y,"",0)) return rc;	/* [NGAŌɕt */
		if (rc = clparmset(y,"",0)) return rc;	/* 2020.10.29 add */
		cmd->prmnum -= 2;				/* p[^ɏL͓Ȃ */
		if (rc = clparmset2(y)) return rc;
		cid = cmd->cid;
/*
printf("_kugiri: thenl_level=%d else_level=%d cmd_count=%d\n",
thenl_level,else_level,cmd_count);
*/
		if (rc = cl_syn_main(y)) {	/* ͖؍쐬 */
			return rc;
		}
		scno = cmd->sub_cid;
		if ((cid==C_LET || cid==C_DEFINE) && (scno==CS_OPTIONS || scno==CS_OPTION)) {
			cM_QUOTE1 = pGlobTable->Quot[0];
			cM_QUOTE2 = pGlobTable->Quot[1];
		}
		/* "end if" ́Acl_syn_main()̒C_ENDIFɕϊ̂cidĐݒ肷 */
		cid = cmd->cid;
/*
printf("_kugiri: comstr=[%s] at line=%d thenl=%d elsel=%d thenl_level=%d\n",
comstr,CLcList.line,thenl,elsel,_get_if_level());
*/
		*pinfo = 'N';
		cl_cmd_init(cmd);
		clparmclr(y);
	}
	return 0;
}
