/*******************************************/
/*						*/
/*	trs	 			*/
/*						*/
/*		by A.Kobayashi 2001.10.24	*/
/*						*/
/*******************************************/
#include	"cpxcommon.h"

#ifndef SS2
#define SS2		0x8e	/* Hankaku Kana */
#define SS3		0x8f	/* G3 AREA      */
#endif

int  f_nmb,t_nmb,mode,debug_flg=0;
FILE *fp;
tdtRepStr *tpRep=NULL;
char *fname=NULL,*tfile=NULL;

void _Exit(stat)
int stat;
{
	if (fp) fclose (fp);
	if (tpRep) cpxcRepStrFree(tpRep);
	exit(stat);
}

int _getopt(argc, argv)
int  argc;
char *argv[];
{
	uchar c1,c2,*p;
	int n,ret,i;
	char parm[256],*argv2[8],buf[128];

	argc--;
	argv++;
	fp = NULL;
	f_nmb = 1;
	t_nmb = 0;
	mode = CD_TYPE_UTF8;
	fname = NULL;

	while (argc-- > 0) {
		p = (uchar *)*argv++;
		c1 = *p;
		if (c1 == '-') {
			p++;
			if ((c2=*p)>='0' && c2<='9') {
				n = atoi((char *)p);
				if (n<1 || n>16) return -1;
				f_nmb = n;
			}
			else if (c2 == 'S' || c2 == 's') mode = CD_TYPE_SJIS;
			else if (c2 == 'E' || c2 == 'e') mode = CD_TYPE_EUC;
			else if (c2 == 'U' || c2 == 'u') mode = CD_TYPE_UTF8;
			else if (c2 == 't' || c2 == 'a') {
				p++;
				if (*p) tfile = (char *)p;
				else {
					argc--;
					tfile = *argv++;
				}
				if (!tpRep) {
					if (!(tpRep=cpxcRepStrNew(0,100,10))) {
						XERROROUTL5(0,"RepStrNew error!!",0,0,0,0,0);
						_Exit(3);
					}
				}
				if (c2 == 't') {
					XDEBUGOUTL5(0,"tfile=[%s]",tfile,0,0,0,0);
					if ((ret=cpxcRepAddFile(tpRep,tfile)) < 0) {
						XERROROUTL5(0,"RepAddFile error=%d!!",ret,0,0,0,0);
						_Exit(4);
					}
				}
				else {
					XDEBUGOUTL5(0,"add=[%s]",tfile,0,0,0,0);
					n = cpxtgetargv2(tfile,argv2,4,parm,sizeof(parm),5);
					XDEBUGOUTL5(0,"cpxtgetargv2 n=%d",n,0,0,0,0);
					if ((ret=cpxcRepSetParm(n,argv2,argv2,NULL,buf)) < 0) {
						XERROROUTL5(0,"RepSetParm error=%d!!",ret,0,0,0,0);
						_Exit(5);
					}
					if ((ret=cpxcRepAddRange(tpRep,n,argv2,NULL)) < 0) {
						XERROROUTL5(0,"RepAddRange error=%d!!",ret,0,0,0,0);
						_Exit(6);
					}
				}
			}
			else if (c2 == '-') {
				p++;
				if (cpxLogSetCommandParm(*p,p+1) < 0) return -4;
			}
			else return -3;
		}
		else if (c1 == '+') {
			p++;
			if ((c2=*p)>='0' && c2<='9') {
				n = atoi((char *)p);
				if (n<1 || n>16) return -1;
				t_nmb = n;
			}
			else return -3;
		}
		else {
			fname = (char *)p;
			XDEBUGOUTL5(0,"fname=[%s]",fname,0,0,0,0);
		}
	}
	if (t_nmb < f_nmb) t_nmb = f_nmb;
	if (mode==CD_TYPE_EUC  && t_nmb<3) t_nmb = 3;
	if (mode==CD_TYPE_SJIS && t_nmb<2) t_nmb = 2;
	if (mode==CD_TYPE_UTF8 && t_nmb<3) t_nmb = 3;
	akxt_set_code_type(mode);
	XDEBUGOUTL5(0,"f_nmb=%d t_nmb=%d",f_nmb,t_nmb,0,0,0);
	return 0;
}

int main(argc,argv)
int  argc;
char *argv[];
{
	char *p;

	p = cpxtGetLastName("\\/",argv[0]);
	cpxLogSetUpName(p);
	XLOGFLG(X_LOG_NO_ERROR,D_LOG_FLG_STDERR);
	XLOGFLG(X_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	if (_getopt(argc, argv) < 0) {
		fprintf(stderr,"usage : %s [-h|-?][--{e|p|d|l}[LOG_PARAMETER] [-s|-e|-u]\n            [-S|-E|-U][-from_number][+to_number][-t table] [-a replace][file_name]\n",p);
		fprintf(stderr,"  here\n    LOG_PARAMETER := [FLAG],[LEVEL],[SIZE_MAX],[FILE_MAX],[OPTION],[FILE]]\n\n");
		_Exit(0);
	}

	if (fname) {
		fp = fopen(fname,"rb");
		if (!fp) {
			XERROROUTL5(0,"file[%s] open error!!",fname,0,0,0,0);
			_Exit(2);
		}
	}
	else {
		fname = "stdin";
		fp = stdin;
	}

	_trs();

	_Exit(0);
}

int _Puts(out_cod)
char *out_cod;
{
	char c;

	while (c = *out_cod++) putchar(c);
	return 0;
}

static int _isankn(p,n,hantei)
char *p,*hantei;
int n;
{
	int i,k,j;

	if (mode >= 0) {
		memset(hantei,0,n);
		for (i=0;i<n;i++) {
			k = akxqkanjilen2(p,n-i);
			p += k;
			if (k > 1) {
				i += (k - 1);
				*(hantei+k-1) = 1;
			}
			else *hantei = 1;
			hantei += k;
		}
		if (i > n) return 0;
	}
	else memset(hantei,1,n);
	return 1;
}

int _trs()
{
	int   c,ret,i,pos,sap,m;
	uchar in_cod[20],out_cod[256],w[20],hantei[20];

	pos = sap = 0;
	while ((pos=cpxaFWgetc(in_cod,t_nmb,fp,pos,sap)) > 0) {
		in_cod[pos] = '\0';
		XDEBUGOUTL5(0,"pos=%d in_cod=[%s]",pos,in_cod,0,0,0);
		_isankn(in_cod,pos,hantei);
		memcpy(w,in_cod,pos);
		ret = 0;
		for (i=pos;i>=f_nmb;i--) {
			w[i] = '\0';
			XDEBUGOUTL5(1,"i=%d hantei=%d",i,hantei[i-1],0,0,0);
			if (hantei[i-1]) {
				/* ΏەŌオ̂PoCgڂłȂƂ́A
				   uΏۂɂB */
				ret = cpxcRepStr(tpRep,0,w,out_cod);
				if (ret > 0) {
					_Puts(out_cod);
					sap = i;
					break;
				}
			}
		}
		if (ret <= 0) {
			/* Ώە񂪊ŁAuȂƂ́Ao͂ */
			m = akxqkanjilen2(in_cod,pos);
			if (m > 1) {
				/* fileI[t߂łȂpos>=młB
				   (t_nmbƂ̃oCgɐݒ肵Ă邽) */
				if (m > pos) m = pos;
				strnzcpy(out_cod,in_cod,m);
				_Puts(out_cod);
				sap = m;
			}
			else {
				putchar(*in_cod);
				sap = 1;
			}
		}
	}
	return 0;
}
