//
proc main;
	if (%0 == 0) then
		echo 'usage: ' SCRIPTNAME ' name list';
		exit 1;
	endif;

	dir =  '/home/koba/develop/src/cpf/';
	try
		while (%0) do
			fname = %1;
			stat(fname,1);
			if ($1 <> 5) then
				echo fname ' is not file, skipped.';
			else
				echo;
				echo '--- ' fname ' ---';
				diff(fname,dir);
			endif;
			shift;
		end do;
	catch;
		fputline(STDERR,ERRMSG);
	end try;
	return ERROR;
end proc;

func diff (fname,dir);
	if instr(fname,'akx/akx') then
		rep(fname,dir,'akx/akx','xcom/cpx');
	elseif instr(fname,'akb/akbcom') then
		rep(fname,dir,'akb/akbcom','fcom/com');
	elseif instr(fname,'akb/akb') then
		rep(fname,dir,'akb/akb','fcom/cpf');
	elseif instr(fname,'aka/aka') then
		rep(fname,dir,'aka/aka','cpa/cpa');
	elseif instr(fname,'include/akx') then
		rep(fname,dir,'include/akx','include/cpx');
	elseif instr(fname,'include/akb') then
		rep(fname,dir,'include/akb','include/cpf');
	elseif instr(fname,'include/aka') then
		rep(fname,dir,'include/aka','include/cpa');
	elseif instr(fname,'include/aku') then
		rep(fname,dir,'include/aku','include/cpu');
	else
		rep(fname,dir,'X','X');
	end if;
	return ERROR;
end func;

func rep(fname,dir,pat1,pat2);
	fname2 = replike(fname,pat1,pat2);
//	echo 'diff' fname "dir & fname2";
	system('diff ' & fname & ' ' & dir & fname2);
	return ERROR;
end func;
