/*static char sccsid[]="%Z% %M% %I% %E% %U%";*/
/************************************************************************/
/*																		*/
/*		akbconst.h														*/
/*																		*/
/*			Coded by Akito Kobayashi	2010.5.28						*/
/*																		*/
/************************************************************************/
#ifndef _AKBCONST_H
#define _AKBCONST_H

/*** Packet Command ***/
#define AKB_CMD_REGIST		1
#define AKB_CMD_DELETE		2
#define AKB_CMD_QUERY		3
#define AKB_CMD_WATCH		4
#define AKB_CMD_SEND		5
#define AKB_CMD_NOTIFY		6
#define AKB_CMD_TRACE		7
#define AKB_CMD_LOGSTART	AKB_CMD_TRACE
#define AKB_CMD_LOG			8
#define AKB_CMD_WAKEUP		9
#define AKB_CMD_RECVMSG		10
#define AKB_CMD_REQUEST		11
#define AKB_CMD_STATISTICS	12
#define AKB_CMD_VERSION		13
#define AKB_CMD_PASSWORD	14
#define AKB_CMD_VCHSEND		15
/* #define AKB_CMD_BROADCAST	15 */
#define AKB_CMD_MEMORY		16
#define AKB_CMD_HELP		17
#define AKB_CMD_HOSTCMD		18
#define AKB_CMD_PROPERTY	19
#define AKB_CMD_NEED_REPLY	20
#define AKB_CMD_BUNSAN		199
#define AKB_CMD_BROADCAST	200
#define AKB_CMD_ONDEMAND	201
#define AKB_CMD_KILL		249
#define AKB_CMD_SELECT		250
#define AKB_CMD_READ		251
#define AKB_CMD_WRITE		252
#define AKB_CMD_START		253
#define AKB_CMD_SHUT		254
#define AKB_CMD_FSHUT		255

/*** akbOption ***/
#define AKB_AKO_NOREPLY		0x01
#define AKB_AKO_VER_B		0x02
#define AKB_AKO_LEAVE		0x04
#define AKB_AKO_CHANNEL		0x08
#define AKB_AKO_MULTI_REPLY	0x10
#define AKB_AKO_CHANNEL_CMD	0x20
/* #define AKB_AKO_VER_A		0x40 */
#define AKB_AKO_ROUTED		0x40

/*** Packet Form ***/
#define AKB_PFM_INDIRECT	0x01
#define AKB_PFM_CDTYPE		0x0e
#define AKB_PFM_SYSINDIR	0x80
#define AKB_PFM_PRIORITY	0x40
#define AKB_PFM_NEED_REPLY	0x20

/* command number */
#define CM_CMD_SRV_REGIST   AKB_CMD_REGIST
#define CM_CMD_SRV_DELETE   AKB_CMD_DELETE
#define CM_CMD_CLT_REGIST   AKB_CMD_REGIST
#define CM_CMD_CLT_DELETE   AKB_CMD_DELETE
#define CM_CMD_TRM_QUERY    AKB_CMD_QUERY
#define CM_CMD_SEND         AKB_CMD_SEND
#define CM_CMD_SHUT         AKB_CMD_SHUT
#define CM_CMD_FSHUT        AKB_CMD_FSHUT

/*  */
#define AKB_PRNAME_PROM   "akProMan"
#define AKB_PRNAME_NETM   "akNetMan"
#define AKB_PRNAME_TERM   "akTrmMan"
#define AKB_PRID_PROM      1
#define AKB_PRID_NETM      2
#define AKB_PRID_TERM      3
#define AKB_PRID_BUNS      4
#define D_PRID_PROM        AKB_PRID_PROM
#define D_PRID_NETM        AKB_PRID_NETM
#define D_PRID_TERM        AKB_PRID_TERM
#define D_PRID_TERM_BASE   10000
#define D_PRID_TERM_MAX    60000
#define AKB_PID_MAX			0xFFF0
#define AKB_BCO_SERV		0x0001
#define AKB_BCO_TERM		0x0002
#define AKB_BCO_CMND		0x0004
#define AKB_BCO_RESV		0x0008
#define AKB_PID_BROADCAST	(AKB_PID_MAX|AKB_BCO_CMND|AKB_BCO_RESV|AKB_BCO_SERV|AKB_BCO_TERM)
#define AKB_PID_BC_SERV		(AKB_PID_MAX|AKB_BCO_CMND|AKB_BCO_RESV|AKB_BCO_SERV)
#define AKB_PID_BC_TERM		(AKB_PID_MAX|AKB_BCO_CMND|AKB_BCO_RESV|AKB_BCO_TERM)
#define D_PID_BROADCAST		AKB_PID_BROADCAST
#define D_PID_BROADCAST_S	AKB_PID_BC_SERV
#define D_PID_BROADCAST_T	AKB_PID_BC_TERM
#define D_PRID_MAX			AKB_PID_MAX
#define D_HID_BROADCAST		0xffffffff

#define  D_NREGIST  0
#define  D_REGIST   1

#define  D_NOCONNECT  0
#define  D_CONNECTED  1
#define  D_REGISTED   2
#define  D_CANCELED   3
#define  D_EXPIRED    4
#define  D_ONDEMAND  0x80 

#define  D_PACKET_MAX_SIZE   256

/* 1R[hőL */
#define D_RECORD_BUFSIZE	AKX_RECORD_BUFSIZE

/* ^CAEg}N */
#define DEFAULT_TIMEOUT		15	/* sec */
#define IGNORE_ONDEMAND_TIME	180	/* sec */
#define AKB_NWSELECT_WAIT		50		/* msec */
#define AKB_NWSELECT_WAIT_MAX	1000	/* msec */
#define AKB_CHA_RB_WAIT_TIME	60000	/* msec */

#define AKB_MAX_EXEC_PARM	50
 
/****************************
       Ot@C
 ****************************/

/* G[x */
#define D_ERROR_LOG		0
#define D_WARNING_LOG	1

/* pPbg */
#define D_DIR_READ		1
#define D_DIR_WRITE		2

/* G[ */
#define D_STATUS_READ	1
#define D_STATUS_WRITE	2
#define D_STATUS_PRE	3

/* G[u */
#define	D_MANAGE_EXIT		1
#define	D_MANAGE_CLOSE		2
#define	D_MANAGE_RESEND		3
#define	D_MANAGE_EXTINCT	4

/*********************************
      pPbg̎
 *********************************/
#define D_PACKET_IS_SEND	1
#define D_PACKET_IS_RESEND	2
#define	D_PACKET_IS_ERROR	4
#define	D_PACKET_IS_NOREPLY	8
#define	D_PACKET_IS_BROADCAST	16
#define	D_PACKET_IS_ROUTED	32

#define  NORMAL     0
#define  ERROR      -1

/*********************************
		Oo
*********************************/
#define D_LOG_NO_MAX		10
#define D_LOG_NO_MAX_RESV	5
#define D_LOG_NO_ERROR		0
#define D_LOG_NO_PRINT		1
#define D_LOG_NO_DEBUG		2
#define D_LOG_NO_RESV		3
#define D_LOG_NO_STATI		3
#define D_LOG_NO_TRACE		4

#define ERROR_LOG_FILE		"error_log"	/* use log_no = 0 */
#define PRINT_LOG_FILE		"print_log"	/* use log_no = 1 */
#define DEBUG_LOG_FILE		"debug_log"	/* use log_no = 2 */
#define STATI_LOG_FILE		"stati_log"	/* use log_no = 3 */
#define TRACE_LOG_FILE		"trace_log"	/* use log_no = 4 */

#define D_LOG_DUMP_SIZE		750	/* byte */

#define AKB_LOG_GROUP		0x20000000	/* for akb */
#define AKBP_LOG_GROUP		0x08000000	/* for akb processes */
#define AKBENT_LOG_GROUP	0x04000000
#define AKBRET_LOG_GROUP	0x02000000

/*********************************
		g[X
*********************************/
#define D_PRLOGFILE  "prom.dump"
#define D_TRLOGFILE  "trmm.dump"
#define D_NTLOGFILE  "netm.dump"

#define D_TRACE_DUMP_SIZE	750	/* byte */

#define AKB_TRACE_HEAD_ONLY	0x08
#define AKB_TRACE_BINARY	0x10
#define AKB_TRACE_HEAD_DUMP	0x20
#define AKB_TRACE_LOGOUT	0x40

/*********************************

*********************************/
#define HOST_NAME_LEN   64              /* zXg */

/* env name */
#define AKB_HOME	"AKB_HOME"
#define AKB_INI		"AKB_INI"
#define AKB_HELP	"AKB_HELP"

/***********************************
		akb.ini
***********************************/
#define AKBINI					"akb.ini"
#define BLK_TITLE				"TITLE"
#define BLK_PROCESS				"PROCESS"
#define BLK_SERVICE				"SERVICE"
#define BLK_HOSTCONNECT			"HOSTCONNECT"
#define BLK_TIMEOUT				"TIMEOUT"
#define BLK_AKBSYSTEM			"AKB_SYSTEM"
#define BLK_BUNSAN				"BUNSAN"
#define D_SECTION_AKB_SYSTEM	BLK_AKBSYSTEM
#define D_KEYNAME_NOTIFY		"NOTIFY"
#define D_KEYNAME_TIMER			"TIMER"
#define D_KEYNAME_VCH			"VCH"
#define D_KEYNAME_RWQ_TIMEOUT	"RWQ_TIMEOUT"
#define D_KEYNAME_ONDEMAND		"ONDEMAND"
#define D_KEYNAME_MSG_TIMEOUT	"MSG_TIMEOUT"
#define D_KEYNAME_EXEC_OPTION	"EXEC_OPTION"
#define D_KEYNAME_PROM_HOST		"PROM_HOST"
#define D_KEYNAME_HELP_DIR		"HELP_DIR"

/*********************************
		^CAEg
*********************************/
#define D_TIMEOUT_SET_READ		0
#define D_TIMEOUT_SET_WRITE		1
#define D_TIMEOUT_SET_CONNECT	2
#define D_TIMEOUT_SET_ACCEPT	3
#define D_TIMEOUT_SET_RQUETO	4
#define D_TIMEOUT_SET_WQUETO	5

/*********************************
		f[^
*********************************/
#define DEF_ZOK_MASK	AKX_ZOK_MASK	/* DATA TYPE MASK	*/
#define DEF_ZOK_USMASK	AKX_ZOK_USMASK	/* unsigned MASK	*/
#define DEF_ZOK_CHAR	AKX_ZOK_CHAR	/*   			*/
#define DEF_ZOK_BINA	AKX_ZOK_BINA	/*   Qi			*/
#define DEF_ZOK_LONG	AKX_ZOK_LONG	/*   Qi			*/
#define DEF_ZOK_FLOA	AKX_ZOK_FLOA	/*   		*/
#define DEF_ZOK_DECI	AKX_ZOK_DECI	/*   POi		*/
#define DEF_ZOK_BULK	AKX_ZOK_BULK	/*   BULK^			*/
#define DEF_ZOK_DATE	AKX_ZOK_DATE	/*   DATE^			*/
#define DEF_ZOK_VARI	AKX_ZOK_VARI	/*   oAg^	*/
#define DEF_ZOK_KANS	AKX_ZOK_KANS	/*   Ԑ			*/
#define DEF_ZOK_UINT	AKX_ZOK_UINT	/*   unsigned int	*/
#define DEF_ZOK_ULNG	AKX_ZOK_ULNG	/*   unsigned long	*/
#define DEF_ZOK_DATA	AKX_ZOK_DATA	/*   			*/

#define D_FMT_STD         0x01         /* WtH[}bg`	*/
#define D_FMT_EXT         0x00         /* gtH[}bg`	*/
#define D_FMT_BIN         0x03         /* l O			*/
#define D_FMT_KAN         0x02         /* ԐڃtH[}bg`	*/

#define D_ACC_EXT         0x00         /* g`         */
#define D_ACC_STD         0x01         /* W`         */
#define D_ACC_CHAR        1         /* x(u char)     */
#define D_ACC_SHORT       2         /* x(short int)  */
#define D_ACC_LONG        4         /* x(long int)   */
#define D_ACC_DOUBLE	8			/* x(8 byte length)  */

#define D_DATA_MALLOC		0x80	/* malloc data        */
#define D_DATA_LPOSDATA		0x40	/* data to pi_pos   */
#define D_DATA_ARRAY_FREE	0x20	/* avail to free array data */
#define D_DATA_ARRAY		0x10	/* array   */

/*********************************
	Read/Write Buffer Que Option
*********************************/
#define AKB_WQUE_MAX_WAIT	5

#define AKB_RQUE_OPT_XTOF			0x01
#define AKB_RQUE_OPT_INDIR			0x02
#define AKB_RQUE_OPT_ERR_DROP		0x20
#define AKB_RQUE_OPT_ERR_BUFF		0x40
#define AKB_WQUE_OPT_MAKE_XPACK		0x04
#define AKB_WQUE_OPT_MAKE_INDIR		0x08
#define AKB_WQUE_OPT_SAME_HOST		0x10
#define AKB_WQUE_OPT_CHK_REPLY		0x80
#define AKB_WQUE_OPT_CHA_RB_OBJ		0x0400
#define AKB_WQUE_OPT_NOT_CHA_RB		0x0800
#define AKB_RWQUE_OPT_NEED_REPLY	0x0100
#define AKB_RWQUE_OPT_WAIT_REPLY	0x0200

/*********************************
	Read/Write Que Option
*********************************/
#define AKB_RB_OPT_USE_SRC		0x01

/*********************************
	Regist Option
*********************************/
#define AKB_REG_OPT_NEED_REPLY	0x01
#define AKB_REG_OPT_DO_CHA_RB	0x02

/*********************************
	Property
*********************************/
#define MAX_TOINDIRF_SIZE	32768	/* 4096 */
#define MAX_INDIRF_COUNT	512
#define INDIRF_SPOOL		"spool"

#define AKB_PRPTY_ID_CONFIG			0
#define AKB_PRPTY_ID_INDIRF_SIZE	1
#define AKB_PRPTY_ID_INDIRF_COUNT	2
#define AKB_PRPTY_ID_INDIRF_SPOOL	3

#endif	/* _AKBCONST_H */
