// Copyright (C) 2021 Jone Bontus
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// ``Software''), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT.	 IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#include <e32cmn.h>

#define DEF_AEABIMEM(name) EXPORT_C typeof (__aeabi_mem##name) __aeabi_mem##name##8 __attribute__((alias ("__aeabi_mem" #name), nothrow)); \
	EXPORT_C typeof (__aeabi_mem##name) __aeabi_mem##name##4 __attribute__((alias ("__aeabi_mem" #name), nothrow));

extern "C" {

EXPORT_C void *__aeabi_memset (void *dest, unsigned int len, int val)
{
	return memset(dest, val, len);
}

DEF_AEABIMEM(set)

EXPORT_C void *__aeabi_memclr (void *dest, unsigned int len)
{
	return memclr(dest, len);
}

DEF_AEABIMEM(clr)

EXPORT_C void *__aeabi_memcpy (void *dest, const void *src, unsigned int len)
{
	return memcpy(dest, src, len);
}

DEF_AEABIMEM(cpy)

EXPORT_C void *__aeabi_memmove (void *dest, const void *src, unsigned int len)
{
	return memmove(dest, src, len);
}

DEF_AEABIMEM(move)

} // extern "C"
