// -*- C++ -*- Allocate exception objects.
// Copyright (C) 2001-2020 Free Software Foundation, Inc.
//
// This file is part of GCC.
//
// GCC is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// GCC is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
// GNU General Public License for more details.
//
// Under Section 7 of GPL version 3, you are granted additional
// permissions described in the GCC Runtime Library Exception, version
// 3.1, as published by the Free Software Foundation.

// You should have received a copy of the GNU General Public License and
// a copy of the GCC Runtime Library Exception along with this program;
// see the files COPYING3 and COPYING.RUNTIME respectively.	 If not, see
// <http://www.gnu.org/licenses/>.

// This is derived from the C++ ABI for IA-64.	Where we diverge
// for cross-architecture compatibility are noted with "@@@".

#ifndef EH_ALLOC_H
#define EH_ALLOC_H

#include <bits/c++config.h>
#include <cstdlib>
#include "concurrence.h"

namespace __gnu_cxx
{
  void __freeres();
}

// namespace
// {
  // A fixed-size heap, variable size object allocator
  class pool
	{
	public:
	  pool();

	  _GLIBCXX_NODISCARD void *allocate (std::size_t);
	  void free (void *);

	  bool in_pool (void *);

	private:
	  struct free_entry {
	std::size_t size;
	free_entry *next;
	  };
	  struct allocated_entry {
	std::size_t size;
	char data[] __attribute__((aligned));
	  };

	  // A single mutex controlling emergency allocations.
	  __gnu_cxx::__mutex emergency_mutex;

	  // The free-list
	  free_entry *first_free_entry;
	  // The arena itself - we need to keep track of these only
	  // to implement in_pool.
	  char *arena;
	  std::size_t arena_size;

	  friend void __gnu_cxx::__freeres();
	};
// }

#endif
