static char sccsid[]="%Z% %M% %I% %E% %U%";
/*
	cc -g -I../include testputline.c  -o testputline
*/
#include <stdio.h>
#include <time.h>
#include <sys/time.h>

/********************************************/
/*                                          */
/********************************************/
int akx_get_log_time(char *buf, int len, char *format)
{
	static char *FORMAT;
	static int check=1;
	time_t  tw;
	struct  tm *str_tm;

	if (!buf) return -1;
	if (len <= 0) return -2;
	tw = time(NULL);
	str_tm = localtime(&tw);
	if (check) {
		strftime(buf,len,"%T",str_tm);
		if (*buf) FORMAT = "%Y/%m/%d %T";
		else FORMAT = "%Y/%m/%d %H:%M:%S";
		check = 0;
	}
	if (!format) format = FORMAT;
	return strftime(buf,len,format,str_tm);
}

/********************************************/
/*                                          */
/********************************************/
char *akx_log_time()
{
	static char buf[64];

	*buf = '\0';

	akx_get_log_time(buf,sizeof(buf),NULL);

	return buf;
}

/************************************************/
/*												*/
/************************************************/
int akxa_get_line(line,linemax,fp,opt)
char *line;
int	 linemax;
FILE *fp;
int	 opt;
{
	int opt1,opt2,c,c2,i,cw,lmax,opt_csv,quot,opt_csv_SLF;
	char *p;

	if (!fp || !line || linemax<2) return -2;

	lmax = linemax - 1;
	p = line;
	opt1 = opt & 0x01;	/* 1: CRLF=>LF, CR=>LF */
	opt2 = opt & 0x02;	/* 1:suppress LF */
	if (opt & 0x08) opt |= 0x04;
	opt_csv = opt & 0x04;	/* 1:for csv */
	if (opt_csv) opt_csv_SLF = opt & (0x08/* | 0x02*/);	/* 1:for csv suppress LF in quot */
	else opt_csv_SLF = 0;
	if (opt2 | opt_csv_SLF) opt1 = 1;
	if (!(opt1+opt2)) lmax--;
	c = EOF;
	quot = 0;
	i = 0;
	while (i<lmax && (c=getc(fp))!=EOF) {
		if (opt_csv) {
			if (c == '"') {
				if (quot) {
					c2 = getc(fp);
					if (c2 == quot) {
						if (i < lmax) {
							*p++ = c;
							i++;
						}
					}
					else {
						ungetc(c2,fp);
						quot = 0;
					}
				}
				else quot = c;
			}
		}
		cw = c;
		if (c == '\r') {
			c2 = getc(fp);
			if (opt1) {
				if (c2 != '\n') ungetc(c2,fp);
				cw = c = '\n';
			}
			else {
				if (c2 == '\n') {
					*p++ = c;
					*p++ = c2;
					i+=2;
					break;
				}
				else {
					cw = '\n';
					ungetc(c2,fp);
				}
			}
		}
		if (cw == '\n') {
			if (!opt2 && !(opt_csv_SLF && quot)) {
				*p++ = c;
				i++;
			}
			if (!(opt_csv && quot)) break;
		}
		else {
			*p++ = c;
			i++;
		}
	}
	*p = '\0';
	if (!i && c==EOF) i = -1;
/*
printf("akxa_get_line: i=%d line=[%s]\n",i,line);
*/
	return i;
}

int main(int argc,char *argv[])
{
	char line[256];
	int n,max,opt,ret;
	FILE *fpr,*fpw;

	fpr = fopen(argv[1],"r");
	if (fpr) {
		while ((n=akxa_get_line(line,256,fpr,2))>=0) {
			fpw = fopen("wwww_log","a");
			if (fpw) {
				fprintf(fpw,"%s: %s\n",akx_log_time(),line);
				fclose(fpw);
				if (ret <= 0) break;
			}
		}
		fclose(fpr);
	}
	else printf("file [%s] open error!!\n",argv[1]);
	return 0;
}
