package jp.nanah.bastub.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * KeyとValueが両方とも文字列リストであるデータ型。
 *
 */
public class KvData {

	private List<String> key;

	private List<String> values = new ArrayList<String>();

	public KvData(List<String> k, String v) {
		key = k;
		addValue(v);
	}

	public void addValue(String v){
		values.add(v);
	}

	public List<String> getKey() {
		return key;
	}

	public void setKey(String k) {
		this.key = toList(k);
	}
	public void setKey(List<String> key) {
		this.key = key;
	}

	public List<String> getValues() {
		return values;
	}

	public String getValueAsOne() {
		return (values.size() == 0) ? "" : values.get(0);
	}

	protected List<String> toList(String s){
		return Arrays.asList(new String[] {s});
	}

}
