static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/*********************************************************/
/*								*/
/*	get arg						*/
/*								*/
/*		coded   by A.Kobayashi	1992.02.21		*/
/*		updated by A.Kobayashi	1992.07.06		*/
/*		updated by A.Kobayashi	1996.01.25		*/
/*		updated by A.Kobayashi  1997.11.06		*/
/*		updated by A.Kobayashi  2001.10.16		*/
/*		updated by A.Kobayashi  2003.05.02		*/
/*								*/
/*********************************************************/

#include	"akxcommon.h"

#define LOCAL_RECORD_BUFSIZE	256
/************************************************/
/*												*/
/************************************************/
static int _vgetc(vap)
VAA_S *vap;
{
	if (vap->opt) {
	}
	else return getc(vap->fp);
}

static int _vungetc(c,vap)
char c;
VAA_S *vap;
{
}

/************************************************/
/*												*/
/************************************************/
int akxaVGetLine(line,linemax,vap,opt)
char *line;
int	 linemax;
VAA_S *vap;
int	 opt;
{
	int opt1,opt2,c,c2,i;
	char *p;
FILE *fp;

	if (!vap || !line || linemax<2) return -2;

	p = line;
	opt1 = opt & 0x01;
	opt2 = opt & 0x02;	/* 1:suppress LF */
	c = EOF;
	for (i=0;i<linemax-1 && (c=getc(fp))!=EOF;i++) {
		if (opt1 && c == '\r') {
			c2 = getc(fp);
			if (c2 == '\n') c = c2;
			else {
				c = '\n';
				ungetc(c2,fp);
			}
		}
		if (c == '\n') {
			if (!opt2) {
				*p++ = c;
				i++;
			}
			break;
		}
		else *p++ = c;
	}
	*p = '\0';
	if (!i && c==EOF) i = -1;
	return i;
}

/************************************************/
/*												*/
/************************************************/
int akxa_get_line(line ,linemax , fp, opt)
char *line;
int	 linemax;
FILE *fp;
int	 opt;
{
	VAA_S va;

	if (!fp || !line || linemax<2) return -2;
	va.opt = 0;
	va.fp  = fp;
	return akxaVGetLine(line ,linemax ,&va, opt);
}

/******************************************************************************
  ֐
        int    akxa_read_line()

  

  ԋpl
		0		ǂݍݏI
		>0		ǂݍ݌p

  Tv
       Ps̒(size-1)byteȏ̏ꍇȏ͓̕ǂ݂Ƃ΂B
        ŏ(size-1)bytebufɊi[B
******************************************************************************/
int akxa_read_line(buf ,size , fp)
char	*buf;
int		size;
FILE	*fp;
{
	int		len,lw;
	char	work[LOCAL_RECORD_BUFSIZE];
	
#if 0	/* 2001.10.16 Koba */
	if (fgets(buf , size , fp)) {
		len = strlen(buf);
#else
	if ((len=akxa_get_line(buf,size,fp,1)) >= 0) {
#endif
		if (buf[len-1] != '\n') {
			/* 255byteȏ̕ǂ݂Ƃ΂ */
			do {
#if 0	/* 2001.10.16 Koba */
				if (!fgets(work,sizeof(work),fp)) {
					return (len);
				}
				lw = strlen(work);
#else
				if ((lw=akxa_get_line(work,sizeof(work),fp,1)) < 0) {
					return len;
				}
#endif
			} while (work[lw-1] != '\n');
			return(len);
		}
		return(len);
	}
	return(0);
}

/************************************************/
/*												*/
/************************************************/
static int _wdmax_check(pwd,pattr,lmax,l,ch)
char **pwd;
uchar *pattr;
int  lmax,l;
char ch;
{
	char *wd=*pwd;

	if (lmax>0) {
		if (l<lmax-1) {
			if (wd) *wd++ = ch;
			l++;
		}
		else pattr[1] = 1;
	}
	else if (lmax==0) l++;
	else {
		if (wd) *wd++ = ch;
		l++;
	}
	*pwd = wd;
	return l;
}

/*****************************************************
	wd == NULL : wdɏ܂Ȃ
	lmax >  0  : lmax`FbNȂwdɏ
	lmax == 0  : wdɏ܂Almax`FbNȂ
	lmax <  0  : wdݎlmax`FbNȂ
******************************************************/
int akxtgetwspl(p, sspl, opt)
char   *p;
SSPL_S *sspl;
int     opt;
{
	char *wd;
	uchar *pattr;
	int	*ppos;
	int	lmax;
	int opt1,opt2,opt3,opt5;
	char	ch, quat, cw;
	int	l = 0, pos, lmax1;

	wd = sspl->wd;
	ppos = &(sspl->sp);
	pattr = &(sspl->attr[0]);
	lmax = sspl->wdmax;

	pattr[0] = 0;
	pattr[1] = 0;

/*	if ((lmax1 = lmax - 1)<0) return -2;	*/
	lmax1 = lmax - 1;
	pos = *ppos;
	p += pos;

	while(((ch=*p)=='\n')||(ch==' ')||(ch=='\t')||(ch=='\r')) {
		p++;
		pos++;
	}
	if (!ch) {
		if (wd && (lmax != 0)) *wd = '\0';
		*ppos = pos;
		return -1;
	}

	if (ch=='"' || ch=='\'') {
		if (ch=='"') *pattr = 6;
		else         *pattr = 5;
		quat = ch;
		p++;
		pos++;
		while(((ch = *p)!='\n')&&(ch!='\0')&&(ch!='\r')) {
			if (ch==quat) {
				p++;
				pos++;
				if (*p != quat) break;
			}
			l = _wdmax_check(&wd,pattr,lmax,l,ch);
			p++;
			pos++;
		}
		if (wd && (lmax != 0)) *wd = '\0';
		*ppos = pos;
		return(l);
	}
#if 1	/* add 2000.1.12 Koba */
	opt1 = opt & 0x01;	/* # */
	opt2 = opt & 0x02;	/* = */
	opt3 = opt & 0x04;	/* , */
	opt5 = opt & 0x10;	/* : or := */
	if ((opt1 && ch=='#')||(opt2 && ch=='=')||(opt5 && ch==':')||
	    (opt3 && ch==',')) {
		l = _wdmax_check(&wd,pattr,lmax,l,ch);
		*pattr = ch;
		if (wd && (lmax != 0)) *wd = '\0';
		if (ch==':' && *(p+1)=='=') {
			l = _wdmax_check(&wd,pattr,lmax,l,'=');
			if (wd && (lmax != 0)) *wd = '\0';
			pos++;
		}
		*ppos = pos + 1;
	/*	return(l+1);	*/
		return l;
	}
#endif
	if (opt & 0x08) opt5 = opt2 = 0;
/*
 !((ch=='\n') || (opt1 && ch=='#') || (opt2 && (ch=='='||ch==':')))
==>
 (!(ch=='\n') && !(opt1 && ch=='#') && !(opt2 && (ch=='='||ch==':')))
==>
 ((ch!='\n') && (!opt1 || ch!='#') && (!opt2 || !(ch='='||ch==':')))
*/
	while(((ch=*p)!='\n')&&(ch!=' ')&&(ch!='\t')&&(ch!='\0')&&(ch!='\r')&&
#if 1	/* add 2000.1.12 Koba */
#if 0	/* 2001.3.19 Koba */
	      (!opt1 || ch!='#') && (!opt2 || ch!='=') && (!opt3 || ch!=',') &&
#else
	      !((opt1 && ch=='#')||(opt2 && ch=='=')||(opt5 && ch==':')||
	        (opt3 && ch==',')) &&
#endif
#endif
	      (ch!='"') && (ch!='\''))
	{
		*pattr = 1;
	/*
		if (ch=='\\') {
			cw = *(p+1);
			if (cw!='\n' && cw!='\0') {
				p++;
				pos++;
				ch=cw;
			}
		}
	*/
		l = _wdmax_check(&wd,pattr,lmax,l,ch);
		p++;
		pos++;
	}
	if (wd && (lmax != 0)) *wd = '\0';
	*ppos = pos;
	return(l);
}

/************************************************/
/*												*/
/************************************************/
int akxtgetw3(p, ppos, wd, lmax, pattr, opt)
char *p, *wd;
int	*ppos;
uchar *pattr;
int	lmax, opt;
{
	SSPL_S sspl;
	int ret;

/*	if (lmax <= 0) return -2;	*/
	sspl.sp = *ppos;
	sspl.wd = wd;
	sspl.wdmax = lmax;
	ret =  akxtgetwspl(p, &sspl, opt);
	memcpy(pattr,sspl.attr,4);
	*ppos  = sspl.sp;
	return ret;
}

/************************************************/
/*												*/
/************************************************/
int akxtgetw2(p, ppos, wd, lmax)
char	*p, *wd;
int	*ppos;
int	lmax;
{
	uchar attr[4];

	if (lmax <= 0) return -2;
	return akxtgetw3(p, ppos, wd, lmax, attr, 0);
}

/************************************************/
/*												*/
/************************************************/
int akxtgetw(p, ppos, wd, lmax)
char	*p, *wd;
int	*ppos;
int	lmax;
{
	int l;

	l = akxtgetw2(p, ppos, wd, lmax);
	if (l < 0) l = 0;
	return l;
}

/************************************************/
/*												*/
/************************************************/
int akxtgetargv2(buf,argv,maxargcs,parm,len,opt)
char *buf,**argv,*parm;
int  maxargcs,len, opt;
{
	char *wd;
	int   argc=0,lw,pos,opt1,opt2,opt3,opt7,opt8,skip,maxargc;
	uchar attr[4], battr=',';

	maxargc = maxargcs;
#if 0	/* 2002.3.7 CSK Koba */
	if (maxargc<0 || len<0) return -2;
	else if (!maxargc) return 0;
	else if (len <= 1 || !buf || !argv || !parm) return -1;
#else
	if (maxargc < 0) maxargc = -maxargc;
	if (len<0) return -2;
	else if (!maxargc) return 0;
	else if (len <= 1 || !buf || !parm) return -1;
#endif
	opt1 = opt & 0x01;	/* # */
	opt2 = opt & 0x12;	/* = */
	opt3 = opt & 0x04;	/* , */
	opt7 = opt & 0x40;	/*  */
	opt8 = opt & 0x80;	/* ,=, */
	pos = 0;
	wd = parm;
#if 0
	while ((lw = akxtgetw2(buf,&pos,wd,len)) >= 0) {
		argc++;
		*argv++ = wd;
		len -= ++lw;
		if (len <= 0) break;
		wd += lw;
		if (argc>=maxargc) break;
	}
	if (lw == -2) argc = lw;
#else
#if 0	/* 2002.3.7 CSK Koba */
	while (maxargc) {
#else
	for (;;) {
		if (argv && maxargcs>0 && maxargc<=0) break;
#endif
		lw = akxtgetw3(buf,&pos,wd,len,attr,opt);
/*
printf("akxtgetargv2:pos=%d lw=%d wd=%s argc=%d attr=%02x\n",pos,lw,wd,argc,attr[0]);
*/
/* 2000.9.8 Koba
		if (opt1 && attr[0] == '#') break;
*/
#if 0	/* 2001.3.21 Koba */
		if (opt1 && attr[0] == '#') {
				*wd = '\0';
				lw = -1;
				pos--;
		}
#else
		if (lw == -1 || (opt1 && attr[0] == '#')) {
			*wd = '\0';
			if (argv) {
				while (maxargc-- > 0) {
					*argv++ = wd;
/*
printf("akxtgetargv2:maxargc=%d\n",maxargc);
*/
				}
			}
			break;
		}
#endif
		if (attr[1]) return -10;
		skip = 0;
		if (opt3) {
			if (attr[0] == ',') {
				if (opt2 && !opt8) {
					opt &= ~opt2;
					opt2 = 0;
				}
				if (battr == ',') {
					lw = 0;
					*wd = '\0';
				}
				else {
					skip = 1;
				}
			}
			battr = attr[0];
		}
	/*
		if (argc == 1) {
			opt &= ~opt2;
			if (opt2 && attr[0] == '=') skip = 1;
		}
	*/
		if (!skip) {
#if 0	/* 2001.3.21 Koba */
			if (opt2 && argc == 1 && attr[0]==1 && (*wd=='=' || *wd==':')) {
				lw--;
				if (lw == 0) {
					opt2 = 0;
					continue;
				}
				strcpy(wd,wd+1);
			}
#else
			if (opt2) {
				if (argc==0 && !opt7 && (attr[0]=='=' || attr[0]==':')) {
					*wd = '\0';
					lw = 0;
				}
				else if (argc == 1) {
					opt &= ~opt2;
					opt2 = 0;
					if ((attr[0]=='=' || attr[0]==':')) {
						continue;
					}
				}
			}
#endif
			if (argv && maxargc>0) {
				*argv++ = wd;
				maxargc--;
			}
			if (lw >= 0) {
				argc++;
				len -= ++lw;
				if ((len<=0 && !argv) || (len<=0 && maxargc>0)) {
					return -10;
				/*	break;	*/
				}
				wd += lw;
			}
#if 0	/* 2001.3.21 Koba */
			if (opt2) opt &= ~opt2;
#else
			if (opt2) opt |= 0x08;	/* Q[hڂA=,:,:=Ŏn܂ȂƂ
			                    [h̓r=,:,:=ŋ؂Ȃ悤ɂ*/
#endif
		}
	}
#endif
	return argc;
}

/************************************************/
/*												*/
/************************************************/
int akxtgetargv(buf,argv,maxargc,parm,len)
char *buf,**argv,*parm;
int  maxargc,len;
{
	return akxtgetargv2(buf,argv,maxargc,parm,len,0);
}

/************************************************/
/*												*/
/************************************************/
int akxagetnapli(file,colm,name,argv,maxargc,parm,len)
char *file,*name,**argv,*parm;
int  colm,maxargc,len;
{
	return akxagetnaplix(file,colm,name,argv,maxargc,parm,len,3);
}

/************************************************/
/*												*/
/************************************************/
int akxagetnaplix(file,colm,name,argv,maxargc,parm,len,opt)
char *file,*name,**argv,*parm;
int  colm,maxargc,len,opt;
{
	FILE *fp;
	char buf[LOCAL_RECORD_BUFSIZE];
	int n,colm1;

	if (colm<=0 || colm>maxargc)
		return (-1);
	if (colm==1) return akxagetnaplx(file,name,argv,maxargc,parm,len,opt);
	colm1 = colm - 1;
	if ((fp = fopen(file,"r"))==NULL) {
/*
printf("akxagetnapli: %s open error!\n",file);
*/
		return (-1);
	}
	while (akxa_read_line(buf,sizeof(buf),fp)) {
		if (*buf == '#')
			continue;
#if 0	/* 2000.12.8 Koba */
		if ((n = akxtgetargv2(buf,argv,maxargc,parm,len,opt))>=colm) {
			if (!strcmp(name,argv[colm1])) {
#else
		if ((n=akxtgetargv2(buf,argv,colm,parm,len,opt))>=colm) {
			if (!strcmp(name,argv[colm1])) {
				n = akxtgetargv2(buf,argv,maxargc,parm,len,opt);
#endif
				fclose (fp);
				return (n);
			}
		}
		else if (n < 0) return n;
	}
	fclose (fp);
	return 0;
}

/************************************************/
/*												*/
/************************************************/
int akxagetnapl(file,name,argv,maxargc,parm,len)
char *file,*name,**argv,*parm;
int  maxargc,len;
{
	return akxagetnaplx(file,name,argv,maxargc,parm,len,3);
}

/************************************************/
/*												*/
/************************************************/
int akxagetnaplx(file,name,argv,maxargc,parm,len,opt)
char *file,*name,**argv,*parm;
int  maxargc,len,opt;
{
	FILE *fp;
	char buf[LOCAL_RECORD_BUFSIZE],*wd;
	int argc=0,lw,pos,i;
	uchar attr[4];

	if (maxargc<0 || len<0) return -2;
	else if (maxargc==0) return 0;
	else if (!argv || !parm || len<1) return -1;

	if ((fp = fopen(file,"r"))==NULL) {
/*
		printf("akxagetnaplx: %s open error! errno=%d\n",file,errno);
*/
		return -1;
	}
	while (akxa_read_line(buf,sizeof(buf),fp)) {
		argc = 0;
		if (*buf == '#')
			continue;
		pos = 0;
		wd = parm;
		lw = akxtgetw3(buf, &pos, wd, len, attr, opt);
/*
printf("1:pos = %d lw = %d wd = %s attr = %d\n",pos,lw,wd,attr[0]);
*/
		if (attr[0] == '#') continue;
		if (attr[1]) {
			fclose (fp);
			return -10;
		}
		if (strcmp(name,wd)) continue;
#if 1	/* 1996.1.25 Koba */
		argc = akxtgetargv2(buf,argv,maxargc,parm,len,opt);
#else
		do {
/*
printf("1:pos = %d lw = %d wd = %s argc = %d\n",pos,lw,wd,argc);
*/
			argc++;
			*argv++ = wd;
			wd += ++lw;
			len -= lw;
			if (argc>=maxargc)
				break;
		}
		while (	lw = akxtgetw (buf,&pos,wd,len));
#endif
		break;
	}
	fclose (fp);
	if (!argc) {
		*parm = '\0';
		for (i=0;i<maxargc;i++) {
			argv[i] = parm;
		}
	}
	return argc;
}

/************************************************/
/*												*/
/************************************************/
int akxa_gsnapl(file,block,name,argv,maxargc,parm,len)
char *file,*block,*name,**argv,*parm;
int  maxargc,len;
{
	return akxa_gsnapli(file,block,1,name,argv,maxargc,parm,len);
}

/************************************************/
/*												*/
/************************************************/
int akxa_gsnapli(file,block,colm,name,argv,maxargc,parm,len)
char *file,*block,*name,**argv,*parm;
int  maxargc,len,colm;
{
	return akxa_gsnaplix(file,block,colm,name,argv,maxargc,parm,len,3);
}

/************************************************/
/*												*/
/************************************************/
int akxa_gsnaplix(file,block,colm,name,argv,maxargc,parm,len,opt)
char *file,*block,*name,**argv,*parm;
int  maxargc,len,colm,opt;
{
	FILE *fp;
	char buf[LOCAL_RECORD_BUFSIZE],c,*wd;
	int argc=0,lw,pos;
	uchar attr[4];
	int n,match,colm1,i,ret[2];

	if (colm<=0 || colm>maxargc) return (-1);
	if (!block || !*block)
		return akxagetnaplix(file,colm,name,argv,maxargc,parm,len,opt);

	colm1 = colm - 1;

	if (maxargc<0 || len<0) return -2;
	else if (maxargc==0) return 0;
	else if (!name || !*name || !argv || !parm || len<1) return -1;

#if 1	/* 2003.4.21 */
	argc = 0;
	if (!(fp = akxa_gsfopen(file,block,NULL,0,NULL,0,opt,ret))) {
		if (ret[0] == 100) goto LB1;
		return -1;
	}
/*
printf("akxa_gsnaplix: name = [%s]\n",name);
*/
#else
	if (!(fp = fopen(file,"r"))) {
/*
printf("akxa_gsnaplix: %s open error!\n",file);
*/
		return -1;
	}
	argc = match = 0;
	while (akxa_read_line(buf,sizeof(buf),fp)) {
		if ((c=*buf) == '#') continue;
		else if (c == '[') {
			pos = 1;
			wd = parm;
			lw = akxtgetw(buf, &pos, wd, len);
/*
printf("akxa_gsnaplix.block:pos = %d lw = %d wd = %s\n",pos,lw,wd);
*/
			lw--;
			if (lw>=0 && wd[lw]==']') {
				wd[lw]='\0';
				pos--;
			}
			if (match=!strcmp(block,wd)) break;
		}
	}
	if (!match) {
/*
printf("akxa_gsnaplix.block:not match\n");
*/
		goto LB0;
	}
	wd = buf + pos;
	for (;;) {
		while ((c=*wd) && c!=']') wd++;
		if (c) break;
		for (;;) {
			if (!akxa_read_line(buf,sizeof(buf),fp)) {
				goto LB0;
			}
			if ((c=*buf) != '#' && c) break;
		}
		wd = buf;
	}
#endif
	while (akxa_read_line(buf,sizeof(buf),fp)) {
		if ((c=*buf) == '#' || !c || c == '\n') continue;
		else if (c == '[') break;

#ifndef OLD_GSNAPL
#if 0	/* 2000.12.12 */
		if ((n = akxtgetargv2(buf,argv,maxargc,parm,len,opt))>=colm) {
			if (!strcmp(name,argv[colm1])) {
#else
		if ((n=akxtgetargv2(buf,argv,colm,parm,len,opt))>=colm) {
			if (!strcmp(name,argv[colm1])) {
				n = akxtgetargv2(buf,argv,maxargc,parm,len,opt);
#endif
				fclose(fp);
				return n;
			}
		}
		else if (n < 0) {
			fclose(fp);
			return n;
		}
#else
		pos = 0;
		wd = parm;
		lw = akxtgetw3(buf, &pos, wd, len, attr, opt);
/*
printf("akxa_gsnaplix.name:pos=%d lw=%d wd=%s attr=%d\n",pos,lw,wd,attr[0]);
*/
		if (attr[0] == '#') continue;
		if (!strcmp(name,wd)) {
			argc = akxtgetargv2(buf,argv,maxargc,parm,len,opt);
			break;
		}
#endif
/*
if (n <= 0) printf("n=%d\n",n);
*/
	}
 LB0:
	fclose (fp);
 LB1:
/*
if (argc <= 0) printf("n=%d\n",argc);
*/
	if (!argc) {
		*parm = '\0';
		for (i=0;i<maxargc;i++) {
			argv[i] = parm;
		}
	}
	return argc;
}

/************************************************/
/*												*/
/************************************************/
int akxa_fwgetc(buf,max,fp,pos,sap)
char *buf;
int pos,max,sap;
FILE *fp;
{
	int i,c,len;
	char *s,*d;
/*
printf("max=%d pos=%d sap=%d\n",max,pos,sap);
*/
	if (!buf || !fp) return -1;
	if (max<=0 || pos<0 || sap<0 /* || pos>max */) return -2;

	d = buf;
	if (sap > 0) {
		if ((pos -= sap) < 0) return -3;
		else if (pos > 0) {
			s = buf + sap;
			for (i=0;i<pos;i++) *d++ = *s++;
		}
	}
	else d += pos;

	for (i=pos;i<max;i++) {
		c = getc(fp);
		if (c == EOF) break;
		*d++ = c;
/*
printf("c=%08x\n",c);
*/
	}
	return i;
}

/************************************************/
/*												*/
/************************************************/
int akxtget2vsep(buf,argv,parm,parmlen,sep,opt)
char *buf,**argv,*parm,sep;
int  parmlen, opt;
{
	char *p,sepa[2];
	int  len,ret;
	
	if (!argv) return -1;
	if (!parm || parmlen<=0) {
		if (!(p = buf)) return -1;
	}
	else {
		if (!(p = parm)) return -1;
		if (buf) {
			len = strlen(buf);
			if (len >= parmlen) return -2;
			memcpy(parm,buf,len+1);
		}
	}
	sepa[0] = sep;
	sepa[1] = '\0';
	ret = akxtgetnvsep(p,argv,2,sepa,opt|0x02);
/*
printf("akxtget2vsep: buf=[%s] argv0=[%s] argv1=[%s]\n",buf,argv[0],argv[1]);
*/
	return ret;
}

/************************************************/
/*												*/
/************************************************/
int akxtgetnvsep(buf,argv,maxargc,sep,opt)
char *buf,**argv,*sep;
int  maxargc, opt;
{
	char *p,c;
	int  i,len,argc,buf_len,opt2;
	
	if (!buf || (maxargc>0 && !argv) || !sep) return -1;
	if ((len = strlen(sep)) <= 0) return -2;
	opt2 = opt & 0x02;
	p = buf;
	argc = 0;
	if (argc < maxargc) argv[argc] = p;
	if (opt & 0x01) {
		buf_len = strlen(buf);
		p = buf + buf_len - 1;
		while (buf_len-- > 0) {
			c = *p;
			if (memchr(sep,c,len)) {
				*p = '\0';
				argc++;
				if (argc < maxargc) argv[argc] = p + 1;
				if (opt2 && argc+1>=maxargc) break;
			}
			p--;
		}
		p = buf + buf_len;
	}
	else {
		while (c = *p) {
			if (memchr(sep,c,len)) {
				*p = '\0';
				argc++;
				if (argc < maxargc) argv[argc] = p + 1;
				if (opt2 && argc+1>=maxargc) break;
			}
			p++;
		}
	}
	for (i=argc+1;i<maxargc;i++) argv[i] = p;

	return argc;
}

/************************************************/
/*												*/
/************************************************/
int akxtgetvseps(string,argv,seps,opt)
char *string,*argv[],*seps;
int opt;
{
	char *p;
	int ret=0,ret2;

	if (!string || !argv || !seps) return -1;
	if (*(p=seps+1)) {
		if ((ret=akxtgetvseps(string,argv+1,p,opt)) < 0) return ret;
	}
	if ((ret2=akxtget2vsep(string,argv,NULL,0,*seps,opt)) < 0) return ret2;
	return ret2 + ret;
}

/************************************************/
/*												*/
/************************************************/
typedef struct tdtSect {
	char *section;
	int  pos;
	struct tdtSect *nextSect;
} tdtSect;

typedef struct tdtFopenCache {
	char *file;
	tdtSect *nextSect;
	struct tdtFopenCache *nextFile;
} tdtFopenCache;

static tdtFopenCache *gtpFopenCache=NULL;

static int _fopen_cache(cmnd,file,section,pret)
char cmnd,*file,*section;
int  pret[];
{
	tdtFopenCache *nF,*nFu,*nFp;
	tdtSect *nS,*nSu,*nSp,*nSpu;

	nF = gtpFopenCache;
	switch (cmnd) {
	case 'i':
		pret[0] = 0;
/*
printf("_fopen_cache:i: called\n");
*/
		while (nF) {
			if (!strcmp(nF->file,file)) {
				nS = nF->ha_nextSect;
				while (nS) {
					nS->section[0] = '\0';
					nS = nS->ha_nextSect;
				}
				break;
			}
			nF = nF->ha_nextFile;
		}
		break;
	case 'r':
		pret[0] = 0;
/*
printf("_fopen_cache:r: file=[%s] section=[%s]\n",file,section);
*/
		nFp = NULL;
		nSp = NULL;
		while (nF) {
			if (!strcmp(nF->file,file)) {
				nS = nF->ha_nextSect;
				while (nS) {
					if (!strcmp(nS->section,section)) {
						pret[0] = nS->pos;
/*
printf("_fopen_cache:r: found pos=%d\n",nS->pos);
*/
						goto L_found;
					}
					nSp = nS;
					nS = nS->ha_nextSect;
				}
			}
			nFp = nF;
			nF = nF->ha_nextFile;
		}
		break;
	case 's':
/*
printf("_fopen_cache:s: file=[%s] section=[%s] pos=%d\n",file,section,pret[0]);
*/
		nFp = nFu = NULL;
		nSp = NULL;
		while (nF) {
			if (*nF->file) {
				if (!strcmp(nF->file,file)) break;
			}
			else nFu = nF;
			nFp = nF;
			nF = nF->ha_nextFile;
		}
		if (nF) {	/* t@Co^ς*/
/*
printf("_fopen_cache:s: found file\n");
*/
			nS = nF->ha_nextSect;
			nSpu = nSp = nSu = NULL;
			while (nS) {
				if (*nS->section) {
					if (!strcmp(nS->section,section)) break;
				}
				else {
					nSu = nS;
					nSpu = nSp;
				}
				nSp = nS;
				nS = nS->ha_nextSect;
			}
			if (nS) {	/* Sectiono^ς*/
/*
printf("_fopen_cache:s: found section\n");
*/
				nS->pos = pret[0];
			}
			else if (nSu) {	/* 󂫂*/
/*
printf("_fopen_cache:s: found unused section entry\n");
*/
				if (nSu->section) Free(nSu->section);
				nSu->section  = Strdup(section);
				nSu->pos      = pret[0];
				nS = nSu;
				nSp = nSpu;
			}
			else {	/* 󂫂Ȃ*/
/*
printf("_fopen_cache:s: no entry section\n");
*/
				if (!(nS=(tdtSect *)Malloc(sizeof(tdtSect)))) return -1;
				nS->section  = Strdup(section);
				nS->pos      = pret[0];
				nS->ha_nextSect = NULL;
				if (nSp) nSp->ha_nextSect = nS;
				else nF->ha_nextSect = nS;
			}
			goto L_found;
		}
		else if (nFu) {	/* 󂫂*/
/*
printf("_fopen_cache:s: found unused file entry\n");
*/
			if (nFu->file) Free(nFu->file);
			nFu->file     = Strdup(file);
			return _fopen_cache(cmnd,file,section,pret);
		}
		else {	/* 󂫂Ȃ*/
/*
printf("_fopen_cache:s: no entry file\n");
*/
			if (!(nF=(tdtFopenCache *)Malloc(sizeof(tdtFopenCache)))) return -1;
			nF->file     = Strdup(file);
			nF->ha_nextSect = NULL;
			nF->ha_nextFile = NULL;
			if (nFp) nFp->ha_nextFile = nF;
			else gtpFopenCache = nF;
			return _fopen_cache(cmnd,file,section,pret);
		}
		break;
	default:
		return -1;
	}
	return 0;

 L_found:
	if (nSp && (nF->ha_nextSect != nS)) {
/*
printf("_fopen_cache: nS to top\n");
*/
		nF->ha_nextSect = nS;
		nSp->ha_nextSect = nS->ha_nextSect;
		nS->ha_nextSect = nSp;
	}
	if (nFp) {
/*
printf("_fopen_cache: nF to top\n");
*/
		gtpFopenCache = nF;
		nFp->ha_nextFile = nF->ha_nextFile;
		nF->ha_nextFile = nFp;
	}
	return 1;
}

FILE *akxa_gsfopen(file,section,argv,maxargc,parm,len,opt,pret)
char *file,*section,**argv,*parm;
int  maxargc,len,opt,pret[];
{
	FILE *fp;
	char buf[LOCAL_RECORD_BUFSIZE],c,*wd,work[LOCAL_RECORD_BUFSIZE];
	int argc=0,lw,pos,l,opt1,seek_pos,ret[2],found,opt2;
	uchar attr[4];
	int n,match,i,sectlen,iend,iRc;


	if (pret) {
		pret[0] = pret[1] = 0;
	}
	if (!file || !*file || !section || !*section || !pret) {
		if (pret) pret[0] = -1;
		return NULL;
	}
	sectlen = strlen(section);
	
	if (maxargc<=0 || len<1 || !argv || !parm) maxargc = 0;

	if (!(fp = fopen(file,"r"))) {
/*
printf("akxa_gsfopen: %s open error!\n",file);
*/
		pret[0] = -2;
		return NULL;
	}

	opt2 = !(opt & AKX_GSFOPEN_NO_CACHE);
	seek_pos = found = 0;
	if (opt2) {
		if (opt & AKX_GSFOPEN_CACHE_INVALID) _fopen_cache('i',file,0,ret);
		else {
			if ((found=_fopen_cache('r',file,section,ret)) > 0) {
				seek_pos = ret[0];
				fseek(fp,seek_pos,SEEK_SET);
			}
		}
	}

	argc = match = iend = 0;
	while (l=akxa_read_line(buf,sizeof(buf),fp)) {
		if ((c=*buf) == '[') {
			wd = buf + 1;
			if (l>sectlen && !memcmp(section,wd,sectlen)) {
				if ((c = *(wd+sectlen))==']' || c==' ' || c=='\n') {
					match = 1;
					pos = 1;
/*
{char w;w=*(wd+sectlen+1);
*(wd+sectlen+1)='\0';
printf("akxa_gsfopen.cmp: buf = [%s] seek_pos = %d\n",buf,seek_pos);
*(wd+sectlen+1)=w;
}
*/
					if (c == ']') {
						if (opt2 && found <= 0) {
							ret[0] = seek_pos;
							_fopen_cache('s',file,section,ret);
						}
						return fp;
					}
					break;
				}
			}
		}
		seek_pos += l;
	}
	if (!match) {
/*
printf("akxa_gsfopen.section:not match\n");
*/
		iRc = 100;
		goto LB0;
	}

	if (opt2 && found <= 0) {
		ret[0] = seek_pos;
		_fopen_cache('s',file,section,ret);
	}

	opt1 = opt & 0x01;	/* # */
	for (;;) {
		wd = buf + pos;
		while ((lw=akxtgetw3(buf,&pos,work,sizeof(work),attr,opt)) >= 0) {
/*
printf("akxa_gsfopen:pos=%d lw=%d work=%s attr=%02x\n",pos,lw,work,attr[0]);
*/
			lw--;
			if (lw>=0 && attr[0]==1 && work[lw]==']') {
				*(buf+pos-1)='\0';
				iend = 1;
				break;
			}
			if (opt1 && attr[0] == '#') {
				break;
			}
		}
		if (maxargc>0 && len>1) {
			n = akxtgetargv2(wd,argv,maxargc,parm,len,opt);
/*
printf("akxa_gsfopen.getargv2: wd = [%s] n = %d\n",wd,n);
*/
			if (n < 0) maxargc = 0;
			else if (n > 0) {
				argc += n;
				argv += n;
				maxargc -= n;
				for (i=0;i<n;i++) {
					lw = strlen(parm) + 1;
					parm += lw;
					len  -= lw;
				}
/*
printf("akxa_gsfopen.getargv2: argc = %d maxargc = %d len = %d\n",
argc,maxargc,len);
*/
			}
		}
		if (iend) break;
		for (;;) {
			if (!(l=akxa_read_line(buf,sizeof(buf),fp))) {
				iRc = -3;
				goto LB0;
			}
			if ((c=*buf) != '#' && c) break;
		}
		if (*buf == '[') {
			iRc = -4;
			goto LB0;
		}
		pos = 0;
	}
	pret[1] = argc;
	return fp;
 LB0:
	pret[0] = iRc;
	pret[1] = argc;
	fclose (fp);
	return NULL;
}

#if 0
/************************************************/
/*												*/
/************************************************/
#define AKX_FILE_BLOCK_ENTRY_MAX	10
#define AKX_SECT_BLOCK_ENTRY_MAX	10

typedef struct tdtSectBlock {
	int usednum;
	struct {
		char *section;
		int  pos;
	} m[AKX_SECT_BLOCK_ENTRY_MAX];
} tdtSectBlock;

typedef struct tdtFileBlock {
	int usednum;
	struct {
		char *file;
		tdtSectBlock *pSectBlock;
	} m[AKX_FILE_BLOCK_ENTRY_MAX];
} tdtFileBlock;

static tdtFileBlock *tpFileBlock=NULL;

static _fopen_cache(cmnd,file,section,pret)
char cmnd,*file,*section;
int  pret[];
{
	tdtFileBlock *nFB;
	tdtSectBlock *nSB;
	int i,k,aki,len,akk;
	char *pf,*ps;

	nFB = tpFileBlock;
	switch (cmnd) {
	case 'i':
		pret[0] = 0;
		if (nFB) {
/*
printf("_fopen_cache:i: file=[%s] usednum=%d\n",file,nFB->usednum);
*/
			for (i=0;i<nFB->usednum;i++) {
				if (!strcmp((pf=nFB->m[i].file),file)) {
/*
printf("_fopen_cache:i: found i = %d\n",i);
*/
					if (nSB=nFB->m[i].pSectBlock) {
						for (k=0;k<nSB->usednum;k++) {
							nSB->m[k].section[0] = '\0';
						}
					}
					*pf = '\0';
					break;
				}
			}
		}
		break;
	case 'r':
		pret[0] = 0;
/*
printf("_fopen_cache:r: file=[%s] section=[%s]\n",file,section);
*/
		if (nFB) {
			for (i=0;i<nFB->usednum;i++) {
				if (!strcmp(nFB->m[i].file,file)) {
					if (nSB=nFB->m[i].pSectBlock) {
						for (k=0;k<nSB->usednum;k++) {
							if (!strcmp(nSB->m[k].section,section)) {
								pret[0] = nSB->m[k].pos;
/*
printf("_fopen_cache:r: found i=%d k=%d pos=%d\n",i,k,pret[0]);
*/
								return 1;
							}
						}
					}
					break;
				}
			}
		}
		break;
	case 's':
/*
printf("_fopen_cache:s: file=[%s] section=[%s] pos=%d\n",file,section,pret[0]);
*/
		if (nFB) {
			aki = -1;
			for (i=0;i<nFB->usednum;i++) {
				if (!*(pf=nFB->m[i].file)) aki = i;
				else if (!strcmp(pf,file)) { /* fileo^ς*/
/*
printf("_fopen_cache:s: found file i = %d\n",i);
*/
					if (nSB=nFB->m[i].pSectBlock) {
						akk = -1;
						for (k=0;k<nSB->usednum;k++) {
							if (!*(ps=nSB->m[k].section)) akk = k;
							else if (!strcmp(ps,section)) {
/*
printf("_fopen_cache:s: found section k = %d\n",k);
*/
								nSB->m[k].pos = pret[0];
								return 0;
							}
						}
						if (akk<0 && nSB->usednum<AKX_SECT_BLOCK_ENTRY_MAX)
							akk = nSB->usednum;
						if (akk >= 0) {	/* section 󂫂*/
/*
printf("_fopen_cache:s: found unused section entry = %d\n",akk);
*/
							if (nSB->m[akk].section) Free(nSB->m[akk].section);
							if (!(nSB->m[akk].section=Strdup(section)))
								return -1;
							nSB->m[akk].pos = pret[0];
							nSB->usednum++;
						}
						else {	/* section 󂫂Ȃ*/
/*
printf("_fopen_cache:s: no entry section\n");
*/
							;
						}
					}
					else {
/*
printf("_fopen_cache:s: no section block\n");
*/
						if (!(nSB=(tdtSectBlock *)Malloc(sizeof(tdtSectBlock))))
							return -1;
						nFB->m[i].pSectBlock = nSB;
						memset(nSB,0,sizeof(tdtSectBlock));
						return _fopen_cache(cmnd,file,section,pret);
					}
					return 0;
				}
			}
			if (aki<0 && nFB->usednum<AKX_FILE_BLOCK_ENTRY_MAX)
				aki = nFB->usednum;
			if (aki >= 0) {	/* file 󂫂*/
/*
printf("_fopen_cache:s: found unused file entry = %d\n",aki);
*/
				if (nFB->m[aki].file) Free(nFB->m[aki].file);
				if (!(nFB->m[aki].file=Strdup(file))) return -1;
				nFB->usednum++;
				return _fopen_cache(cmnd,file,section,pret);
			}
			else {	/* file 󂫂Ȃ*/
/*
printf("_fopen_cache:s: no entry file\n");
*/
				;
			}
		}
		else {	/* fileǗubNȂ*/
/*
printf("_fopen_cache:s: no file block\n");
*/
			if (!(nFB=(tdtFileBlock *)Malloc(sizeof(tdtFileBlock))))
				return -1;
			tpFileBlock = nFB;
			memset(nFB,0,sizeof(tdtFileBlock));
			return _fopen_cache(cmnd,file,section,pret);
		}
		break;
	default:
		return -1;
	}
	return 0;
}
#endif
