static  char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/* MMISC                                    */
/*(Man Machine Interface for execute SCript)*/
/*                                          */
/********************************************/
/*
 *	script test program
 *
 *		updated by A.Kobayashi 92/2/13
 *		updated by A.Kobayashi 92/4/15
 *		updated by A.Kobayashi 92/6/25
 *		updated by A.Kobayashi 92/7/2
 *		updated by A.Kobayashi 94/9/6
 *		updated by A.Kobayashi 97/5/27
 *		updated by A.Kobayashi 98/3/3
 *		updated by A.Kobayashi 98/8/11   V2.2
 *		updated by A.Kobayashi 2001/9/18   V3.0
 *		updated by A.Kobayashi 2003/3/12   V3.1
 *		updated by A.Kobayashi 2004/08/04   V3.2
 */
#include "cpacommon.h"
#include "cpmmi.h"

#define CMND_BASE		65536
#define CMND_HELP		CMND_BASE+1
#define CMND_RUN		CMND_BASE+2
#define CMND_REGIST		CMND_BASE+3
#define CMND_DUMP		CMND_BASE+4
#define CMND_HISTORY	CMND_BASE+5
#define CMND_SET		CMND_BASE+6
#define CMND_RECV		CMND_BASE+7
#define CMND_TIME		CMND_BASE+8
#define CMND_TIMEOUT	CMND_BASE+9
#define CMND_END		CMND_BASE+10

#define		PSZ	char *

/*
typedef		unsigned char UCHAR	;
*/

/*	DEBUG	SWITCH	*/
#define	PRM_NTOH	1
#define	PRM_HTON	1
#define	DEBUG		0
#define	DBG			0
#define HOSTNAME	"ldhost"
#define TRMNNAME	"cpTrMain"
#define SERVICE		"Term_Port"
#define PORTNO		15018
#define S_PID		60002
#define D_PID		201
#define SAVEHISTORY	"mmisc.his"
#define PROGRAM		"MMISC V3.3"

int task;
int	Log_flg;
FILE *fp,*fp_log;

#define NSEP	11
#define NMTAB	24
char sep[NSEP]={' ','\t','\n',';',',','(','/','{','}','"','\''};
char name[128],w[128],ww[128];

#define  PKHEAD_LEN	32
#define  UCODE_SIZE	68

typedef struct {
	unsigned char pkh_verid;
	unsigned char pkh_mode;
	unsigned short pkh_cmd;
	long		pkh_dhost;
	long		pkh_dprid;
	long		pkh_dpkid;
	long		pkh_shost;
	long		pkh_sprid;
	long		pkh_spkid;
	long		pkh_pklen;
} PKHEAD_S;

struct CMHD_S {
	char ucode[UCODE_SIZE];
	long cmd;
	long nprm;
} cmhd,*cmhdp;

typedef struct DHEAD_S {
	UCHAR atr;
	UCHAR len;
	char llen[4];
} dhead_s;

typedef struct {
	UCHAR id;
	UCHAR um;
	UCHAR dum[2];
	long  len;
} pk_kan;

typedef struct {
	UCHAR id;
	UCHAR um;
	UCHAR dum[2];
	long  pos;
	long  len;
} dt_kan;

HEAD pkhead;
qRWQue qQue;

short wrks;
long  wrkl;

#define LINEMAX	512
#define MAXBUF	4096
#define HISTORY	24
char buf[MAXBUF];
char dat[MAXBUF];
char rmsg[20480];
char *line[HISTORY];
char crntline[LINEMAX];
int  history;
/*
extern   int   errno;
*/

HEAD	Head_w = { 0 };
HEAD	Head_r = { 0 };

long   Hid,dHid;
ushort sPid,dPid,rPid;
char   Uid[9];
int	   Fd = 0;
int    timeset[3];
int    giDataCode;
char *gcpProcName;

/* insert tsuru 1993.11.08 */
dhead_s			dHead;
USERTBL			userctl;

int Commandcount=1;
int Repeat=0;
int	RepeatSleep=0;
int Dumpflg=0;
int SaveHistoryFlg=1;
int iStack;
FILE *fpS,*fpStack[10];

long ldc_setdhs();
long ldc_getdhs();

struct timeval tval1,tval2;

char *cpHelp[]={
	"/start  process no : start process",
	"/shut   process no [-D] : shut  process",
	"/fshut  process no [-D] : fshut process",
/*	"/kill   process no [signal] : kill  process",
*/
	"/query [process no [on process no] | -l] : query process",
	"/regist [on process no] : query client process",
/*	"/trace procno mode [cmdno [sizemax [filemax [check point [file name]]]]] : change trace mode",
*/
	"/log   procno logno [flag [level [sizemax [filemax [check point [file name]]]]]] : change log mode",
	"/version [process no] : query version",
	"/statistics procno cmnd [parameter list] : statistics get/start s/end",
/*	"/password [-procno] password : input password for procno",
*/
	"/memory procno cmnd [parameter list] : memory get/start .../stop ...",
	"/dump : change mode to dump send and receive data",
	"/recv : receive data",
/*	"/time : change mode to display time",
*/
	"/timeout [read [write]] : change timeout(sec)",
	"/history : change mode to save history",
/*	"/set {dHid|dPid|dClass} value : set value to variable",
*/
	"{/run | < | @} filename : change input",
	"{/help | ?} [subcommand] : output this help",
	"~unix command : execute unix command",
	"!h : display history",
	"!! : send before data ",
	"!. : edit and send before data",
	"!number : edit and send history data",
	"// : cancel input",
	"; : exit or end of file",
	NULL
};

typedef struct {
	char *cmd;
	short osize;
	short parmno;
	int   cmdno;
} tdtcmdtbl;

tdtcmdtbl cmdtbl[]=
	{"/start"     ,4,1,CPF_CMD_START
	,"/shut"      ,4,1,CPF_CMD_SHUT
	,"/fshut"     ,4,1,CPF_CMD_FSHUT
/*	,"/kill"      ,4,2,CPF_CMD_KILL
*/
	,"/query"     ,4,2,CPF_CMD_QUERY
	,"/regist"    ,4,0,CMND_REGIST
/*	,"/trace"     ,4,6,CPF_CMD_TRACE
*/
	,"/log"       ,0,8,CPF_CMD_LOG
	,"/version"   ,4,0,CPF_CMD_VERSION
	,"/statistics",5,2,CPF_CMD_STATISTICS
/*	,"/password"  ,4,1,CPF_CMD_PASSWORD
*/
	,"/watch"     ,4,0,CPF_CMD_WATCH
	,"/memory"    ,4,1,CPF_CMD_MEMORY
	,"/dump"      ,4,0,CMND_DUMP
	,"/recv"      ,4,0,CMND_RECV
/*	,"/time"      ,4,0,CMND_TIME
*/
	,"/timeout"   ,0,2,CMND_TIMEOUT
	,"/history"   ,4,0,CMND_HISTORY
/*	,"/set"       ,0,2,CMND_SET
*/
	,"/run"       ,0,1,CMND_RUN
	,"/help"      ,4,1,CMND_HELP
/*	,"/end"       ,0,0,CMND_END
*/
	,NULL         ,0,0,0
	};

/********************************/
/*								*/
/********************************/
static char *_realloc(temp,l)
char *temp;
int l;
{
/*
printf("_realloc: temp=%08x l=%d\n",temp,l);
*/
	if (temp) temp = realloc(temp,l);
	else temp = malloc(l);
	return temp;
}

/********************************/
/*								*/
/********************************/
int subcmd_check(cmdtbl,s,len)
tdtcmdtbl *cmdtbl;
char *s;
int len;
{
	int i,osize;

	for (i=0;cmdtbl[i].cmd;i++) {
		osize = cmdtbl[i].osize;
		if ((osize>0 && len>=osize && strlen(cmdtbl[i].cmd)>=len &&
			 !memicmp(s,cmdtbl[i].cmd,len)) ||
		    !stricmp(s,cmdtbl[i].cmd)) {
			return i;
		}
	}
	return -1;
}

/********************************/
/*								*/
/********************************/
char *geterrmsg(err_no)
int err_no;
{
	return cpfStrError(err_no);
}

/********************************/
/*								*/
/********************************/
int get_msg(fd,pHead,pQue)
int fd;
HEAD *pHead;
qRWQue *pQue;
{
	int ret,msglen,len,msec;

	ret = sk_read(fd,(char *)pHead,sizeof(HEAD));
	if( ret != sizeof(HEAD) ) {
		if (ret == -2) {
			printf("[MMISC] read timeout\n");
		}
		else {
			printf("[MMISC] Read error ret=%d errno=%d %s\n",
			       ret,errno,strerror(errno));
		}
		Repeat = 0;
		return ret;
	}
	cpxeGetmSec(NULL,&tval2);
	msec = cpxeTimerSub(NULL,&tval2,&tval1);
	printf("\n*** receiv (%s) <%d msec> ***\n",cpfLogTime(),msec);

	log_fxdmp("read packet header",(PSZ)pHead,sizeof(HEAD));
	if (Dumpflg)
		cpxaxdump("receive packet head",(char *)pHead,ret);

	pQue->lRWLen=msglen=ntohl(pHead->len);
/*
printf("get_msg: msglen=%d\n",msglen);
*/
	if (msglen>0) {
		pQue->cpBuff = _realloc(pQue->cpBuff,msglen);
		if (!pQue->cpBuff) {
			printf("*** malloc/realloc error !!! ***\n");
			return -1;
		}
		len=sk_read(fd,pQue->cpBuff,msglen);
		if (len != msglen) {
			printf("read error len=%d\n",len);
			return -1;
		}
		log_fxdmp("read packet data",pQue->cpBuff,len);
	/*
		if (Dumpflg) cpxaxdump("receive packet data",pQue->cpBuff,len);
	*/
	}
	return msglen;
}

/********************************/
/*								*/
/********************************/
int sk_read( fd, buff, size )
int	fd;
char	*buff;
int	size;
{
	return cpfSkRead(fd, buff, size);
}

/********************************/
/*								*/
/********************************/
int main( argc, argv )
int	 argc;
char *argv[];
{
	char  server[256],*pretcod,service[32],myhost[256];
	int   ret,i,j,cmd,port_no,msec,msglen;
	int   aa,len;
	uchar p1[11];
	uchar p2[8];
/* insert tsuru 1993.11.08 */
	char  *p;
	short sCommand, sw;
	long lw;
	ushort s_class,s_pid;

	giDataCode = cpxtGetCodeType();

	cpfLogSetProcName(gcpProcName=cpxtGetLastName("\\/",argv[0]));
	iStack = 0;
	fpS = stdin;
/*
	printf("  MMISC V2.2\n  (c) Copyright CSK 1998\n");
*/
	printf("  %s\n  (c) Copyright CSK 2001\n",PROGRAM);

	/* 荞݃nh[̓o^ */
	signal(SIGALRM, cpfSockTimeOut);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, cpfBrokenPipe);
	siginterrupt(SIGPIPE, 1);
	timeset[0] =  60;	/* read */
	timeset[1] =   5;	/* write */
	timeset[2] =   5;	/* connect */
	cpfSetTimeOutSet(timeset,3);

	cpfLogFlg(0,1);	/* not output error_log */
	cpfLogFlg(1,1);	/* not output print_log */

	if (gethostname( myhost, sizeof(myhost) ) ) {
		perror("MMISC gethostname");
		exit(0);
	}
	/************************
	 * p[^̎荞 *
	 ************************/
	strcpy(server,myhost);

	if (argc > 1) {
		if (!strcmp(argv[1],"-h") || !strcmp(argv[1],"/h")) {
			printf("usage: %s [host name|.] [port no|.] [sPid|.] [Uid|.] [rcvPid]\n",argv[0]);
			exit(0);
		}
		else if (*argv[1]!='.')
			strcpy(server,argv[1]);
	}
	if (argc<=2 || (argc>2 && *argv[2] == '.')) {
		if (cpfgetcpfservname(TRMNNAME,service) <= 0) {
			printf("MMISC : use default service [%s]\n",SERVICE);
			strcpy(service,SERVICE);
		}
		if ((port_no = cpfGetPortNo(service)) <= 0) {
			port_no = PORTNO;
			printf("MMISC : getservbyname failed. use default(%d).\n",port_no);
		}
		sprintf(service,"%d",port_no);
	}
	else {
		strcpy(service,argv[2]);
		if ((port_no = cpfGetPortNo(service)) <= 0) {
			exit(1);
		}
	}
	printf( "MMISC : server = [%s], port no = %d\n",server,port_no);
 
	sPid = 0;
	if (argc>3 && *argv[3]!='.') {
		if (!cpxccvn(10,argv[3],strlen(argv[3]),&i)) {
			if (i >= 0 && i <= CPF_PID_MAX) sPid = i;
		}
	}
 
	if (argc<=4)
		strcpy(Uid,"legend");
	else
		strcpy(Uid,argv[4]);

	/************************
	 * T[oւ̐ڑ       *
	 ************************/
	Fd = cpfConnect(server,service,0,0);
	if (Fd <= 0) {
		if (Fd < 0) perror( "MMISC connect" );
		else printf("MMISC connect: timeout.\n");
		exit( 0 );
	}

	/************************
	 * T[oւ̓o^       *
	 ************************/
	sprintf(buf,"hostname:%s\nuser:%s\nprogram:%s\n",
	        myhost,getenv("USER"),PROGRAM);
	ret = cpaRegist2(Fd,sPid,buf,strlen(buf));
	if (ret) {
		printf("\n*** regist error=%d EXIT.\n",ret);
		goto End;
	}
	dHid = Hid = cpaGetPrHostId();
	if (!(sPid = cpaGetRegistPid())) sPid = S_PID;
	if ((rPid = cpaGetRegistDestPid()) > 3) dPid = rPid;
	else dPid = D_PID;
	printf( "MMISC : sPid = %d, dPid = %d\n",sPid,dPid);

/* insert tsuru 1993.11.08 */
	memcpy(&userctl.usr_code[8],"MMISC1",7);

#ifdef LOGOUT_ON
	Log_flg = 1;
#else
	Log_flg = 0;
#endif
	if (Log_flg) {
		fp_log = fopen("HSTLINE.DAT","w");
		if(fp_log == 0){
			printf("Log file open error!!\n");
		}
	}

	/****************************
	 * R}hEqXg̕ *
	 ****************************/
	for (i=0;i<HISTORY;i++) line[i] = NULL;
	fp = fopen(SAVEHISTORY,"r");
	if (fp) {
		for (i=0;i<HISTORY;i++) {
			if ((j=cpxaReadLineOpt(buf, LINEMAX, fp, 2)) < 0) break;
			line[i] = Strdup(buf);
		}
		history = i - 1;
		fclose(fp);
	}
	else history = HISTORY;

	/************************
	 * CE[v       *
	 ************************/
	memset(&qQue,0,sizeof(qRWQue));
	crntline[0] = '\0';
	for (;;) {
		cpfSetTimeOutSet(timeset,1);
		ret = send_cmd(Fd);
		if (ret < 0) break;
		else if (ret==0) continue;
ReRead:
		msglen = get_msg(Fd,&pkhead,&qQue);
		if (msglen == -2) continue;
		else if (msglen < 0) break;

		if (pkhead.sled_s) {	/* Command packet */
			if (pkhead.cpferr) {
				ret = ntohs(pkhead.cpferr);
				printf("\n*** command cpferror=%d %s\n",ret,geterrmsg(ret));
			}
			sCommand = ntohs(pkhead.command);
			if (sCommand == CPF_CMD_SHUT || sCommand == CPF_CMD_FSHUT ) {
				printf("\n*** SHUT/FSHUT command received.\n*** Exit.\n");
				if (sPid<=10000) {
					cpfExchgIndicate(&pkhead);
					cpaSetShutPacket(&pkhead);
					break;
				}
				goto End;
			}
			else {
				analyze_etc(&pkhead,&qQue);
				goto ReRead;
			}
		}
		else {	/* Reply packet */
			s_class = ntohs(pkhead.class_s);
			if (pkhead.pckno) {
				ret = (short)ntohs(pkhead.pckno);
				printf("\n*** reply  cpferror=%d %s\n",ret,geterrmsg(ret));
			}
			else {
				if (s_class==CPA_CLASS_SHUT || s_class==CPA_CLASS_FSHUT)
					goto End;
			}
			s_pid   = ntohs(pkhead.prs_s);
			dump_ret(pkhead.info & CPF_PFM_INDIRECT,
			         s_pid,s_class,qQue.cpBuff,msglen);

			if (pkhead.info)
				pretcod = buf+8+UCODE_SIZE+4;
			else
				pretcod = buf+UCODE_SIZE+4;
			memcpy(&lw, pretcod, sizeof(long));
			ret = ntohl(lw);
			memcpy(&lw, pretcod-4, sizeof(long));
			cmd = ntohl(lw);
		/*
			printf("Command Return Code = %d\n",ret);
		*/
			/* insert tsuru 1993.11.08 */
			if (ret == 0 && cmd == 0x00010001)
			{
				p = pretcod + 16;
				p += ldc_getdhs(p,&dHead,8,userctl.usr_code);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.men_nm),userctl.men_nm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.hnb_cd),userctl.hnb_cd);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.hnb_nm),userctl.hnb_nm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.hnb_rnm),userctl.hnb_rnm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.bsh_cd),userctl.bsh_cd);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.bsh_nm),userctl.bsh_nm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.bsh_rnm),userctl.bsh_rnm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.yku_cd),userctl.yku_cd);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.yku_nm),userctl.yku_nm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.yku_rnm),userctl.yku_rnm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.shk_cd),userctl.shk_cd);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.shk_nm),userctl.shk_nm);
				p += ldc_getdhs(p,&dHead,sizeof(userctl.shk_rnm),userctl.shk_rnm);

				memcpy(&userctl.usr_code[16],userctl.usr_id,sizeof(userctl.usr_id));
			    memcpy(&userctl.usr_code[32],userctl.usr_pass,sizeof(userctl.usr_pass));
			    memcpy(&userctl.usr_code[48],userctl.hnb_cd,sizeof(userctl.hnb_cd));
			    memcpy(&userctl.usr_code[52],userctl.bsh_cd,sizeof(userctl.bsh_cd));
			    memcpy(&userctl.usr_code[60],userctl.yku_cd,sizeof(userctl.yku_cd));
			    memcpy(&userctl.usr_code[64],userctl.shk_cd,sizeof(userctl.shk_cd));
			}
		}
	}
	cpaCancel(Fd,sPid);
End:
	shutdown(Fd,2);
	close(Fd);
	/****************************
	 * R}hEqXg̕ۑ *
	 ****************************/
	if (SaveHistoryFlg) {
		fp = fopen(SAVEHISTORY,"w");
		if (fp) {
			j = history;
			for (i=0;i<HISTORY;i++) {
				if (++j>=HISTORY) j=0;
				if (p=line[j]) {
					if (fprintf(fp,"%s\n",p)<0) break;
				}
			}
			fclose(fp);
		}
	}
	if (fp_log) fclose(fp_log);
	if (qQue.cpBuff) free(qQue.cpBuff);
}

/********************************/
/*								*/
/********************************/
int getline(line, prompt)
char   *line;
char   *prompt;
{
	char *p;
	int ch;

	printf("%s", prompt);
	for (;;) {
		p = line;
		while ((ch = getc(fpS)) != '\n' && ch != EOF) *p++ = ch;
		*p = '\0';
		if (ch==EOF && !*line) {
			if (iStack > 0) {
				fpS = fpStack[--iStack];
			}
			else return(EOF);
		}
		else break;
	}
	return (strlen(line));
}

/********************************/
/*								*/
/********************************/
hit_return()
{
	char	tbuf[32];

	getline(tbuf, "hit return : ");
}

/********************************/
/*								*/
/********************************/
int send_cmd(s)
int s;
{
	int ret,i,j,k,opt;
	int len, iCmd, iVal, argc, cmdno, parmno, osize, iVal2, direct;
	long ll,ld;
	char *p,*argv[10],parm[256],**ph,*subcmd,c;
	ushort usa[2],sw;
	ushort d_pid,d_class;

	while ((len = make_cmd())<0) printf(" data error ret=%d\n",len);
	if (len==0) return -1;
	Commandcount++;
	pkhead.ver     = 'C';
	pkhead.info    = 0x00	/* | CPFPFMCDTYPE(cpxtGetCodeType()) */;
	pkhead.command = htons(COMM_SEND);
	pkhead.host_d  = htonl(dHid);
	pkhead.class_d = htons(1);
	pkhead.prs_d   = htons(dPid);
	pkhead.sled_d  = 0;
	pkhead.cpfopt  = 0;
	pkhead.cpferr  = 0;
	pkhead.host_s  = htonl(Hid);
	pkhead.class_s = 0;
	pkhead.prs_s   = htons(sPid);
	pkhead.sled_s  = 1;
	pkhead.dispos  = 1;
	pkhead.pckno   = 1;
	pkhead.len     = 0;

	direct = cmdno = 0;
	if (dat[0]=='/') {
	/*	d_pid = 0;	*/
		d_class = 2;
	/*	usProcId = 0;	*/
		argc = cpxtgetargv2(dat,argv,10,parm,sizeof(parm),CPX_ARGV_TERM_IGE);
	/*	word  = argv[1];	*/
		d_pid = atoi(argv[3]);
		subcmd = "";
		len = strlen(argv[0]);
		i = subcmd_check(cmdtbl,argv[0],len);
		if (i >= 0) {
			subcmd = cmdtbl[i].cmd;
			cmdno  = cmdtbl[i].cmdno;
			parmno = cmdtbl[i].parmno;
		}
		else {
			printf("[MMISC] subcommand[%s] not found\n",argv[0]);
			return (0);
		}
/*
printf("subcmd=[%s] cmdno=%d\n",subcmd,cmdno);
*/
		wrks = cmdno;
		switch (cmdno) {
		case CPF_CMD_SHUT:
		case CPF_CMD_FSHUT:
		case CPF_CMD_VERSION:
			if (!stricmp("-D",argv[1])) {
				direct = 1;
			}
		case CPF_CMD_LOG:
			break;
		case CMND_RECV:
			cpfSetTimeOut(0); /* read */
			return 1;
		case CMND_DUMP:
			if (Dumpflg) {
				Dumpflg = 0;
				printf("[MMISC] dump mode off\n");
			}
			else {
				Dumpflg = 1;
				printf("[MMISC] dump mode on\n");
			}
			return 0;
		case CMND_HISTORY:
			if (SaveHistoryFlg) {
				SaveHistoryFlg = 0;
				printf("[MMISC] save history mode off\n");
			}
			else {
				SaveHistoryFlg = 1;
				printf("[MMISC] save history mode on\n");
			}
			return 0;
		case CMND_RUN:
			if (iStack > 9) {
				printf("[MMISC] stack over\n");
			}
			else {
				if (fp=fopen(argv[1],"r")) {
					fpStack[iStack++] = fpS;
					fpS = fp;
				}
				else {
					printf("[MMISC] file[%s] open error\n",argv[1]);
				}
			}
			return 0;
		case CMND_HELP:
/*
printf("argc=%d argv=[%s] [%s]\n",argc,argv[1],argv[2]);
*/
			ph = cpHelp;
			if (argc >= 2) {
				while (p = *ph++) {
					if ((c=*p) == '{') {
						len = strlen(p);
						for (k=1;k<len;k++) {
							if (p[k] == '}') break;
						}
					}
					for (j=1;j<argc;j++) {
						if (c == '{') {
							sprintf(buf,"%%%s%%",argv[j]);
/*
printf("k=%d buf=[%s]\n",k,buf);
*/
							if (!cpxsCaseLike(p,k,buf,strlen(buf))) break;
						}
						else {
							if (!memicmp(p,argv[j],strlen(argv[j]))) break;
						}
					}
					if (j < argc) printf("%s\n",p);
				}
			}
			else {
				while (p = *ph++) printf("%s\n",p);
			}
			return 0;
	/*
		default:
			printf("[MMISC] subcommand[%s] not found\n",argv[0]);
			return (0);
	*/
		}

		if (cmdno==CPF_CMD_SHUT || cmdno==CPF_CMD_FSHUT ||
		    cmdno==CPF_CMD_START ||
		    cmdno==CPF_CMD_VERSION || cmdno==CPF_CMD_QUERY) {
			p = buf+sizeof(HEAD);
			strcpy(p,subcmd+1);
			p += strlen(p);
			for (i=0;i<parmno;i++) {
				*p++ = ' ';
				strcpy(p,argv[i+1]);
				p += strlen(p);
			}
			strcpy(p,"\n");
			len = strlen(buf+sizeof(HEAD)) + 1;
			if (direct || rPid>3) {
				if (cmdno != CPF_CMD_QUERY) len = 0;
				d_class = CPA_CLASS_BASE - cmdno;
				d_pid = dPid;
			}
			else if (!d_pid) d_pid = 1;
		}
		else if (cmdno==CMND_REGIST) {
			p = buf+sizeof(HEAD);
			strcpy(p,"query\n");
			len = strlen(p) + 1;
			if (!d_pid) d_pid = 3;
			if (direct || rPid>3) {
				d_pid = dPid;
				d_class = CPA_CLASS_BASE - cmdno;
			}
		}
		else if (cmdno==CPF_CMD_LOG || cmdno==CPF_CMD_STATISTICS ||
		    cmdno==CPF_CMD_MEMORY) {
			p = buf+sizeof(HEAD);
			d_pid = 0;
			if (cmdno==CPF_CMD_LOG) strcpy(p,"-1\n");
			else strcpy(p,"get\n");
			if (argc > 1) d_pid = atoi(argv[1]);
			if (argc > 2) sprintf(p,"%s %s %s %s %s %s %s %s\n",
			                      argv[2],argv[3],argv[4],argv[5],argv[6],
			                      argv[7],argv[8],argv[9]);
			len = strlen(buf+sizeof(HEAD)) + 1;
			d_class = CPA_CLASS_BASE - cmdno;
		}
		if (!d_pid) d_pid = D_PID;	/* dPid; */
		pkhead.prs_d   = ntohs(d_pid);
		pkhead.class_d = htons(d_class);
	/*
		usa[0] = htons(wrks);
		usa[1] = 0;
		len = 4;
		memcpy(buf+PKHEAD_LEN,usa,len);
	*/
		opt = 0;
	}
	else {
/* insert tsuru 1993.11.08 */
/*
		strcpy(buf+PKHEAD_LEN,Uid);
*/
		ll = *(int*)dat;
		if (ntohl(ll) == 0x00010001 && len>8)
		{
			p = dat + 8;
			ll=ldc_getdhs(p,&dHead,sizeof(userctl.usr_id),userctl.usr_id);
			if (len > 8+ll)
				ldc_getdhs(p+ll,&dHead,sizeof(userctl.usr_pass),
				           userctl.usr_pass);
		}
		memcpy(buf+sizeof(HEAD),userctl.usr_code,sizeof(userctl.usr_code));
		memcpy(buf+sizeof(HEAD)+UCODE_SIZE,dat,len);
		len += UCODE_SIZE;
		opt = 1;
	}
	pkhead.len = htonl(len);
	memcpy(buf,(PSZ)&pkhead,sizeof(HEAD));
	len += sizeof(HEAD);
	print_send_opt(buf,len,opt);

	cpxeGetmSec(NULL,&tval1);

	if ((ret=cpfSkWrite(s, buf, len)) != len) {
		if (ret == -2) {
			printf("[MMISC] write timeout\n");
		}
		else {
			printf("[MMISC] write error\n");
			return (-1);
		}
	}

	return(len);
}

/********************************/
/*	hex dump to file 			*/
/********************************/
log_fxdmp(s,p,len)
char *s,*p;
long len;
{
	if (Log_flg) cpxafxdmp(fp_log,s,p,len);
	return 0;
}

/********************************/
/*								*/
/********************************/
int getwssp(s,ssp) /* J -ƁJ */
char *s;
struct SSP_S *ssp;
{
	char c,*w;
	int i,l;

	s += ssp->sp;
	w=ssp->wd;
	while ((c = *s) == ' ' || c=='\t') {
		s++;
		ssp->sp++;
	}
	if (!cpxqiskanji1(c)) {
		for (i=0;i<NSEP;i++)
			if (c==sep[i]) {
				*w++ = c;
				*w = '\0';
				ssp->sp++;
				return (-1);
			}
	}
	l=0;
	while (c = *s++) {
		if (cpxqiskanji1(c)) {
			l+=2;
			*w++ = c;
			*w++ = *s++;
			ssp->sp++;
		}
		else {
			for (i=0;i<NSEP;i++)
				if (c==sep[i])
					break;
			if (i<NSEP)
				break;
			else {
				l++;
				*w++ = c;
			}
		}
		ssp->sp++;
	}
	*w = '\0';
	return (l);
}

/********************************/
/*								*/
/********************************/
int q_skip(buf,ssp,quat)
char *buf,quat;
struct SSP_S *ssp;
{
	char c;
	int n=0,l;
#if DEBUG
printf("*** q_skip start.\n");
#endif

	for (;;) {
		if (c=buf[ssp->sp++]) {
			if (c=='\\' || cpxqiskanji1(c)==1) {
				n++;
				ssp->sp++;
			}
			else if (c==quat)
				break;
			n++;
		}
		else {
			if ((l=getline(buf," : "))==EOF)
				return (-1);
			else if (l==0)
				return (0);
			if (buf[0]=='/' && buf[1]=='/') return (-2);
			ssp->sp=0;
		}
	}
	return (n);
}

/********************************/
/*								*/
/********************************/
int c_skip(buf,ssp)
char *buf;
struct SSP_S *ssp;
{
	char c;
	int n=0,l;
#if DEBUG
printf("*** c_skip start.\n");
#endif
	n++;
	ssp->sp++;
	for (;;) {
		if (c=buf[ssp->sp++]) {
			if (cpxqiskanji1(c)) {
				n++;
				ssp->sp++;
			}
			else if (c=='*') {
				if (buf[ssp->sp]=='/') {
					ssp->sp++;
					n++;
					break;
				}
			}
		}
		else {
			if ((l=getline(buf," : "))==EOF)
				return (-1);
			else if (l==0)
				return (0);
			if (buf[0]=='/' && buf[1]=='/') return (-2);
			ssp->sp=0;
		}
	}
	return (n);
}

/********************************/
/*								*/
/********************************/
static int _set_history(tmp)
char *tmp;
{
	int i;
	char *p;

	for (i=0;i<HISTORY;i++) {
		if (p=line[i]) {
			if (!strcmp(p,tmp)) return i;
		}
	}
	if (++history>=HISTORY) history = 0;
	if (p=line[history]) Free(p);
	line[history] = Strdup(tmp);
/*
printf("_set_history: history=%d\n",history);
*/
	return history;
}

/********************************/
/*								*/
/********************************/
static int _set_Repeat(buf)
char *buf;
{
	int l;
	char tmp[LINEMAX],*argv[3];

	if (strlen(buf)>3) {
		l = cpxtgetargv2(buf+3,argv,2,tmp,sizeof(tmp),1);
		if (l>=1) Repeat=atoi(argv[0]);
		if (l>=2) RepeatSleep=atoi(argv[1]);
	}
	return 0;
}

/********************************/
/*								*/
/********************************/
int make_cmd()
{
	int l,cflg,nparam,dl,i,ret;
	char *p,c,*dp,c1,tmp[LINEMAX],cc,prompt[30];
	SSP_S ssp;
	long ll,lp;

	ssp.wd=w;

	for (;;) {
		if (Repeat>0) {
			if (RepeatSleep>0) sleep(RepeatSleep);
			strcpy(buf,"!!");
			l=2;
			printf("*** remain = %d\n",Repeat);
			Repeat--;
		}
		else {
			RepeatSleep = 0;
			sprintf(prompt, "\nEnter command %d: ",Commandcount);
			l=getline(buf,prompt);
		}
		if (l==EOF) return (0);
		c1 = ' ';
		if ((c=buf[0])=='#') continue;
		else if (c=='?') {
			sprintf(dat,"/help %s",buf+1);
			return (strlen(dat));
		}
		else if (c=='<' || c=='@') {
			sprintf(dat,"/run %s",buf+1);
			return (strlen(dat));
		}
		else if (c=='~') {
			if (strlen(buf)>1) {
				printf("\n");
				system(buf+1);
			}
			continue;
		}
        else if (c=='/') {
			if (buf[1]=='/')
				continue;
			else if (buf[1]!='*') {
				_set_history(buf);
			/*	strcpy(dat,buf);
				strcpy(crntline,buf);
				return (l); */
				break;
			}
		}
		else if (c=='!') {
			if ((c1=buf[1])=='h') {
				l = history;
				printf("\n");
				for (i=0;i<HISTORY;i++) {
					if (++l>=HISTORY) l=0;
/*
printf("make_cmd:h: l=%d\n",l);
*/
					if (p=line[l]) printf("[%d] %s\n",l,p);
				}
			}
			else if (c1=='!') {
				_set_Repeat(buf);
				strcpy(buf,crntline);
				printf("\n%s\n",buf);
				if (strlen(buf)==0) continue;
				break;
			}
			else if ((c1>='0' && c1<='9') || c1=='.') {
				_set_Repeat(buf);
				if (c1=='.') strcpy(buf,crntline);
				else {
					if ((l=atoi(buf+1))<0 || l>=HISTORY) continue;
					if (line[l]) strcpy(buf,line[l]);
					else continue;
				}
				printf("\n*** EDIT ***\n%s\n",buf);
				if (getline(dat,"")>0) {
					if (dat[0]=='/' && dat[1]=='/') continue;
					edit_cmd(dat,buf);
					printf("\n*** EDIT ***\n%s\n",buf);
					while (getline(dat,"")>0) {
						if (dat[0]=='/' && dat[1]=='/') break;
						edit_cmd(dat,buf);
						printf("\n*** EDIT ***\n%s\n",buf);
					}
					if (dat[0]=='/' && dat[1]=='/') continue;
				}
				break;
			}
		}
		else {
			break;
		}
	}

	strcpy(tmp,buf);
	ssp.sp=0;
	cflg = 0;
	dp = dat;
	nparam =0;
	dl = 0;
	strcpy(crntline,buf);
	for (;;) {
		l=getwssp(buf,&ssp);
		if (l<0) {
			switch (cc=*w) {
			case '\'':
			case '"':
				p=&buf[ssp.sp];
				ll=q_skip(buf,&ssp,*w);
				if (ll==EOF)
					return (0);
				else if (ll == -2)
					return (-1);
/*
printf("q_skip len=%ld\n",ll);
*/
				lp=ldc_setdhs(dp,1,1,ll,p);
				dp += lp;
				nparam++;
				dl += lp;
				break;
			case ';':
				ll=nparam;
				*(long *)(dat+4) = htonl(ll);
/*
				printf("nparam = %d  dlen = %d\n",nparam,dl);
*/
				strcpy(crntline,tmp);
				if (!(c=='!' && c1=='!') && *tmp!=';') _set_history(tmp);
				return(dl);
				break;
			case '/':
				if (buf[ssp.sp]=='*') {
					l=c_skip(buf,&ssp);
					if (l==EOF)
						return (0);
					else if (ll == -2)
						return (-1);
/*
printf("c_skip len=%d\n",l);
*/
				}
				else if (!dl) {
					if (!(c=='!' && c1=='!') && *tmp!=';') _set_history(tmp);
					dat[0] = '/';
					strcpy(dat+1,buf+ssp.sp);
					return strlen(dat);
				}
				break;
			default:
				break;
			}
		}
		else if (l>0) {
			if (!strcmp(w,"file")) {
				l=getwssp(buf,&ssp);
				if ((ll=read_file(w,rmsg,sizeof(rmsg)))<0) return -1;
				lp=ldc_setdhs(dp,1,1,ll,rmsg);
				dp += lp;
				nparam++;
				dl += lp;
			}
			else if (cflg) {
printf("make_cmd: w=[%s]\n",w);
			/*	ll = atoi(w);	*/
				if ((ret=cpxcecnv(NULL,w,strlen(w),&ll)) < 0) return ret;
				lp=ldc_setdhs(dp,2,3,4,&ll);
				dp += lp;
				nparam++;
				dl += lp;
			}
			else {
				cflg=1;
				memset(dp,0,8);
				cpxcctox(w,l,dp);
				dp += 8;
				dl = 8;
			}
		}
		else {
			l=getline(buf, " : ");
			if (l==EOF)
				return (0);
			if (buf[0]=='/' && buf[1]=='/') return (-1);
			strcat(tmp,buf);
			ssp.sp=0;
		}
	}
	
}

/********************************/
/*								*/
/********************************/
edit_cmd(eds,cmdio)
char *eds,*cmdio;
{
	char c, tmp[4096], *cms, *cmd;

	cmd = tmp;
	cms = cmdio;
	while (c=*eds++) {
		if (c==' ') {
			if (*cms)
				*cmd++ = *cms++;
			else {
				*cmd++ = c;
				*cmd   = '\0';
			}
		}
		else if (c=='#') {
			if (*cms) cms++;
		}
		else if (c=='^') {
			if (c=*eds++) {
				*cmd++ = c;
			}
			else break;
		}
		else if (c=='%') {
			strcpy(cmd,eds);
			strcpy(cmdio,tmp);
			return 0;
		}
		else if (c=='\\') {
			if (c=*eds++) {
				*cmd++ = c;
				if (*cms) cms++;
			}
			else break;
		}
		else if (c==';') {
			*cmd++ = c;
			*cmd   = '\0';
			strcpy(cmdio,tmp);
			return 0;
		}
		else {
			*cmd++ = c;
			if (*cms) cms++;
		}
	}
	strcpy(cmd,cms);
	strcpy(cmdio,tmp);
	return 0;
}

/********************************/
/*								*/
/********************************/
long ldc_setdhs(p,atr,prs,len,data)
char *p,*data;
unsigned char atr,prs;
long len;
{
	dhead_s *dhdp;
	char  w[256];
	int l;
	short ns,sw;
	long nl,lw;

	dhdp = (dhead_s *)p;
	dhdp->atr = atr<<4 | prs;
	l = len;
	switch (atr) {
	    case  1:
			p += 6;
			memcpy(p,data,l);
			*(p+len)='\0';
			l=strlen(p);
			if (l<256) {
				memcpy(p-4,p,l);
				dhdp->len = l;
				len=(long)l+2;
			}
			else {
				dhdp->atr &= 0xf0;
				dhdp->len  = 0;
				lw = htonl(l);
				memcpy(dhdp->llen,&lw,4);
				len=(long)l+6;
			}
			dhdp->atr |= (giDataCode<<1) & 0x0e;
			break;
	    case 2:
			p += 2;
			if (len==1) {
				dhdp->len = 1;
				*p = *data;
			}
			else if (len==2) {
				dhdp->len = 2;
			/*
				memcpy(p,data,2);
			*/
				memcpy(&sw,data,2);
				ns = htons(sw);
				memcpy(p,&ns,2);
			}
			else {
				dhdp->len = 4;
			/*
				memcpy(p,data,4);
			*/
				memcpy(&lw,data,4);
				nl = htonl(lw);
				memcpy(p,&nl,4);
			}
			len += 2;
			break;
	    default:
			memcpy(p+6,data,len);
			dhdp->atr  = 0x50;
			dhdp->len  = 0;
		/*
			memcpy(dhdp->llen,&len,4);
		*/
			lw = htonl(len);
			memcpy(dhdp->llen,&lw,4);
			len += 6;
			break;
	}
	return (len);
}

/********************************/
/*								*/
/********************************/
long ldc_getdhs(p,dhp,len,data)
char *p,*data;
long len;
dhead_s *dhp;
{
	dhead_s *  hed;
	UCHAR atr,dlen;
	char dc;
	long ll,nl,dl,lw;
	int l;
	short ns,ds,sw;

	atr=((dhead_s *)p)->atr;
	dlen=((dhead_s *)p)->len;
	dhp->atr=atr;
	dhp->len=dlen;
	/*
	dhp->llen=0;
	*/
	switch (atr & 0x70) {
	    case 0x10:
			if (atr & 0x01) {
				p +=2;
				if (len>dlen) {
					l = dlen;
					memcpy(data,p,l);
					*(data+dlen) = '\0';
				}
				else {
					l = len;
					memcpy(data,p,l);
				}
				ll = (long)(dlen+2);
			}
			break;
	    case 0x20:
			p += 2;
			switch (atr & 0x0f) {
			    case 0x01:
					dc = *data = *p;
					dl = (long)dc;
					break;
			    case 0x02:
					memcpy(&ns,p,2);
					ds = ntohs(ns);
					memcpy(data,(PSZ)&ds,2);
					dl = (long)ds;
					break;
			    default:
					memcpy(&nl,p,4);
					dl = ntohl(nl);
					memcpy(data,&dl,4);
					break;
			}
			if (len != (long)dlen) {
				switch (len) {
				    case 1:
						*data = (char)dl;
						break;
				    case 2:
						ns = dl;
						memcpy(data,(PSZ)&ns,2);
						break;
				    default:
						memcpy(data,&dl,4);
						break;
				}
			}
			ll = (long)(dlen+2);
			break;
	    case 0x50:
			hed = (dhead_s *)p;
			memcpy(&nl,hed->llen,4);
			p += 6;
			dhp->len=0;
			ll = ntohl(nl);
			if (len>0) {
				if (ll<len) l = ll;
				else	    l = len;
			}
			else l = ll;
			memcpy(data,p,l);
			ll += 6;
			break;
	    default:
			memcpy(data,p,len);
			ll = (long)len;
			break;
	}
	return (ll);
}

/********************************/
/*								*/
/********************************/
long print_dat(pdat,datlen,temp)
char *pdat,*temp;
int datlen;
{
	UCHAR atr,dlen;
	char dc, *p;
	long ll,nl,dl,lw;
	int l,slen;
	short ns,ds;
	dt_kan kan;

	p = pdat;
	slen = datlen;
	atr=((dhead_s *)p)->atr;
	dlen=((dhead_s *)p)->len;
	p +=2;
	slen -= 2;
	l = 2;
	switch (atr & 0x70) {
	    case 0x10:
			if (atr & 0x01) {
				ll = dlen;
			}
			else {
				memcpy(&lw,p,4);
				ll = ntohl(lw);
				p += 4;
				l += 4;
			}
			if (ll>slen) ll=slen;
			memcpy(temp,p,ll);
			*(temp+ll) = '\0';
			printf("[%s]\n",temp);
			l += ll;
			break;
	    case 0x20:
			switch (atr & 0x0f) {
			    case 0x01:
					dc = *p;
					dl = (long)dc;
					break;
			    case 0x02:
					memcpy(&ns,p,2);
					dl = (long)ntohs(ns);
					break;
			    default:
					memcpy(&lw,p,4);
					dl = ntohl(lw);
					break;
			}
			printf("%d\n",dl);
			l += dlen;
			break;
	    case 0x50:
			if (atr & 0x80) {
				memcpy(&kan,p,sizeof(dt_kan));
				p += sizeof(dt_kan);
				memcpy(temp,p,kan.um-8);
				temp[kan.um-8]='\0';
				printf("'%c' %d %d [%s]\n",kan.id,ntohl(kan.pos),ntohl(kan.len),temp);				l += dlen;
			}
			else {
				memcpy(&lw,p,4);
				ll = ntohl(lw);
				p += 4;
				l += ll + 4;
				if (ll>slen) ll=slen;
				cpxaxdump("BULK",p,ll);
			}
			break;
	    default:
			cpxaxdump("ERROR DATA",pdat,datlen);
			l = datlen;
			break;
	}
	return (l);
}

/********************************/
/*								*/
/********************************/
print_send_opt(buf,len,opt)
char *buf;
int len,opt;
{
	printf("\n*** send   (%s) ***\n",cpfLogTime());
	if (Dumpflg) cpxaxdump("send packet head",buf,sizeof(HEAD));
	buf += sizeof(HEAD);
	len -= sizeof(HEAD);
	if (Dumpflg) {
		putchar('\n');
		cpxaxdump("DATA",buf,len);
	}
	if (opt) {
		len -= UCODE_SIZE;
		buf += UCODE_SIZE;
		print_send(buf,len,dat);
	}
	else if (len > 0) printf("%s\n",buf);
	return 0;
}

/********************************/
/*								*/
/********************************/
print_send(dat,len,tmp)
char *dat,*tmp;
int len;
{
	int ret,nparam,i;
	long lw;

	memcpy(&lw,dat,4);
	nparam = ntohl(lw);
	printf("command  = %08x\n",nparam);
	dat += 4;
	memcpy(&lw,dat,4);
	nparam = ntohl(lw);
	printf("nparam   = %d\n",nparam);
	dat += 4;
	len -= 8;
	i = 1;
	while (len>0) {
/*
printf("len=%d\n",len);
*/
		printf("parm(%2d) = ",i++);
		ret=print_dat(dat,len,tmp);
		len -= ret;
		dat += ret;
	/*	getchar();	*/
	}
	return 0;
}

/********************************/
/*								*/
/********************************/
int dump_ret(mode,proc_no,class_no,buf,len)
char *buf;
int mode,proc_no,class_no,len;
{

	if (Dumpflg) {
		putchar('\n');
		cpxaxdump("DATA",buf,len);
	}
	if (class_no == 1) print_ret(mode,buf,len,dat);
	else print_query(mode,proc_no,class_no,buf,len);

	return(0);
}

/********************************/
/*								*/
/********************************/
print_ret(mode,buf,len,temp)
char *buf,*temp;
int mode,len;
{
	int ret,nparam,i,kan_len;
	pk_kan kan;

	if (!mode) {
		len -= UCODE_SIZE;
		buf += UCODE_SIZE;
		print_page(buf,len,temp);
		return 0;
	}
	while (len>0) {
		memcpy(&kan,buf,sizeof(pk_kan));
		kan_len = ntohl(kan.len);
		if (kan.id=='P' || kan.id=='F' || kan.id=='X') {
			printf("packet type = '%c'\n",kan.id);
			buf += sizeof(pk_kan);
			len -= sizeof(pk_kan);
			switch (kan.id) {
			case 'P':
				print_page(buf+UCODE_SIZE,kan_len-UCODE_SIZE,temp);
				len -= kan_len;
				buf += kan_len;
				break;
			case 'F':
			case 'X':
				memcpy(temp,buf,kan.um-4);
				temp[kan.um-4]='\0';
				printf("  file name = [%s]\n",temp);
				printf("  data len  = %d\n",kan_len);
				len -= kan.um;
				buf += kan.um;
				if (kan.id == 'X') {
					cpxaxdump("DATA",buf,kan_len);
					len -= kan_len;
					buf += kan_len;
				}
				break;
			}
		}
		else {
			cpxaxdump("ERROR DATA",buf,len);
			return 0;
		}
	}
	return 0;
}

/********************************/
/*								*/
/********************************/
print_page(buf,len,temp)
char *buf,*temp;
int len;
{
	char *p,w[32];
	long ret,l,nt,nd,cmnd;
	int i;
	FILE *fp;

	p = buf;
	memcpy(&ret,p,4);
	printf("command  = %08x\n",ntohl(ret));
	cmnd = ret;
	p += 4;
	memcpy(&ret,p,4);
	printf("retcode  = %d\n",ntohl(ret));
	p += 4;
	len -= 8;
	while (len>0) {
		if (!memcmp(p,"FM",2)) {
			p += 2;
			len -= 2;
			printf("FM\n");
			ret=print_dat(p,len,temp);
			len -= ret;
			p += ret;
		}
		else if (!memcmp(p,"GR",2)) {
			if (len>=17) {
				memcpy(w,p+12,5);
				w[5]='\0';
				l=atoi(w)*5+17;
				if (l>len) l=len;
			}
			else l=len;
			memcpy(temp,p,l);
			temp[l]='\0';
			printf("%s\n",temp);
			len -= l;
			p += l;
		}
		else if (!memcmp(p,"DT",2)) {
			strcpy(temp,"DT");
			p += 2;
			len -= 2;
			if (len>=5) {
				memcpy(temp+2,p,5);
				temp[7]='\0';
				p += 5;
				len -= 5;
			}
			if (len>=5) {
				memcpy(w,p,5);
				w[5]='\0';
				nd=atoi(w);
				memcpy(temp+7,p,5);
				temp[12]='\0';
				p += 5;
				len -= 5;
			}
			printf("%s\n",temp);
			for (i=0;i<nd && len>0;i++) {
				printf("parm(%2d) = ",i);
				ret=print_dat(p,len,temp);
				len -= ret;
				p += ret;
			}
		}
		else {
			*(p+len) = '\0';
			if (strstr(p,"<HTML>")) {
				printf("%s",p);
				sprintf(w,"cmnd%08x.htm",cmnd);
				if (fp=fopen(w,"wb")) {
					fwrite(p,1,len,fp);
					fclose(fp);
				}
			}
			else {
				cpxaxdump("ERROR DATA ",p,len);
			}
			break;
		}
	}
	return 0;
}

/********************************/
/*								*/
/********************************/
int print_query(mode,proc_no,class_no,buf,len)
char *buf;
int mode,len,proc_no,class_no;
{
	int ret,nparam,i;
	int m,l,j,lw;
	uchar c,*p;
	SSP_S ssp;
	static char *temp=NULL;

	if (!mode) {
		p = buf;
		if (len>=4 && proc_no<=3 && class_no==1) {
			memcpy(&lw,p,4);
			ret = ntohl(lw);
			printf("\n%d %s\n",ret,geterrmsg(ret));
			p += 4;
			len -= 4;
		}
		temp = _realloc(temp,len+1);
		for (i=0,m=0;i<len;i++) {
#if 1
			if (c=*p++) temp[m++]=c;
#else
			if (!(c=*p++)) c='.';
			temp[m++]=c;
#endif
		}
		temp[m]='\0';
		if (!memcmp(temp,"R ",2)) {
			ssp.sp=0;
			len=cpxtmgetline(temp,m,&ssp);
			temp[len]='\0';
			ret=atoi(temp+2);
			printf("\n%s %s\n%s\n",temp,geterrmsg(ret),temp+ssp.sp);
		}
		else if (m > 0) printf("\n%s\n",temp);
	}
	return 0;
}

/********************************/
/*								*/
/********************************/
int read_file(fname,buf,maxlen)
char *fname,*buf;
int  maxlen;
{
	struct stat tStat;
	FILE *fp;
	int len;

	if (stat(fname,&tStat)) {
		printf("file[%s] stat error!!\n",fname);
		return -1;
	}
	if (tStat.st_size > maxlen) {
		printf("size(%d) over (%d)\n",tStat.st_size,maxlen);
		return -2;
	}
	if (!(fp=fopen(fname,"rb"))) {
		printf("file[%s] open error!!\n",fname);
		return -3;
	}
	len = fread(buf,1,tStat.st_size,fp);
	fclose(fp);
	return len;
}

/********************************/
/*								*/
/********************************/
int analyze_etc(pHead,pQue)
HEAD *pHead;
qRWQue *pQue;
{
	char *pBody;
	int   msglen;
	short sCommand;
	ushort usEvent, *usp, usProcId,usw;
	int lw,iRc;

	pBody  = pQue->cpBuff;
	msglen = pQue->lRWLen;
	switch (sCommand=ntohs(pHead->command)) {
	case CPF_CMD_NOTIFY:
		printf("\n*** NOTIFY command received.\n");
		usp = (ushort *)pBody;
		usEvent  = ntohs(*usp++);
		usProcId = ntohs(*usp++);
		if (msglen-4 < 4) iRc = 0;
		else {
			memcpy(&lw,usp,sizeof(int));
			iRc = ntohl(lw);
		}
		printf("    ProcId=%d Event=%d Rc=%d\n",usProcId,usEvent,iRc);
		break;
	case CPF_CMD_WATCH:
		printf("\n*** WATCH command received.\n");
		reply_msg(pHead,0,0);
		break;
	default:
		putchar('\n');
		cpxaxdump("Command Message",pBody,msglen);
		reply_msg(pHead,pBody,msglen);
	/*
		print_ret(pHead->info & CPF_PFM_INDIRECT,pBody,msglen,dat);
	*/
	}
	return 0;
}

/********************************/
/*								*/
/********************************/
int reply_msg(pHead,pBody,msglen)
HEAD *pHead;
char *pBody;
int  msglen;
{
	int ret,len,i;
	char *p;

	memcpy(&Head_w,pHead,4);
	memcpy(&Head_w.host_d,&pHead->host_s,12);
	memcpy(&Head_w.host_s,&pHead->host_d,12);
	if (pBody && msglen>0) Head_w.len = htonl(msglen);
	else Head_w.len = 0;
	p = (char *)&Head_w;
	len = sizeof(HEAD);
	if (Dumpflg) {
		putchar('\n');
		cpxaxdump("reply packet head",p,len);
	}
	for (i=0;i<2;i++) {
		if ((ret = cpfSkWrite(Fd,p,len)) != len) {
			if (ret == -2) {
				printf("[MMISC] write timeout\n");
			}
			else {
				printf("[MMISC] write error\n");
				return -1;
			}
		}
		if ((p=pBody) && (len=msglen)>0) {
			if (i==0 && Dumpflg) {
				putchar('\n');
				cpxaxdump("DATA",p,len);
			}
		}
		else break;
	}
	return 0;
}
