000010 IDENTIFICATION  DIVISION.
000020 PROGRAM-ID      3_FROM_VSAM.
000030*
000040 ENVIRONMENT     DIVISION.
000050 INPUT-OUTPUT    SECTION.
000060 FILE-CONTROL.
000070     SELECT  VSAM-FILE  ASSIGN  TO  I1
000080         ORGANIZATION           IS  INDEXED
000090         ACCESS           MODE  IS  DYNAMIC
000100         RECORD           KEY   IS  VSAM-KEY
000110         FILE  STATUS           IS  VSAM-STS.
000120*
000130     SELECT  SAM-FILE  ASSIGN   TO  O1
000140         FILE  STATUS           IS  SAM-STS.
000150*
000160     SELECT  SAM-FILE-IN  ASSIGN  TO  I2
000170             FILE  STATUS  IS  SAM-STS2.
000180*
000190 DATA  DIVISION.
000200 FILE  SECTION.
000210 FD  SAM-FILE-IN.
000220 01  SAM-REC-IN.
000230   03  SAM-KEY.
000240     05  SAM-KEY1-11         PIC  X(11).
000250     05  SAM-KEY12-12        PIC  X(01).
000260   03  SAM-DATA              PIC  X(88).
000270*
000280 FD  VSAM-FILE.
000290 01  VSAM-REC.
000300   03  VSAM-KEY.
000310     05  VSAM-KEY1-11        PIC  X(11).
000320     05  VSAM-KEY12-12       PIC  X(01).
000330   03  VSAM-DATA             PIC  X(88).
000340*
000350 FD  SAM-FILE.
000360 01  SAM-REC                 PIC  X(100).
000370*
000380 WORKING-STORAGE SECTION.
000390 01  VSAM-KEY-NUM            PIC  9(12).
000400 01  SAM-STS                 PIC X(2).
000410 01  SAM-STS2                PIC X(2).
000420 01  VSAM-STS                PIC X(2).
000430   88     FSTATUS-OK         VALUE          '00'.
000440   88     FSTATUS-NG         VALUE          '23'.
000450 01  END-SW                  PIC X(01).
000460   88     SUM-FILE-END       VALUE          '1'.
000470 01  SYSIN-STS               PIC X(2).
000480 01  READ-CNT                PIC 9(10).
000490 01  WRITE-CNT               PIC 9(10).
000500 01  UPDATE-CNT              PIC 9(10).
000510 01  DELETE-CNT              PIC 9(10).
000520 01  I                       PIC 9(12).
000530 01  SW-ERR                  PIC 9(01).
000540*
000550 01  WK-JIKAN.
000560     05  WK-TIME.
000570       07  WK-HHMMSS.
000580         09  WK-HHMM.
000590           11  WK-HH         PIC 9(2).
000600           11  WK-MM         PIC 9(2).
000610         09  WK-SS           PIC 9(2).
000620       07  WK-COMMASS        PIC 9(2).
000630*
000640     05  WK-TIME-D.
000650       07  WK-HH-D           PIC 9(2).
000660       07  WK-COLON1         PIC X(1)   VALUE ':'.
000670       07  WK-MM-D           PIC 9(2).
000680       07  WK-COLON2         PIC X(1)   VALUE ':'.
000690       07  WK-SS-D           PIC 9(2).
000700       07  WK-COLON3         PIC X(1)   VALUE '.'.
000710       07  WK-COMMASS-D      PIC 9(2).
000720*
000730 PROCEDURE       DIVISION.
000740     PERFORM  START-RTN.
000750     PERFORM  MAIN-RTN UNTIL END-SW = '1'.
000760     PERFORM  END-RTN.
000770*
000780     PERFORM  LAST-RTN.
000790     STOP RUN.
000800*
000810 START-RTN.
000820     DISPLAY '3_FROM_VSAM(VSAM TO SAM) START'.
000830     PERFORM GET-TIME-RTN.
000840     DISPLAY '* START '  WK-TIME-D.
000850     MOVE  ZERO    TO  READ-CNT.
000860     MOVE  ZERO    TO  UPDATE-CNT.
000870     MOVE  ZERO    TO  DELETE-CNT.
000880     MOVE  ZERO    TO  SW-ERR.
000890     MOVE  ZERO    TO  END-SW.
000900     OPEN  I-O     VSAM-FILE
000910           INPUT   SAM-FILE-IN.
000920*
000930     PERFORM READ-SAM-RTN.
000940*
000950 MAIN-RTN.
000960     EVALUATE SAM-KEY12-12
000970       WHEN '1'
000980         PERFORM UPDATE-RTN
000990       WHEN '3'
001000         PERFORM DELETE-RTN
001010     END-EVALUATE.
001020     PERFORM READ-SAM-RTN
001030*
001040 UPDATE-RTN.
001050     MOVE  SAM-KEY     TO  VSAM-KEY
001060     MOVE  SAM-REC-IN  TO  VSAM-REC
001070     PERFORM  WRITE-VSAM-RTN
001080*     IF SW-ERR = ZERO
001090*         PERFORM  READ-VSAM-RTN
001100*         IF SW-ERR = ZERO
001110*             MOVE VSAM-REC  TO  SAM-REC
001120*             PERFORM WRITE-SAM-RTN
001130*         END-IF
001140*     END-IF
001150*
001160 DELETE-RTN.
001170     MOVE  SAM-KEY     TO  VSAM-KEY
001180     DELETE  VSAM-FILE.
001190     IF VSAM-STS  = ZERO
001200         ADD  1  TO  DELETE-CNT
001210     ELSE
001220         DISPLAY 'ERR DELETE VSAM-FILE STATUS=' VSAM-STS
001230         MOVE  '1'  TO  SW-ERR
001240     END-IF.
001250*
001260 GET-TIME-RTN.
001270     ACCEPT WK-TIME FROM TIME.
001280     MOVE    WK-HH       TO  WK-HH-D.
001290     MOVE    WK-MM       TO  WK-MM-D.
001300     MOVE    WK-SS       TO  WK-SS-D.
001310     MOVE    WK-COMMASS  TO  WK-COMMASS-D.
001320* 
001330 READ-SAM-RTN.
001340     READ  SAM-FILE-IN
001350       AT END  MOVE '1' TO END-SW.
001360     IF END-SW NOT = '1'
001370         ADD  1  TO  READ-CNT
001380     END-IF.
001390* 
001400 READ-VSAM-RTN.
001410     READ  VSAM-FILE.
001420     IF VSAM-STS  NOT = ZERO
001430         DISPLAY 'ERR READ VSAM-FILE STATUS=' VSAM-STS
001440         MOVE  '1'  TO  SW-ERR
001450     END-IF.
001460* 
001470 WRITE-VSAM-RTN.
001480     REWRITE  VSAM-REC.
001490     IF VSAM-STS  = ZERO
001500         ADD  1  TO  UPDATE-CNT
001510     ELSE
001520         DISPLAY 'ERR REWRITE VSAM-FILE STATUS=' VSAM-STS
001530         MOVE  '1'  TO  SW-ERR
001540     END-IF.
001550*
001560 WRITE-SAM-RTN.
001570     WRITE  SAM-REC.
001580     IF SAM-STS = ZERO
001590         ADD  1  TO  WRITE-CNT
001600     ELSE
001610         DISPLAY 'ERR WRITE FILE(SAM-FILE) STATUS=' SAM-STS
001620         MOVE  '1'  TO  SW-ERR
001630     END-IF.
001640*
001650 END-RTN.
001660     CLOSE SAM-FILE-IN
001670           VSAM-FILE.
001680*
001690     PERFORM GET-TIME-RTN.
001700     DISPLAY '* END   '  WK-TIME-D.
001710     DISPLAY  'READ-CNT   =' READ-CNT.
001720     DISPLAY  'UPDATE-CNT =' UPDATE-CNT.
001730     DISPLAY  'DELETE-CNT =' DELETE-CNT.
001740*
001750 LAST-RTN.
001760     DISPLAY '3_FROM_VSAM(VSAM TO SAM) START'.
001770     PERFORM GET-TIME-RTN.
001780     DISPLAY '* START '  WK-TIME-D.
001790     MOVE  ZERO    TO  READ-CNT.
001800     MOVE  ZERO    TO  WRITE-CNT.
001810     MOVE  ZERO    TO  SW-ERR.
001820     MOVE  ZERO    TO  END-SW.
001830     OPEN  INPUT   VSAM-FILE
001840           OUTPUT  SAM-FILE.
001850*
001860      MOVE    LOW-VALUE   TO  VSAM-KEY.
001870      START   VSAM-FILE   KEY  >  VSAM-KEY
001880         INVALID KEY
001890           IF  FSTATUS-NG
001900               CONTINUE
001910           ELSE
001920               DISPLAY 'ERR READ FILE(VSAM-FILE) STATUS='
001930                                                 VSAM-STS
001940               CLOSE SAM-FILE
001950                     VSAM-FILE
001960               STOP RUN
001970           END-IF
001980     END-START.
001990     IF FSTATUS-OK
002000         READ  VSAM-FILE  NEXT
002010               AT END  MOVE  '1'  TO  END-SW
002020         END-READ
002030*
002040         PERFORM UNTIL END-SW = '1'
002050             ADD  1  TO  READ-CNT
002060             MOVE VSAM-REC  TO  SAM-REC
002070             PERFORM WRITE-SAM-RTN
002080             IF SW-ERR = ZERO
002090                 READ  VSAM-FILE  NEXT
002100                     AT END  MOVE  '1'  TO  END-SW
002110                 END-READ
002120             END-IF
002130         END-PERFORM
002140*
002150         CLOSE SAM-FILE
002160               VSAM-FILE
002170*
002180         PERFORM GET-TIME-RTN
002190         DISPLAY '* END   '  WK-TIME-D
002200         DISPLAY  'READ-CNT   =' READ-CNT
002210         DISPLAY  'WRITE-CNT  =' WRITE-CNT
002220     END-IF.
