#### Aya - A Gemini server
#### Copyright (C) 2021 Remilia Scarlet <remilia@posteo.jp>
####
#### This program is free software: you can redistribute it and/or modify
#### it under the terms of the GNU Affero General Public License as
#### published by the Free Software Foundation, either version 3 of the
#### License, or (at your option) any later version.
####
#### This program is distributed in the hope that it will be useful,
#### but WITHOUT ANY WARRANTY; without even the implied warranty of
#### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#### GNU Affero General Public License for more details.
####
#### You should have received a copy of the GNU Affero General Public License
#### along with this program.  If not, see <https://www.gnu.org/licenses/>.
require "./listener"

module Aya
  class Server
    @listeners : Array(Listener) = [] of Listener

    def initialize
      RemiLog.log.dlog("Init server")
    end

    def run
      RemiLog.log.log("Starting server")

      Aya.config.listen.each do |addr|
        @listeners << Listener.new(addr, Aya.config.listenPort)
      end

      RemiLog.log.dlog("Starting listeners")
      @listeners.each do |listen|
        spawn { listen.run }
      end

      # Just wait
      Channel(Bool).new.receive
    end
  end
end
