# Aya Gemini Server

Aya is a very simple [Gemini](https://portal.mozz.us/gemini/gemini.circumlunar.space/) server written in
[Crystal](https://crystal-lang.org/) and released under the [GNU Affero General Public
License](https://www.gnu.org/licenses/agpl-3.0.html).

## How do I get set up?

1. Clone this repository
2. Run `make` (or `make release=1` for a release build).  The binary will be in the `bin/` directory.
3. Create a configuration file by copying `sample-config.yml` and editing the copy.  Note that Aya will
   automatically load a file named `aya-config.yaml`, otherwise you will need to use the `--config` parameter.
4. Start Aya.

## Development

Aya is in a VERY early state of development and can only serve static files at the moment.  It's likely insecure,
buggy, and may eat your pet hamster.  You have been warned.

### Style info
I use a slightly different style for my code.

- Keep lines 118 characters or shorter.  Obviously sometimes you can't, but please try.  Use 115 characters for
  Markdown files, though.
- Please use pascalCase for variable and method names.  Use CamelCase for type names.  Use UPPER_SNAKE_CASE for
  constants.
- The type name for exceptions end with Error.  For example, `ExternalProgramError`.

## How do I contribute?

I do not use Git.  Let the Crystal folks know you'd like them to support other VCSs.

1. Go to https://osdn.net/users/yukiraven/pf/aya/ and clone the Mercurial repository.
2. Create a new branch for your feature.
3. Push locally to the new branch
4. Create a ticket.

## Contributors

- Remilia Scarlet - creator and maintainer
