static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************/
/*											*/
/*	  coded by A.Kobayashi() 2010.5.27		*/
/*											*/
/********************************************/
#include "akxcommon.h"

static MPA _MMAX = {
	'M','P',
	 0, /* opt  */
	40,	/* alen */
  NMPA,	/* len  */
MAXEXP,	/* exp  */
	 0,	/* sign */
	 0,	/* zero */
	 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
	 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
	 99, 99, 99, 99, 99, 99, 99, 0};

static MPA _M0 = {
	'M','P',
	0,  /* opt  */
	40,	/* alen */
	0,	/* len  */
	0,	/* exp */
	0,	/* sign */
	1,	/* zero */
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0};

static MPA G_MI[RADIX];

/********************************/
/*								*/
/********************************/
MPA *m_get_i(int i)
{
	MPA *a;

	if (i>=0 && i<=RADIX-1) {
		a = &G_MI[i];
		*a = _M0;
		if (i > 0) {
			a->zero = 0;
			a->len = 1;
			a->num[0] = i;
		}
	}
	else a = &_M0;
	return a;
}

/********************************/
/*								*/
/********************************/
MPA *m_get_MMAX()
{
	return &_MMAX;
}

/********************************/
/*								*/
/********************************/
MPA *m_cpy(MPA *d,MPA *s,int iCPY)
{
	memcpy(d,s,sizeof(MPA));
	return d;
}

/************************************/
/*	m_set_an_opt	MPA <-- "123"	*/
/************************************/
int m_set_an_opt(MPA *a, char *s, int len_s, int opt)
{
	char *p,cc,*pnum;
	int c, exp, i, pflag, sign, nzflag, pos, n, j, syo, lens, ret, at;
	char *q;
	int opt2,comma,chk_comma;
	MPA10W w;

	if (!a || !s) return -1;
	lens = len_s;
	p = s;
	sign = 0;
	while ((lens > 0) && (cc = *p)) {
		if(cc == '-') sign = 1;
		else if(cc!='+' && cc!=' ' && cc!='\t' && cc!='0') break;
		p++;
		lens--;
	}
	opt2 = opt & AKX_CNVN_OPT_COMMA;
	pnum = w.num + 1;
	memset(&w,0,sizeof(MPA10W));
	at = ret = pos = exp = syo = comma = chk_comma = 0;
	pflag = nzflag = 0;
	while ((lens-- > 0) && (cc = *p++)) {
		at++;
		if (cc == '.') {
			if (pflag || comma) {
				ret = at;
				break;
			}
			if (at==1) syo--;
			pflag = 1;
			chk_comma = 0;
		}
		else if (cc=='E' || cc=='e') {
			exp += atoi(p);
			break;
		}
		else if(cc == '+' || cc == '-') {
			exp += atoi(p-1);
			break;
		}
		else if (opt2 && cc==',') {
			if (pflag || comma) {
				ret = at;
				break;
			}
			comma = 3;
			chk_comma = 1;
		}
		else {
			c = cc - '0';
			if (c<0 || c>9) {
				ret = at;
				break;
			}
			if (c) nzflag = 1;
			if (nzflag) {
				if (pos < NMPA10) pnum[pos++] = c;
			}
			else if (syo) syo--;
			if (!pflag) exp++;
			if (chk_comma) comma--;
		}
	}
/*
printf("m_set_an: sign=%d exp=%d syo=%d comma=%d\n",sign,exp,syo,comma);
*/
	if (comma) ret = at;
	if (syo) exp += syo;
	else exp--;
	w.exp  = exp;
	w.sign = sign;
	w.len  = pos;
	m_10to100(a,&w);
	if ((at=m_normalize(a)) < 0) ret = at;
/*
m_print("m_set_an: ",a,0);
*/
	return ret;
}

/********************************/
/*	m_set_an	MPA <-- "123"	*/
/********************************/
int m_set_an(MPA *a, char *s, int len_s)
{
	return m_set_an_opt(a, s, len_s, 0);
}

/********************************/
/*	m_set_a		MPA <-- "123"	*/
/********************************/
int m_set_a(MPA *a, char *s)
{
	if (!s) return -1;
	return m_set_an(a,s,strlen(s));
}

MPA *m_pset_an(MPA *a, char *s, int len)
{
	int ret;
	ret = m_set_an(a,s,len);
	if (ret) return &_M0;
	return a;
}

MPA *m_pset_a(MPA *a, char *s)
{
	if (!s) return &_M0;
	return m_pset_an(a,s,strlen(s));
}

/********************************/
/*	m_10to100		a <-- w		*/
/********************************/
int m_10to100(MPA *a, MPA10W *w)
{
	int i,exp,n;
	char *p;

	if (!a || !w) return -1;
	*a = _M0;
	a->exp = w->exp;
	a->len = w->len;
	a->sign = w->sign;
	a->zero = w->zero;
	if (w->zero) return 0;
	p = w->num;
	n = w->len;
	if ((exp=w->exp) % 2) {
		p++;
		n = (n+1)/2;
	}
	else {
		n = n/2 + 1;
	}
	for (i=0;i<n;i++) {
		a->num[i] = *p*RADIX10 + *(p+1);
		p += 2;
	}
	if (exp < 0) exp--;
	a->exp = exp/2;
	a->len = n;
	return 0;
}

/********************************/
/*	m_100to10		a --> w		*/
/********************************/
int m_100to10(MPA *a, MPA10W *w)
{
	int i,exp,v,n,i_p,nn;
	char *p,*q;

	if (!a || !w) return -1;
	memset(w->num,0,sizeof(w->num));
	w->exp = a->exp;
	w->len = a->len;
	w->sign = a->sign;
	w->zero = a->zero;
	if (a->zero) return 0;
	n = a->len;
	if (n <= 0) return -1;
	exp = a->exp*2;
	nn = NMPA2 - (n*2);
	p = w->num;
	i_p = 0;
	if (a->num[0] >= RADIX10) {
		*p++ = '\0';
		i_p++;
		exp++;
		nn--;
	}
	q = a->num;
	for (i=0;i<n;i++) {
		*p++ = (v=*q++)/RADIX10;
		*p++= v % RADIX10;
	}
	i_p += n*2;
	n = i_p;
	if (!*(p-1)) n--;
	w->exp = exp;
	w->len = n - 1;
	memset(p,0,nn);
	return 0;
}

/********************************/
/*	m_mul_10					*/
/********************************/
int m_mul_10(MPA *a, int m)
{
	MPA10W w;
	int ret;

	if (!(ret=m_100to10(a,&w))) {
		w.exp += m;
		ret = m_10to100(a,&w);
	}
	return ret;
}

/********************************/
/*	m_normalize					*/
/********************************/
int m_normalize(MPA *a)
{
	int pos,i,n,exp,sgn;
	char *q,*r;

	sgn = a->sign;
	exp = a->exp;
	pos = a->len;
	q = a->num + pos - 1;
	while (pos>0 && !*q--) pos--;
	if (pos) {
		i = 0;
		q = a->num;
		while (i<pos && !*q) {
			i++;
			q++;
		}
		if (i > 0) {
			n = i;
			r = a->num;
			for (;i<pos;i++) {
				*r++ = *q;
				*q++ = 0;
			}
			pos -= n;
			exp -= n;
		}
	}
	else {
		a->sign = 0;
		exp  = 0;
		a->zero = 1;
	}
	if (pos > NMPA) {
		pos = NMPA;
		a->num[pos] = 0;
	}
	a->len  = pos;

	if (exp > MAXEXP) {
		*a = _MMAX;
		a->sign = sgn;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*a = _M0;
		return MPA_ERR_UNDERFLOW;
	}
	a->exp = exp;
	return 0;
}

/********************************/
/*								*/
/********************************/
int m_cmp(MPA *a, MPA *b)
{
	int mca;

	if (!a || !b) return -1;
	if (a->zero) {
		if (b->zero) return 0;
		return (b->sign)? 1: -1;
	}
	if (b->zero) return (a->sign)? -1: 1;
	if (a->sign == b->sign) {
		mca = m_cmp_a(a, b);
		return (a->sign)? -mca: mca;
	}
	return (a->sign)? -1: 1;
}

/****************************************/
/*	m_cmp_a		compare |MPA| vs |MPA|	*/
/****************************************/
int m_cmp_a(MPA *aa, MPA *bb)
{
	int i,a_exp,b_exp;
	char *p, *q;

	if (!aa || !bb) return -1;
	if (aa->zero) return (bb->zero)? 0: -1;
	if (bb->zero) return 1;
	if ((a_exp=aa->exp) > (b_exp=bb->exp)) return 1;
	else if (a_exp < b_exp) return -1;

	for(i = 0, p = aa->num, q = bb->num; i <= NMPA; i++, p++, q++)
		if(*p != *q) return (*p > *q)? 1: -1;
	return 0;
}

/****************************************/
/*	m_add		MPA c <-- MPA a + MPA b	*/
/****************************************/
int m_add(MPA *c, MPA *a, MPA *b)
{
	int cmp,ret;
/*
m_print("m_add:a: ",a,0);
m_print("m_add:b: ",b,0);
*/
	if(a->zero)	{
		*c = *b;
		return 0;
	}
	else if (b->zero) {
		*c = *a;
		return 0;
	}
	ret = 0;
	if (a->sign == b->sign) {
		ret = m_add_a(c, a, b);
		c->sign = a->sign;
	}
	else {
		cmp = m_cmp_a(a, b);
		if(!cmp) {
			*c = _M0;
			return 0;
		}
		else if (cmp > 0) {
			ret = m_sub_a(c, a, b);
			c->sign = a->sign;
		}
		else {
			ret = m_sub_a(c, b, a);
			c->sign = b->sign;
		}
	}
/*
m_print("m_add:c: ",c,0);
*/
	return ret;
}

/****************************************/
/*	m_sub		MPA c <-- MPA a - MPA b	*/
/****************************************/
int m_sub(MPA *c, MPA *a, MPA *b)
{
	int cmp,ret;

	if (a->zero) {
		if (b->zero) {
			*c = _M0;
			return 0;
		}
		*c = *b;
		c->sign = 1 - c->sign;
		return 0;
	}
	if (b->zero) {
		*c = *a;
		return 0;
	}
	else if (a->sign != b->sign) {
		ret = m_add_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	cmp = m_cmp_a(a, b);
	if (!cmp) {
		*c = _M0;
		return 0;
	}
	else if (cmp > 0) {
		ret = m_sub_a(c, a, b);
		c->sign = a->sign;
		return ret;
	}
	ret = m_sub_a(c, b, a);
	c->sign = 1 - b->sign;
	return ret;
}

/************************************************/
/*	m_add_a		MPA ans <-- |MPA a| + |MPA b|	*/
/************************************************/
int m_add_a(MPA *ans, MPA *a, MPA *b)
{
	MPA c,*pc,*pa,*pb;
	char *pan,*pbn;
	int i, u, n, ia, ib, ia1, len1;

	if (!ans || !a || !b) return -1;
	if (a->zero) {
		*ans = *b;
		return 0;
	}
	if (b->zero) {
		*ans = *a;
		return 0;
	}
	if (a->exp >= b->exp) {
		c = *a;
		pb = b;
	}
	else {
		c = *b;
		pb = a;
	}
	pa = &c;
	c.zero = 0;
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib) > NMPA) {
		ib -= ia-NMPA;
		ia = NMPA;
	}
	if (ib < 0) {
		*ans = c;
		return 0;
	}
	len1 = pa->len - 1;
	ia1 = ia + 1;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	u = 0;
	while (ib-- >= 0) {
		u += *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) >= RADIX) {
			n = u - RADIX;
			u = 1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >= 0) {
			u += *pan;
			if ((n=u) >= RADIX) {
				*pan-- = u - RADIX;
				u = 1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
#if 1
			if (ia1 > pa->len) pa->len = ia1;
#endif
			if (pa->len < NMPA) pa->len++;
			i = pa->len - 1;
			pan = pa->num + i;
			pbn = pan - 1;
			while (i-- > 0) *pan-- = *pbn--;
			pa->num[0] = u;
			pa->exp++;
		}
	}
	if (ia1 > pa->len) pa->len = ia1;
	*ans = c;
/*
m_print("m_add_a:ans: ",ans,0);
*/
	return m_normalize(ans);
}

/************************************************/
/*	m_sub_a		MPA ans <-- |MPA a| - |MPA b|	*/
/************************************************/
int m_sub_a(MPA *ans, MPA *a, MPA *b)
{
	MPA c,*pc,*pa,*pb;
	char *pan,*pbn;;
	int u, n, ia, ib, ia1, len1, len;

	if (!ans || !a || !b) return -1;
	pa = &c;
	pb = b;
	c = *a;
	ib = pb->len - 1;
	if ((ia=pa->exp-pb->exp+ib) > NMPA) {
		ib -= ia-NMPA;
		ia = NMPA;
	}
	if (ib < 0) {
		*ans = c;
		return 0;
	}
	len = pa->len;
	len1 = len - 1;
	ia1 = ia + 1;
	u = 0;
	pbn = pb->num + ib;
	pan = pa->num + ia;
	while (ib-- >= 0) {
		u -= *pbn--;
		if (ia-- <= len1) u += *pan;
		if ((n=u) < 0) {
			n = u + RADIX;
			u = -1;
		}
		else u = 0;
		*pan-- = n;
	}
	if (u) {
		while (ia-- >=0) {
			u = *pan + u;
			if ((n=u) < 0) {
				*pan-- = u + RADIX;
				u = -1;
			}
			else {
				*pan-- = n;
				u = 0;
				break;
			}
		}
		if (u) {
			*ans = _M0;
			return MPA_ERR_A_LT_B;
		}
	}
	if (ia1 > len) pa->len = ia1;
	*ans = c;
	return m_normalize(ans);
}

/********************************/
/*	m_add1		MPA a += MPA b	*/
/********************************/
int m_add1(MPA *a, MPA *b)
{
	return m_add(a,a,b);
}

/********************************/
/*	m_sub1		MPA a -= MPA b	*/
/********************************/
int m_sub1(MPA *a, MPA *b)
{
	return m_sub(a,a,b);
}

/************************************/
/*	m_add1_a.c	|MPA a| += |MPA b|	*/
/************************************/
int m_add1_a(MPA *a, MPA *b)
{
	return m_add_a(a,a,b);
}

/************************************/
/*	m_sub1_a	|MPA a| -= |MPA b|	*/
/************************************/
int m_sub1_a(MPA *a, MPA *b)
{
	return m_sub_a(a,a,b);
}

/********************************************/
/*	m_mul		MPA ans <-- MPA a * MPA b	*/
/********************************************/
int m_mul(MPA *ans, MPA *a, MPA *b)
{
	MPA c;
	int i, j, m, *r, *xp, u, v, exp;
	int x[NMPA2];
	char *p, *q;

	if (!ans || !a || !b) return -1;
	if (a->zero || b->zero) {
		*ans = _M0;
		return 0;
	}
  if (b->len==1 && ((v=b->num[0])==1 || v==10)) {
	c = *a;
  	if (v == 10) {
		m_mul_10(&c,1);
		exp = (int)c.exp + (int)b->exp;
	}
  }
  else if (a->len==1 && ((v=a->num[0])==1 || v==10)) {
  	c = *b;
  	if (v == 10) {
		m_mul_10(&c,1);
		exp = (int)a->exp + (int)c.exp;
	}
  }
  else {
	memset(x,0,sizeof(x));
	m = a->len + b->len - 1;
	if (m >= NMPA2) m = NMPA2 - 1;
	for (i=b->len-1, xp=x+m, p=b->num+i; i>=0; i--, xp--, p--) {
		if ((v = *p)) {
			j = a->len - 1;
			q = a->num + j;
			r = xp;
			if (v == 1) {
				while (j-- >= 0) *r-- += *q--;
			}
			else if (v == 2) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<1;
					r--;
				}
			}
			else if (v == 4) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<2;
					r--;
				}
			}
			else if (v == 8) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<3;
					r--;
				}
			}
			else if (v == 16) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<4;
					r--;
				}
			}
			else if (v == 32) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<5;
					r--;
				}
			}
			else if (v == 64) {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u<<6;
					r--;
				}
			}
			else {
				while (j-- >= 0) {
					u = *q--;
					if (u) *r += u * v;
					r--;
				}
			}
		}
	}
	c = _M0;
	i = m;
	xp = x + i;
	p = c.num + i;
	u = 0;
	while (i >= 0) {
		if (i == NMPA) u += 5;
		*xp += u;
		if (*xp >= RADIX) {
			u = *xp/RADIX;
			*xp %= RADIX;
		}
		else u = 0;
		if (i-- < NMPA) *p = *xp;
		p--;
		xp--;
	}
	if ((c.len=m+1) > NMPA1) c.len = NMPA1;
	exp = (int)a->exp + (int)b->exp + 1;
  }
	if (exp > MAXEXP) {
		*ans = _MMAX;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*ans = _M0;
		return MPA_ERR_UNDERFLOW;
	}
/*
	a->exp = exp;
*/
	c.zero = 0;
	c.sign = (a->sign == b->sign)? 0: 1;
	c.exp = exp;
/*	if ((c.len=m+1) > NMPA1) c.len = NMPA1;	*/
	*ans = c;
	return m_normalize(ans);
}

/********************************************/
/*	m_div		MPA ans <-- MPA a / MPA b	*/
/********************************************/
int m_div(MPA *ans, MPA *aa, MPA *bb)
{
	MPA c, a, b, md[RADIX];
	int d, i, exp, zmd[RADIX+1], anm, bnm;
	char *pcn;
	short sign;

	if (!ans || !aa || !bb) return -1;
	b = *bb;
	m_normalize(&b);
	if (b.zero)	{
		*ans = _MMAX;
		return MPA_ERR_ZERODIVIDE;
	}
	a = *aa;
	m_normalize(&a);
	if (a.zero)	{
		*ans = _M0;
		return 0;
	}
	c = _M0;
	c.zero = 0;
	sign = (a.sign == b.sign)? 0: 1;
	a.sign = b.sign = 0;

	exp = (int)a.exp - (int)b.exp;
	if (exp > MAXEXP) {
		*ans = _MMAX;
		ans->sign = sign;
		return MPA_ERR_OVERFLOW;
	}
	else if(exp < MINEXP) {
		*ans = _M0;
		ans->sign = sign;
		return MPA_ERR_UNDERFLOW;
	}

  if (b.len==1 && ((d=b.num[0])==1 || d==10)) {
  	c = a;
	c.exp = exp;
	if (d == 10) {
		m_mul_10(&c,-1);
		c.exp -= b.exp;
	}
  }
  else {
	memset(zmd,0,sizeof(zmd));
	bnm = b.num[0]*RADIX + b.num[1];
	c.exp = exp;
	a.exp = b.exp = 0;
	for (i=0,pcn=c.num;i<=NMPA;) {
/*
m_print("a",&a,0);
*/
		anm = a.num[0]*RADIX + a.num[1];
		if (a.exp == 1) anm = anm*RADIX + a.num[2];
		d = anm/bnm;
		if (d > 0) {
			while (d > 0) {
/*
printf("m_div: i=%d anm=%d bnm=%d d=%d\n",i,anm,bnm,d);
*/
				if (!zmd[d]) {
					if (d == 1) m_cpy(&md[d],&b,0);
					else if (d < RADIX) m_mul(&md[d],&b,m_get_i(d));
					else {
						m_cpy(&md[d],&b,0);
						md[d].exp++;
					}
					zmd[d] = 1;
/*
m_print("md[d]",&md[d],0);
*/
				}
				if (m_cmp(&a,&md[d]) >= 0) {
					m_sub1(&a,&md[d]);
					break;
				}
				d--;
			}
		}
		a.exp++;
		*pcn++ = d;
		i++;
		if (a.zero) break;
	}
	c.len = i;
  }
  	c.sign = sign;
	*ans = c;
	m_normalize(ans);
	return 0;
}

/********************************/
/*	m_mul1		MPA a *= MPA b	*/
/********************************/
int m_mul1(MPA *a, MPA *b)
{
	return m_mul(a,a,b);
}

/********************************/
/*	m_div1		MPA a /= MPA b	*/
/********************************/
int m_div1(MPA *a, MPA *b)
{
	return m_div(a,a,b);
}

/************************************/
/*	m_pack			DEC a <-- MPA b	*/
/************************************/
int m_pack(char *a, int precision, int scale, int opt, MPA *b)
{
	int i,size,pos,dsize,mode;
	char *pam,*pbm,c1,c2;
	MPA bb;
	MPA10W w;

	if (!a || !b) return -1;
	if (opt & AKX_MPA_IGNO_SCALE) return m_pack_size(a,precision,b);
	bb = *b;
	if ((i=m_scale(&bb,precision,scale,opt)) < 0) return i;
	m_100to10(&bb,&w);
	pos = precision - (w.exp + 1);
	if (scale > 0) pos -= scale;
	if (pos < 0) return -2;

	pam = a;
	pbm = w.num + 1;
	dsize = (precision+2)/2;
	memset(pam,0,dsize);
	if (!(precision % 2)) pos++;
	mode = pos % 2;
	pos >>= 1;
	pam += pos;
	c1 = 0;
	for (i=0;i<w.len;i++) {
		if (mode) {
			*pam++ = c1<<4 | *pbm++;
			mode = 0;
			pos++;
			if (pos >= dsize) return -3;
		}
		else {
			c1 = *pbm++;
			mode = 1;
		}
	}
	if (mode) *pam = c1<<4;
	if (bb.sign) c2 = 0x0d;
	else c2 = 0x0c;
	pam = a + dsize - 1;
	*pam |= c2;
	return dsize;
}

int m_pack_size(char *a, int dec_size, MPA *b)
{
	int i,len,size,ret,dsize;
	char *pam,*pbm,c1,c2;
	MPA10W w;

	if (!a || !b) return -1;
	m_100to10(b,&w);
	pam = a;
/*	pbm = b->num;	*/
	pbm = w.num + 1;
	size = w.len;
	len = size/2;
	ret = len + 1;
	if (dec_size > 0) {
		if (size > dec_size) return MPA_ERR_SIZE_OVER;
		dsize = dec_size/2 + 1;
		for (i=0;i<dsize-ret;i++) *pam++ = '\0';
	}
	else dsize = ret;
	if (!(size % 2)) {
		c1 = *pbm++;
		*pam++ = c1 & 0x0f;
		len--;
	}
	for (i=0;i<len;i++) {
		c1 = *pbm++;
		c2 = *pbm++;
		*pam++ = c1<<4 | (c2 & 0x0f);
	}
	c1 = *pbm;
	if (b->sign) c2 = 0x0d;
	else c2 = 0x0c;
	*pam = c1<<4 | (c2 & 0x0f);
	return dsize;
}

/************************************/
/*	m_unpack	MPA a <-- DEC b		*/
/************************************/
int m_unpack(MPA *a, char *b, int size, int scale)
{
	int i,len,a_len,a_exp;
	char *pam,*pbm,c,d;
	MPA10W w;

	if (!a || !b) return -1;
	*a = _M0;
/*	pam = a->num;	*/
	pam = w.num + 1;
	w.num[0] = '\0';
	pbm = b;
	len = size/2;
	if (!(size % 2)) {
		c = *pbm++;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		len--;
	}
	for (i=0;i<len;i++) {
		c = *pbm++;
		*pam++ = d = c>>4 & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
		*pam++ = d = c & 0x0f;
		if (d > 9) return MPA_ERR_INVALID;
	}
	c = *pbm;
	*pam = d = c>>4 & 0x0f;
	if (d > 9) return MPA_ERR_INVALID;
	c &= 0x0f;
	if (c == 0x0d) w.sign = 1;
	else if (c==0x0c || !c) w.sign = 0;
	else return -1;
	w.exp = size - scale - 1;
	w.len = size;
	w.zero = 0;
	m_10to100(a,&w);
	return m_normalize(a);
}

/********************************/
/*	m_mpa2d						*/
/********************************/
int m_mpa2d(MPA *a, double *dval)
{
	double d;
	int i,exp;
	char *p, *q;

	if (a->zero) {
		*dval = 0.0;
		return 0;
	}
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = (double)*p++;
	while (i-- > 0) {
		d = d * (double)RADIX + (double)*p++;
		exp--;
	}
	while (exp > 0) {
		d *= (double)RADIX;
		exp--;
	}
	while (exp < 0) {
		d /= (double)RADIX;
		exp++;
	}
	if (a->sign) d = -d;
	*dval = d;
	return 0;
}

int m_dset(double *dval, MPA *a)
{
	return m_mpa2d(a, dval);
}

/********************************/
/*	m_mpa2l						*/
/********************************/
int m_mpa2l(MPA *a, long *val)
{
	int ret, i, exp;
	long d;
	char *p,c;

	if (!a || !val) return -1;
	*val = 0;
	if (a->zero || a->exp < 0) return 0;
	exp = a->exp;
	p = a->num;
	i = a->len - 1;
	d = *p++;
	ret = 0;
	while (exp-- > 0) {
		d *= RADIX;
		if (i-- > 0) d += *p++;
		if (d < 0) {
			ret = MPA_ERR_OVERFLOW_I;
			break;
		}
	}
	if (ret) {
		if (a->sign) d = LONG_MIN;
		else d = LONG_MAX;
	}
	else if (a->sign) d = -d;
	*val = d;
	return ret;
}

/********************************/
/*	m_mpa2i						*/
/********************************/
int m_mpa2i(MPA *a, int *val)
{
	int ret;
	long l=0;

	ret = m_mpa2l(a,&l);
	*val = l;
	return ret;
}

/********************************/
/*	m_mpa2an					*/
/********************************/
int m_mpa2an(MPA *a, char *s, int len_s, int opt)
{
	char *p;
	int lens,exp,len,opt20,comma;
	char *pan,c;
	MPA10W w;
/*
m_print("m_mpa2an: ",a,0);
*/
	p = s;
	if (!a || !p) return -1;
	if ((lens=len_s) <= 0) return -1;
	lens--;
	if (a->zero) {
		if (opt&0x01) {
			if (lens > 0) {
				if (lens == 1) *p++ = '0';
				else if (lens >= 2) {
					*p++ = '.';
					*p++ = '0';
				}
			}
		}
		else {
			if (lens-- > 0) *p++ = '0';
			if ((opt&(0x02|0x04)) && lens-- > 0) *p++ = '.';
			if ((opt&0x04) && lens-- > 0) *p++ = '0';
		}
	}
	else {
		m_100to10(a,&w);
		if (w.sign && lens-- > 0) *p++ = '-';
		len = w.len;
		pan = w.num + 1;
		if ((exp=w.exp) < 0) {
			if (!(opt&0x01) && lens-- > 0) *p++ = '0';
			if (lens-- > 0) *p++ = '.';
			exp++;
			while (exp++ < 0 && lens-- > 0) *p++ = '0';
			while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
		}
		else {
			if (opt20 = opt & 0x20) {
				if (!(comma = (exp+1) % 3)) comma = 3;
			}
			while (exp-- >= 0 && lens-- > 0) {
				if (len > 0) {
					c = *pan++ + '0';
					len--;
				}
				else c = '0';
				*p++ = c;
				if (opt20) {
					comma--;
					if (comma <= 0) {
						*p++ = ',';
						lens--;
						comma = 3;
					}
				}
			}
			if (*(p-1) == ',') {
				p--;
				lens++;
			}
 			if ((len>0||(opt&(0x02|0x04))) && lens-- > 0) *p++ = '.';
			if (len > 0) {
				while (len-- > 0 && lens-- > 0) *p++ = *pan++ + '0';
			}
			else if ((opt&0x04) && lens>0) *p++ = '0';
		}
	}
	*p = '\0';
	return strlen(s);
}

/********************************/
/*	m_l2mpa						*/
/********************************/
int m_l2mpa(long val, MPA *a)
{
	long n;
	int  exp, len, w;
	char *p, *q;

	*a = _M0;
	if(!(n=val)) return 0;
	a->zero = 0;
	if (n < 0) {
		a->sign = 1;
		n = -n;
	}
	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX;
		n /= RADIX;
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	return m_normalize(a);
}

/********************************/
/*	m_d2mpa						*/
/********************************/
int m_d2mpa(double d, MPA *m)
{
	int i,exp;
	char *p;
	double a,a1;

	a = d;
	*m = _M0;
	if (a == 0.) return 0;
	m->zero = 0;
	if (a < 0.) {
		m->sign = 1;
		a = - a;
	}
	exp = 0;
	while (a >= (double)RADIX) {
		exp++;
		a /= (double)RADIX;
	}
	while (a < 1.) {
		exp--;
		a *= (double)RADIX;
	}
	p = m->num;
	i = 0;
	a1 = a * 1.0e-16;
/*
printf("m_d2mpa: a=%e\n",a);
*/
	do {
		i++;
		*p = (int)a;
		a -= (double)*p++;
/*
printf("m_d2mpa: i=%d a=%e\n",i,a);
*/
		if (a <= a1) break;
		a *= (double)RADIX;
	} while(a != 0. && i <= 8);	/* NMPA); */
	m->len = i;
	for (i++; i <= NMPA; i++) *p++ = 0;
	m->exp = exp;
	return m_normalize(m);
}

/********************************/
/*	m_scale						*/
/********************************/
int m_scale(MPA *mpa,int precision,int scale,int opt)
/* opt=0:ľܓ/1:؎̂/2:؏グ  */
{
	MPA p5;
	int pre_exp,i,sign,len,exp;
	char *p;
	MPA10W w,p5w;

	if (!mpa) return -1001;
	if (precision<=0 || precision>NMPA) return -1002;
	if (scale >= 0) {
		if (scale > precision) return -1003;
	}
	else {
		if (-scale >= precision) return -1004;
	}
	m_100to10(mpa,&w);
#if 1
	if (w.zero) {
		w.zero = 0;
		w.exp = -scale;
		w.len = 1;
		w.num[1] = '\0';
		m_10to100(mpa,&w);
		return 0;
	}
#else
	if (mpa->zero) return 0;
#endif
	if ((opt & 0x03) != 0x01) {
		memcpy(&p5,m_get_i(1),sizeof(MPA));
		p5.sign = w.sign;
		m_100to10(&p5,&p5w);
		if (opt & 0x02) {
			i = w.exp + 1 + scale;
			p = w.num + i;
			i = w.len - i;
			while (i-- > 0) {
				if (*p++) {
					p5w.exp = -scale;
					m_10to100(&p5,&p5w);
					m_add1(mpa,&p5);	/* ؏グ */
					break;
				}
			}
		}
		else {
			p5w.exp = -(scale+1);
			p5w.num[1] = 5;
			m_10to100(&p5,&p5w);
			if (w.exp >= p5w.exp) m_add1(mpa,&p5);	/* ľܓ */
		}
		if (mpa->zero)/* return 0;	*/
			return m_scale(mpa,precision,scale,0);
		m_100to10(mpa,&w);
	}
	pre_exp = precision - 1;
	if (scale > 0) pre_exp -= scale;
	exp = w.exp;
/*
printf("m_scale: exp=%d pre_exp=%d precision=%d scale=%d\n",exp,pre_exp,precision,scale);
*/
	if (exp > pre_exp) {
		sign = w.sign;
		memset(mpa,0,sizeof(MPA));
		w.exp = pre_exp;
		w.sign = sign;
		w.len = precision;
		memset(w.num+1,9,precision);
		m_10to100(mpa,&w);
		return MPA_ERR_OVERFLOW;
	}
	else if ((len=scale+exp+1) <= 0) {
		memcpy(mpa,m_get_i(0),sizeof(MPA));
		return m_scale(mpa,precision,scale,0);
	/*	return 12;	*/
	}
	else {
		i = w.len - len;
		if (i > 0) {
			p = w.num + 1 + len;
		}
		else if (i < 0) {
			p = w.num + 1 + mpa->len;
			i = -i;
		}
		w.len = len;
		while (i-- > 0) *p++ = 0;
	}
	m_10to100(mpa,&w);
	return 0;
}

/********************************/
/*	m_print						*/
/********************************/
void m_print(char *s, MPA *a, int _short)
{
	int i;
	char *p;

	printf("%s\n", s);
	printf("exp=%d zero=%d len =%d\n", a->exp, a->zero, a->len);
	if(a->sign)	putchar('-');
	else		putchar('+');
	for (i = 0, p = a->num; i <= NMPA; i++) {
		printf("%d ",*p++);
	}
	putchar('\n');
	return;
}

/********************************/
/*	m_ll2mpa					*/
/********************************/
int m_ll2mpa(off_t val, MPA *a)
{
	off_t n;
	int exp, len, w;
	long v[2], v1, v2;
	char *p, *q;

	if (sizeof(off_t) == sizeof(long)) return m_l2mpa(val,a);
	*a = _M0;
	if(!(n=val)) return 0;
	a->zero = 0;
	if (n < 0) {
		a->sign = 1;
		n = -n;
	}

	memcpy(v,&n,sizeof(off_t));
	if (1 == htonl(1)) {
		v1 = v[0];
		v2 = v[1];
	}
	else {
		v1 = v[1];
		v2 = v[0];
	}
	if (!v1) return m_l2mpa(v2,a);

	exp = len = 0;
	p = q = a->num;
	while (n) {
		*p++ = n % RADIX;
		n /= RADIX;
		exp++;
		len++;
	}
	exp--;
	p--;
	while(q < p) {
		w = *p;
		*p-- = *q;
		*q++ = w;
	}
	a->exp = exp;
	a->len = len;
	return m_normalize(a);
}

/********************************/
/*	m_is_mpa0					*/
/********************************/
int m_is_mpa0(MPA *a)
{
	if (!a) return 0;
	return a->zero;
}

/************************************/
/*	m_str2pack	DEC a <-- char b[]	*/
/************************************/
int m_str2pack(char *dec, int precision, int scale, int opt, char *s, int s_len0)
{
	char wrk[128],*p;
	int  len,lend,lens,s_len;
	MPA  a;

	if (!s || !dec) return -1;
	if ((s_len=s_len0)<=0 || precision<=0) return -2;
	if (scale >= 0) {
		if (scale > precision) return -3;
	}
	else {
		if (-scale >= precision) return -4;
	}
	ret = m_set_an_opt(&a,s,s_len,opt);
	if (ren >= 0) ret = m_pack(dec,precision,scale,opt,&a);
	return 0;
}

/************************************/
/*	_to_hex		char s[] <-- DEC b	*/
/************************************/
static int _to_hex(char *s, char *dec, int len)
{
	int i;
	char  *a;
	uchar c;

	a = s;
	for (i=0; i<len;i++) {
		c = (uchar)*dec++;
		*a++ = ((c >> 4) & 0x0f) + '0';
		*a++ = (c & 0x0f) + '0';
	}
	if (len > 0) {
		*(a-1) = (*(dec-1) & 0x0f) - 0x0c + 'C';
	}
	return len*2;
}
/************************************/
/*	m_pack2str	char a[] <-- DEC b	*/
/************************************/
int m_pack2str(char *s, int s_len0, char *dec, int precision, int scale)
{
	char wrk[128],*p;
	int  len,lend,lens,s_len;

	if (!s || !dec) return -1;
	if ((s_len=s_len0)<=0 || precision<=0) return -2;
	if (scale >= 0) {
		if (scale > precision) return -3;
	}
	else {
		if (-scale >= precision) return -4;
	}
	len = (precision+2)/2;
	len = _to_hex(wrk,dec,len);
	len--;
	lens = 0;
	if (wrk[len] == 'D') {
		*s++ = '-';
		lens++;
		s_len--;
	}
	p = wrk;
	if (!(precision % 2)) {
		p++;
		len--;
	}
	if (s_len < len) {
		p += (len-s_len);
		len = s_len;
	}
	lend = len;
	lens += lend;
	if (scale >0) lend -= scale;
	if (lend < 0) return -4;
	memcpy(s,p,lend);
	s += lend;
	if (scale >0) {
		*s++ = '.';
		lens++;
		memcpy(s,p+lend,scale);
		s += scale;
	}
	if (lens < s_len0) *s = '\0';
	return lens;
}
