/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import jp.sourceforge.users.yutang.omegat.plugin.htmlinexcel.VersionInfo;
import org.omegat.core.Core;

public class Setting {
    private static final String SETTINS_FILE_NAME = ".ini\\HTMLinExcel.ini";
    private static File settingsFile;
    private static final String HEC_AUTO_COVERSION_ENABLED = "autoConversionEnabled";
    private static final boolean HEC_AUTO_COVERSION_ENABLED_DEFAULT_VALUE = false;

    public static void open() {
        settingsFile = new File(Core.getProject().getProjectProperties().getProjectRoot(), SETTINS_FILE_NAME);
    }

    public static void close() {
        settingsFile = null;
    }

    public static boolean getEnabled() throws IOException {
        Properties properties = Setting.getProperties(settingsFile);
        return Setting.getBoolProperty(properties, HEC_AUTO_COVERSION_ENABLED);
    }

    public static void setEnabled(boolean newValue) throws IOException {
        Properties properties = Setting.getProperties(settingsFile);
        Setting.setBoolProperty(properties, HEC_AUTO_COVERSION_ENABLED, newValue);
        Setting.storeProperties(properties, settingsFile);
    }

    private static Properties getProperties(File file) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        Properties p = new Properties(Setting.createDefaultProperties());
        if (file.isFile()) {
            FileInputStream in = new FileInputStream(file);
            InputStreamReader r = new InputStreamReader((InputStream)in, "UTF-8");
            p.load(r);
            ((Reader)r).close();
        }
        return p;
    }

    private static boolean getBoolProperty(Properties properties, String key) {
        if (properties.containsKey(key)) {
            String value = properties.getProperty(key);
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private static void setBoolProperty(Properties properties, String key, boolean value) {
        properties.setProperty(key, String.valueOf(value));
    }

    private static Properties createDefaultProperties() {
        Properties p = new Properties();
        p.setProperty(HEC_AUTO_COVERSION_ENABLED, String.valueOf(false));
        return p;
    }

    private static void storeProperties(Properties properties, File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdir();
        }
        StringBuilder comment = new StringBuilder();
        comment.append("------------------------------------------------------------------------------\n");
        comment.append(" <auto-generated>\n");
        comment.append("     This code was generated by HTMLinExcel plugin.\n");
        comment.append("     Plugin Version:").append(VersionInfo.getVersionString()).append("\n");
        comment.append("\n");
        comment.append("     Changes to this file may cause incorrect behavior and will be lost if\n");
        comment.append("     the code is regenerated.\n");
        comment.append(" </auto-generated>\n");
        comment.append("------------------------------------------------------------------------------\n");
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        properties.store(wr, comment.toString());
        wr.close();
    }
}

