
#include <stdint.h>
#include <cstring>
#include <algorithm>

namespace {
/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */
/* Copyright 2012 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

  const char *ExpertEncoding[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "space", "exclamsmall", "Hungarumlautsmall", "", "dollaroldstyle",
    "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior",
    "parenrightsuperior", "twodotenleader", "onedotenleader", "comma",
    "hyphen", "period", "fraction", "zerooldstyle", "oneoldstyle",
    "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle",
    "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "colon",
    "semicolon", "commasuperior", "threequartersemdash", "periodsuperior",
    "questionsmall", "", "asuperior", "bsuperior", "centsuperior", "dsuperior",
    "esuperior", "", "", "isuperior", "", "", "lsuperior", "msuperior",
    "nsuperior", "osuperior", "", "", "rsuperior", "ssuperior", "tsuperior",
    "", "ff", "fi", "fl", "ffi", "ffl", "parenleftinferior", "",
    "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall",
    "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall",
    "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall",
    "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall",
    "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary",
    "onefitted", "rupiah", "Tildesmall", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "exclamdownsmall", "centoldstyle", "Lslashsmall",
    "", "", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall",
    "Caronsmall", "", "Dotaccentsmall", "", "", "Macronsmall", "", "",
    "figuredash", "hypheninferior", "", "", "Ogoneksmall", "Ringsmall",
    "Cedillasmall", "", "", "", "onequarter", "onehalf", "threequarters",
    "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths",
    "seveneighths", "onethird", "twothirds", "", "", "zerosuperior",
    "onesuperior", "twosuperior", "threesuperior", "foursuperior",
    "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior",
    "ninesuperior", "zeroinferior", "oneinferior", "twoinferior",
    "threeinferior", "fourinferior", "fiveinferior", "sixinferior",
    "seveninferior", "eightinferior", "nineinferior", "centinferior",
    "dollarinferior", "periodinferior", "commainferior", "Agravesmall",
    "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall",
    "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall",
    "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall",
    "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall",
    "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall",
    "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall",
    "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall",
	"Ydieresissmall"};

  const char *MacExpertEncoding[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "space", "exclamsmall", "Hungarumlautsmall", "centoldstyle",
    "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall",
    "parenleftsuperior", "parenrightsuperior", "twodotenleader",
    "onedotenleader", "comma", "hyphen", "period", "fraction", "zerooldstyle",
    "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle",
    "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle",
    "nineoldstyle", "colon", "semicolon", "", "threequartersemdash", "",
    "questionsmall", "", "", "", "", "Ethsmall", "", "", "onequarter",
    "onehalf", "threequarters", "oneeighth", "threeeighths", "fiveeighths",
    "seveneighths", "onethird", "twothirds", "", "", "", "", "", "", "ff",
    "fi", "fl", "ffi", "ffl", "parenleftinferior", "", "parenrightinferior",
    "Circumflexsmall", "hypheninferior", "Gravesmall", "Asmall", "Bsmall",
    "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall",
    "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall",
    "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall",
    "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah",
    "Tildesmall", "", "", "asuperior", "centsuperior", "", "", "", "",
    "Aacutesmall", "Agravesmall", "Acircumflexsmall", "Adieresissmall",
    "Atildesmall", "Aringsmall", "Ccedillasmall", "Eacutesmall", "Egravesmall",
    "Ecircumflexsmall", "Edieresissmall", "Iacutesmall", "Igravesmall",
    "Icircumflexsmall", "Idieresissmall", "Ntildesmall", "Oacutesmall",
    "Ogravesmall", "Ocircumflexsmall", "Odieresissmall", "Otildesmall",
    "Uacutesmall", "Ugravesmall", "Ucircumflexsmall", "Udieresissmall", "",
    "eightsuperior", "fourinferior", "threeinferior", "sixinferior",
    "eightinferior", "seveninferior", "Scaronsmall", "", "centinferior",
    "twoinferior", "", "Dieresissmall", "", "Caronsmall", "osuperior",
    "fiveinferior", "", "commainferior", "periodinferior", "Yacutesmall", "",
    "dollarinferior", "", "Thornsmall", "", "nineinferior", "zeroinferior",
    "Zcaronsmall", "AEsmall", "Oslashsmall", "questiondownsmall",
    "oneinferior", "Lslashsmall", "", "", "", "", "", "", "Cedillasmall", "",
    "", "", "", "", "OEsmall", "figuredash", "hyphensuperior", "", "", "", "",
    "exclamdownsmall", "", "Ydieresissmall", "", "onesuperior", "twosuperior",
    "threesuperior", "foursuperior", "fivesuperior", "sixsuperior",
    "sevensuperior", "ninesuperior", "zerosuperior", "", "esuperior",
    "rsuperior", "tsuperior", "", "", "isuperior", "ssuperior", "dsuperior",
    "", "", "", "", "", "lsuperior", "Ogoneksmall", "Brevesmall",
    "Macronsmall", "bsuperior", "nsuperior", "msuperior", "commasuperior",
	"periodsuperior", "Dotaccentsmall", "Ringsmall"};

  const char *MacRomanEncoding[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "space", "exclam", "quotedbl", "numbersign", "dollar", "percent",
    "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus",
    "comma", "hyphen", "period", "slash", "zero", "one", "two", "three",
    "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon",
    "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F",
    "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
    "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright",
    "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g",
    "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
    "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "",
    "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis",
    "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde",
    "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis",
    "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute",
    "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave",
    "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling",
    "section", "bullet", "paragraph", "germandbls", "registered", "copyright",
    "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity",
    "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff",
    "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine",
    "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot",
    "radical", "florin", "approxequal", "Delta", "guillemotleft",
    "guillemotright", "ellipsis", "", "Agrave", "Atilde", "Otilde", "OE",
    "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft",
    "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction",
    "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl",
    "periodcentered", "quotesinglbase", "quotedblbase", "perthousand",
    "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute",
    "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple",
    "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex",
    "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut",
	"ogonek", "caron"};

  const char *StandardEncoding[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "space", "exclam", "quotedbl", "numbersign", "dollar", "percent",
    "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus",
    "comma", "hyphen", "period", "slash", "zero", "one", "two", "three",
    "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon",
    "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F",
    "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
    "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright",
    "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f",
    "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u",
    "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "exclamdown",
    "cent", "sterling", "fraction", "yen", "florin", "section", "currency",
    "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft",
    "guilsinglright", "fi", "fl", "", "endash", "dagger", "daggerdbl",
    "periodcentered", "", "paragraph", "bullet", "quotesinglbase",
    "quotedblbase", "quotedblright", "guillemotright", "ellipsis",
    "perthousand", "", "questiondown", "", "grave", "acute", "circumflex",
    "tilde", "macron", "breve", "dotaccent", "dieresis", "", "ring", "cedilla",
    "", "hungarumlaut", "ogonek", "caron", "emdash", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "AE", "", "ordfeminine", "", "",
    "", "", "Lslash", "Oslash", "OE", "ordmasculine", "", "", "", "", "", "ae",
	"", "", "", "dotlessi", "", "", "lslash", "oslash", "oe", "germandbls"};

  const char *WinAnsiEncoding[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "space", "exclam", "quotedbl", "numbersign", "dollar", "percent",
    "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus",
    "comma", "hyphen", "period", "slash", "zero", "one", "two", "three",
    "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon",
    "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F",
    "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
    "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright",
    "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g",
    "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v",
    "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde",
    "bullet", "Euro", "bullet", "quotesinglbase", "florin", "quotedblbase",
    "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron",
    "guilsinglleft", "OE", "bullet", "Zcaron", "bullet", "bullet", "quoteleft",
    "quoteright", "quotedblleft", "quotedblright", "bullet", "endash",
    "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", "bullet",
    "zcaron", "Ydieresis", "", "exclamdown", "cent", "sterling",
    "currency", "yen", "brokenbar", "section", "dieresis", "copyright",
    "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered",
    "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute",
    "mu", "paragraph", "periodcentered", "cedilla", "onesuperior",
    "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters",
    "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis",
    "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis",
    "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve",
    "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash",
    "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn",
    "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis",
    "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis",
    "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve",
    "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash",
    "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn",
	"ydieresis"};

  const char *SymbolSetEncoding[] = {"", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "space", "exclam", "universal", "numbersign", "existential", "percent",
    "ampersand", "suchthat", "parenleft", "parenright", "asteriskmath", "plus",
    "comma", "minus", "period", "slash", "zero", "one", "two", "three", "four",
    "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less",
    "equal", "greater", "question", "congruent", "Alpha", "Beta", "Chi",
    "Delta", "Epsilon", "Phi", "Gamma", "Eta", "Iota", "theta1", "Kappa",
    "Lambda", "Mu", "Nu", "Omicron", "Pi", "Theta", "Rho", "Sigma", "Tau",
    "Upsilon", "sigma1", "Omega", "Xi", "Psi", "Zeta", "bracketleft",
    "therefore", "bracketright", "perpendicular", "underscore", "radicalex",
    "alpha", "beta", "chi", "delta", "epsilon", "phi", "gamma", "eta", "iota",
    "phi1", "kappa", "lambda", "mu", "nu", "omicron", "pi", "theta", "rho",
    "sigma", "tau", "upsilon", "omega1", "omega", "xi", "psi", "zeta",
    "braceleft", "bar", "braceright", "similar", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
    "", "", "", "", "", "", "", "Euro", "Upsilon1", "minute", "lessequal",
    "fraction", "infinity", "florin", "club", "diamond", "heart", "spade",
    "arrowboth", "arrowleft", "arrowup", "arrowright", "arrowdown", "degree",
    "plusminus", "second", "greaterequal", "multiply", "proportional",
    "partialdiff", "bullet", "divide", "notequal", "equivalence",
    "approxequal", "ellipsis", "arrowvertex", "arrowhorizex", "carriagereturn",
    "aleph", "Ifraktur", "Rfraktur", "weierstrass", "circlemultiply",
    "circleplus", "emptyset", "intersection", "union", "propersuperset",
    "reflexsuperset", "notsubset", "propersubset", "reflexsubset", "element",
    "notelement", "angle", "gradient", "registerserif", "copyrightserif",
    "trademarkserif", "product", "radical", "dotmath", "logicalnot",
    "logicaland", "logicalor", "arrowdblboth", "arrowdblleft", "arrowdblup",
    "arrowdblright", "arrowdbldown", "lozenge", "angleleft", "registersans",
    "copyrightsans", "trademarksans", "summation", "parenlefttp",
    "parenleftex", "parenleftbt", "bracketlefttp", "bracketleftex",
    "bracketleftbt", "bracelefttp", "braceleftmid", "braceleftbt", "braceex",
    "", "angleright", "integral", "integraltp", "integralex", "integralbt",
    "parenrighttp", "parenrightex", "parenrightbt", "bracketrighttp",
    "bracketrightex", "bracketrightbt", "bracerighttp", "bracerightmid",
	"bracerightbt"};
	
	
// The normalization table is obtained by filtering the Unicode characters
// database with <compat> entries.
struct NormalizedUnicode{
	uint16_t src;
	uint16_t dest[8];
	bool operator < (const NormalizedUnicode &rhs){
		return (src < rhs.src);
	}
} NormalizedUnicodes[] = {
	0x00A8, {0x0020, 0x0308, 0},
	0x00AF, {0x0020, 0x0304, 0},
	0x00B4, {0x0020, 0x0301, 0},
	0x00B5, {0x03BC, 0},
	0x00B8, {0x0020, 0x0327, 0},
	0x0132, {0x0049, 0x004A, 0},
	0x0133, {0x0069, 0x006A, 0},
	0x013F, {0x004C, 0x00B7, 0},
	0x0140, {0x006C, 0x00B7, 0},
	0x0149, {0x02BC, 0x006E, 0},
	0x017F, {0x0073, 0},
	0x01C4, {0x0044, 0x017D, 0},
	0x01C5, {0x0044, 0x017E, 0},
	0x01C6, {0x0064, 0x017E, 0},
	0x01C7, {0x004C, 0x004A, 0},
	0x01C8, {0x004C, 0x006A, 0},
	0x01C9, {0x006C, 0x006A, 0},
	0x01CA, {0x004E, 0x004A, 0},
	0x01CB, {0x004E, 0x006A, 0},
	0x01CC, {0x006E, 0x006A, 0},
	0x01F1, {0x0044, 0x005A, 0},
	0x01F2, {0x0044, 0x007A, 0},
	0x01F3, {0x0064, 0x007A, 0},
	0x02D8, {0x0020, 0x0306, 0},
	0x02D9, {0x0020, 0x0307, 0},
	0x02DA, {0x0020, 0x030A, 0},
	0x02DB, {0x0020, 0x0328, 0},
	0x02DC, {0x0020, 0x0303, 0},
	0x02DD, {0x0020, 0x030B, 0},
	0x037A, {0x0020, 0x0345, 0},
	0x0384, {0x0020, 0x0301, 0},
	0x03D0, {0x03B2, 0},
	0x03D1, {0x03B8, 0},
	0x03D2, {0x03A5, 0},
	0x03D5, {0x03C6, 0},
	0x03D6, {0x03C0, 0},
	0x03F0, {0x03BA, 0},
	0x03F1, {0x03C1, 0},
	0x03F2, {0x03C2, 0},
	0x03F4, {0x0398, 0},
	0x03F5, {0x03B5, 0},
	0x03F9, {0x03A3, 0},
	0x0587, {0x0565, 0x0582, 0},
	0x0675, {0x0627, 0x0674, 0},
	0x0676, {0x0648, 0x0674, 0},
	0x0677, {0x06C7, 0x0674, 0},
	0x0678, {0x064A, 0x0674, 0},
	0x0E33, {0x0E4D, 0x0E32, 0},
	0x0EB3, {0x0ECD, 0x0EB2, 0},
	0x0EDC, {0x0EAB, 0x0E99, 0},
	0x0EDD, {0x0EAB, 0x0EA1, 0},
	0x0F77, {0x0FB2, 0x0F81, 0},
	0x0F79, {0x0FB3, 0x0F81, 0},
	0x1E9A, {0x0061, 0x02BE, 0},
	0x1FBD, {0x0020, 0x0313, 0},
	0x1FBF, {0x0020, 0x0313, 0},
	0x1FC0, {0x0020, 0x0342, 0},
	0x1FFE, {0x0020, 0x0314, 0},
	0x2002, {0x0020, 0},
	0x2003, {0x0020, 0},
	0x2004, {0x0020, 0},
	0x2005, {0x0020, 0},
	0x2006, {0x0020, 0},
	0x2008, {0x0020, 0},
	0x2009, {0x0020, 0},
	0x200A, {0x0020, 0},
	0x2017, {0x0020, 0x0333, 0},
	0x2024, {0x002E, 0},
	0x2025, {0x002E, 0x002E, 0},
	0x2026, {0x002E, 0x002E, 0x002E, 0},
	0x2033, {0x2032, 0x2032, 0},
	0x2034, {0x2032, 0x2032, 0x2032, 0},
	0x2036, {0x2035, 0x2035, 0},
	0x2037, {0x2035, 0x2035, 0x2035, 0},
	0x203C, {0x0021, 0x0021, 0},
	0x203E, {0x0020, 0x0305, 0},
	0x2047, {0x003F, 0x003F, 0},
	0x2048, {0x003F, 0x0021, 0},
	0x2049, {0x0021, 0x003F, 0},
	0x2057, {0x2032, 0x2032, 0x2032, 0x2032, 0},
	0x205F, {0x0020, 0},
	0x20A8, {0x0052, 0x0073, 0},
	0x2100, {0x0061, 0x002F, 0x0063, 0},
	0x2101, {0x0061, 0x002F, 0x0073, 0},
	0x2103, {0x00B0, 0x0043, 0},
	0x2105, {0x0063, 0x002F, 0x006F, 0},
	0x2106, {0x0063, 0x002F, 0x0075, 0},
	0x2107, {0x0190, 0},
	0x2109, {0x00B0, 0x0046, 0},
	0x2116, {0x004E, 0x006F, 0},
	0x2121, {0x0054, 0x0045, 0x004C, 0},
	0x2135, {0x05D0, 0},
	0x2136, {0x05D1, 0},
	0x2137, {0x05D2, 0},
	0x2138, {0x05D3, 0},
	0x213B, {0x0046, 0x0041, 0x0058, 0},
	0x2160, {0x0049, 0},
	0x2161, {0x0049, 0x0049, 0},
	0x2162, {0x0049, 0x0049, 0x0049, 0},
	0x2163, {0x0049, 0x0056, 0},
	0x2164, {0x0056, 0},
	0x2165, {0x0056, 0x0049, 0},
	0x2166, {0x0056, 0x0049, 0x0049, 0},
	0x2167, {0x0056, 0x0049, 0x0049, 0x0049, 0},
	0x2168, {0x0049, 0x0058, 0},
	0x2169, {0x0058, 0},
	0x216A, {0x0058, 0x0049, 0},
	0x216B, {0x0058, 0x0049, 0x0049, 0},
	0x216C, {0x004C, 0},
	0x216D, {0x0043, 0},
	0x216E, {0x0044, 0},
	0x216F, {0x004D, 0},
	0x2170, {0x0069, 0},
	0x2171, {0x0069, 0x0069, 0},
	0x2172, {0x0069, 0x0069, 0x0069, 0},
	0x2173, {0x0069, 0x0076, 0},
	0x2174, {0x0076, 0},
	0x2175, {0x0076, 0x0069, 0},
	0x2176, {0x0076, 0x0069, 0x0069, 0},
	0x2177, {0x0076, 0x0069, 0x0069, 0x0069, 0},
	0x2178, {0x0069, 0x0078, 0},
	0x2179, {0x0078, 0},
	0x217A, {0x0078, 0x0069, 0},
	0x217B, {0x0078, 0x0069, 0x0069, 0},
	0x217C, {0x006C, 0},
	0x217D, {0x0063, 0},
	0x217E, {0x0064, 0},
	0x217F, {0x006D, 0},
	0x222C, {0x222B, 0x222B, 0},
	0x222D, {0x222B, 0x222B, 0x222B, 0},
	0x222F, {0x222E, 0x222E, 0},
	0x2230, {0x222E, 0x222E, 0x222E, 0},
	0x2474, {0x0028, 0x0031, 0x0029, 0},
	0x2475, {0x0028, 0x0032, 0x0029, 0},
	0x2476, {0x0028, 0x0033, 0x0029, 0},
	0x2477, {0x0028, 0x0034, 0x0029, 0},
	0x2478, {0x0028, 0x0035, 0x0029, 0},
	0x2479, {0x0028, 0x0036, 0x0029, 0},
	0x247A, {0x0028, 0x0037, 0x0029, 0},
	0x247B, {0x0028, 0x0038, 0x0029, 0},
	0x247C, {0x0028, 0x0039, 0x0029, 0},
	0x247D, {0x0028, 0x0031, 0x0030, 0x0029, 0},
	0x247E, {0x0028, 0x0031, 0x0031, 0x0029, 0},
	0x247F, {0x0028, 0x0031, 0x0032, 0x0029, 0},
	0x2480, {0x0028, 0x0031, 0x0033, 0x0029, 0},
	0x2481, {0x0028, 0x0031, 0x0034, 0x0029, 0},
	0x2482, {0x0028, 0x0031, 0x0035, 0x0029, 0},
	0x2483, {0x0028, 0x0031, 0x0036, 0x0029, 0},
	0x2484, {0x0028, 0x0031, 0x0037, 0x0029, 0},
	0x2485, {0x0028, 0x0031, 0x0038, 0x0029, 0},
	0x2486, {0x0028, 0x0031, 0x0039, 0x0029, 0},
	0x2487, {0x0028, 0x0032, 0x0030, 0x0029, 0},
	0x2488, {0x0031, 0x002E, 0},
	0x2489, {0x0032, 0x002E, 0},
	0x248A, {0x0033, 0x002E, 0},
	0x248B, {0x0034, 0x002E, 0},
	0x248C, {0x0035, 0x002E, 0},
	0x248D, {0x0036, 0x002E, 0},
	0x248E, {0x0037, 0x002E, 0},
	0x248F, {0x0038, 0x002E, 0},
	0x2490, {0x0039, 0x002E, 0},
	0x2491, {0x0031, 0x0030, 0x002E, 0},
	0x2492, {0x0031, 0x0031, 0x002E, 0},
	0x2493, {0x0031, 0x0032, 0x002E, 0},
	0x2494, {0x0031, 0x0033, 0x002E, 0},
	0x2495, {0x0031, 0x0034, 0x002E, 0},
	0x2496, {0x0031, 0x0035, 0x002E, 0},
	0x2497, {0x0031, 0x0036, 0x002E, 0},
	0x2498, {0x0031, 0x0037, 0x002E, 0},
	0x2499, {0x0031, 0x0038, 0x002E, 0},
	0x249A, {0x0031, 0x0039, 0x002E, 0},
	0x249B, {0x0032, 0x0030, 0x002E, 0},
	0x249C, {0x0028, 0x0061, 0x0029, 0},
	0x249D, {0x0028, 0x0062, 0x0029, 0},
	0x249E, {0x0028, 0x0063, 0x0029, 0},
	0x249F, {0x0028, 0x0064, 0x0029, 0},
	0x24A0, {0x0028, 0x0065, 0x0029, 0},
	0x24A1, {0x0028, 0x0066, 0x0029, 0},
	0x24A2, {0x0028, 0x0067, 0x0029, 0},
	0x24A3, {0x0028, 0x0068, 0x0029, 0},
	0x24A4, {0x0028, 0x0069, 0x0029, 0},
	0x24A5, {0x0028, 0x006A, 0x0029, 0},
	0x24A6, {0x0028, 0x006B, 0x0029, 0},
	0x24A7, {0x0028, 0x006C, 0x0029, 0},
	0x24A8, {0x0028, 0x006D, 0x0029, 0},
	0x24A9, {0x0028, 0x006E, 0x0029, 0},
	0x24AA, {0x0028, 0x006F, 0x0029, 0},
	0x24AB, {0x0028, 0x0070, 0x0029, 0},
	0x24AC, {0x0028, 0x0071, 0x0029, 0},
	0x24AD, {0x0028, 0x0072, 0x0029, 0},
	0x24AE, {0x0028, 0x0073, 0x0029, 0},
	0x24AF, {0x0028, 0x0074, 0x0029, 0},
	0x24B0, {0x0028, 0x0075, 0x0029, 0},
	0x24B1, {0x0028, 0x0076, 0x0029, 0},
	0x24B2, {0x0028, 0x0077, 0x0029, 0},
	0x24B3, {0x0028, 0x0078, 0x0029, 0},
	0x24B4, {0x0028, 0x0079, 0x0029, 0},
	0x24B5, {0x0028, 0x007A, 0x0029, 0},
	0x2A0C, {0x222B, 0x222B, 0x222B, 0x222B, 0},
	0x2A74, {0x003A, 0x003A, 0x003D, 0},
	0x2A75, {0x003D, 0x003D, 0},
	0x2A76, {0x003D, 0x003D, 0x003D, 0},
	0x2E9F, {0x6BCD, 0},
	0x2EF3, {0x9F9F, 0},
	0x2F00, {0x4E00, 0},
	0x2F01, {0x4E28, 0},
	0x2F02, {0x4E36, 0},
	0x2F03, {0x4E3F, 0},
	0x2F04, {0x4E59, 0},
	0x2F05, {0x4E85, 0},
	0x2F06, {0x4E8C, 0},
	0x2F07, {0x4EA0, 0},
	0x2F08, {0x4EBA, 0},
	0x2F09, {0x513F, 0},
	0x2F0A, {0x5165, 0},
	0x2F0B, {0x516B, 0},
	0x2F0C, {0x5182, 0},
	0x2F0D, {0x5196, 0},
	0x2F0E, {0x51AB, 0},
	0x2F0F, {0x51E0, 0},
	0x2F10, {0x51F5, 0},
	0x2F11, {0x5200, 0},
	0x2F12, {0x529B, 0},
	0x2F13, {0x52F9, 0},
	0x2F14, {0x5315, 0},
	0x2F15, {0x531A, 0},
	0x2F16, {0x5338, 0},
	0x2F17, {0x5341, 0},
	0x2F18, {0x535C, 0},
	0x2F19, {0x5369, 0},
	0x2F1A, {0x5382, 0},
	0x2F1B, {0x53B6, 0},
	0x2F1C, {0x53C8, 0},
	0x2F1D, {0x53E3, 0},
	0x2F1E, {0x56D7, 0},
	0x2F1F, {0x571F, 0},
	0x2F20, {0x58EB, 0},
	0x2F21, {0x5902, 0},
	0x2F22, {0x590A, 0},
	0x2F23, {0x5915, 0},
	0x2F24, {0x5927, 0},
	0x2F25, {0x5973, 0},
	0x2F26, {0x5B50, 0},
	0x2F27, {0x5B80, 0},
	0x2F28, {0x5BF8, 0},
	0x2F29, {0x5C0F, 0},
	0x2F2A, {0x5C22, 0},
	0x2F2B, {0x5C38, 0},
	0x2F2C, {0x5C6E, 0},
	0x2F2D, {0x5C71, 0},
	0x2F2E, {0x5DDB, 0},
	0x2F2F, {0x5DE5, 0},
	0x2F30, {0x5DF1, 0},
	0x2F31, {0x5DFE, 0},
	0x2F32, {0x5E72, 0},
	0x2F33, {0x5E7A, 0},
	0x2F34, {0x5E7F, 0},
	0x2F35, {0x5EF4, 0},
	0x2F36, {0x5EFE, 0},
	0x2F37, {0x5F0B, 0},
	0x2F38, {0x5F13, 0},
	0x2F39, {0x5F50, 0},
	0x2F3A, {0x5F61, 0},
	0x2F3B, {0x5F73, 0},
	0x2F3C, {0x5FC3, 0},
	0x2F3D, {0x6208, 0},
	0x2F3E, {0x6236, 0},
	0x2F3F, {0x624B, 0},
	0x2F40, {0x652F, 0},
	0x2F41, {0x6534, 0},
	0x2F42, {0x6587, 0},
	0x2F43, {0x6597, 0},
	0x2F44, {0x65A4, 0},
	0x2F45, {0x65B9, 0},
	0x2F46, {0x65E0, 0},
	0x2F47, {0x65E5, 0},
	0x2F48, {0x66F0, 0},
	0x2F49, {0x6708, 0},
	0x2F4A, {0x6728, 0},
	0x2F4B, {0x6B20, 0},
	0x2F4C, {0x6B62, 0},
	0x2F4D, {0x6B79, 0},
	0x2F4E, {0x6BB3, 0},
	0x2F4F, {0x6BCB, 0},
	0x2F50, {0x6BD4, 0},
	0x2F51, {0x6BDB, 0},
	0x2F52, {0x6C0F, 0},
	0x2F53, {0x6C14, 0},
	0x2F54, {0x6C34, 0},
	0x2F55, {0x706B, 0},
	0x2F56, {0x722A, 0},
	0x2F57, {0x7236, 0},
	0x2F58, {0x723B, 0},
	0x2F59, {0x723F, 0},
	0x2F5A, {0x7247, 0},
	0x2F5B, {0x7259, 0},
	0x2F5C, {0x725B, 0},
	0x2F5D, {0x72AC, 0},
	0x2F5E, {0x7384, 0},
	0x2F5F, {0x7389, 0},
	0x2F60, {0x74DC, 0},
	0x2F61, {0x74E6, 0},
	0x2F62, {0x7518, 0},
	0x2F63, {0x751F, 0},
	0x2F64, {0x7528, 0},
	0x2F65, {0x7530, 0},
	0x2F66, {0x758B, 0},
	0x2F67, {0x7592, 0},
	0x2F68, {0x7676, 0},
	0x2F69, {0x767D, 0},
	0x2F6A, {0x76AE, 0},
	0x2F6B, {0x76BF, 0},
	0x2F6C, {0x76EE, 0},
	0x2F6D, {0x77DB, 0},
	0x2F6E, {0x77E2, 0},
	0x2F6F, {0x77F3, 0},
	0x2F70, {0x793A, 0},
	0x2F71, {0x79B8, 0},
	0x2F72, {0x79BE, 0},
	0x2F73, {0x7A74, 0},
	0x2F74, {0x7ACB, 0},
	0x2F75, {0x7AF9, 0},
	0x2F76, {0x7C73, 0},
	0x2F77, {0x7CF8, 0},
	0x2F78, {0x7F36, 0},
	0x2F79, {0x7F51, 0},
	0x2F7A, {0x7F8A, 0},
	0x2F7B, {0x7FBD, 0},
	0x2F7C, {0x8001, 0},
	0x2F7D, {0x800C, 0},
	0x2F7E, {0x8012, 0},
	0x2F7F, {0x8033, 0},
	0x2F80, {0x807F, 0},
	0x2F81, {0x8089, 0},
	0x2F82, {0x81E3, 0},
	0x2F83, {0x81EA, 0},
	0x2F84, {0x81F3, 0},
	0x2F85, {0x81FC, 0},
	0x2F86, {0x820C, 0},
	0x2F87, {0x821B, 0},
	0x2F88, {0x821F, 0},
	0x2F89, {0x826E, 0},
	0x2F8A, {0x8272, 0},
	0x2F8B, {0x8278, 0},
	0x2F8C, {0x864D, 0},
	0x2F8D, {0x866B, 0},
	0x2F8E, {0x8840, 0},
	0x2F8F, {0x884C, 0},
	0x2F90, {0x8863, 0},
	0x2F91, {0x897E, 0},
	0x2F92, {0x898B, 0},
	0x2F93, {0x89D2, 0},
	0x2F94, {0x8A00, 0},
	0x2F95, {0x8C37, 0},
	0x2F96, {0x8C46, 0},
	0x2F97, {0x8C55, 0},
	0x2F98, {0x8C78, 0},
	0x2F99, {0x8C9D, 0},
	0x2F9A, {0x8D64, 0},
	0x2F9B, {0x8D70, 0},
	0x2F9C, {0x8DB3, 0},
	0x2F9D, {0x8EAB, 0},
	0x2F9E, {0x8ECA, 0},
	0x2F9F, {0x8F9B, 0},
	0x2FA0, {0x8FB0, 0},
	0x2FA1, {0x8FB5, 0},
	0x2FA2, {0x9091, 0},
	0x2FA3, {0x9149, 0},
	0x2FA4, {0x91C6, 0},
	0x2FA5, {0x91CC, 0},
	0x2FA6, {0x91D1, 0},
	0x2FA7, {0x9577, 0},
	0x2FA8, {0x9580, 0},
	0x2FA9, {0x961C, 0},
	0x2FAA, {0x96B6, 0},
	0x2FAB, {0x96B9, 0},
	0x2FAC, {0x96E8, 0},
	0x2FAD, {0x9751, 0},
	0x2FAE, {0x975E, 0},
	0x2FAF, {0x9762, 0},
	0x2FB0, {0x9769, 0},
	0x2FB1, {0x97CB, 0},
	0x2FB2, {0x97ED, 0},
	0x2FB3, {0x97F3, 0},
	0x2FB4, {0x9801, 0},
	0x2FB5, {0x98A8, 0},
	0x2FB6, {0x98DB, 0},
	0x2FB7, {0x98DF, 0},
	0x2FB8, {0x9996, 0},
	0x2FB9, {0x9999, 0},
	0x2FBA, {0x99AC, 0},
	0x2FBB, {0x9AA8, 0},
	0x2FBC, {0x9AD8, 0},
	0x2FBD, {0x9ADF, 0},
	0x2FBE, {0x9B25, 0},
	0x2FBF, {0x9B2F, 0},
	0x2FC0, {0x9B32, 0},
	0x2FC1, {0x9B3C, 0},
	0x2FC2, {0x9B5A, 0},
	0x2FC3, {0x9CE5, 0},
	0x2FC4, {0x9E75, 0},
	0x2FC5, {0x9E7F, 0},
	0x2FC6, {0x9EA5, 0},
	0x2FC7, {0x9EBB, 0},
	0x2FC8, {0x9EC3, 0},
	0x2FC9, {0x9ECD, 0},
	0x2FCA, {0x9ED1, 0},
	0x2FCB, {0x9EF9, 0},
	0x2FCC, {0x9EFD, 0},
	0x2FCD, {0x9F0E, 0},
	0x2FCE, {0x9F13, 0},
	0x2FCF, {0x9F20, 0},
	0x2FD0, {0x9F3B, 0},
	0x2FD1, {0x9F4A, 0},
	0x2FD2, {0x9F52, 0},
	0x2FD3, {0x9F8D, 0},
	0x2FD4, {0x9F9C, 0},
	0x2FD5, {0x9FA0, 0},
	0x3036, {0x3012, 0},
	0x3038, {0x5341, 0},
	0x3039, {0x5344, 0},
	0x303A, {0x5345, 0},
	0x309B, {0x0020, 0x3099, 0},
	0x309C, {0x0020, 0x309A, 0},
	0x3131, {0x1100, 0},
	0x3132, {0x1101, 0},
	0x3133, {0x11AA, 0},
	0x3134, {0x1102, 0},
	0x3135, {0x11AC, 0},
	0x3136, {0x11AD, 0},
	0x3137, {0x1103, 0},
	0x3138, {0x1104, 0},
	0x3139, {0x1105, 0},
	0x313A, {0x11B0, 0},
	0x313B, {0x11B1, 0},
	0x313C, {0x11B2, 0},
	0x313D, {0x11B3, 0},
	0x313E, {0x11B4, 0},
	0x313F, {0x11B5, 0},
	0x3140, {0x111A, 0},
	0x3141, {0x1106, 0},
	0x3142, {0x1107, 0},
	0x3143, {0x1108, 0},
	0x3144, {0x1121, 0},
	0x3145, {0x1109, 0},
	0x3146, {0x110A, 0},
	0x3147, {0x110B, 0},
	0x3148, {0x110C, 0},
	0x3149, {0x110D, 0},
	0x314A, {0x110E, 0},
	0x314B, {0x110F, 0},
	0x314C, {0x1110, 0},
	0x314D, {0x1111, 0},
	0x314E, {0x1112, 0},
	0x314F, {0x1161, 0},
	0x3150, {0x1162, 0},
	0x3151, {0x1163, 0},
	0x3152, {0x1164, 0},
	0x3153, {0x1165, 0},
	0x3154, {0x1166, 0},
	0x3155, {0x1167, 0},
	0x3156, {0x1168, 0},
	0x3157, {0x1169, 0},
	0x3158, {0x116A, 0},
	0x3159, {0x116B, 0},
	0x315A, {0x116C, 0},
	0x315B, {0x116D, 0},
	0x315C, {0x116E, 0},
	0x315D, {0x116F, 0},
	0x315E, {0x1170, 0},
	0x315F, {0x1171, 0},
	0x3160, {0x1172, 0},
	0x3161, {0x1173, 0},
	0x3162, {0x1174, 0},
	0x3163, {0x1175, 0},
	0x3164, {0x1160, 0},
	0x3165, {0x1114, 0},
	0x3166, {0x1115, 0},
	0x3167, {0x11C7, 0},
	0x3168, {0x11C8, 0},
	0x3169, {0x11CC, 0},
	0x316A, {0x11CE, 0},
	0x316B, {0x11D3, 0},
	0x316C, {0x11D7, 0},
	0x316D, {0x11D9, 0},
	0x316E, {0x111C, 0},
	0x316F, {0x11DD, 0},
	0x3170, {0x11DF, 0},
	0x3171, {0x111D, 0},
	0x3172, {0x111E, 0},
	0x3173, {0x1120, 0},
	0x3174, {0x1122, 0},
	0x3175, {0x1123, 0},
	0x3176, {0x1127, 0},
	0x3177, {0x1129, 0},
	0x3178, {0x112B, 0},
	0x3179, {0x112C, 0},
	0x317A, {0x112D, 0},
	0x317B, {0x112E, 0},
	0x317C, {0x112F, 0},
	0x317D, {0x1132, 0},
	0x317E, {0x1136, 0},
	0x317F, {0x1140, 0},
	0x3180, {0x1147, 0},
	0x3181, {0x114C, 0},
	0x3182, {0x11F1, 0},
	0x3183, {0x11F2, 0},
	0x3184, {0x1157, 0},
	0x3185, {0x1158, 0},
	0x3186, {0x1159, 0},
	0x3187, {0x1184, 0},
	0x3188, {0x1185, 0},
	0x3189, {0x1188, 0},
	0x318A, {0x1191, 0},
	0x318B, {0x1192, 0},
	0x318C, {0x1194, 0},
	0x318D, {0x119E, 0},
	0x318E, {0x11A1, 0},
	0x3200, {0x0028, 0x1100, 0x0029, 0},
	0x3201, {0x0028, 0x1102, 0x0029, 0},
	0x3202, {0x0028, 0x1103, 0x0029, 0},
	0x3203, {0x0028, 0x1105, 0x0029, 0},
	0x3204, {0x0028, 0x1106, 0x0029, 0},
	0x3205, {0x0028, 0x1107, 0x0029, 0},
	0x3206, {0x0028, 0x1109, 0x0029, 0},
	0x3207, {0x0028, 0x110B, 0x0029, 0},
	0x3208, {0x0028, 0x110C, 0x0029, 0},
	0x3209, {0x0028, 0x110E, 0x0029, 0},
	0x320A, {0x0028, 0x110F, 0x0029, 0},
	0x320B, {0x0028, 0x1110, 0x0029, 0},
	0x320C, {0x0028, 0x1111, 0x0029, 0},
	0x320D, {0x0028, 0x1112, 0x0029, 0},
	0x320E, {0x0028, 0x1100, 0x1161, 0x0029, 0},
	0x320F, {0x0028, 0x1102, 0x1161, 0x0029, 0},
	0x3210, {0x0028, 0x1103, 0x1161, 0x0029, 0},
	0x3211, {0x0028, 0x1105, 0x1161, 0x0029, 0},
	0x3212, {0x0028, 0x1106, 0x1161, 0x0029, 0},
	0x3213, {0x0028, 0x1107, 0x1161, 0x0029, 0},
	0x3214, {0x0028, 0x1109, 0x1161, 0x0029, 0},
	0x3215, {0x0028, 0x110B, 0x1161, 0x0029, 0},
	0x3216, {0x0028, 0x110C, 0x1161, 0x0029, 0},
	0x3217, {0x0028, 0x110E, 0x1161, 0x0029, 0},
	0x3218, {0x0028, 0x110F, 0x1161, 0x0029, 0},
	0x3219, {0x0028, 0x1110, 0x1161, 0x0029, 0},
	0x321A, {0x0028, 0x1111, 0x1161, 0x0029, 0},
	0x321B, {0x0028, 0x1112, 0x1161, 0x0029, 0},
	0x321C, {0x0028, 0x110C, 0x116E, 0x0029, 0},
	0x321D, {0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029, 0},
	0x321E, {0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029, 0},
	0x3220, {0x0028, 0x4E00, 0x0029, 0},
	0x3221, {0x0028, 0x4E8C, 0x0029, 0},
	0x3222, {0x0028, 0x4E09, 0x0029, 0},
	0x3223, {0x0028, 0x56DB, 0x0029, 0},
	0x3224, {0x0028, 0x4E94, 0x0029, 0},
	0x3225, {0x0028, 0x516D, 0x0029, 0},
	0x3226, {0x0028, 0x4E03, 0x0029, 0},
	0x3227, {0x0028, 0x516B, 0x0029, 0},
	0x3228, {0x0028, 0x4E5D, 0x0029, 0},
	0x3229, {0x0028, 0x5341, 0x0029, 0},
	0x322A, {0x0028, 0x6708, 0x0029, 0},
	0x322B, {0x0028, 0x706B, 0x0029, 0},
	0x322C, {0x0028, 0x6C34, 0x0029, 0},
	0x322D, {0x0028, 0x6728, 0x0029, 0},
	0x322E, {0x0028, 0x91D1, 0x0029, 0},
	0x322F, {0x0028, 0x571F, 0x0029, 0},
	0x3230, {0x0028, 0x65E5, 0x0029, 0},
	0x3231, {0x0028, 0x682A, 0x0029, 0},
	0x3232, {0x0028, 0x6709, 0x0029, 0},
	0x3233, {0x0028, 0x793E, 0x0029, 0},
	0x3234, {0x0028, 0x540D, 0x0029, 0},
	0x3235, {0x0028, 0x7279, 0x0029, 0},
	0x3236, {0x0028, 0x8CA1, 0x0029, 0},
	0x3237, {0x0028, 0x795D, 0x0029, 0},
	0x3238, {0x0028, 0x52B4, 0x0029, 0},
	0x3239, {0x0028, 0x4EE3, 0x0029, 0},
	0x323A, {0x0028, 0x547C, 0x0029, 0},
	0x323B, {0x0028, 0x5B66, 0x0029, 0},
	0x323C, {0x0028, 0x76E3, 0x0029, 0},
	0x323D, {0x0028, 0x4F01, 0x0029, 0},
	0x323E, {0x0028, 0x8CC7, 0x0029, 0},
	0x323F, {0x0028, 0x5354, 0x0029, 0},
	0x3240, {0x0028, 0x796D, 0x0029, 0},
	0x3241, {0x0028, 0x4F11, 0x0029, 0},
	0x3242, {0x0028, 0x81EA, 0x0029, 0},
	0x3243, {0x0028, 0x81F3, 0x0029, 0},
	0x32C0, {0x0031, 0x6708, 0},
	0x32C1, {0x0032, 0x6708, 0},
	0x32C2, {0x0033, 0x6708, 0},
	0x32C3, {0x0034, 0x6708, 0},
	0x32C4, {0x0035, 0x6708, 0},
	0x32C5, {0x0036, 0x6708, 0},
	0x32C6, {0x0037, 0x6708, 0},
	0x32C7, {0x0038, 0x6708, 0},
	0x32C8, {0x0039, 0x6708, 0},
	0x32C9, {0x0031, 0x0030, 0x6708, 0},
	0x32CA, {0x0031, 0x0031, 0x6708, 0},
	0x32CB, {0x0031, 0x0032, 0x6708, 0},
	0x3358, {0x0030, 0x70B9, 0},
	0x3359, {0x0031, 0x70B9, 0},
	0x335A, {0x0032, 0x70B9, 0},
	0x335B, {0x0033, 0x70B9, 0},
	0x335C, {0x0034, 0x70B9, 0},
	0x335D, {0x0035, 0x70B9, 0},
	0x335E, {0x0036, 0x70B9, 0},
	0x335F, {0x0037, 0x70B9, 0},
	0x3360, {0x0038, 0x70B9, 0},
	0x3361, {0x0039, 0x70B9, 0},
	0x3362, {0x0031, 0x0030, 0x70B9, 0},
	0x3363, {0x0031, 0x0031, 0x70B9, 0},
	0x3364, {0x0031, 0x0032, 0x70B9, 0},
	0x3365, {0x0031, 0x0033, 0x70B9, 0},
	0x3366, {0x0031, 0x0034, 0x70B9, 0},
	0x3367, {0x0031, 0x0035, 0x70B9, 0},
	0x3368, {0x0031, 0x0036, 0x70B9, 0},
	0x3369, {0x0031, 0x0037, 0x70B9, 0},
	0x336A, {0x0031, 0x0038, 0x70B9, 0},
	0x336B, {0x0031, 0x0039, 0x70B9, 0},
	0x336C, {0x0032, 0x0030, 0x70B9, 0},
	0x336D, {0x0032, 0x0031, 0x70B9, 0},
	0x336E, {0x0032, 0x0032, 0x70B9, 0},
	0x336F, {0x0032, 0x0033, 0x70B9, 0},
	0x3370, {0x0032, 0x0034, 0x70B9, 0},
	0x33E0, {0x0031, 0x65E5, 0},
	0x33E1, {0x0032, 0x65E5, 0},
	0x33E2, {0x0033, 0x65E5, 0},
	0x33E3, {0x0034, 0x65E5, 0},
	0x33E4, {0x0035, 0x65E5, 0},
	0x33E5, {0x0036, 0x65E5, 0},
	0x33E6, {0x0037, 0x65E5, 0},
	0x33E7, {0x0038, 0x65E5, 0},
	0x33E8, {0x0039, 0x65E5, 0},
	0x33E9, {0x0031, 0x0030, 0x65E5, 0},
	0x33EA, {0x0031, 0x0031, 0x65E5, 0},
	0x33EB, {0x0031, 0x0032, 0x65E5, 0},
	0x33EC, {0x0031, 0x0033, 0x65E5, 0},
	0x33ED, {0x0031, 0x0034, 0x65E5, 0},
	0x33EE, {0x0031, 0x0035, 0x65E5, 0},
	0x33EF, {0x0031, 0x0036, 0x65E5, 0},
	0x33F0, {0x0031, 0x0037, 0x65E5, 0},
	0x33F1, {0x0031, 0x0038, 0x65E5, 0},
	0x33F2, {0x0031, 0x0039, 0x65E5, 0},
	0x33F3, {0x0032, 0x0030, 0x65E5, 0},
	0x33F4, {0x0032, 0x0031, 0x65E5, 0},
	0x33F5, {0x0032, 0x0032, 0x65E5, 0},
	0x33F6, {0x0032, 0x0033, 0x65E5, 0},
	0x33F7, {0x0032, 0x0034, 0x65E5, 0},
	0x33F8, {0x0032, 0x0035, 0x65E5, 0},
	0x33F9, {0x0032, 0x0036, 0x65E5, 0},
	0x33FA, {0x0032, 0x0037, 0x65E5, 0},
	0x33FB, {0x0032, 0x0038, 0x65E5, 0},
	0x33FC, {0x0032, 0x0039, 0x65E5, 0},
	0x33FD, {0x0033, 0x0030, 0x65E5, 0},
	0x33FE, {0x0033, 0x0031, 0x65E5, 0},
	0xFB00, {0x0066, 0x0066, 0},
	0xFB01, {0x0066, 0x0069, 0},
	0xFB02, {0x0066, 0x006C, 0},
	0xFB03, {0x0066, 0x0066, 0x0069, 0},
	0xFB04, {0x0066, 0x0066, 0x006C, 0},
	0xFB05, {0x017F, 0x0074, 0},
	0xFB06, {0x0073, 0x0074, 0},
	0xFB13, {0x0574, 0x0576, 0},
	0xFB14, {0x0574, 0x0565, 0},
	0xFB15, {0x0574, 0x056B, 0},
	0xFB16, {0x057E, 0x0576, 0},
	0xFB17, {0x0574, 0x056D, 0},
	0xFB4F, {0x05D0, 0x05DC, 0},
	0xFB50, {0x0671, 0},
	0xFB51, {0x0671, 0},
	0xFB52, {0x067B, 0},
	0xFB53, {0x067B, 0},
	0xFB54, {0x067B, 0},
	0xFB55, {0x067B, 0},
	0xFB56, {0x067E, 0},
	0xFB57, {0x067E, 0},
	0xFB58, {0x067E, 0},
	0xFB59, {0x067E, 0},
	0xFB5A, {0x0680, 0},
	0xFB5B, {0x0680, 0},
	0xFB5C, {0x0680, 0},
	0xFB5D, {0x0680, 0},
	0xFB5E, {0x067A, 0},
	0xFB5F, {0x067A, 0},
	0xFB60, {0x067A, 0},
	0xFB61, {0x067A, 0},
	0xFB62, {0x067F, 0},
	0xFB63, {0x067F, 0},
	0xFB64, {0x067F, 0},
	0xFB65, {0x067F, 0},
	0xFB66, {0x0679, 0},
	0xFB67, {0x0679, 0},
	0xFB68, {0x0679, 0},
	0xFB69, {0x0679, 0},
	0xFB6A, {0x06A4, 0},
	0xFB6B, {0x06A4, 0},
	0xFB6C, {0x06A4, 0},
	0xFB6D, {0x06A4, 0},
	0xFB6E, {0x06A6, 0},
	0xFB6F, {0x06A6, 0},
	0xFB70, {0x06A6, 0},
	0xFB71, {0x06A6, 0},
	0xFB72, {0x0684, 0},
	0xFB73, {0x0684, 0},
	0xFB74, {0x0684, 0},
	0xFB75, {0x0684, 0},
	0xFB76, {0x0683, 0},
	0xFB77, {0x0683, 0},
	0xFB78, {0x0683, 0},
	0xFB79, {0x0683, 0},
	0xFB7A, {0x0686, 0},
	0xFB7B, {0x0686, 0},
	0xFB7C, {0x0686, 0},
	0xFB7D, {0x0686, 0},
	0xFB7E, {0x0687, 0},
	0xFB7F, {0x0687, 0},
	0xFB80, {0x0687, 0},
	0xFB81, {0x0687, 0},
	0xFB82, {0x068D, 0},
	0xFB83, {0x068D, 0},
	0xFB84, {0x068C, 0},
	0xFB85, {0x068C, 0},
	0xFB86, {0x068E, 0},
	0xFB87, {0x068E, 0},
	0xFB88, {0x0688, 0},
	0xFB89, {0x0688, 0},
	0xFB8A, {0x0698, 0},
	0xFB8B, {0x0698, 0},
	0xFB8C, {0x0691, 0},
	0xFB8D, {0x0691, 0},
	0xFB8E, {0x06A9, 0},
	0xFB8F, {0x06A9, 0},
	0xFB90, {0x06A9, 0},
	0xFB91, {0x06A9, 0},
	0xFB92, {0x06AF, 0},
	0xFB93, {0x06AF, 0},
	0xFB94, {0x06AF, 0},
	0xFB95, {0x06AF, 0},
	0xFB96, {0x06B3, 0},
	0xFB97, {0x06B3, 0},
	0xFB98, {0x06B3, 0},
	0xFB99, {0x06B3, 0},
	0xFB9A, {0x06B1, 0},
	0xFB9B, {0x06B1, 0},
	0xFB9C, {0x06B1, 0},
	0xFB9D, {0x06B1, 0},
	0xFB9E, {0x06BA, 0},
	0xFB9F, {0x06BA, 0},
	0xFBA0, {0x06BB, 0},
	0xFBA1, {0x06BB, 0},
	0xFBA2, {0x06BB, 0},
	0xFBA3, {0x06BB, 0},
	0xFBA4, {0x06C0, 0},
	0xFBA5, {0x06C0, 0},
	0xFBA6, {0x06C1, 0},
	0xFBA7, {0x06C1, 0},
	0xFBA8, {0x06C1, 0},
	0xFBA9, {0x06C1, 0},
	0xFBAA, {0x06BE, 0},
	0xFBAB, {0x06BE, 0},
	0xFBAC, {0x06BE, 0},
	0xFBAD, {0x06BE, 0},
	0xFBAE, {0x06D2, 0},
	0xFBAF, {0x06D2, 0},
	0xFBB0, {0x06D3, 0},
	0xFBB1, {0x06D3, 0},
	0xFBD3, {0x06AD, 0},
	0xFBD4, {0x06AD, 0},
	0xFBD5, {0x06AD, 0},
	0xFBD6, {0x06AD, 0},
	0xFBD7, {0x06C7, 0},
	0xFBD8, {0x06C7, 0},
	0xFBD9, {0x06C6, 0},
	0xFBDA, {0x06C6, 0},
	0xFBDB, {0x06C8, 0},
	0xFBDC, {0x06C8, 0},
	0xFBDD, {0x0677, 0},
	0xFBDE, {0x06CB, 0},
	0xFBDF, {0x06CB, 0},
	0xFBE0, {0x06C5, 0},
	0xFBE1, {0x06C5, 0},
	0xFBE2, {0x06C9, 0},
	0xFBE3, {0x06C9, 0},
	0xFBE4, {0x06D0, 0},
	0xFBE5, {0x06D0, 0},
	0xFBE6, {0x06D0, 0},
	0xFBE7, {0x06D0, 0},
	0xFBE8, {0x0649, 0},
	0xFBE9, {0x0649, 0},
	0xFBEA, {0x0626, 0x0627, 0},
	0xFBEB, {0x0626, 0x0627, 0},
	0xFBEC, {0x0626, 0x06D5, 0},
	0xFBED, {0x0626, 0x06D5, 0},
	0xFBEE, {0x0626, 0x0648, 0},
	0xFBEF, {0x0626, 0x0648, 0},
	0xFBF0, {0x0626, 0x06C7, 0},
	0xFBF1, {0x0626, 0x06C7, 0},
	0xFBF2, {0x0626, 0x06C6, 0},
	0xFBF3, {0x0626, 0x06C6, 0},
	0xFBF4, {0x0626, 0x06C8, 0},
	0xFBF5, {0x0626, 0x06C8, 0},
	0xFBF6, {0x0626, 0x06D0, 0},
	0xFBF7, {0x0626, 0x06D0, 0},
	0xFBF8, {0x0626, 0x06D0, 0},
	0xFBF9, {0x0626, 0x0649, 0},
	0xFBFA, {0x0626, 0x0649, 0},
	0xFBFB, {0x0626, 0x0649, 0},
	0xFBFC, {0x06CC, 0},
	0xFBFD, {0x06CC, 0},
	0xFBFE, {0x06CC, 0},
	0xFBFF, {0x06CC, 0},
	0xFC00, {0x0626, 0x062C, 0},
	0xFC01, {0x0626, 0x062D, 0},
	0xFC02, {0x0626, 0x0645, 0},
	0xFC03, {0x0626, 0x0649, 0},
	0xFC04, {0x0626, 0x064A, 0},
	0xFC05, {0x0628, 0x062C, 0},
	0xFC06, {0x0628, 0x062D, 0},
	0xFC07, {0x0628, 0x062E, 0},
	0xFC08, {0x0628, 0x0645, 0},
	0xFC09, {0x0628, 0x0649, 0},
	0xFC0A, {0x0628, 0x064A, 0},
	0xFC0B, {0x062A, 0x062C, 0},
	0xFC0C, {0x062A, 0x062D, 0},
	0xFC0D, {0x062A, 0x062E, 0},
	0xFC0E, {0x062A, 0x0645, 0},
	0xFC0F, {0x062A, 0x0649, 0},
	0xFC10, {0x062A, 0x064A, 0},
	0xFC11, {0x062B, 0x062C, 0},
	0xFC12, {0x062B, 0x0645, 0},
	0xFC13, {0x062B, 0x0649, 0},
	0xFC14, {0x062B, 0x064A, 0},
	0xFC15, {0x062C, 0x062D, 0},
	0xFC16, {0x062C, 0x0645, 0},
	0xFC17, {0x062D, 0x062C, 0},
	0xFC18, {0x062D, 0x0645, 0},
	0xFC19, {0x062E, 0x062C, 0},
	0xFC1A, {0x062E, 0x062D, 0},
	0xFC1B, {0x062E, 0x0645, 0},
	0xFC1C, {0x0633, 0x062C, 0},
	0xFC1D, {0x0633, 0x062D, 0},
	0xFC1E, {0x0633, 0x062E, 0},
	0xFC1F, {0x0633, 0x0645, 0},
	0xFC20, {0x0635, 0x062D, 0},
	0xFC21, {0x0635, 0x0645, 0},
	0xFC22, {0x0636, 0x062C, 0},
	0xFC23, {0x0636, 0x062D, 0},
	0xFC24, {0x0636, 0x062E, 0},
	0xFC25, {0x0636, 0x0645, 0},
	0xFC26, {0x0637, 0x062D, 0},
	0xFC27, {0x0637, 0x0645, 0},
	0xFC28, {0x0638, 0x0645, 0},
	0xFC29, {0x0639, 0x062C, 0},
	0xFC2A, {0x0639, 0x0645, 0},
	0xFC2B, {0x063A, 0x062C, 0},
	0xFC2C, {0x063A, 0x0645, 0},
	0xFC2D, {0x0641, 0x062C, 0},
	0xFC2E, {0x0641, 0x062D, 0},
	0xFC2F, {0x0641, 0x062E, 0},
	0xFC30, {0x0641, 0x0645, 0},
	0xFC31, {0x0641, 0x0649, 0},
	0xFC32, {0x0641, 0x064A, 0},
	0xFC33, {0x0642, 0x062D, 0},
	0xFC34, {0x0642, 0x0645, 0},
	0xFC35, {0x0642, 0x0649, 0},
	0xFC36, {0x0642, 0x064A, 0},
	0xFC37, {0x0643, 0x0627, 0},
	0xFC38, {0x0643, 0x062C, 0},
	0xFC39, {0x0643, 0x062D, 0},
	0xFC3A, {0x0643, 0x062E, 0},
	0xFC3B, {0x0643, 0x0644, 0},
	0xFC3C, {0x0643, 0x0645, 0},
	0xFC3D, {0x0643, 0x0649, 0},
	0xFC3E, {0x0643, 0x064A, 0},
	0xFC3F, {0x0644, 0x062C, 0},
	0xFC40, {0x0644, 0x062D, 0},
	0xFC41, {0x0644, 0x062E, 0},
	0xFC42, {0x0644, 0x0645, 0},
	0xFC43, {0x0644, 0x0649, 0},
	0xFC44, {0x0644, 0x064A, 0},
	0xFC45, {0x0645, 0x062C, 0},
	0xFC46, {0x0645, 0x062D, 0},
	0xFC47, {0x0645, 0x062E, 0},
	0xFC48, {0x0645, 0x0645, 0},
	0xFC49, {0x0645, 0x0649, 0},
	0xFC4A, {0x0645, 0x064A, 0},
	0xFC4B, {0x0646, 0x062C, 0},
	0xFC4C, {0x0646, 0x062D, 0},
	0xFC4D, {0x0646, 0x062E, 0},
	0xFC4E, {0x0646, 0x0645, 0},
	0xFC4F, {0x0646, 0x0649, 0},
	0xFC50, {0x0646, 0x064A, 0},
	0xFC51, {0x0647, 0x062C, 0},
	0xFC52, {0x0647, 0x0645, 0},
	0xFC53, {0x0647, 0x0649, 0},
	0xFC54, {0x0647, 0x064A, 0},
	0xFC55, {0x064A, 0x062C, 0},
	0xFC56, {0x064A, 0x062D, 0},
	0xFC57, {0x064A, 0x062E, 0},
	0xFC58, {0x064A, 0x0645, 0},
	0xFC59, {0x064A, 0x0649, 0},
	0xFC5A, {0x064A, 0x064A, 0},
	0xFC5B, {0x0630, 0x0670, 0},
	0xFC5C, {0x0631, 0x0670, 0},
	0xFC5D, {0x0649, 0x0670, 0},
	0xFC5E, {0x0020, 0x064C, 0x0651, 0},
	0xFC5F, {0x0020, 0x064D, 0x0651, 0},
	0xFC60, {0x0020, 0x064E, 0x0651, 0},
	0xFC61, {0x0020, 0x064F, 0x0651, 0},
	0xFC62, {0x0020, 0x0650, 0x0651, 0},
	0xFC63, {0x0020, 0x0651, 0x0670, 0},
	0xFC64, {0x0626, 0x0631, 0},
	0xFC65, {0x0626, 0x0632, 0},
	0xFC66, {0x0626, 0x0645, 0},
	0xFC67, {0x0626, 0x0646, 0},
	0xFC68, {0x0626, 0x0649, 0},
	0xFC69, {0x0626, 0x064A, 0},
	0xFC6A, {0x0628, 0x0631, 0},
	0xFC6B, {0x0628, 0x0632, 0},
	0xFC6C, {0x0628, 0x0645, 0},
	0xFC6D, {0x0628, 0x0646, 0},
	0xFC6E, {0x0628, 0x0649, 0},
	0xFC6F, {0x0628, 0x064A, 0},
	0xFC70, {0x062A, 0x0631, 0},
	0xFC71, {0x062A, 0x0632, 0},
	0xFC72, {0x062A, 0x0645, 0},
	0xFC73, {0x062A, 0x0646, 0},
	0xFC74, {0x062A, 0x0649, 0},
	0xFC75, {0x062A, 0x064A, 0},
	0xFC76, {0x062B, 0x0631, 0},
	0xFC77, {0x062B, 0x0632, 0},
	0xFC78, {0x062B, 0x0645, 0},
	0xFC79, {0x062B, 0x0646, 0},
	0xFC7A, {0x062B, 0x0649, 0},
	0xFC7B, {0x062B, 0x064A, 0},
	0xFC7C, {0x0641, 0x0649, 0},
	0xFC7D, {0x0641, 0x064A, 0},
	0xFC7E, {0x0642, 0x0649, 0},
	0xFC7F, {0x0642, 0x064A, 0},
	0xFC80, {0x0643, 0x0627, 0},
	0xFC81, {0x0643, 0x0644, 0},
	0xFC82, {0x0643, 0x0645, 0},
	0xFC83, {0x0643, 0x0649, 0},
	0xFC84, {0x0643, 0x064A, 0},
	0xFC85, {0x0644, 0x0645, 0},
	0xFC86, {0x0644, 0x0649, 0},
	0xFC87, {0x0644, 0x064A, 0},
	0xFC88, {0x0645, 0x0627, 0},
	0xFC89, {0x0645, 0x0645, 0},
	0xFC8A, {0x0646, 0x0631, 0},
	0xFC8B, {0x0646, 0x0632, 0},
	0xFC8C, {0x0646, 0x0645, 0},
	0xFC8D, {0x0646, 0x0646, 0},
	0xFC8E, {0x0646, 0x0649, 0},
	0xFC8F, {0x0646, 0x064A, 0},
	0xFC90, {0x0649, 0x0670, 0},
	0xFC91, {0x064A, 0x0631, 0},
	0xFC92, {0x064A, 0x0632, 0},
	0xFC93, {0x064A, 0x0645, 0},
	0xFC94, {0x064A, 0x0646, 0},
	0xFC95, {0x064A, 0x0649, 0},
	0xFC96, {0x064A, 0x064A, 0},
	0xFC97, {0x0626, 0x062C, 0},
	0xFC98, {0x0626, 0x062D, 0},
	0xFC99, {0x0626, 0x062E, 0},
	0xFC9A, {0x0626, 0x0645, 0},
	0xFC9B, {0x0626, 0x0647, 0},
	0xFC9C, {0x0628, 0x062C, 0},
	0xFC9D, {0x0628, 0x062D, 0},
	0xFC9E, {0x0628, 0x062E, 0},
	0xFC9F, {0x0628, 0x0645, 0},
	0xFCA0, {0x0628, 0x0647, 0},
	0xFCA1, {0x062A, 0x062C, 0},
	0xFCA2, {0x062A, 0x062D, 0},
	0xFCA3, {0x062A, 0x062E, 0},
	0xFCA4, {0x062A, 0x0645, 0},
	0xFCA5, {0x062A, 0x0647, 0},
	0xFCA6, {0x062B, 0x0645, 0},
	0xFCA7, {0x062C, 0x062D, 0},
	0xFCA8, {0x062C, 0x0645, 0},
	0xFCA9, {0x062D, 0x062C, 0},
	0xFCAA, {0x062D, 0x0645, 0},
	0xFCAB, {0x062E, 0x062C, 0},
	0xFCAC, {0x062E, 0x0645, 0},
	0xFCAD, {0x0633, 0x062C, 0},
	0xFCAE, {0x0633, 0x062D, 0},
	0xFCAF, {0x0633, 0x062E, 0},
	0xFCB0, {0x0633, 0x0645, 0},
	0xFCB1, {0x0635, 0x062D, 0},
	0xFCB2, {0x0635, 0x062E, 0},
	0xFCB3, {0x0635, 0x0645, 0},
	0xFCB4, {0x0636, 0x062C, 0},
	0xFCB5, {0x0636, 0x062D, 0},
	0xFCB6, {0x0636, 0x062E, 0},
	0xFCB7, {0x0636, 0x0645, 0},
	0xFCB8, {0x0637, 0x062D, 0},
	0xFCB9, {0x0638, 0x0645, 0},
	0xFCBA, {0x0639, 0x062C, 0},
	0xFCBB, {0x0639, 0x0645, 0},
	0xFCBC, {0x063A, 0x062C, 0},
	0xFCBD, {0x063A, 0x0645, 0},
	0xFCBE, {0x0641, 0x062C, 0},
	0xFCBF, {0x0641, 0x062D, 0},
	0xFCC0, {0x0641, 0x062E, 0},
	0xFCC1, {0x0641, 0x0645, 0},
	0xFCC2, {0x0642, 0x062D, 0},
	0xFCC3, {0x0642, 0x0645, 0},
	0xFCC4, {0x0643, 0x062C, 0},
	0xFCC5, {0x0643, 0x062D, 0},
	0xFCC6, {0x0643, 0x062E, 0},
	0xFCC7, {0x0643, 0x0644, 0},
	0xFCC8, {0x0643, 0x0645, 0},
	0xFCC9, {0x0644, 0x062C, 0},
	0xFCCA, {0x0644, 0x062D, 0},
	0xFCCB, {0x0644, 0x062E, 0},
	0xFCCC, {0x0644, 0x0645, 0},
	0xFCCD, {0x0644, 0x0647, 0},
	0xFCCE, {0x0645, 0x062C, 0},
	0xFCCF, {0x0645, 0x062D, 0},
	0xFCD0, {0x0645, 0x062E, 0},
	0xFCD1, {0x0645, 0x0645, 0},
	0xFCD2, {0x0646, 0x062C, 0},
	0xFCD3, {0x0646, 0x062D, 0},
	0xFCD4, {0x0646, 0x062E, 0},
	0xFCD5, {0x0646, 0x0645, 0},
	0xFCD6, {0x0646, 0x0647, 0},
	0xFCD7, {0x0647, 0x062C, 0},
	0xFCD8, {0x0647, 0x0645, 0},
	0xFCD9, {0x0647, 0x0670, 0},
	0xFCDA, {0x064A, 0x062C, 0},
	0xFCDB, {0x064A, 0x062D, 0},
	0xFCDC, {0x064A, 0x062E, 0},
	0xFCDD, {0x064A, 0x0645, 0},
	0xFCDE, {0x064A, 0x0647, 0},
	0xFCDF, {0x0626, 0x0645, 0},
	0xFCE0, {0x0626, 0x0647, 0},
	0xFCE1, {0x0628, 0x0645, 0},
	0xFCE2, {0x0628, 0x0647, 0},
	0xFCE3, {0x062A, 0x0645, 0},
	0xFCE4, {0x062A, 0x0647, 0},
	0xFCE5, {0x062B, 0x0645, 0},
	0xFCE6, {0x062B, 0x0647, 0},
	0xFCE7, {0x0633, 0x0645, 0},
	0xFCE8, {0x0633, 0x0647, 0},
	0xFCE9, {0x0634, 0x0645, 0},
	0xFCEA, {0x0634, 0x0647, 0},
	0xFCEB, {0x0643, 0x0644, 0},
	0xFCEC, {0x0643, 0x0645, 0},
	0xFCED, {0x0644, 0x0645, 0},
	0xFCEE, {0x0646, 0x0645, 0},
	0xFCEF, {0x0646, 0x0647, 0},
	0xFCF0, {0x064A, 0x0645, 0},
	0xFCF1, {0x064A, 0x0647, 0},
	0xFCF2, {0x0640, 0x064E, 0x0651, 0},
	0xFCF3, {0x0640, 0x064F, 0x0651, 0},
	0xFCF4, {0x0640, 0x0650, 0x0651, 0},
	0xFCF5, {0x0637, 0x0649, 0},
	0xFCF6, {0x0637, 0x064A, 0},
	0xFCF7, {0x0639, 0x0649, 0},
	0xFCF8, {0x0639, 0x064A, 0},
	0xFCF9, {0x063A, 0x0649, 0},
	0xFCFA, {0x063A, 0x064A, 0},
	0xFCFB, {0x0633, 0x0649, 0},
	0xFCFC, {0x0633, 0x064A, 0},
	0xFCFD, {0x0634, 0x0649, 0},
	0xFCFE, {0x0634, 0x064A, 0},
	0xFCFF, {0x062D, 0x0649, 0},
	0xFD00, {0x062D, 0x064A, 0},
	0xFD01, {0x062C, 0x0649, 0},
	0xFD02, {0x062C, 0x064A, 0},
	0xFD03, {0x062E, 0x0649, 0},
	0xFD04, {0x062E, 0x064A, 0},
	0xFD05, {0x0635, 0x0649, 0},
	0xFD06, {0x0635, 0x064A, 0},
	0xFD07, {0x0636, 0x0649, 0},
	0xFD08, {0x0636, 0x064A, 0},
	0xFD09, {0x0634, 0x062C, 0},
	0xFD0A, {0x0634, 0x062D, 0},
	0xFD0B, {0x0634, 0x062E, 0},
	0xFD0C, {0x0634, 0x0645, 0},
	0xFD0D, {0x0634, 0x0631, 0},
	0xFD0E, {0x0633, 0x0631, 0},
	0xFD0F, {0x0635, 0x0631, 0},
	0xFD10, {0x0636, 0x0631, 0},
	0xFD11, {0x0637, 0x0649, 0},
	0xFD12, {0x0637, 0x064A, 0},
	0xFD13, {0x0639, 0x0649, 0},
	0xFD14, {0x0639, 0x064A, 0},
	0xFD15, {0x063A, 0x0649, 0},
	0xFD16, {0x063A, 0x064A, 0},
	0xFD17, {0x0633, 0x0649, 0},
	0xFD18, {0x0633, 0x064A, 0},
	0xFD19, {0x0634, 0x0649, 0},
	0xFD1A, {0x0634, 0x064A, 0},
	0xFD1B, {0x062D, 0x0649, 0},
	0xFD1C, {0x062D, 0x064A, 0},
	0xFD1D, {0x062C, 0x0649, 0},
	0xFD1E, {0x062C, 0x064A, 0},
	0xFD1F, {0x062E, 0x0649, 0},
	0xFD20, {0x062E, 0x064A, 0},
	0xFD21, {0x0635, 0x0649, 0},
	0xFD22, {0x0635, 0x064A, 0},
	0xFD23, {0x0636, 0x0649, 0},
	0xFD24, {0x0636, 0x064A, 0},
	0xFD25, {0x0634, 0x062C, 0},
	0xFD26, {0x0634, 0x062D, 0},
	0xFD27, {0x0634, 0x062E, 0},
	0xFD28, {0x0634, 0x0645, 0},
	0xFD29, {0x0634, 0x0631, 0},
	0xFD2A, {0x0633, 0x0631, 0},
	0xFD2B, {0x0635, 0x0631, 0},
	0xFD2C, {0x0636, 0x0631, 0},
	0xFD2D, {0x0634, 0x062C, 0},
	0xFD2E, {0x0634, 0x062D, 0},
	0xFD2F, {0x0634, 0x062E, 0},
	0xFD30, {0x0634, 0x0645, 0},
	0xFD31, {0x0633, 0x0647, 0},
	0xFD32, {0x0634, 0x0647, 0},
	0xFD33, {0x0637, 0x0645, 0},
	0xFD34, {0x0633, 0x062C, 0},
	0xFD35, {0x0633, 0x062D, 0},
	0xFD36, {0x0633, 0x062E, 0},
	0xFD37, {0x0634, 0x062C, 0},
	0xFD38, {0x0634, 0x062D, 0},
	0xFD39, {0x0634, 0x062E, 0},
	0xFD3A, {0x0637, 0x0645, 0},
	0xFD3B, {0x0638, 0x0645, 0},
	0xFD3C, {0x0627, 0x064B, 0},
	0xFD3D, {0x0627, 0x064B, 0},
	0xFD50, {0x062A, 0x062C, 0x0645, 0},
	0xFD51, {0x062A, 0x062D, 0x062C, 0},
	0xFD52, {0x062A, 0x062D, 0x062C, 0},
	0xFD53, {0x062A, 0x062D, 0x0645, 0},
	0xFD54, {0x062A, 0x062E, 0x0645, 0},
	0xFD55, {0x062A, 0x0645, 0x062C, 0},
	0xFD56, {0x062A, 0x0645, 0x062D, 0},
	0xFD57, {0x062A, 0x0645, 0x062E, 0},
	0xFD58, {0x062C, 0x0645, 0x062D, 0},
	0xFD59, {0x062C, 0x0645, 0x062D, 0},
	0xFD5A, {0x062D, 0x0645, 0x064A, 0},
	0xFD5B, {0x062D, 0x0645, 0x0649, 0},
	0xFD5C, {0x0633, 0x062D, 0x062C, 0},
	0xFD5D, {0x0633, 0x062C, 0x062D, 0},
	0xFD5E, {0x0633, 0x062C, 0x0649, 0},
	0xFD5F, {0x0633, 0x0645, 0x062D, 0},
	0xFD60, {0x0633, 0x0645, 0x062D, 0},
	0xFD61, {0x0633, 0x0645, 0x062C, 0},
	0xFD62, {0x0633, 0x0645, 0x0645, 0},
	0xFD63, {0x0633, 0x0645, 0x0645, 0},
	0xFD64, {0x0635, 0x062D, 0x062D, 0},
	0xFD65, {0x0635, 0x062D, 0x062D, 0},
	0xFD66, {0x0635, 0x0645, 0x0645, 0},
	0xFD67, {0x0634, 0x062D, 0x0645, 0},
	0xFD68, {0x0634, 0x062D, 0x0645, 0},
	0xFD69, {0x0634, 0x062C, 0x064A, 0},
	0xFD6A, {0x0634, 0x0645, 0x062E, 0},
	0xFD6B, {0x0634, 0x0645, 0x062E, 0},
	0xFD6C, {0x0634, 0x0645, 0x0645, 0},
	0xFD6D, {0x0634, 0x0645, 0x0645, 0},
	0xFD6E, {0x0636, 0x062D, 0x0649, 0},
	0xFD6F, {0x0636, 0x062E, 0x0645, 0},
	0xFD70, {0x0636, 0x062E, 0x0645, 0},
	0xFD71, {0x0637, 0x0645, 0x062D, 0},
	0xFD72, {0x0637, 0x0645, 0x062D, 0},
	0xFD73, {0x0637, 0x0645, 0x0645, 0},
	0xFD74, {0x0637, 0x0645, 0x064A, 0},
	0xFD75, {0x0639, 0x062C, 0x0645, 0},
	0xFD76, {0x0639, 0x0645, 0x0645, 0},
	0xFD77, {0x0639, 0x0645, 0x0645, 0},
	0xFD78, {0x0639, 0x0645, 0x0649, 0},
	0xFD79, {0x063A, 0x0645, 0x0645, 0},
	0xFD7A, {0x063A, 0x0645, 0x064A, 0},
	0xFD7B, {0x063A, 0x0645, 0x0649, 0},
	0xFD7C, {0x0641, 0x062E, 0x0645, 0},
	0xFD7D, {0x0641, 0x062E, 0x0645, 0},
	0xFD7E, {0x0642, 0x0645, 0x062D, 0},
	0xFD7F, {0x0642, 0x0645, 0x0645, 0},
	0xFD80, {0x0644, 0x062D, 0x0645, 0},
	0xFD81, {0x0644, 0x062D, 0x064A, 0},
	0xFD82, {0x0644, 0x062D, 0x0649, 0},
	0xFD83, {0x0644, 0x062C, 0x062C, 0},
	0xFD84, {0x0644, 0x062C, 0x062C, 0},
	0xFD85, {0x0644, 0x062E, 0x0645, 0},
	0xFD86, {0x0644, 0x062E, 0x0645, 0},
	0xFD87, {0x0644, 0x0645, 0x062D, 0},
	0xFD88, {0x0644, 0x0645, 0x062D, 0},
	0xFD89, {0x0645, 0x062D, 0x062C, 0},
	0xFD8A, {0x0645, 0x062D, 0x0645, 0},
	0xFD8B, {0x0645, 0x062D, 0x064A, 0},
	0xFD8C, {0x0645, 0x062C, 0x062D, 0},
	0xFD8D, {0x0645, 0x062C, 0x0645, 0},
	0xFD8E, {0x0645, 0x062E, 0x062C, 0},
	0xFD8F, {0x0645, 0x062E, 0x0645, 0},
	0xFD92, {0x0645, 0x062C, 0x062E, 0},
	0xFD93, {0x0647, 0x0645, 0x062C, 0},
	0xFD94, {0x0647, 0x0645, 0x0645, 0},
	0xFD95, {0x0646, 0x062D, 0x0645, 0},
	0xFD96, {0x0646, 0x062D, 0x0649, 0},
	0xFD97, {0x0646, 0x062C, 0x0645, 0},
	0xFD98, {0x0646, 0x062C, 0x0645, 0},
	0xFD99, {0x0646, 0x062C, 0x0649, 0},
	0xFD9A, {0x0646, 0x0645, 0x064A, 0},
	0xFD9B, {0x0646, 0x0645, 0x0649, 0},
	0xFD9C, {0x064A, 0x0645, 0x0645, 0},
	0xFD9D, {0x064A, 0x0645, 0x0645, 0},
	0xFD9E, {0x0628, 0x062E, 0x064A, 0},
	0xFD9F, {0x062A, 0x062C, 0x064A, 0},
	0xFDA0, {0x062A, 0x062C, 0x0649, 0},
	0xFDA1, {0x062A, 0x062E, 0x064A, 0},
	0xFDA2, {0x062A, 0x062E, 0x0649, 0},
	0xFDA3, {0x062A, 0x0645, 0x064A, 0},
	0xFDA4, {0x062A, 0x0645, 0x0649, 0},
	0xFDA5, {0x062C, 0x0645, 0x064A, 0},
	0xFDA6, {0x062C, 0x062D, 0x0649, 0},
	0xFDA7, {0x062C, 0x0645, 0x0649, 0},
	0xFDA8, {0x0633, 0x062E, 0x0649, 0},
	0xFDA9, {0x0635, 0x062D, 0x064A, 0},
	0xFDAA, {0x0634, 0x062D, 0x064A, 0},
	0xFDAB, {0x0636, 0x062D, 0x064A, 0},
	0xFDAC, {0x0644, 0x062C, 0x064A, 0},
	0xFDAD, {0x0644, 0x0645, 0x064A, 0},
	0xFDAE, {0x064A, 0x062D, 0x064A, 0},
	0xFDAF, {0x064A, 0x062C, 0x064A, 0},
	0xFDB0, {0x064A, 0x0645, 0x064A, 0},
	0xFDB1, {0x0645, 0x0645, 0x064A, 0},
	0xFDB2, {0x0642, 0x0645, 0x064A, 0},
	0xFDB3, {0x0646, 0x062D, 0x064A, 0},
	0xFDB4, {0x0642, 0x0645, 0x062D, 0},
	0xFDB5, {0x0644, 0x062D, 0x0645, 0},
	0xFDB6, {0x0639, 0x0645, 0x064A, 0},
	0xFDB7, {0x0643, 0x0645, 0x064A, 0},
	0xFDB8, {0x0646, 0x062C, 0x062D, 0},
	0xFDB9, {0x0645, 0x062E, 0x064A, 0},
	0xFDBA, {0x0644, 0x062C, 0x0645, 0},
	0xFDBB, {0x0643, 0x0645, 0x0645, 0},
	0xFDBC, {0x0644, 0x062C, 0x0645, 0},
	0xFDBD, {0x0646, 0x062C, 0x062D, 0},
	0xFDBE, {0x062C, 0x062D, 0x064A, 0},
	0xFDBF, {0x062D, 0x062C, 0x064A, 0},
	0xFDC0, {0x0645, 0x062C, 0x064A, 0},
	0xFDC1, {0x0641, 0x0645, 0x064A, 0},
	0xFDC2, {0x0628, 0x062D, 0x064A, 0},
	0xFDC3, {0x0643, 0x0645, 0x0645, 0},
	0xFDC4, {0x0639, 0x062C, 0x0645, 0},
	0xFDC5, {0x0635, 0x0645, 0x0645, 0},
	0xFDC6, {0x0633, 0x062E, 0x064A, 0},
	0xFDC7, {0x0646, 0x062C, 0x064A, 0},
	0xFE49, {0x203E, 0},
	0xFE4A, {0x203E, 0},
	0xFE4B, {0x203E, 0},
	0xFE4C, {0x203E, 0},
	0xFE4D, {0x005F, 0},
	0xFE4E, {0x005F, 0},
	0xFE4F, {0x005F, 0},
	0xFE80, {0x0621, 0},
	0xFE81, {0x0622, 0},
	0xFE82, {0x0622, 0},
	0xFE83, {0x0623, 0},
	0xFE84, {0x0623, 0},
	0xFE85, {0x0624, 0},
	0xFE86, {0x0624, 0},
	0xFE87, {0x0625, 0},
	0xFE88, {0x0625, 0},
	0xFE89, {0x0626, 0},
	0xFE8A, {0x0626, 0},
	0xFE8B, {0x0626, 0},
	0xFE8C, {0x0626, 0},
	0xFE8D, {0x0627, 0},
	0xFE8E, {0x0627, 0},
	0xFE8F, {0x0628, 0},
	0xFE90, {0x0628, 0},
	0xFE91, {0x0628, 0},
	0xFE92, {0x0628, 0},
	0xFE93, {0x0629, 0},
	0xFE94, {0x0629, 0},
	0xFE95, {0x062A, 0},
	0xFE96, {0x062A, 0},
	0xFE97, {0x062A, 0},
	0xFE98, {0x062A, 0},
	0xFE99, {0x062B, 0},
	0xFE9A, {0x062B, 0},
	0xFE9B, {0x062B, 0},
	0xFE9C, {0x062B, 0},
	0xFE9D, {0x062C, 0},
	0xFE9E, {0x062C, 0},
	0xFE9F, {0x062C, 0},
	0xFEA0, {0x062C, 0},
	0xFEA1, {0x062D, 0},
	0xFEA2, {0x062D, 0},
	0xFEA3, {0x062D, 0},
	0xFEA4, {0x062D, 0},
	0xFEA5, {0x062E, 0},
	0xFEA6, {0x062E, 0},
	0xFEA7, {0x062E, 0},
	0xFEA8, {0x062E, 0},
	0xFEA9, {0x062F, 0},
	0xFEAA, {0x062F, 0},
	0xFEAB, {0x0630, 0},
	0xFEAC, {0x0630, 0},
	0xFEAD, {0x0631, 0},
	0xFEAE, {0x0631, 0},
	0xFEAF, {0x0632, 0},
	0xFEB0, {0x0632, 0},
	0xFEB1, {0x0633, 0},
	0xFEB2, {0x0633, 0},
	0xFEB3, {0x0633, 0},
	0xFEB4, {0x0633, 0},
	0xFEB5, {0x0634, 0},
	0xFEB6, {0x0634, 0},
	0xFEB7, {0x0634, 0},
	0xFEB8, {0x0634, 0},
	0xFEB9, {0x0635, 0},
	0xFEBA, {0x0635, 0},
	0xFEBB, {0x0635, 0},
	0xFEBC, {0x0635, 0},
	0xFEBD, {0x0636, 0},
	0xFEBE, {0x0636, 0},
	0xFEBF, {0x0636, 0},
	0xFEC0, {0x0636, 0},
	0xFEC1, {0x0637, 0},
	0xFEC2, {0x0637, 0},
	0xFEC3, {0x0637, 0},
	0xFEC4, {0x0637, 0},
	0xFEC5, {0x0638, 0},
	0xFEC6, {0x0638, 0},
	0xFEC7, {0x0638, 0},
	0xFEC8, {0x0638, 0},
	0xFEC9, {0x0639, 0},
	0xFECA, {0x0639, 0},
	0xFECB, {0x0639, 0},
	0xFECC, {0x0639, 0},
	0xFECD, {0x063A, 0},
	0xFECE, {0x063A, 0},
	0xFECF, {0x063A, 0},
	0xFED0, {0x063A, 0},
	0xFED1, {0x0641, 0},
	0xFED2, {0x0641, 0},
	0xFED3, {0x0641, 0},
	0xFED4, {0x0641, 0},
	0xFED5, {0x0642, 0},
	0xFED6, {0x0642, 0},
	0xFED7, {0x0642, 0},
	0xFED8, {0x0642, 0},
	0xFED9, {0x0643, 0},
	0xFEDA, {0x0643, 0},
	0xFEDB, {0x0643, 0},
	0xFEDC, {0x0643, 0},
	0xFEDD, {0x0644, 0},
	0xFEDE, {0x0644, 0},
	0xFEDF, {0x0644, 0},
	0xFEE0, {0x0644, 0},
	0xFEE1, {0x0645, 0},
	0xFEE2, {0x0645, 0},
	0xFEE3, {0x0645, 0},
	0xFEE4, {0x0645, 0},
	0xFEE5, {0x0646, 0},
	0xFEE6, {0x0646, 0},
	0xFEE7, {0x0646, 0},
	0xFEE8, {0x0646, 0},
	0xFEE9, {0x0647, 0},
	0xFEEA, {0x0647, 0},
	0xFEEB, {0x0647, 0},
	0xFEEC, {0x0647, 0},
	0xFEED, {0x0648, 0},
	0xFEEE, {0x0648, 0},
	0xFEEF, {0x0649, 0},
	0xFEF0, {0x0649, 0},
	0xFEF1, {0x064A, 0},
	0xFEF2, {0x064A, 0},
	0xFEF3, {0x064A, 0},
	0xFEF4, {0x064A, 0},
	0xFEF5, {0x0644, 0x0622, 0},
	0xFEF6, {0x0644, 0x0622, 0},
	0xFEF7, {0x0644, 0x0623, 0},
	0xFEF8, {0x0644, 0x0623, 0},
	0xFEF9, {0x0644, 0x0625, 0},
	0xFEFA, {0x0644, 0x0625, 0},
	0xFEFB, {0x0644, 0x0627, 0},
	0xFEFC, {0x0644, 0x0627, 0}
};
}

const uint16_t *PDF_GetNormalizedUnicodes(uint16_t uc){
	NormalizedUnicode nu;
	nu.src = uc;
	NormalizedUnicode *end = NormalizedUnicodes + sizeof(NormalizedUnicodes) / sizeof(NormalizedUnicode);
	NormalizedUnicode *f = std::lower_bound(NormalizedUnicodes, end, nu);
	if (f == end) return 0;
	if (f->src != uc) return 0;
	return f->dest;
}

int PDF_GetEncodingTable(const char *encname, const char **&table){
	if (std::strcmp(encname, "StandardEncoding") == 0){
		table = StandardEncoding; return sizeof(StandardEncoding) / sizeof(const char *);
	}
	if (std::strcmp(encname, "MacRomanEncoding") == 0){
		table = MacRomanEncoding; return sizeof(MacRomanEncoding) / sizeof(const char *);
	}
	if (std::strcmp(encname, "WinAnsiEncoding") == 0){
		table = WinAnsiEncoding; return sizeof(WinAnsiEncoding) / sizeof(const char *);
	}
	if (std::strcmp(encname, "MacExpertEncoding") == 0){
		table = MacExpertEncoding; return sizeof(MacExpertEncoding) / sizeof(const char *);
	}

	table = 0; return 0;
}
