/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	TODOCMD_SRC_SETUP
#include"todocmd.h"


/* ===================================================================*/
TODOCMD_SETUP_EXTERN
int
	Setup_ImportClientJson(
			char	*pstr_filename )
{
	int		i_result;

	if( NULL == pstr_filename ) { return 0x03; }

	i_result    = LibToDo_ImportClientJson( pstr_filename );
	if( 0x00 != i_result )	{ return 0x04; }

	puts(" [INFO] Imported Google-API ClientID/Secrect.");
	puts(" [INFO] Next Step, the each user of todocmd command do the following operation." );
	puts(" [INFO]   1. Please do \"> todo setup\" command. ");
	puts(" [INFO]   2. Please access the displayed URL and login with your google Account." );
	puts(" [INFO]   3. Authorize this app to access your Google tasks user data on your browser.");
	puts(" [INFO]   4. Input the Verification Code displayed on the Browser into the console of the todocmd.");

	return 0x00;
}


/* ===================================================================*/
TODOCMD_SETUP_EXTERN
int
	Setup_RegistScenery(
			void )
{
	int		i_len;
	int		i_result;
	char	str_url[1024];
	char	str_code[512];

	i_result	= LibToDo_CreateUserOAuthURL( str_url );
	if( 0x00 != i_result )	{
		return -0x01;
	}

	puts(" Please access the following URL, and login and verificate with your google Account.");
	printf( "%s\n", str_url );

	puts("");
	puts(" Please input the verification code displayed on the Browser.");

	fgets( str_code, 512, stdin );

	i_len	= strnlen( str_code, 512 );
	if( 0 < i_len )	{
		str_code[i_len - 1]	= '\0';
		i_len--;
	}

	puts(" Is the input code correct below? (Y/N): " );

	printf("    CODE: [%s]\n", str_code );
	i_result	= getchar();
	if(('y' != i_result) && ('Y' != i_result))	{
		return 0x00;
	}

	i_result	= LibToDo_CreateConfigFile( str_code );
	if( 0x00 != i_result )	{
		return -0x02;
	}

	puts(" Success! - Create ConfigFile.");

	return 0x00;
}


/* EOF of main.c ******************************************************/
