/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	TODOCMD_SRC_PRINTTODO
#include"todocmd.h"


/* ===================================================================*/
TODOCMD_PRINTTODO_EXTERN
int
	PrintToDo_PrintToDoData(
			LibToDo_Data	*p_tdata,
			DWord	dw_option)
{
	int				i_len;
	char			str_space[16];
	char			str_mark[4];
	char			str_buffer[512];
	char			str_output[512];
	char			chr_status;

	if((TODO_STATUS_COMPLETED & p_tdata->b_status)
			|| (TODO_STATUS_DELETED & p_tdata->b_status ))	{
		if(0x00 == (OPTION_LIST_ALL & dw_option))
			{ return 0x00; }
	}

	memset( str_space, 0x00, 16 );
	memset( str_space, ' ', (p_tdata->i_level * 3) );

	memset( str_mark, 0x00, 4 );
	if( 1 == p_tdata->i_level )	{
		str_mark[0]	= '*';
		str_mark[1] = ' ';
	}
	else if( 2 == p_tdata->i_level )	{
		str_mark[0]	= '-';
		str_mark[1] = ' ';
	}

	i_len	= strnlen( p_tdata->str_item, 512 );
	Common_ConvLanguage_toTerminal(
			str_buffer, (size_t)512, p_tdata->str_item, i_len );

	chr_status	= ' ';
	if( TODO_STATUS_DELETED & p_tdata->b_status )
		{ chr_status	= 'X'; }
	else if( TODO_STATUS_COMPLETED & p_tdata->b_status )
		{ chr_status	= 'C'; }

	snprintf( str_output, 512, "%s%s%s", str_space, str_mark, str_buffer );
	/* for Debug
	printf( "  %c%c <%3d> %-39s %32s %8lu\n", p_tdata->chr_flag, chr_status,
			p_tdata->i_id, str_output, p_tdata->str_id,
			p_tdata->qw_position);
	*/
	printf( "  %c%c <%3d> %-39s %32s\n", p_tdata->chr_flag, chr_status,
			p_tdata->i_id, str_output, p_tdata->str_id );

	return 0x00;
}


/* ===================================================================*/
int
	PrintToDo_PrintSub(
			int		i_list,
			int		i_level,
			DWord	dw_option )
{
	int				i_todo;
	LibToDo_Data	t_data;

	i_todo	= LibToDo_GetChildDataID( i_list );
	while( NO_TODODATA != i_todo )	{
		memset( &t_data, 0x00, sizeof( LibToDo_Data ) );
		LibToDo_GetData( &t_data, i_todo );
		PrintToDo_PrintToDoData( &t_data, dw_option );
		PrintToDo_PrintSub( i_todo, 2, dw_option );
		i_todo	= LibToDo_GetNextDataID( i_todo );
	}

	return 0x00;
}


/* ===================================================================*/
TODOCMD_PRINTTODO_EXTERN
int
	PrintToDo_Print(
			DWord	dw_option )
{
	int				i_todo;
	LibToDo_Data	t_data;

	i_todo	= LibToDo_GetTopDataID();
	while( NO_TODODATA != i_todo )	{
		puts(" ----<Num> Task Name --------------------------------------- Task ID ----------------");
		LibToDo_GetData( &t_data, i_todo );
		PrintToDo_PrintToDoData( &t_data, dw_option );
		PrintToDo_PrintSub( i_todo, 1, dw_option );
		i_todo	= LibToDo_GetNextDataID( i_todo );
	}
		
	puts("");

	return 0x00;
}


/* EOF of main.c ******************************************************/
