/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_GLAPI_LIST

#include"libtodo_header.h"

/*==========================================================================
list
GET		https://www.googleapis.com/tasks/v1/users/@me/lists
Returns all the authenticated user's task lists.
==========================================================================*/
#define	GLAPI_URL_LIST_list	"https://www.googleapis.com/tasks/v1/users/@me/lists"
LIBTODO_GLAPI_LIST_EXTERN
int
	GLAPI_List_GetTaskList(
			void )
{
	int				i_cnt;
	int				i_err;
	int				i_result	= 0x00;
	int				i_tdataid;
	char			str_id[64];
	json_object		*p_json;
	json_object		*p_jitems;
	json_object		*p_jlist;
	ToDo_Data		*p_tdata;
	GLAPI_Result	t_glresult;

	GLAPI_Base_AllocResultArea( &t_glresult );

	i_err	= GLAPI_Base_DoAPI( &t_glresult, SENDAPI_MODE_GET, GLAPI_URL_LIST_list );
	if( 0x00 != i_err )	{
		SET_ERRINFO1( "Failed function call: GLAPI_Base_DoAPI()", i_err );
		i_result	= -0x01;
		goto	goto_GLAPI_List_GetTaskList_return;
	}

	// Parse & Inset ListData ---
	p_json	= json_tokener_parse( (const char *)t_glresult.pb_result );

	if( 0x00 != ProcJson_CheckKind( p_json, JSON_VALUE_LISTS_KIND ) )	{
		SET_ERRINFO( "Failed function call: ProcJson_CheckKind()" );
		i_result	= -0x02;
		goto	goto_GLAPI_List_GetTaskList_putjson;
	}

	p_jitems	= ProcJson_GetJsonChildArray( p_json, JSON_KEY_LISTS_ITEMS );
	if( NULL == p_jitems )	{
		SET_ERRINFO( "Failed function call: ProcJson_GetJsonChildArray()" );
		i_result	= -0x03;
		goto	goto_GLAPI_List_GetTaskList_putjson;
	}

	for( i_cnt = 0; i_cnt < json_object_array_length( p_jitems); i_cnt++ )	{
		p_jlist	= json_object_array_get_idx( p_jitems, i_cnt );
		assert( NULL != p_jlist );

		// kind
		if( 0x00 != ProcJson_CheckKind( p_jlist, JSON_VALUE_LIST_KIND ) )	{
			SET_ERRINFO( "Failed function call: ProcJson_CheckKind()" );
			i_result	= -0x05;
			goto	goto_GLAPI_List_GetTaskList_putjson;
		}
	
		// id
		ProcJson_GetJsonChildString( str_id, p_jlist, JSON_KEY_LIST_ID, 64 );

		i_tdataid	= ToDoData_InsetToDoData( 0, TODODATA_TYPE_LIST, str_id, TODODATA_APPEND );
		if( 0 > i_tdataid )	{
			SET_ERRINFO1( "Failed function call: ToDoData_InsetToDoData()", i_tdataid );
			i_result	= -0x04;
			goto	goto_GLAPI_List_GetTaskList_putjson;
		}

		p_tdata	= ToDoData_GetToDoData( i_tdataid );
		assert( NULL != p_tdata );

		// etag: NOT USE.
		// title
		ProcJson_GetJsonChildString( p_tdata->t_data.str_item, p_jlist, JSON_KEY_LIST_TITLE, 512 );
		// updated
		ProcJson_GetJsonChildString( p_tdata->t_data.str_update, p_jlist, JSON_KEY_LIST_UPDATED, 32 );
		ToDoData_RenewLastUpdated( p_tdata->t_data.str_update );
		// selflink: NOT USE.

		// Flag
		ToDoData_UpdateFlag( p_tdata, TODODATA_FLAG_SYNCED );

		// level
		p_tdata->t_data.i_level	= 0;

		p_tdata->t_data.i_id	= p_tdata->i_id;
	}
	i_result	= i_cnt;

goto_GLAPI_List_GetTaskList_putjson:
	json_object_put( p_json );

goto_GLAPI_List_GetTaskList_return:
	GLAPI_Base_FreeResultArea( &t_glresult );

	return i_result;
}


/*==========================================================================
get
GET		https://www.googleapis.com/tasks/v1/users/@me/lists/tasklist
Returns the authenticated user's specified task list.
==========================================================================*/

/*==========================================================================
insert
POST	https://www.googleapis.com/tasks/v1/users/@me/lists
Creates a new task list and adds it to the authenticated user's task lists.
==========================================================================*/

/*==========================================================================
update
PUT		https://www.googleapis.com/tasks/v1/users/@me/lists/tasklist
Updates the authenticated user's specified task list.
==========================================================================*/

/*==========================================================================
delete
DELETE	https://www.googleapis.com/tasks/v1/users/@me/lists/tasklist
Deletes the authenticated user's specified task list.
==========================================================================*/

/*==========================================================================
patch
PATACH	https://www.googleapis.com/tasks/v1/users/@me/lists/tasklist
Updates the authenticated user's specified task list.
This method supports patch semantics. 
==========================================================================*/



/* EOF of main.c ******************************************************/
