/*TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO

                           T o D o C m d
           (Command-Line & ncurses Google Tasks/Todo Client)

   Copyright(C) 2019- Koine Yuusuke(koinec). All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice,
     this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.

 THIS SOFTWARE IS PROVIDED BY Koine Yuusuke(koinec) ``AS IS'' AND ANY
 EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL Koine Yuusuke(koinec) OR CONTRIBUTORS BE
 LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 OF THE POSSIBILITY OF SUCH DAMAGE.

TODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODOCMDTODO*/


#define	LIBTODO_SRC_LIBTODO_ERROR

#include"libtodo_header.h"

/* ===================================================================*/
LIBTODO_API_ERROR_EXTERN
int
	LibToDo_GetErrorInfo(
			char	*pstr_errmsg,
			int		i_len,
			int		i_history )
{
	int		i_errinfo;
	char	str_buf[512];

	if(( 0 > i_history ) || ( ERROR_MAXERRORS <= i_history ) || ( 0 >= i_len ))	{
		return -0x01;
	}

	i_errinfo	= ((ERROR_MAXERRORS + gi_errinfos - i_history) % ERROR_MAXERRORS );

	assert( 0 <= i_errinfo );
	assert( ERROR_MAXERRORS > i_errinfo );

	if( '\0' == gt_errinfo[ i_errinfo ].str_srcfile[0] )	{
		*(pstr_errmsg + 0)	= '\0';
		return 0x00;
	}

	snprintf( str_buf, sizeof(str_buf), "  libtodo [%s:%d]: %s (param1= %d, param2= %ul)\n", 
				gt_errinfo[ i_errinfo ].str_srcfile,
				gt_errinfo[ i_errinfo ].i_line,
				gt_errinfo[ i_errinfo ].str_errmsg,
				gt_errinfo[ i_errinfo ].i_value1,
				gt_errinfo[ i_errinfo ].dw_value2 );

	strncpy( pstr_errmsg, str_buf, i_len );

	return 0x01;
}


/* ===================================================================*/
LIBTODO_API_ERROR_EXTERN
void
	LibToDo_PrintErrorInfo(
			void )
{
	int		i_cnt;
	char	str_buf[512];

	for( i_cnt = 0; i_cnt < ERROR_MAXERRORS; i_cnt++ )	{
		if( LibToDo_GetErrorInfo( str_buf, sizeof( str_buf ), i_cnt ) )
			{ puts( str_buf ); }
	}

	return;
}


/* ===================================================================*/
LIBTODO_ERROR_EXTERN
void
	Error_SetErrorInfo(
			char	*pstr_srcfile,
			int		i_line,
			const char	*pstr_errmsg,
			int		i_value1,
			DWord	dw_value2 )
{
	strncpy( gt_errinfo[ gi_errinfos ].str_srcfile, pstr_srcfile,
						sizeof( gt_errinfo[gi_errinfos].str_srcfile ) );
	gt_errinfo[ gi_errinfos ].i_line	= i_line;
	strncpy( gt_errinfo[ gi_errinfos ].str_errmsg, pstr_errmsg,
						sizeof( gt_errinfo[gi_errinfos].str_errmsg ) );
	gt_errinfo[ gi_errinfos ].i_value1	= i_value1;
	gt_errinfo[ gi_errinfos ].dw_value2	= dw_value2;

	gi_errinfos++;
	gi_errinfos	= (( ERROR_MAXERRORS == gi_errinfos ) ? 0 : gi_errinfos );

	return;
}


/* ===================================================================*/
LIBTODO_ERROR_EXTERN
void
	Error_InitErrorInfo(
			void )
{
	gi_errinfos	= 0;
	memset( &gt_errinfo, 0x00, sizeof( LibToDo_ErrorInfo ) * ERROR_MAXERRORS );

	return;
}


/* ===================================================================*/
LIBTODO_ERROR_EXTERN
void
	Error_TermErrorInfo(
			void )
{
	return;
}


/* EOF of main.c ******************************************************/
