/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.ui.view;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.ccc.atools.command.AbstractCommand;
import org.ccc.atools.command.CommandManager;
import org.ccc.atools.command.Converter;
import org.ccc.atools.command.ICommand;
import org.ccc.atools.command.extention.CommandInfo;
import org.ccc.atools.command.extention.CommandRegistry;
import org.ccc.atools.command.extention.ICommandDelegate;
import org.ccc.atools.internal.command.NullConverter;
import org.ccc.atools.mediator.AToolUI;
import org.ccc.atools.message.Messages;
import org.ccc.atools.ui.view.FileInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ConvertView
extends ViewPart {
    private static final String SOURCE_FILE_LABEL = Messages.ConvertView_SOURCE_FILE_LABEL;
    private static final String FILE_DIALOG_SOURCE_FILES = Messages.ConvertView_FILE_DIALOG_SOURCE_FILES;
    private static final String TARGET_LABEL_NAME = Messages.ConvertView_TARGET_LABEL_NAME;
    private static final String FILE_DIALOG_TARGET_FILES = Messages.ConvertView_FILE_DIALOG_TARGET_FILES;
    private static final String FILE_DIALOG_BUTTON = Messages.ConvertView_FILE_DIALOG_BUTTON;
    private static final String STATUS_LABEL = Messages.ConvertView_STATUS_LABEL;
    private static final String STATUS_LABEL_ERR_SOURCE_FILE_MUST_BE_SPECIFIED = Messages.ConvertView_STATUS_LABEL_ERR_SOURCE_FILE_MUST_BE_SPECIFIED;
    private static final String STATUS_LABEL_ERR_TARGET_FILE_MUST_BE_SPECIFIED = Messages.ConvertView_STATUS_LABEL_ERR_TARGET_FILE_MUST_BE_SPECIFIED;
    private static final String STATUS_LABEL_ERR_TARGET_FILE_ALREADY_EXISTS = Messages.ConvertView_STATUS_LABEL_ERR_TARGET_FILE_ALREADY_EXISTS;
    private static final String COMMAND_CONVERT_BUTTON = Messages.ConvertView_COMMAND_CONVERT_BUTTON;
    private static final String COMMAND_LABEL_PRE_CONVERT = Messages.ConvertView_COMMAND_LABEL_PRE_CONVERT;
    private static final String COMMAND_LABEL_POST_CONVERT = Messages.ConvertView_COMMAND_LABEL_POST_CONVERT;
    private static final String COMMAMD_STATUS_LABEL = Messages.ConvertView_COMMAMD_STATUS_LABEL;
    private static final String ACTION_SHOW_MASSAGE = Messages.ConvertView_ACTION_SHOW_MASSAGE;
    private static final String ACTION_MASSAGE_LABEL = Messages.ConvertView_ACTION_MASSAGE_LABEL;
    private static final String ACTION_MASSAGE_TOOLTIP_LABEL = Messages.ConvertView_ACTION_MASSAGE_TOOLTIP_LABEL;
    private static final String DOUBLE_CLICK_ACTION_SHOW_MASSAGE = Messages.ConvertView_DOUBLE_CLICK_ACTION_SHOW_MASSAGE;
    private static final String ACTION_SHOW_TITLE = Messages.ConvertView_ACTION_SHOW_TITLE;
    private static final String SCALE_MENU_LABEL = Messages.ConvertView_SCALE_MENU_LABEL;
    private static final String SCALE_TO_COPY_ACTION_MASSAGE_LABEL = Messages.ConvertView_SCALE_TO_COPY_ACTION_MASSAGE_LABEL;
    private static final String SCALE_TO_COPY_ACTION_MASSAGE_TOOLTIP_LABEL = Messages.ConvertView_SCALE_TO_COPY_ACTION_MASSAGE_TOOLTIP_LABEL;
    private static final String SCALE_TO_FULLHD_ACTION_MASSAGE_LABEL = Messages.ConvertView_SCALE_TO_FULLHD_ACTION_MASSAGE_LABEL;
    private static final String SCALE_TO_FULLHD_ACTION_MASSAGE_TOOLTIP_LABEL = Messages.ConvertView_SCALE_TO_FULLHD_ACTION_MASSAGE_TOOLTIP_LABEL;
    private static final String SCALE_TO_HD_ACTION_MASSAGE_LABEL = Messages.ConvertView_SCALE_TO_HD_ACTION_MASSAGE_LABEL;
    private static final String SCALE_TO_HD_ACTION_MASSAGE_TOOLTIP_LABEL = Messages.ConvertView_SCALE_TO_HD_ACTION_MASSAGE_TOOLTIP_LABEL;
    private static final String SCALE_TO_VGA_ACTION_MASSAGE_LABEL = Messages.ConvertView_SCALE_TO_VGA_ACTION_MASSAGE_LABEL;
    private static final String SCALE_TO_VGA_ACTION_MASSAGE_TOOLTIP_LABEL = Messages.ConvertView_SCALE_TO_VGA_ACTION_MASSAGE_TOOLTIP_LABEL;
    public static final String ID = "org.ccc.ConvertView";
    @Inject
    IWorkbench workbench;
    private Text statusText;
    private Text commandText;
    private ProgressBar progressBar;
    protected Button commandButton;
    protected FileInfo fileInfo;
    protected CommandManager commandManager;
    private TableViewer viewer;
    private Action action;
    private Action doubleClickAction;
    private final String scale_copy = "-1";
    private final String scale_640 = "640";
    private final String scale_1280 = "1280";
    protected String scale;
    private Action scaleToCopyAction;
    private Action scaleToFullHDAction;
    private Action scaleToHDAction;
    private Action scaleToVGAAction;
    protected String encode;

    public void dispose() {
        this.commandManager = null;
        this.viewer = null;
        super.dispose();
    }

    private Text getStatusText() {
        return this.statusText;
    }

    private void setStatusText(Text statusText) {
        this.statusText = statusText;
    }

    private Text getCommandText() {
        return this.commandText;
    }

    private ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label sourceLabel = new Label(container, 0);
        sourceLabel.setText(SOURCE_FILE_LABEL);
        Text sourceText = new Text(container, 2060);
        GridData sourceGd = new GridData(768);
        sourceText.setLayoutData((Object)sourceGd);
        sourceText.addModifyListener(e -> this.dialogChanged());
        Button sourceButton = new Button(container, 8);
        sourceButton.setText(FILE_DIALOG_BUTTON);
        sourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleBrowse();
            }

            private void handleBrowse() {
                FileDialog fileDialog = new FileDialog(parent.getShell(), 34);
                fileDialog.setText(FILE_DIALOG_SOURCE_FILES);
                fileDialog.open();
                String[] fileNames = fileDialog.getFileNames();
                if (fileNames.length == 0) {
                    return;
                }
                String dirName = fileDialog.getFilterPath();
                IPath fullPath = Path.fromOSString((String)dirName);
                fullPath = fullPath.addTrailingSeparator();
                fullPath = fullPath.append(fileNames[0]);
                ConvertView.this.fileInfo.setSourcePath(fullPath);
                sourceText.setText(fullPath.toOSString());
            }
        });
        Label targetLabel = new Label(container, 0);
        targetLabel.setText(TARGET_LABEL_NAME);
        Text targetText = new Text(container, 2060);
        GridData targetGd = new GridData(768);
        targetText.setLayoutData((Object)targetGd);
        targetText.addModifyListener(e -> this.dialogChanged());
        Button targetButton = new Button(container, 8);
        targetButton.setText(FILE_DIALOG_BUTTON);
        targetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleBrowse();
            }

            private void handleBrowse() {
                FileDialog fileDialog = new FileDialog(parent.getShell(), 34);
                fileDialog.setText(FILE_DIALOG_TARGET_FILES);
                fileDialog.open();
                String[] fileNames = fileDialog.getFileNames();
                if (fileNames.length == 0) {
                    return;
                }
                String dirName = fileDialog.getFilterPath();
                IPath fullPath = Path.fromOSString((String)dirName);
                fullPath = fullPath.addTrailingSeparator();
                fullPath = fullPath.append(fileNames[0]);
                ConvertView.this.fileInfo.setTargetPath(fullPath);
                targetText.setText(fullPath.toOSString());
            }
        });
        Display display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        Image image = display.getSystemImage(2);
        Label imageLabel = new Label(container, 0);
        imageLabel.setImage(image);
        this.statusText = new Text(container, 2060);
        GridData statusGd = new GridData(768);
        this.statusText.setLayoutData((Object)statusGd);
        this.statusText.setBackground(AToolUI.getDisplay().getSystemColor(29));
        this.statusText.setForeground(AToolUI.getDisplay().getSystemColor(28));
        Label statusLabel = new Label(container, 0);
        statusLabel.setText(STATUS_LABEL);
        this.commandText = new Text(container, 2060);
        GridData commandGd = new GridData(768);
        this.commandText.setLayoutData((Object)commandGd);
        this.commandText.addModifyListener(e -> this.dialogChanged());
        this.progressBar = new ProgressBar(container, 65536);
        GridData progressGd = new GridData(768);
        this.progressBar.setLayoutData((Object)progressGd);
        display.timerExec(100, new Runnable(){

            @Override
            public void run() {
                if (ConvertView.this.progressBar.isDisposed()) {
                    return;
                }
                ConvertView.this.updateCommandProgress();
                if (ConvertView.this.progressBar.getSelection() <= ConvertView.this.progressBar.getMaximum()) {
                    display.timerExec(100, (Runnable)this);
                }
            }
        });
        this.commandButton = new Button(container, 8);
        this.commandButton.setText(COMMAND_CONVERT_BUTTON);
        this.commandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConvertView.this.commandText.setText(COMMAND_LABEL_PRE_CONVERT);
                try {
                    if (ConvertView.this.commandButton.getClass().isInstance(e.getSource()) && ConvertView.this.commandButton.isEnabled()) {
                        Converter converter = null;
                        converter = ConvertView.this.scale == null ? new Converter() : new Converter(ConvertView.this.scale);
                        ICommandDelegate commandDelegate = null;
                        if (ConvertView.this.encode == null) {
                            commandDelegate = new NullConverter();
                        } else {
                            Map<String, CommandInfo> encodeToCommandInfos = CommandRegistry.getInstance().getEncodeToCommandInfos();
                            CommandInfo commandInfo = encodeToCommandInfos.get(ConvertView.this.encode);
                            commandDelegate = commandInfo.getCommand();
                        }
                        converter.setCommand(commandDelegate, ConvertView.this.fileInfo.getSourcePath().toOSString(), ConvertView.this.fileInfo.getTargetPath().toOSString(), new AToolUI());
                        ConvertView.this.commandManager.setCommand(converter);
                        ConvertView.this.commandManager.execute();
                    }
                }
                finally {
                    ConvertView.this.commandText.setText(COMMAND_LABEL_POST_CONVERT);
                }
            }
        });
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)new String[]{"select a source movie", "select a target movie"});
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.workbench.getHelpSystem().setHelp(this.viewer.getControl(), "org.ccc.atools.ui.viewer");
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.initialize();
        this.dialogChanged();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ConvertView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        IContributionItem item;
        MenuManager subMenu = new MenuManager(SCALE_MENU_LABEL);
        subMenu.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
        subMenu.add((IAction)this.scaleToCopyAction);
        subMenu.add((IAction)this.scaleToFullHDAction);
        subMenu.add((IAction)this.scaleToHDAction);
        subMenu.add((IAction)this.scaleToVGAAction);
        this.scaleToFullHDAction.setChecked(true);
        manager.add((IContributionItem)subMenu);
        manager.add((IContributionItem)new Separator());
        MenuManager subMenu2 = new MenuManager("Encode Type");
        subMenu2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
        ArrayList<String> encodes = new ArrayList<String>(CommandRegistry.getInstance().getEncodeToCommandInfos().keySet());
        encodes.sort(String::compareTo);
        for (String encodeType : encodes) {
            Action action = new Action(encodeType, 8){

                public void run() {
                    ConvertView.this.encode = encodeType;
                }
            };
            subMenu2.add((IAction)action);
        }
        IContributionItem[] items = subMenu2.getItems();
        if (items.length > 0 && (item = items[0]) instanceof ActionContributionItem) {
            ((ActionContributionItem)item).getAction().setChecked(true);
            ((ActionContributionItem)item).getAction().run();
        }
        manager.add((IContributionItem)subMenu2);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action);
    }

    private void makeActions() {
        this.action = new Action(){

            public void run() {
                ConvertView.this.showMessage(ACTION_SHOW_MASSAGE);
            }
        };
        this.action.setText(ACTION_MASSAGE_LABEL);
        this.action.setToolTipText(ACTION_MASSAGE_TOOLTIP_LABEL);
        this.action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.scaleToCopyAction = new Action(null, 8){

            public void run() {
                ConvertView.this.scale = "-1";
            }
        };
        this.scaleToCopyAction.setText(SCALE_TO_COPY_ACTION_MASSAGE_LABEL);
        this.scaleToCopyAction.setToolTipText(SCALE_TO_COPY_ACTION_MASSAGE_TOOLTIP_LABEL);
        this.scaleToFullHDAction = new Action(null, 8){

            public void run() {
                ConvertView.this.scale = null;
            }
        };
        this.scaleToFullHDAction.setText(SCALE_TO_FULLHD_ACTION_MASSAGE_LABEL);
        this.scaleToFullHDAction.setToolTipText(SCALE_TO_FULLHD_ACTION_MASSAGE_TOOLTIP_LABEL);
        this.scaleToHDAction = new Action(null, 8){

            public void run() {
                ConvertView.this.scale = "1280";
            }
        };
        this.scaleToHDAction.setText(SCALE_TO_HD_ACTION_MASSAGE_LABEL);
        this.scaleToHDAction.setToolTipText(SCALE_TO_HD_ACTION_MASSAGE_TOOLTIP_LABEL);
        this.scaleToVGAAction = new Action(null, 8){

            public void run() {
                ConvertView.this.scale = "640";
            }
        };
        this.scaleToVGAAction.setText(SCALE_TO_VGA_ACTION_MASSAGE_LABEL);
        this.scaleToVGAAction.setToolTipText(SCALE_TO_VGA_ACTION_MASSAGE_TOOLTIP_LABEL);
        this.doubleClickAction = new Action(){

            public void run() {
                IStructuredSelection selection = ConvertView.this.viewer.getStructuredSelection();
                Object obj = selection.getFirstElement();
                ConvertView.this.showMessage(String.valueOf(DOUBLE_CLICK_ACTION_SHOW_MASSAGE) + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConvertView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)ACTION_SHOW_TITLE, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void initialize() {
        this.fileInfo = new FileInfo();
        this.commandManager = new CommandManager();
    }

    private void dialogChanged() {
        IPath sourcePath = this.fileInfo.getSourcePath();
        IPath targetPath = this.fileInfo.getTargetPath();
        if (sourcePath == null) {
            this.updateStatus(STATUS_LABEL_ERR_SOURCE_FILE_MUST_BE_SPECIFIED);
            return;
        }
        if (targetPath == null) {
            this.updateStatus(STATUS_LABEL_ERR_TARGET_FILE_MUST_BE_SPECIFIED);
            return;
        }
        if (this.existOf(targetPath)) {
            this.updateStatus(STATUS_LABEL_ERR_TARGET_FILE_ALREADY_EXISTS);
            return;
        }
        this.updateStatus(null);
    }

    private boolean existOf(IPath path) {
        return path.toFile().exists();
    }

    private void updateStatus(String message) {
        this.setStatusText(message == null ? "" : message);
        this.updateCommandProgress();
        this.enableCommandFor(message == null);
        this.updateCommandHistory();
    }

    private void setStatusText(String message) {
        Text text = this.getStatusText();
        if (text != null) {
            text.setText(message);
        }
    }

    private void updateCommandProgress() {
        this.updateCommandText();
        this.updateProgressBar();
    }

    private void updateCommandText() {
        Text text = this.getCommandText();
        if (text == null) {
            return;
        }
        List<ICommand> commands = this.commandManager.findTerminatedCommands();
        String newText = "[" + String.valueOf(commands.size()) + " / " + String.valueOf(String.valueOf(this.commandManager.getCommandHistory().size()) + "]" + " " + COMMAMD_STATUS_LABEL);
        if (!newText.equals(text.getText())) {
            text.setText(newText);
        }
    }

    private void updateProgressBar() {
        if (this.progressBar != null) {
            List<ICommand> commands = this.commandManager.findTerminatedCommands();
            this.progressBar.setMaximum(this.commandManager.getCommandHistory().size());
            this.progressBar.setSelection(commands.size());
        }
    }

    private void enableCommandFor(boolean enable) {
        if (this.commandButton != null) {
            this.commandButton.setEnabled(enable);
        }
    }

    private void updateCommandHistory() {
        Object oldInput;
        if (this.viewer == null) {
            return;
        }
        ArrayList<String> newInput = new ArrayList<String>();
        for (ICommand command : this.commandManager.getCommandHistory()) {
            if (!(command instanceof AbstractCommand)) continue;
            AbstractCommand abstractCommand = (AbstractCommand)command;
            String sourcePath = abstractCommand.getInput();
            String targetPath = abstractCommand.getOutput();
            if (sourcePath == null || targetPath == null) continue;
            String s = String.valueOf(sourcePath) + " -> " + targetPath;
            newInput.add(s);
        }
        String[] newInputArray = newInput.toArray(new String[newInput.size()]);
        if (!newInputArray.equals(oldInput = this.viewer.getInput())) {
            this.viewer.setInput((Object)newInputArray);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            ICommand command;
            if (ConvertView.this.fileInfo == null) {
                return ConvertView.this.workbench.getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
            if (obj instanceof String && (command = this.findTerminatedCommand((String)obj)) != null) {
                return ConvertView.this.workbench.getSharedImages().getImage("IMG_TOOL_COPY");
            }
            return ConvertView.this.workbench.getSharedImages().getImage("IMG_ELCL_SYNCED");
        }

        private ICommand findTerminatedCommand(String obj) {
            if (ConvertView.this.commandManager == null) {
                return null;
            }
            String[] split = obj.split(Pattern.quote(" -> "));
            if (split.length != 2) {
                return null;
            }
            return ConvertView.this.commandManager.findTerminatedCommand(split[0], split[1]);
        }
    }
}

