/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.mediator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.ccc.atools.mediator.Console;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

public class AToolUI
implements Console {
    private int resultForConsole = 0;
    private boolean inheritConsole = false;

    public boolean isInheritConsole() {
        return this.inheritConsole;
    }

    public void setInheritConsole(boolean inheritConsole) {
        this.inheritConsole = inheritConsole;
    }

    public void dispose() {
    }

    @Override
    public void execForConsole(String[] command) {
        this.execForUIConsole(command);
    }

    private void execForUIConsole(String[] command) {
        this.execForUIConsole(command, null);
    }

    private void execForUIConsole(String[] command, File directory) {
        Process rawProc = null;
        try {
            rawProc = DebugPlugin.exec((String[])command, (File)directory);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        IProcess proc = this.showConsole(rawProc);
    }

    private IProcess showConsole(Process rawProc) {
        if (rawProc == null) {
            return null;
        }
        Launch launch = new Launch(null, "run", null);
        String label = this.createLabel("org.ccc.atools");
        IProcess proc = DebugPlugin.newProcess((ILaunch)launch, (Process)rawProc, (String)label);
        proc.setAttribute("org.ccc.atools", Long.toString(System.currentTimeMillis()));
        IOConsole console = this.getConsole(proc, label);
        IOConsoleOutputStream consoleStream = console instanceof MessageConsole ? ((MessageConsole)console).newMessageStream() : console.newOutputStream();
        IStreamListener streamlistener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                this.println(text);
            }

            private void print(String message) {
                try {
                    consoleStream.write(message);
                }
                catch (IOException e) {
                    ConsolePlugin.log((Throwable)e);
                }
            }

            private void println(String message) {
                this.print(String.valueOf(message) + "\n");
            }
        };
        proc.getStreamsProxy().getOutputStreamMonitor().addListener(streamlistener);
        proc.getStreamsProxy().getErrorStreamMonitor().addListener(streamlistener);
        IDebugEventSetListener listener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    this.handleDebugEvent(event);
                    ++n2;
                }
            }

            private void handleDebugEvent(DebugEvent event) {
                Object obj = event.getSource();
                ITerminate dt = null;
                if (event.getKind() == 8 && obj instanceof ITerminate && proc == (dt = (ITerminate)obj)) {
                    AToolUI.this.resultForConsole |= 1;
                    System.out.println("[Info] Process is finished.");
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(listener);
        console.activate();
        return proc;
    }

    private String createLabel(String consoleId) {
        if (this.isInheritConsole()) {
            return consoleId;
        }
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        org.eclipse.ui.console.IConsole[] consoles = conMan.getConsoles();
        ArrayList<org.eclipse.ui.console.IConsole> consolesForATools = new ArrayList<org.eclipse.ui.console.IConsole>();
        org.eclipse.ui.console.IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole processConsole;
            IProcess process;
            String timestamp;
            org.eclipse.ui.console.IConsole console = iConsoleArray[n2];
            if (console instanceof IConsole && (timestamp = (process = (processConsole = (IConsole)console).getProcess()).getAttribute(consoleId)) != null) {
                consolesForATools.add(console);
            }
            ++n2;
        }
        return String.valueOf(consoleId) + "(" + this.createSuffix(consoleId) + ")";
    }

    private String createSuffix(String consoleId) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        org.eclipse.ui.console.IConsole[] consoles = conMan.getConsoles();
        ArrayList<org.eclipse.ui.console.IConsole> consolesForAToolS = new ArrayList<org.eclipse.ui.console.IConsole>();
        org.eclipse.ui.console.IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole processConsole;
            IProcess process;
            String timestamp;
            org.eclipse.ui.console.IConsole console = iConsoleArray[n2];
            if (console instanceof IConsole && (timestamp = (process = (processConsole = (IConsole)console).getProcess()).getAttribute(consoleId)) != null) {
                consolesForAToolS.add(console);
            }
            ++n2;
        }
        int count = consolesForAToolS.size() + 1;
        return String.valueOf(count);
    }

    private IOConsole getConsole(IProcess proc, String name) {
        org.eclipse.ui.console.IConsole console;
        org.eclipse.ui.console.IConsole[] consoles;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        org.eclipse.ui.console.IConsole[] iConsoleArray = consoles = conMan.getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            console = iConsoleArray[n2];
            if (name.equals(console.getName())) {
                return (IOConsole)console;
            }
            ++n2;
        }
        console = new ProcessConsole(proc, new IConsoleColorProvider(){

            public boolean isReadOnly() {
                return false;
            }

            public Color getColor(String streamIdentifer) {
                return AToolUI.getDisplay().getSystemColor(9);
            }

            public void connect(IProcess process, IConsole console) {
            }

            public void disconnect() {
            }
        });
        conMan.addConsoles(new org.eclipse.ui.console.IConsole[]{console});
        return console;
    }

    @Override
    public int getResultForConsole() {
        return this.resultForConsole;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

