/*
 * Decompiled with CFR 0.152.
 */
package org.ccc.atools.command.filter.extention;

import java.util.HashMap;
import java.util.Map;
import org.ccc.atools.command.filter.extention.CommandFilterInfo;
import org.ccc.atools.command.filter.extention.ICommandFilterDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class CommandFilterRegistry {
    private static final String COMMAND_EXTENSION_POINT = "org.ccc.atools.commandFilters";
    public static final String EXTENSION_NAME = "commandFilter";
    public static final String ATT_FILTER = "filter";
    public static final String ATT_CLASS = "class";
    public static final String ATT_EXCLUSION = "exclusion";
    private static CommandFilterRegistry singleton;
    private Map<String, CommandFilterInfo> filterToCommandFilterInfos;

    private CommandFilterRegistry() {
    }

    public static CommandFilterRegistry getInstance() {
        if (singleton == null) {
            singleton = new CommandFilterRegistry();
        }
        return singleton;
    }

    public Map<String, CommandFilterInfo> getFilterToCommandFilterInfos() {
        if (this.filterToCommandFilterInfos == null) {
            this.filterToCommandFilterInfos = this.createFilterToCommandFilterInfos();
        }
        return this.filterToCommandFilterInfos;
    }

    private Map<String, CommandFilterInfo> createFilterToCommandFilterInfos() {
        HashMap<String, CommandFilterInfo> result = new HashMap<String, CommandFilterInfo>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(COMMAND_EXTENSION_POINT);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block6: {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getName().equals(EXTENSION_NAME)) {
                        ICommandFilterDelegate commandFilter;
                        String exclusion;
                        String filter;
                        block5: {
                            filter = ce.getAttribute(ATT_FILTER);
                            exclusion = ce.getAttribute(ATT_EXCLUSION);
                            commandFilter = null;
                            try {
                                Object aClass = ce.createExecutableExtension(ATT_CLASS);
                                if (!(aClass instanceof ICommandFilterDelegate)) break block5;
                                commandFilter = (ICommandFilterDelegate)aClass;
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                                break block6;
                            }
                        }
                        CommandFilterInfo commandFilterInfo = new CommandFilterInfo();
                        commandFilterInfo.setFilter(filter);
                        commandFilterInfo.setCommandFilter(commandFilter);
                        commandFilterInfo.setExclusion(exclusion != null ? exclusion : "");
                        result.put(filter, commandFilterInfo);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }
}

