#!/usr/bin/ruby
# -*- coding:utf-8 -*-


# ==============================================================================
# split_new_entries
# ==============================================================================

split_new_entries = Proc.new do

	file = File.new("mozcdic.txt", "r")
		mozcdic = file.readlines
	file.close

	# mozcエントリの並びを変えてマークをつける
	# (変更前) げんかん	1823	1823	5278	玄関
	# (変更後) げんかん	玄関	*1823	1823	5278

	mozcdic.length.times do |i|
		s = mozcdic[i].chomp.split("	")
		s = [s[0], s[4], "*" + s[1], s[2], s[3]]
		mozcdic[i] = s.join("	")
	end

	file = File.new($filename, "r")
		neologd = file.readlines
	file.close

	# neologdエントリの並びを変える
	# (変更前) げんかん	1617	1617	7178	厳寒
	# (変更後) げんかん	厳寒	1617	1617	7178

	neologd.length.times do |i|
		s = neologd[i].chomp.split("	")
		s = [s[0], s[4], s[1], s[2], s[3]]
		neologd[i] = s.join("	")
	end

	lines = mozcdic + neologd
	mozcdic = []
	neologd = []
	lines = lines.sort

	# この時点での並び
	# げんかん	玄関	*1823	1823	5278
	# げんかん	厳寒	1617	1617	7178

	dicfile = File.new($dicname, "w")

	# 新規エントリを書き出す
	lines.length.times do |i|
		s1 = lines[i].chomp.split("	")
		s2 = lines[i - 1].chomp.split("	")

		# mozcエントリをスキップ
		if s1[2][0] == "*"
			next
		end

		if s2[2][0] == "*"
			s2[2] = s2[2][1..-1]
		end

		# mozcエントリと読み+表記+左文脈IDが重複しないものを収録
		if s1[0..2] != s2[0..2]
			s1 = [s1[0], s1[2], s1[3], s1[4], s1[1]]
			dicfile.puts s1.join("	")
		end
	end

	dicfile.close
end


# ==============================================================================
# main
# ==============================================================================

targetfiles = ARGV

if ARGV == []
	puts "Usage: ruby script.rb [FILE]"
	exit
end

targetfiles.length.times do |i|
	$filename = targetfiles[i]
	$dicname = $filename + ".newentries"

	split_new_entries.call
end
