# auth.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg plugin providing support for signing distributable packages.
#
# -----------------------------------------------------------------------------
#
# $Id: auth.sh,v 0fac2bbafaf3 2018/12/03 22:11:40 keith $
#
# Written by Keith Marshall <keithmarshall@users.sourceforge.net>
# Copyright (C) 2018, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
  require module defn

# Loaded from user's $HOME/.mingw-pkgrc, by command:
#
#   load plugin auth <gpg_cmd> <key_id>
#
# we must save the name of the gpg command, which will be used to generate
# the package signatures, and the user's signing key id...
#
  GPG_CMD=$3 GPG_KEY_ID=$4

# ...in addition to providing the implementation for the mingw-pkg "sign"
# sub-command action:
#
  defn sign
  defn_set_hook sign default sign_staged_packages
  sign_staged_packages(){
  # Iterate over the source, and all associated component packages, as
  # identified within the package specification file, and marshalled in
  # the mingw-dist package staging directory, and invoke the nominated
  # gpg signing command in respect of each.
  #
    phase gpg_sign "sign distributable packages"
    ( cd ${STAGED_PKGDIR-"dist"}
      for component in src $COMPONENTS
      do  case $component in
	    *:*) package="`IFS=:; set -- $component; defn_parameter_list $1`"
		 component="`IFS=:; set -- $component; defn_parameter_list $2`" ;;
	    *)   package=$PACKAGE ;;
	  esac
	  package="$package-$TAGGED_VERSION-$ARCH-$component${PKGEXT-".tar"}"
	  gpg_sign_package $package
      done
    )
    phase "done."
  }

  gpg_sign_package(){
    step "generate $GPG_CMD detached signature for package $1"
    $GPG_CMD --sign --detach-sign --yes --local-user $GPG_KEY_ID $1
  }
#
# -----------------------------------------------------------------------------
# $RCSfile: auth.sh,v $: end of file
