# help.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg module implementing the built-in help displays.
#
# -----------------------------------------------------------------------------
#
# $Id: help.sh,v 45e5c6c41d94 2020/01/08 19:16:48 keith $
#
# Written by Keith Marshall <keith@users.osdn.me>
# Copyright (C) 2014, 2018, 2019, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
  for help_class in all synopsis options actions
  do case $help_class in ${optarg-"all"}*) optarg=$help_class;; esac
  done

  help_synopsis(){
    cat <<-ETX
	Usage: ${cmd="mingw-pkg"} [OPTIONS] [VAR=value ...] [ACTION ...]

	Download and build packages, as directed by mingw-port specifications,
	and/or construct and manage MinGW.org distributable package sets.

	ETX
      }

  help_options(){
    cat <<-ETX
	Options:
	  -h, --help[=class]	Display help, and exit; "class" is any one of:--
	 	synopsis	Show only the command synopsis.
	 	options		Show the synopsis, and summary of options.
	 	actions		Show the synopsis, and summary of action keywords.
	 	all		Show the full "help" display; (this is the default).

	  --licence		Display the $cmd licence, and exit.
	  --license		A synonym for "--licence".

	  -V, --version		Display the $cmd version, and exit.

	  --srcdir=path		Specify the relative path from the build directory
	 			to the package source tree; this becomes a "sticky"
	 			setting, (i.e. once specified, it will be reused for
	 			subsequent $cmd invocations within the current
	 			build directory, unless subsequently redefined).

	  --arch=name		Specify the architecture for which the package is
	 			to be built; if unspecified, "mingw32" is assumed.

	  --port		Modify the behaviour of the "distribute" action,
	 			such that its payload is reduced to that required
	 			for distribution as a mingw-port.

	  --identity="<name>-<version>"
	 			Set the package identity explicitly, rather than
	 			deducing it from the source directory name; this
	 			is required when the source directory structure
	 			has not been established at invocation time, e.g.
	 			when importing a mingw-port specification.

	  --option="spec"	Augment the set of options specified within the
	 			package specification file; "spec" must take the
	 			form of an "option" directive, as it would appear
	 			within that file.

	  --keep-staged-image	Do not delete the staged package image, after
	 			creating a distributable package set; (this option
	 			is required, prior to use of the "--pre-staged"
	 			option, when incrementally updating distributable
	 			package sets.

	  --pre-staged		When creating a distributable package set, do not
	 			run an "install" step, to refresh the staged image.

	  --ignore-untracked-files
	 			Ignore the presence of untracked files, within the
	 			source directory hierarchy, when creating a source
	 			code distribution; normally, mingw-pkg will abort
	 			when any untracked files, or uncommitted changes to
	 			tracked files, are detected; this option allows the
	 			operation to continue, in the presence of untracked
	 			files, (but not if there are uncommitted changes).

	  -v, --verbose		Make diagnostic output more verbose; currently,
	   			this only enables progress reporting, when creating
	 			distributable package sets in lzma or xz format.

	  -c, --stdout		Direct output from the "mkspec" action to standard
	 			output, rather than creating or overwriting the
	 			default package specification file.

	  --xtool		Enable cross-compiler build mode; do not pass any
	 			"--build" or "--host" options to configure, so that
	 			configuration relates to native compilation of the
	 			cross-compiler tools themselves, when running the
	 			build process on a non-MinGW host.

	ETX
      }

  help_actions(){
    cat <<-ETX
	Actions:
	  import		Download and unpack the upstream source tarball,
	 			after having first done likewise for an associated
	 			mingw-port specification file, if necessary.

	  initialize		Prepare the development environment, considering
	 			the current state of the package directory as being
	 			representative of the clean upstream package, for
	 			progression towards a MinGW port.

	  mkspec		Create a package specification template, at the
	 			appropriate location within the package source tree;
	 			this should then be edited manually, to customize it
	 			for the particular package to which it relates.

	  patch			Apply the series of patches, if any, which accompany
	 			the package specification file.

	  configure		Run the configure script, if any in the top source
	 			directory, to prepare the package for compilation.

	  compile		Compile the package, in whatever state is currently
	 			represented by the content of the package directory.

	  install		Install the package, either into its ultimate
	 			location, or into a staging directory tree, prior
	 			to creating a distributable package set.

	  distribute		Create a distributable package set.

	  mkxml			Create an initial mingw-get catalogue entry file,
	 			for the distributable package set; (note that this
	 			may require further manual editing).

	  clean			Clean build files from the package directory tree.

	ETX
      }

  case $optarg in
    synopsis) help_$optarg;;
    options | actions) help_synopsis; help_$optarg;;
    all) help_synopsis; help_options; help_actions;;
    *) die "unknown help category '$optarg'";;
  esac

  exit 0
#
# -----------------------------------------------------------------------------
# $RCSfile: help.sh,v $: end of file
