# dmh.sh
# -----------------------------------------------------------------------------
#
# mingw-pkg module implementing diagnostic message handler functions
#
# -----------------------------------------------------------------------------
#
# $Id: dmh.sh,v 1ce4aa1b5978 2018/10/31 19:35:24 keith $
#
# Written by Keith Marshall <keithmarshall@users.sourceforge.net>
# Copyright (C) 2018, MinGW.org Project
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# -----------------------------------------------------------------------------
#
# ANSI terminal control sequences to select/reset bold output...
#
  sgr_mode(){ echo "$sgr_control_prefix$@"; }
  sgr_control_prefix=`echo '^[[' | tr -s '^[' '\033['`
  bold=`sgr_mode 1m` unbold=`sgr_mode '30;0m'`

# ...and for selecting coloured output for diagnostic messages.
#
  error_colour=`sgr_mode '31;1m'` warning_colour=`sgr_mode 31m`

# Use them, to implement the diagnostic message functions.
#
  warning(){ echo >&2 "$warning_colour$cmd: *** WARNING *** $@$unbold"; }
  error(){ echo >&2 "$error_colour$cmd: *** ERROR *** $@$unbold"; }

  die(){
    local status=2
    case $1 in --) shift ;; [0-9]*) die_with_status "$1" "$1" && shift ;; esac
    echo >&2 "$error_colour$cmd: *** FATAL *** $@$unbold"; exit $status
  }
  if ( foo=777; test "${foo#[0-9]}" = 77 ) 2> /dev/null
  then
    die_with_status(){
      until test "x$2" = "x${2#[0-9]}"; do set -- "$1" "${2#[0-9]}"; done
      test "x$2" = x && status="$1"
    }
  else
    die_with_status(){
      echo "$1" | grep > /dev/null 2>&1 '^[0-9][0-9]*$' && status="$1"
    }
  fi
#
# -----------------------------------------------------------------------------
# $RCSfile: dmh.sh,v $: end of file
