/*
 * Decompiled with CFR 0.152.
 */
package v1;

import bits.BitExclusiveSelector;
import bits.BooleanVariable;
import bits.Conjunction;
import bits.IBooleanVariable;
import bits.KSatReader;
import bits.exceptions.UnsolvableProblemException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import v1.ConstraintHandler;
import v1.Node;
import v1.PList;
import v1.ParaIDAndNumLevels;
import v1.Parameter;
import v1.Testcase;

class SATConstraintHandler
implements ConstraintHandler {
    private ArrayList<ParaIDAndNumLevels> parameterToIDAndNumLevels = new ArrayList();
    private IBooleanVariable[][] booleanVariables = null;
    private int[][] sat4jvariables = null;
    private bits.IProblem booleanConstraint = null;
    private IProblem sat4jproblem;
    KSatReader reader = null;
    ISolver solver = null;

    SATConstraintHandler(PList parameterList, List<Node> constraintList, TreeSet<Integer> constrainedParametersArg) {
        for (Integer factor : constrainedParametersArg) {
            ParaIDAndNumLevels pidlevels = new ParaIDAndNumLevels(factor, ((Parameter)parameterList.get((int)factor.intValue())).value_name.size());
            this.parameterToIDAndNumLevels.add(pidlevels);
        }
        this.booleanVariables = new IBooleanVariable[this.parameterToIDAndNumLevels.size()][];
        try {
            int i = 0;
            for (ParaIDAndNumLevels pidlevels : this.parameterToIDAndNumLevels) {
                this.booleanVariables[i] = new IBooleanVariable[pidlevels.getNumLevels()];
                int j = 0;
                while (j < pidlevels.getNumLevels()) {
                    String str = "p" + pidlevels.getID() + "_" + j;
                    this.booleanVariables[i][j] = BooleanVariable.getBooleanVariable(str);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.booleanConstraint = this.setSATConstraint(constraintList);
        this.solver = SolverFactory.newDefault();
        this.reader = new KSatReader(this.solver);
        try {
            this.sat4jproblem = this.reader.parseInstance(this.booleanConstraint);
        }
        catch (UnsolvableProblemException e) {
            e.printStackTrace();
        }
        this.sat4jvariables = new int[this.parameterToIDAndNumLevels.size()][];
        try {
            int i = 0;
            while (i < this.parameterToIDAndNumLevels.size()) {
                ParaIDAndNumLevels pidlevels;
                pidlevels = this.parameterToIDAndNumLevels.get(i);
                this.sat4jvariables[i] = new int[pidlevels.getNumLevels()];
                int j = 0;
                while (j < pidlevels.getNumLevels()) {
                    IBooleanVariable ib = this.booleanVariables[i][j];
                    this.sat4jvariables[i][j] = this.reader.getSat4jVariable(ib);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    private bits.IProblem setSATConstraint(List<Node> constraintList) {
        ArrayList<bits.IProblem> problemArrayList = new ArrayList<bits.IProblem>();
        int i = 0;
        while (i < constraintList.size()) {
            bits.IProblem tmp = constraintList.get(i).buildSAT(this.parameterToIDAndNumLevels, this.booleanVariables);
            problemArrayList.add(tmp);
            ++i;
        }
        i = 0;
        while (i < this.parameterToIDAndNumLevels.size()) {
            ArrayList<IBooleanVariable> bitArrayList = new ArrayList<IBooleanVariable>();
            ParaIDAndNumLevels pidlevels = this.parameterToIDAndNumLevels.get(i);
            int j = 0;
            while (j < pidlevels.getNumLevels()) {
                bitArrayList.add(this.booleanVariables[i][j]);
                ++j;
            }
            try {
                BitExclusiveSelector problem = new BitExclusiveSelector(bitArrayList);
                problemArrayList.add(problem);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        Conjunction res = null;
        try {
            res = new Conjunction(problemArrayList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isPossible(Testcase test) {
        res = false;
        constList = new ArrayList<IConstr>();
        try {
            i = 0;
            while (i < this.parameterToIDAndNumLevels.size()) {
                block9: {
                    p = this.parameterToIDAndNumLevels.get(i).getID();
                    v = test.get(p);
                    if (v >= 0) {
                        clause = new int[]{this.sat4jvariables[i][v]};
                        try {
                            tmp = this.solver.addClause(new VecInt(clause));
                            if (tmp != null) {
                                constList.add(tmp);
                            }
                            break block9;
                        }
                        catch (ContradictionException e) {
                            res = false;
                            ** for (cnst : constList)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.solver.removeConstr(cnst);
                            continue;
                        }
lbl22:
                        // 1 sources

                        return res;
                    }
                }
                ++i;
            }
            problem = this.solver;
            res = problem.isSatisfiable();
            for (IConstr cnst : constList) {
                this.solver.removeConstr(cnst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean isPossible(int[] test) {
        res = false;
        constList = new ArrayList<IConstr>();
        try {
            i = 0;
            while (i < this.parameterToIDAndNumLevels.size()) {
                block9: {
                    p = this.parameterToIDAndNumLevels.get(i).getID();
                    v = test[p];
                    if (v >= 0) {
                        clause = new int[]{this.sat4jvariables[i][v]};
                        try {
                            tmp = this.solver.addClause(new VecInt(clause));
                            if (tmp != null) {
                                constList.add(tmp);
                            }
                            break block9;
                        }
                        catch (ContradictionException e) {
                            res = false;
                            ** for (cnst : constList)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.solver.removeConstr(cnst);
                            continue;
                        }
lbl22:
                        // 1 sources

                        return res;
                    }
                }
                ++i;
            }
            problem = this.solver;
            res = problem.isSatisfiable();
            for (IConstr cnst : constList) {
                this.solver.removeConstr(cnst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        return res;
    }
}

