/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.List;
import v1.CombinationGenerator;
import v1.ConstraintHandler;
import v1.Error;
import v1.GList;
import v1.Generator;
import v1.Main;
import v1.OutOfMaxNumOfTestcasesException;
import v1.ParameterModel;
import v1.Testcase;

public class IPOG
extends Generator {
    protected int[][] matrix;
    protected int strength;
    protected boolean[][] bitmap;
    protected int numOfRows;
    private int[] positions;

    IPOG(ParameterModel parametermodel, GList groupList, ConstraintHandler constrainthandler, List<Testcase> seed, long randomseed, int strength) {
        super(parametermodel, groupList, constrainthandler, seed, randomseed);
        this.strength = strength;
        this.matrix = new int[10000][parametermodel.size];
        int i = 0;
        while (i < 10000) {
            int j = 0;
            while (j < parametermodel.size) {
                this.matrix[i][j] = -1;
                ++j;
            }
            ++i;
        }
    }

    @Override
    List<Testcase> generate() throws OutOfMaxNumOfTestcasesException {
        this.buildFirstColumnsDebug();
        ArrayList<Testcase> res = new ArrayList<Testcase>();
        int factorID = this.strength;
        while (factorID < this.parametermodel.size) {
            this.initializeBitmap(factorID);
            this.horizontalExtentionNew(factorID);
            this.verticalExtention(factorID);
            ++factorID;
        }
        if (Main.randstar == Main.Randstar.OFF) {
            this.fillInStars();
        }
        int i = 0;
        while (i < this.numOfRows) {
            Testcase test = new Testcase(this.parametermodel.size);
            int j = 0;
            while (j < this.parametermodel.size) {
                test.set(j, this.matrix[i][j]);
                ++j;
            }
            res.add(test);
            if (res.size() > 10000) {
                throw new OutOfMaxNumOfTestcasesException();
            }
            ++i;
        }
        return res;
    }

    private void fillInStars() {
        int row = 0;
        while (row < this.numOfRows) {
            int column = 0;
            while (column < this.parametermodel.size) {
                if (this.matrix[row][column] < 0) {
                    int range = this.parametermodel.range[column];
                    int basevalue = this.rnd.nextInt(range);
                    int i = 0;
                    while (i < range) {
                        int value;
                        this.matrix[row][column] = value = (basevalue + i) % range;
                        if (this.constrainthandler.isPossible(this.matrix[row])) break;
                        this.matrix[row][column] = -1;
                        ++i;
                    }
                    if (this.matrix[row][column] < 0) {
                        System.err.println("fillin star error!");
                    }
                }
                ++column;
            }
            ++row;
        }
    }

    private void initializeBitmap(int factorID) {
        int totalColumnCombinations = CombinationGenerator.getTotalNumber(factorID, this.strength - 1);
        this.bitmap = new boolean[totalColumnCombinations][];
        this.positions = new int[totalColumnCombinations];
        CombinationGenerator cg = new CombinationGenerator(factorID, this.strength - 1);
        do {
            int numOfTuples = this.parametermodel.range[factorID];
            int i = 0;
            while (i < this.strength - 1) {
                numOfTuples *= this.parametermodel.range[cg.get(i)];
                ++i;
            }
            this.bitmap[cg.getID()] = new boolean[numOfTuples];
        } while (cg.visitNext());
    }

    private void verticalExtention(int factor) {
        CombinationGenerator cg = new CombinationGenerator(factor, this.strength - 1);
        do {
            int[] bases = this.getBases(cg, this.strength - 1, factor);
            int i = 0;
            while (i < this.bitmap[cg.getID()].length) {
                if (!this.bitmap[cg.getID()][i]) {
                    int[] tuple = this.getTupleFromID(i, bases);
                    Testcase tmp = new Testcase(this.parametermodel.size);
                    tmp.initiallize();
                    int j = 0;
                    while (j < this.strength - 1) {
                        tmp.set(cg.get(j), tuple[j]);
                        ++j;
                    }
                    tmp.set(factor, tuple[this.strength - 1]);
                    boolean isValid = this.constrainthandler.isPossible(tmp);
                    if (isValid) {
                        this.addTupleNew(tuple, cg, factor);
                    }
                    this.bitmap[cg.getID()][i] = true;
                }
                ++i;
            }
        } while (cg.visitNext());
    }

    private void addTupleNew(int[] tuple, CombinationGenerator cg, int factor) {
        int row = 0;
        while (row < this.numOfRows) {
            if (tuple[this.strength - 1] == this.matrix[row][factor]) {
                boolean isIdentical = true;
                int i = tuple.length - 2;
                while (i >= 0) {
                    if (tuple[i] != this.matrix[row][cg.get(i)]) {
                        isIdentical = false;
                        break;
                    }
                    --i;
                }
                if (isIdentical) {
                    return;
                }
            }
            ++row;
        }
        row = 0;
        while (row < 10000) {
            block18: {
                if (this.matrix[row][factor] < 0 || tuple[this.strength - 1] == this.matrix[row][factor]) {
                    int i = tuple.length - 2;
                    while (i >= 0) {
                        if (this.matrix[row][cg.get(i)] < 0 || tuple[i] == this.matrix[row][cg.get(i)]) {
                            --i;
                            continue;
                        }
                        break block18;
                    }
                    Testcase tmp = new Testcase(this.parametermodel.size);
                    tmp.initiallize();
                    int j = 0;
                    while (j < this.strength - 1) {
                        tmp.set(cg.get(j), tuple[j]);
                        ++j;
                    }
                    tmp.set(factor, tuple[this.strength - 1]);
                    j = 0;
                    while (j < factor) {
                        if (tmp.get(j) < 0) {
                            tmp.set(j, this.matrix[row][j]);
                        }
                        ++j;
                    }
                    if (this.constrainthandler.isPossible(tmp)) {
                        this.matrix[row][factor] = tuple[this.strength - 1];
                        assert (tuple[this.strength - 1] < this.parametermodel.range[factor]);
                        int i2 = tuple.length - 2;
                        while (i2 >= 0) {
                            this.matrix[row][cg.get((int)i2)] = tuple[i2];
                            assert (tuple[i2] < this.parametermodel.range[cg.get(i2)]);
                            --i2;
                        }
                        if (row >= this.numOfRows) {
                            assert (row == this.numOfRows);
                            this.numOfRows = row + 1;
                        }
                        return;
                    }
                }
            }
            ++row;
        }
        Error.printError(Main.language == Main.Language.JP ? "\u4e0a\u965010000\u3092\u8d85\u3048\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059" : "The number of test cases exceeds the upper bound 10000");
    }

    private void horizontalExtentionNew(int factor) {
        int levelsOfCurrentFactor = this.parametermodel.range[factor];
        int[] occurrence = new int[levelsOfCurrentFactor];
        int row = 0;
        while (row < this.numOfRows) {
            int i;
            boolean[] validity = new boolean[levelsOfCurrentFactor];
            int v = 0;
            while (v < levelsOfCurrentFactor) {
                this.matrix[row][factor] = v;
                validity[v] = this.constrainthandler.isPossible(this.matrix[row]);
                ++v;
            }
            this.matrix[row][factor] = -1;
            int[] count = new int[levelsOfCurrentFactor];
            CombinationGenerator cg = new CombinationGenerator(factor, this.strength - 1);
            do {
                int id = 0;
                int multiplier = levelsOfCurrentFactor;
                boolean isDontcareContained = false;
                i = this.strength - 2;
                while (i >= 0) {
                    int column = cg.get(i);
                    if (this.matrix[row][column] < 0) {
                        isDontcareContained = true;
                        break;
                    }
                    id += this.matrix[row][column] * multiplier;
                    multiplier *= this.parametermodel.range[column];
                    --i;
                }
                int cg_getID = cg.getID();
                if (isDontcareContained) {
                    this.positions[cg_getID] = -1;
                    continue;
                }
                this.positions[cg_getID] = id;
                int v2 = 0;
                while (v2 < levelsOfCurrentFactor) {
                    if (!validity[v2]) {
                        count[v2] = -1;
                    } else if (!this.bitmap[cg_getID][id + v2]) {
                        int n = v2;
                        count[n] = count[n] + 1;
                    }
                    ++v2;
                }
            } while (cg.visitNext());
            int maxv = -1;
            int maxcount = -1;
            int min_occurrence = 0;
            int v3 = 0;
            while (v3 < levelsOfCurrentFactor) {
                if (count[v3] > maxcount && validity[v3] || count[v3] == maxcount && validity[v3] && occurrence[v3] < min_occurrence) {
                    maxcount = count[v3];
                    maxv = v3;
                    min_occurrence = occurrence[v3];
                }
                ++v3;
            }
            if (maxcount > 0) {
                this.matrix[row][factor] = maxv;
                assert (maxv < levelsOfCurrentFactor);
                int n = maxv;
                occurrence[n] = occurrence[n] + 1;
                i = 0;
                while (i < this.positions.length) {
                    int id = this.positions[i];
                    if (id >= 0) {
                        this.bitmap[i][id + maxv] = true;
                    }
                    ++i;
                }
            }
            ++row;
        }
    }

    protected void buildFirstColumnsDebug() throws OutOfMaxNumOfTestcasesException {
        int numOfCombinations = 1;
        int row = 0;
        int i = 0;
        while (i < this.strength) {
            numOfCombinations *= this.parametermodel.range[i];
            ++i;
        }
        boolean isTupleValid = false;
        int[] tuple = new int[this.strength];
        int i2 = 0;
        while (i2 < this.strength) {
            tuple[i2] = 0;
            this.matrix[row][i2] = 0;
            ++i2;
        }
        if (this.constrainthandler.isPossible(this.matrix[row])) {
            ++row;
        }
        i2 = 1;
        while (i2 < numOfCombinations) {
            int j = this.strength - 1;
            while (j >= 0) {
                if (tuple[j] + 1 < this.parametermodel.range[j]) {
                    int n = j;
                    int n2 = tuple[n] + 1;
                    tuple[n] = n2;
                    this.matrix[row][j] = n2;
                    int k = j - 1;
                    while (k >= 0) {
                        this.matrix[row][k] = tuple[k];
                        --k;
                    }
                    break;
                }
                tuple[j] = 0;
                this.matrix[row][j] = 0;
                --j;
            }
            isTupleValid = this.constrainthandler.isPossible(this.matrix[row]);
            if (isTupleValid) {
                if (row + 1 > 10000) {
                    Error.printError(Main.language == Main.Language.JP ? "\u7279\u5b9a\u56e0\u5b50\u306e\u5168\u7db2\u7f85\u306b\u4e0a\u965010000\u3092\u8d85\u3048\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059" : "The number of test cases exceeds the upper bound 10000");
                } else {
                    ++row;
                }
            }
            ++i2;
        }
        if (!isTupleValid) {
            i2 = 0;
            while (i2 < this.strength) {
                this.matrix[row][i2] = -1;
                ++i2;
            }
        }
        this.numOfRows = row;
    }

    protected void buildFirstColumns() throws OutOfMaxNumOfTestcasesException {
        int numOfCombinations = 1;
        int row = 0;
        int i = 0;
        while (i < this.strength) {
            numOfCombinations *= this.parametermodel.range[i];
            ++i;
        }
        Testcase tmptest = new Testcase(this.parametermodel.size);
        tmptest.initiallize();
        int i2 = 0;
        while (i2 < this.strength) {
            tmptest.set(i2, 0);
            ++i2;
        }
        if (this.constrainthandler.isPossible(tmptest)) {
            int j = 0;
            while (j < this.strength) {
                this.matrix[row][j] = tmptest.get(j);
                ++j;
            }
            ++row;
        }
        i2 = 1;
        while (i2 < numOfCombinations) {
            tmptest = tmptest.makeClone();
            int j = this.strength - 1;
            while (j >= 0) {
                if (tmptest.get(j) + 1 < this.parametermodel.range[j]) {
                    tmptest.set(j, tmptest.get(j) + 1);
                    break;
                }
                tmptest.set(j, 0);
                --j;
            }
            if (this.constrainthandler.isPossible(tmptest)) {
                if (row + 1 > 10000) {
                    Error.printError(Main.language == Main.Language.JP ? "\u7279\u5b9a\u56e0\u5b50\u306e\u5168\u7db2\u7f85\u306b\u4e0a\u965010000\u3092\u8d85\u3048\u308b\u30c6\u30b9\u30c8\u30b1\u30fc\u30b9\u304c\u5fc5\u8981\u3067\u3059" : "The number of test cases exceeds the upper bound 10000");
                }
                j = 0;
                while (j < this.strength) {
                    this.matrix[row][j] = tmptest.get(j);
                    assert (tmptest.get(j) < this.parametermodel.range[j]);
                    ++j;
                }
                ++row;
            }
            ++i2;
        }
        this.numOfRows = row;
    }

    private int[] getBases(CombinationGenerator cg, int size, int factor) {
        int base = this.parametermodel.range[factor];
        int[] bases = new int[size];
        int i = size - 1;
        while (i >= 0) {
            bases[i] = base;
            base *= this.parametermodel.range[cg.get(i)];
            --i;
        }
        return bases;
    }

    private int[] getTupleFromID(int id, int[] bases) {
        int[] tuple = new int[bases.length + 1];
        int i = 0;
        while (i < bases.length) {
            tuple[i] = id / bases[i];
            id %= bases[i];
            ++i;
        }
        tuple[bases.length] = id;
        return tuple;
    }
}

