/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.util.AbstractSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Factory;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.DisjointSet;
import jdd.util.Test;
import jdd.util.math.BitMatrix;

public class SimpleAlgorithms {
    public static Vector divide(Graph graph) {
        int n = graph.numOfNodes();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Vector<Graph> vector = new Vector<Graph>();
        Vector<Edge> vector2 = new Vector<Edge>();
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        HashSet hashSet = new HashSet(graph.getNodes());
        while (!hashSet.isEmpty()) {
            Object object;
            Object object2;
            hashMap.clear();
            vector2.clear();
            Graph graph2 = new Graph(graph.isDirected());
            vector.add(graph2);
            Node node = (Node)hashSet.iterator().next();
            hashSet.remove(node);
            nodeArray[0] = node;
            n2 = 1;
            while (n2 > 0) {
                object2 = nodeArray[--n2];
                object = graph2.addCopy((Node)object2);
                hashMap.put(object2, object);
                Edge edge = ((Node)object2).firstOut;
                while (edge != null) {
                    if (hashSet.remove(edge.n2)) {
                        nodeArray[n2++] = edge.n2;
                    }
                    vector2.add(edge);
                    edge = edge.next;
                }
                edge = ((Node)object2).firstIn;
                while (edge != null) {
                    if (hashSet.remove(edge.n1)) {
                        nodeArray[n2++] = edge.n1;
                    }
                    vector2.add(edge);
                    edge = edge.prev;
                }
            }
            object2 = vector2.elements();
            while (object2.hasMoreElements()) {
                object = (Edge)object2.nextElement();
                graph2.addCopy((Node)hashMap.get(((Edge)object).n1), (Node)hashMap.get(((Edge)object).n2), (Edge)object);
            }
        }
        return vector;
    }

    public static int level_n_degree(Node node, int n, AbstractSet abstractSet) {
        abstractSet.clear();
        SimpleAlgorithms.add_adjacent_rec(abstractSet, node, n);
        abstractSet.remove(node);
        return abstractSet.size();
    }

    private static void add_adjacent_rec(AbstractSet abstractSet, Node node, int n) {
        if (n <= 0) {
            return;
        }
        Edge edge = node.firstOut;
        while (edge != null) {
            if (abstractSet.add(edge.n2)) {
                SimpleAlgorithms.add_adjacent_rec(abstractSet, edge.n2, n - 1);
            }
            edge = edge.next;
        }
        edge = node.firstIn;
        while (edge != null) {
            if (abstractSet.add(edge.n1)) {
                SimpleAlgorithms.add_adjacent_rec(abstractSet, edge.n1, n - 1);
            }
            edge = edge.prev;
        }
    }

    public static boolean is_bipartie(Graph graph) {
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (edge.n1 == edge.n2) continue;
            if (edge.n1.extra1 == -1 && edge.n2.extra1 == -1) {
                edge.n1.extra1 = 0;
                edge.n2.extra1 = 1;
                continue;
            }
            if (edge.n1.extra1 == -1) {
                edge.n1.extra1 = 1 ^ edge.n2.extra1;
                continue;
            }
            if (edge.n2.extra1 == -1) {
                edge.n2.extra1 = 1 ^ edge.n1.extra1;
                continue;
            }
            if ((edge.n2.extra1 ^ edge.n1.extra1) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean is_connected(Graph graph) {
        int n = graph.numOfNodes();
        if (n == 0) {
            return false;
        }
        return SimpleAlgorithms.number_of_islands(graph) <= 1;
    }

    public static boolean is_tree(Graph graph) {
        if (graph.numOfNodes() != graph.numOfEdges() + 1) {
            return false;
        }
        return SimpleAlgorithms.is_connected(graph);
    }

    public static BitMatrix transistive_closure(Graph graph) {
        int n = 0;
        int n2 = graph.numOfNodes();
        BitMatrix bitMatrix = new BitMatrix(n2, n2);
        bitMatrix.clear();
        Enumeration enumeration = graph.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).extra1 = n++;
        }
        for (int i = 0; i < n2; ++i) {
            bitMatrix.set(i, i);
        }
        Enumeration enumeration2 = graph.getEdges().elements();
        while (enumeration2.hasMoreElements()) {
            Edge edge = (Edge)enumeration2.nextElement();
            bitMatrix.set(edge.n2.extra1, edge.n1.extra1);
            if (graph.isDirected()) continue;
            bitMatrix.set(edge.n1.extra1, edge.n2.extra1);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n2; ++k) {
                    if (!bitMatrix.get(j, i) || !bitMatrix.get(i, k)) continue;
                    bitMatrix.set(j, k);
                }
            }
        }
        return bitMatrix;
    }

    public static int number_of_islands(Graph graph) {
        int n = 0;
        int n2 = graph.numOfNodes();
        Object object = graph.getNodes().elements();
        while (object.hasMoreElements()) {
            ((Node)object.nextElement()).extra1 = n++;
        }
        object = new DisjointSet(n2);
        Enumeration enumeration = graph.getEdges().elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            ((DisjointSet)object).union(((DisjointSet)object).find(edge.n1.extra1), ((DisjointSet)object).find(edge.n2.extra1));
        }
        return ((DisjointSet)object).classes();
    }

    public static void internal_test() {
        Test.start("SimpleAlgorithms");
        Graph graph = new Graph(false);
        Test.checkEquality(SimpleAlgorithms.is_connected(graph), false, "empty graphs not connected");
        Node node = graph.addNode();
        Node node2 = graph.addNode();
        Node node3 = graph.addNode();
        graph.addEdge(node, node2);
        Test.checkEquality(SimpleAlgorithms.is_connected(graph), false, "not connected yet");
        graph.addEdge(node, node3);
        Test.checkEquality(SimpleAlgorithms.is_connected(graph), true, "connected now");
        Test.checkEquality(SimpleAlgorithms.is_connected(Factory.complete(5)), true, "A complete graphs is always connected");
        graph = Factory.tree(3, 4);
        Test.checkEquality(SimpleAlgorithms.is_connected(graph), true, "A tree connected");
        Test.checkEquality(SimpleAlgorithms.is_tree(graph), true, "A tree is a tree :)");
        Test.check(!SimpleAlgorithms.is_bipartie(Factory.circle(999)), "circle of odd length is not bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.circle(100)), "circle of even length is  bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.path(9)), "a path is always bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.complete_bipartie(4, 4)), "K4,4 is bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.complete_bipartie(2, 500)), "K2,500 is bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.complete(2)), "K2 is bi-partie");
        Test.check(!SimpleAlgorithms.is_bipartie(Factory.complete(3)), "K3 is not bi-partie");
        Test.check(!SimpleAlgorithms.is_bipartie(Factory.complete(4)), "K4 is not bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.tree(4, 4)), "a tree is bi-partie");
        Test.check(SimpleAlgorithms.is_bipartie(Factory.permutation(4)), "a permutation tree is bi-partie");
        graph = new Graph(false);
        Node node4 = graph.addNode();
        node4.setLabel("d1");
        Node node5 = graph.addNode();
        node5.setLabel("d2");
        Node node6 = graph.addNode();
        node6.setLabel("d3");
        Node node7 = graph.addNode();
        node7.setLabel("d4");
        graph.addEdge(node4, node5);
        Vector vector = SimpleAlgorithms.divide(graph);
        Test.checkEquality(vector.size(), 3, "divide: 3 subgraphs");
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Graph graph2 = (Graph)enumeration.nextElement();
            n += graph2.numOfNodes();
            n2 += graph2.numOfEdges();
        }
        Test.checkEquality(graph.numOfNodes(), n, "divide: correct num of nodes");
        Test.checkEquality(graph.numOfEdges(), n2, "divide: corrent num of edges");
        Test.end();
    }
}

