/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.bdd;

import jdd.des.automata.Automata;
import jdd.des.automata.AutomataIO;
import jdd.des.automata.bdd.BDDAutomata;
import jdd.des.automata.bdd.BDDAutomataHelper;
import jdd.des.automata.bdd.ConjunctivePartitions;
import jdd.des.automata.bdd.SymbolicAutomataSearch;

public class ConjunctiveSearch
implements SymbolicAutomataSearch {
    private ConjunctivePartitions cp;
    private BDDAutomata manager;

    public ConjunctiveSearch(ConjunctivePartitions conjunctivePartitions) {
        this.cp = conjunctivePartitions;
        this.manager = conjunctivePartitions.getBDDAutomata();
    }

    @Override
    public void cleanup() {
    }

    @Override
    public int forward(int n) {
        int n2;
        int n3 = this.manager.ref(n);
        do {
            n2 = n3;
            int n4 = this.image(n3);
            n3 = this.manager.orTo(n3, n4);
            this.manager.deref(n4);
            System.err.print(".");
        } while (n2 != n3);
        return n3;
    }

    public int image(int n) {
        int n2;
        int n3;
        int n4 = this.manager.ref(n);
        for (n3 = 0; n3 < this.cp.getSize(); ++n3) {
            n2 = this.manager.relProd(n4, this.cp.getBDDDeltaTop(n3), this.cp.getBDDSCube(n3));
            this.manager.deref(n4);
            n4 = this.manager.ref(n2);
        }
        n3 = this.manager.ref(this.manager.exists(n4, this.manager.getBDDCubeEvents()));
        this.manager.deref(n4);
        n2 = this.manager.ref(this.manager.replace(n3, this.manager.getPermSp2S()));
        this.manager.deref(n3);
        return n2;
    }

    public static void main(String[] stringArray) {
        try {
            Automata automata = AutomataIO.loadXML("data/agv.xml");
            BDDAutomata bDDAutomata = new BDDAutomata(automata);
            ConjunctivePartitions conjunctivePartitions = new ConjunctivePartitions(bDDAutomata);
            ConjunctiveSearch conjunctiveSearch = new ConjunctiveSearch(conjunctivePartitions);
            int n = BDDAutomataHelper.getI(bDDAutomata);
            int n2 = conjunctiveSearch.forward(n);
            double d = BDDAutomataHelper.countStates(bDDAutomata, n2);
            System.out.println("Found " + d + " states");
            conjunctivePartitions.cleanup();
            bDDAutomata.cleanup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

