/*
 * Decompiled with CFR 0.152.
 */
package jdd.des.automata.analysis;

import jdd.graph.Graph;
import jdd.graph.Topology;
import jdd.util.JDDConsole;
import jdd.util.math.Digits;

public class AutomataAnalyzerData {
    private static final String fields = "file\tautomata\tevents\tcomponents\tG-STATES.max\tL-STATES.min\tL-STATES.max\tL-STATES.avg\tL-STATES.dev\tL-EVENTS.min\tL-EVENTS.max\tL-EVENTS.avg\tL-EVENTS.dev\tPCG.edges\tPCG.weight-sum\tMST.edges\tMST.weight\tVC.ED.nodes\tVC.MDG.nodes\tDep.min\tDep.max\tDep.agv\tDep.dev\tDep.min.name\tDep.max.name\tDep2.min\tDep2.max\tDep2.agv\tDep2.dev\tDep2.min.name\tDep2.max.name\tEvProb.min\tEvProb.max\tEvProb.avg\tEvProb.dev\tEvProb.min.name\tEvProb.max.name\tEBF";
    public String file;
    public String internal_name;
    public int num_automata;
    public int num_events;
    public int g_num_edges;
    public int g_num_island;
    public double g_vcnodes_mdg;
    public double g_vcnodes_ed;
    public double max_states;
    public double g_sum_weight;
    public double g_mst_weight;
    public double g_mst_edges;
    public double level1_dep_min;
    public double level1_dep_max;
    public double level1_dep_avg;
    public double level1_dep_dev;
    public double level2_dep_min;
    public double level2_dep_max;
    public double level2_dep_avg;
    public double level2_dep_dev;
    public double event_prob_min;
    public double event_prob_max;
    public double event_prob_avg;
    public double event_prob_dev;
    public String level1_dep_min_name;
    public String level1_dep_max_name;
    public String level2_dep_min_name;
    public String level2_dep_max_name;
    public String event_prob_min_name;
    public String event_prob_max_name;
    public double state_dist_min;
    public double state_dist_max;
    public double state_dist_avg;
    public double state_dist_dev;
    public double event_dist_min;
    public double event_dist_max;
    public double event_dist_avg;
    public double event_dist_dev;
    public double estimated_branching_factor;
    public Graph pcg;
    public Graph mst;
    public Topology wto;

    public static void printHeader() {
        JDDConsole.out.println(fields);
    }

    public void print() {
        JDDConsole.out.print(this.internal_name + "\t" + this.num_automata + "\t" + this.num_events + "\t" + this.g_num_island + "\t" + this.max_states + "\t");
        JDDConsole.out.print(this.state_dist_min + "\t" + this.state_dist_max + "\t" + this.state_dist_avg + "\t" + this.state_dist_dev + "\t");
        JDDConsole.out.print(this.event_dist_min + "\t" + this.event_dist_max + "\t" + this.event_dist_avg + "\t" + this.event_dist_dev + "\t");
        JDDConsole.out.print(this.g_num_edges + "\t" + this.g_sum_weight + "\t");
        JDDConsole.out.print(this.g_mst_edges + "\t" + this.g_mst_weight + "\t");
        JDDConsole.out.print(this.g_vcnodes_mdg + "\t" + this.g_vcnodes_ed + "\t");
        JDDConsole.out.print(this.level1_dep_min + "\t" + this.level1_dep_max + "\t" + this.level1_dep_avg + "\t" + this.level1_dep_dev + "\t" + this.level1_dep_min_name + "\t" + this.level1_dep_max_name + "\t");
        JDDConsole.out.print(this.level2_dep_min + "\t" + this.level2_dep_max + "\t" + this.level2_dep_avg + "\t" + this.level2_dep_dev + "\t" + this.level2_dep_min_name + "\t" + this.level2_dep_max_name + "\t");
        JDDConsole.out.print(this.event_prob_min + "\t" + this.event_prob_max + "\t" + this.event_prob_avg + "\t" + this.event_prob_dev + "\t" + this.level2_dep_min_name + "\t" + this.event_prob_max_name + "\t");
        JDDConsole.out.print("" + this.estimated_branching_factor);
        JDDConsole.out.println();
    }

    public void printOne() {
        JDDConsole.out.println("Name: " + this.internal_name + ", " + this.num_automata + " automata with " + this.num_events + " events, max states: " + this.max_states);
        JDDConsole.out.println("State distribution: " + Digits.getWithDecimals(this.state_dist_min, 2) + "/" + Digits.getWithDecimals(this.state_dist_avg, 2) + "/" + Digits.getWithDecimals(this.state_dist_max, 2) + ", std-dev: " + this.state_dist_dev);
        JDDConsole.out.println("Event distribution: " + Digits.getWithDecimals(this.event_dist_min, 2) + "/" + Digits.getWithDecimals(this.event_dist_avg, 2) + "/" + Digits.getWithDecimals(this.event_dist_max, 2) + ", std-dev: " + this.event_dist_dev);
        JDDConsole.out.println("PCG: " + this.g_num_edges + " edges, weight-sum = " + this.g_sum_weight + ", components: " + this.g_num_island);
        JDDConsole.out.println("PCG-MST: " + Digits.getPercent(this.g_mst_edges) + "% edges, weight = " + this.g_mst_weight);
        JDDConsole.out.println("PCG-vertex cover: " + Digits.getPercent(this.g_vcnodes_mdg) + "% nodes with MDG and " + Digits.getPercent(this.g_vcnodes_ed) + "% nodes with ED heuristics");
        JDDConsole.out.println("LD1-dep: " + Digits.getPercent(this.level1_dep_min) + "/" + Digits.getPercent(this.level1_dep_avg) + "/" + Digits.getPercent(this.level1_dep_max) + "%, std-dev: " + this.level1_dep_dev);
        JDDConsole.out.println("LD2-dep: " + Digits.getPercent(this.level2_dep_min) + "/" + Digits.getPercent(this.level2_dep_avg) + "/" + Digits.getPercent(this.level2_dep_max) + "%, std-dev: " + this.level2_dep_dev);
        JDDConsole.out.println("Event-probability: " + Digits.getPercent(this.event_prob_min) + "/" + Digits.getPercent(this.event_prob_avg) + "/" + Digits.getPercent(this.event_prob_max) + "%, std-dev: " + this.event_prob_dev);
        JDDConsole.out.println("Estimated branching-factor: " + this.estimated_branching_factor);
        JDDConsole.out.println();
    }
}

