/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd.debug;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.LinkedList;
import jdd.bdd.CacheBase;
import jdd.bdd.NodeTable;
import jdd.bdd.debug.BDDDebuger;
import jdd.util.JDDConsole;
import jdd.util.PrintTarget;
import jdd.util.TextAreaTarget;

public class BDDDebugFrame
extends Frame
implements WindowListener,
Runnable,
BDDDebuger {
    private static final int SLEEP_TIME = 1000;
    private NodeTable nodetable;
    private Thread thread;
    private boolean stop;
    private LinkedList list;
    private Label status;
    private TextArea statistics;

    public BDDDebugFrame(NodeTable nodeTable) {
        super("[BDD Profiler]");
        this.nodetable = nodeTable;
        Collection collection = nodeTable.addDebugger(this);
        this.list = new LinkedList();
        Panel panel = new Panel(new GridLayout(3, Math.max(1, collection.size() / 3), 5, 5));
        for (CacheBase cacheBase : collection) {
            CacheFrame cacheFrame = new CacheFrame(cacheBase);
            panel.add(cacheFrame);
            this.list.add(cacheFrame);
        }
        this.add((Component)panel, "Center");
        this.status = new Label("");
        this.add((Component)this.status, "South");
        this.statistics = new TextArea(10, 80);
        this.add((Component)this.statistics, "North");
        this.statistics.setEditable(false);
        this.statistics.setVisible(false);
        this.addWindowListener(this);
        this.pack();
        this.pack();
        this.setVisible(true);
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        long l = 0L;
        while (!this.stop) {
            try {
                Thread.sleep(1000L);
                this.status.setText("Update " + ++l);
                for (CacheFrame cacheFrame : this.list) {
                    cacheFrame.repaint();
                }
            }
            catch (Exception exception) {
            }
        }
        this.status.setText("stopped");
    }

    @Override
    public void stop() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.statistics.setVisible(true);
        this.pack();
        this.pack();
        TextAreaTarget textAreaTarget = new TextAreaTarget(this.statistics);
        PrintTarget printTarget = JDDConsole.out;
        JDDConsole.out = textAreaTarget;
        JDDConsole.out.println("\nPackage statistics:\n==================\n");
        this.nodetable.showStats();
        JDDConsole.out = printTarget;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stop = true;
        this.setVisible(false);
        this.dispose();
    }

    private class MiniGraph {
        private static final int GRAPH_HEIGH = 40;
        private int[] memory;
        private int current;
        private int size;
        private int last;
        private double min;
        private double max;

        public MiniGraph(int n, double d, double d2) {
            this.size = n;
            this.current = 0;
            if (d == d2) {
                d2 += 1.0;
            }
            this.memory = new int[n];
            this.min = d;
            this.max = d2;
            for (int i = 0; i < n; ++i) {
                this.memory[i] = -1;
            }
        }

        public void add(double d) {
            this.last = (int)(0.5 + (d - this.min) * 100.0 / (this.max - this.min));
            d = (d - this.min) * 40.0 / (this.max - this.min);
            this.current = (this.current + 1) % this.size;
            this.memory[this.current] = 40 - (int)d;
        }

        public void draw(Graphics graphics, int n, int n2) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n, n2, this.size, 40);
            graphics.setColor(Color.blue);
            int n3 = this.current;
            n += this.size - 1;
            for (int i = 0; i < this.size; ++i) {
                int n4 = this.memory[n3];
                if (n4 >= 0 & n4 <= 40) {
                    graphics.drawLine(n, n2 + n4, n, n2 + n4 + 1);
                }
                --n;
                if (--n3 != -1) continue;
                n3 = this.size - 1;
            }
            graphics.setColor(Color.black);
            graphics.drawString("" + this.last, n + 5, n2 + 25);
        }
    }

    private class CacheFrame
    extends Canvas {
        private CacheBase cb;
        private MiniGraph g1;
        private MiniGraph g2;

        public CacheFrame(CacheBase cacheBase) {
            this.cb = cacheBase;
            this.g1 = new MiniGraph(95, 0.0, 100.0);
            this.g2 = new MiniGraph(95, 0.0, 100.0);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 90);
        }

        @Override
        public void paint(Graphics graphics) {
            int n = this.getHeight();
            int n2 = this.getWidth();
            graphics.drawRect(1, 1, n2 - 2, n - 2);
            long l = this.cb.getAccessCount();
            if (l == 0L) {
                graphics.drawString(this.cb.getName() + " unused.", 20, 30);
            } else {
                graphics.drawString(this.cb.getName() + ", SIZE=" + this.cb.getCacheSize(), 5, 12);
                graphics.drawString("Load factor and hitrate:", 5, 24);
                this.g1.add(this.cb.computeLoadFactor());
                this.g1.draw(graphics, 3, 28);
                this.g2.add(this.cb.computeHitRate());
                this.g2.draw(graphics, 103, 28);
                graphics.drawString("Acss=" + l + ", CLRS=" + this.cb.getNumberOfClears() + "/" + this.cb.getNumberOfPartialClears(), 5, 85);
            }
        }
    }
}

