/*
 * Decompiled with CFR 0.152.
 */
package jdd.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jdd.applet.QueensBoard;
import jdd.examples.BDDQueens;
import jdd.examples.Queens;
import jdd.examples.SATQueens;
import jdd.examples.ZDDCSPQueens;
import jdd.examples.ZDDQueens;
import jdd.sat.dpll.DPLLSolver;
import jdd.sat.gsat.GSAT2Solver;
import jdd.util.JDDConsole;
import jdd.util.Options;
import jdd.util.TextAreaTarget;

public class QueensApplet
extends Applet
implements ActionListener {
    private TextArea msg;
    private Button bSolve;
    private Button bClear;
    private Choice cSize;
    private Choice cSolver;
    private Checkbox cbVerbose;

    public QueensApplet() {
        Color color = new Color(224, 224, 224);
        this.setBackground(color);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new FlowLayout(0));
        panel.setBackground(color);
        this.add((Component)panel, "North");
        this.bSolve = new Button("Solve!");
        panel.add(this.bSolve);
        this.bClear = new Button("Clear");
        panel.add(this.bClear);
        panel.add(new Label("        N = "));
        this.cSize = new Choice();
        panel.add(this.cSize);
        for (int i = 4; i < 14; ++i) {
            this.cSize.add("" + i);
        }
        this.cSize.select(5);
        panel.add(new Label("        Solver: "));
        this.cSolver = new Choice();
        panel.add(this.cSolver);
        this.cSolver.add("BDD");
        this.cSolver.add("ZDD");
        this.cSolver.add("ZDD-CSP");
        this.cSolver.add("GSAT");
        this.cSolver.add("DPLL");
        this.cbVerbose = new Checkbox("Verbose");
        panel.add(this.cbVerbose);
        this.msg = new TextArea(10, 80);
        this.add((Component)this.msg, "Center");
        this.msg.setEditable(false);
        this.msg.setBackground(color);
        this.bSolve.addActionListener(this);
        this.bClear.addActionListener(this);
        JDDConsole.out = new TextAreaTarget(this.msg);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bSolve) {
            this.doSolve();
        } else if (object == this.bClear) {
            this.doClear();
        }
    }

    private void doClear() {
        this.msg.setText("");
    }

    private Queens getSolver(int n) {
        JDDConsole.out.println("Loading solver '" + this.cSolver.getSelectedItem() + "'...");
        int n2 = this.cSolver.getSelectedIndex();
        switch (n2) {
            case 0: {
                return new BDDQueens(n);
            }
            case 1: {
                return new ZDDQueens(n);
            }
            case 2: {
                return new ZDDCSPQueens(n);
            }
            case 3: {
                return new SATQueens(n, new GSAT2Solver(5000L));
            }
            case 4: {
                return new SATQueens(n, new DPLLSolver(5000L));
            }
        }
        return null;
    }

    private void doSolve() {
        try {
            int n = Integer.parseInt(this.cSize.getSelectedItem());
            Options.verbose = this.cbVerbose.getState();
            Queens queens = this.getSolver(n);
            boolean[] blArray = queens.getOneSolution();
            JDDConsole.out.println("" + queens.numberOfSolutions() + " solutions /" + queens.getTime() + "ms");
            if (blArray != null) {
                new QueensBoard(blArray);
            }
        }
        catch (Exception exception) {
            JDDConsole.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
        }
    }
}

