/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BitFixer;
import bits.BooleanLiteral;
import bits.BooleanVariable;
import bits.Clause;
import bits.Conjunction;
import bits.Disjunction;
import bits.EquivalenceRelation;
import bits.IBitString;
import bits.IBooleanLiteral;
import bits.IBooleanVariable;
import bits.IClause;
import bits.INaturalNumber;
import bits.IProblem;
import bits.KSatReader;
import bits.exceptions.ClauseException;
import bits.exceptions.ProblemException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ISolver;

public class Problem
implements IProblem {
    private static int problemCount;
    private static PrintStream stream;
    private List<IClause> backing = new ArrayList<IClause>();

    static {
        stream = System.out;
    }

    public static ISolver defaultSolver() {
        return SolverFactory.newMiniSATHeap();
    }

    public static IProblem newProblem() {
        return new Problem();
    }

    public static IProblem randomProblem(IBooleanVariable[] bv, int n) throws Exception {
        Problem p = new Problem();
        int i = 0;
        while (i < n) {
            p.addClause(Clause.randomClause(bv));
            ++i;
        }
        i = 0;
        while (i < p.numberOfClauses()) {
            if (p.getClause(i).isEmpty()) {
                p.removeClause(i);
            }
            ++i;
        }
        return p;
    }

    public static IProblem trivialProblem() throws Exception {
        return new Problem(new IClause[1]);
    }

    public static IProblem unsolvableProblem() throws Exception {
        return new Problem(new IClause[]{new Clause()});
    }

    public Problem() {
    }

    public Problem(IClause[] clause) throws Exception {
        this.setClauses(clause);
    }

    public Problem(IProblem iproblem) throws Exception {
        this.setClauses(iproblem.getClauses());
    }

    public Problem(List<IClause> v) throws Exception {
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                IClause o = v.get(i);
                if (o instanceof IClause) {
                    IClause c = o;
                    this.addClause(c);
                }
                ++i;
            }
        }
    }

    public void add(IClause currcl) {
        this.getClauses().add(currcl);
    }

    @Override
    public boolean addClause(IClause c) throws Exception {
        if (c == null) {
            return false;
        }
        if (!this.contains(c)) {
            this.backing.add(c);
            return true;
        }
        return false;
    }

    @Override
    public void addClauseVoid(IClause c) throws Exception {
        this.addClause(c);
    }

    public void addClauseVoid(IClause[] c) throws Exception {
        if (c == null || c.length == 0) {
            return;
        }
        int i = 0;
        while (i < c.length) {
            this.addClause(c[i]);
            ++i;
        }
    }

    @Override
    public IProblem and(IProblem p) throws Exception {
        return new Conjunction(this, p);
    }

    public EquivalenceRelation buildEquivalenceRelation() {
        EquivalenceRelation e = new EquivalenceRelation();
        int i = 0;
        while (i < this.numberOfClauses()) {
            IBooleanVariable[] objary = this.getClause(i).getBooleanVariables();
            int j = 0;
            while (j < objary.length) {
                int k = 0;
                while (k < objary.length) {
                    e.add(objary[j], objary[k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return e;
    }

    public Object clone() {
        List<IClause> cobj = this.getClauses();
        Problem res = null;
        try {
            res = new Problem(cobj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public IProblem combineSinglyMatchingClauses() throws Exception {
        int psize = this.size();
        IProblem ret = Problem.newProblem();
        int i = 0;
        while (i < psize) {
            IClause clausei = this.getClause(i);
            boolean newclausecreated = false;
            int j = 0;
            while (j < psize) {
                IClause clausej = this.getClause(j);
                IBooleanLiteral diff = ((Clause)clausei).differsSinglyFrom(clausej);
                if (diff != null) {
                    IClause newclause = (IClause)clausei.clone();
                    newclause.remove(diff);
                    ret.addClause(newclause);
                    newclausecreated = true;
                }
                ++j;
            }
            if (!newclausecreated) {
                ret.addClause(clausei);
            }
            ++i;
        }
        return ret;
    }

    public IProblem compress() throws Exception {
        IProblem contender;
        IProblem latest = this;
        while ((contender = latest.compress0()).size() != latest.size()) {
            latest = contender;
        }
        return latest;
    }

    private IProblem compress0() throws Exception {
        IProblem reduction1 = this.compressReductionPass();
        Problem reducedProblem1 = new Problem();
        for (IClause curr1 : this) {
            IClause dominatedBy = null;
            for (IClause curr2 : reduction1) {
                if (!((Clause)curr2).dominates(curr1)) continue;
                dominatedBy = curr2;
                break;
            }
            if (dominatedBy != null) {
                reducedProblem1.addClause(dominatedBy);
                continue;
            }
            reducedProblem1.addClause(curr1);
        }
        return reducedProblem1;
    }

    private IProblem compressReductionPass() throws Exception {
        Problem reduction = new Problem();
        int i = 0;
        while (i < this.size()) {
            Clause c1 = (Clause)this.getClause(i);
            int j = i + 1;
            while (j < this.size()) {
                IClause c2 = this.getClause(j);
                if (c1.differsSinglyFrom(c2) != null) {
                    reduction.addClause(c1.intersection(c2));
                }
                ++j;
            }
            ++i;
        }
        return reduction;
    }

    @Override
    public boolean contains(IClause c) throws Exception {
        if (c == null) {
            return false;
        }
        int i = 0;
        while (i < this.numberOfClauses()) {
            IClause curr = this.getClause(i);
            if (curr != null && curr.equals(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAnEmptyClause() {
        int i = 0;
        while (i < this.numberOfClauses()) {
            if (this.getClause(i).isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IProblem eliminateComplementaryPairClauses() throws Exception {
        IProblem dup = Problem.newProblem();
        int i = 0;
        while (i < this.numberOfClauses()) {
            IClause c = this.getClause(i);
            boolean removeClause = false;
            int j = 0;
            while (j < c.size()) {
                IBooleanLiteral ib = c.getLiteralAt(j);
                if (c.contains(ib.complement())) {
                    removeClause = true;
                    break;
                }
                ++j;
            }
            if (!removeClause) {
                dup.addClause(c);
            }
            ++i;
        }
        return dup;
    }

    public void eliminateEmptyClauses() {
        int n = 0;
        while (n < this.size()) {
            if (this.getClause(n).isEmpty()) {
                this.removeClause(n);
            }
            ++n;
        }
    }

    public boolean equals(List<IBooleanLiteral> p) {
        if (!(p instanceof List)) {
            return false;
        }
        return this.getClauses().containsAll(p) && p.containsAll((Collection)((Object)this));
    }

    public ArrayList<IBooleanLiteral> findModel() throws Exception {
        return this.findModel(Problem.defaultSolver());
    }

    public ArrayList<IBooleanLiteral> findModel(ISolver solver) throws Exception {
        KSatReader reader = new KSatReader(solver);
        org.sat4j.specs.IProblem sat4jproblem = reader.parseInstance(this);
        if (!sat4jproblem.isSatisfiable()) {
            return new ArrayList<IBooleanLiteral>();
        }
        ArrayList<IBooleanLiteral> rl = reader.toBooleanLiterals(sat4jproblem.model());
        IProblem test = this.resolve(rl);
        if (test.size() > 0) {
            return new ArrayList<IBooleanLiteral>();
        }
        return rl;
    }

    public List<IBooleanLiteral> findModelList() throws Exception {
        return this.findModelList(Problem.defaultSolver());
    }

    @Override
    public List<IBooleanLiteral> findModelList(ISolver s) throws Exception {
        return this.findModel(s);
    }

    public ArrayList<?>[] findTwoModels(IBitString b) throws Exception {
        return this.findTwoModels(b.getBVArray());
    }

    @Override
    public ArrayList<?>[] findTwoModels(IBooleanVariable b) throws Exception {
        ArrayList[] res = new ArrayList[2];
        if (!this.getBooleanVariables().contains(b)) {
            throw new ProblemException("The given IProblem does not depend upon the given IBooleanVariable.");
        }
        Conjunction p1 = new Conjunction(this, new BitFixer(b, false));
        Conjunction p2 = new Conjunction(this, new BitFixer(b, true));
        res[0] = (ArrayList)p1.findModel(Problem.defaultSolver());
        res[1] = (ArrayList)p2.findModel(Problem.defaultSolver());
        return res;
    }

    public ArrayList<?>[] findTwoModels(IBooleanVariable b, IProblem problem) throws Exception {
        return new Conjunction(this, problem).findTwoModels(b);
    }

    public ArrayList<?>[] findTwoModels(IBooleanVariable[] b) throws Exception {
        IProblem[] res = new IProblem[b.length];
        int i = 0;
        while (i < res.length) {
            ArrayList<?>[] ret = this.findTwoModels(b[i]);
            if (ret != null & ret.length == 2 && ret[0] != null && ret[0].size() > 0 && ret[1] != null && ret[1].size() > 0) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<?>[] findTwoModels(INaturalNumber n) throws Exception {
        return this.findTwoModels(n.getBVArray());
    }

    @Override
    public ArrayList<IBooleanVariable> getBooleanVariables() throws Exception {
        ArrayList<IBooleanVariable> hs = new ArrayList<IBooleanVariable>();
        int i = 0;
        while (i < this.numberOfClauses()) {
            IClause curr = this.getClause(i);
            if (curr != null) {
                IBooleanVariable[] currObjArray = curr.getBooleanVariables();
                int j = 0;
                while (j < currObjArray.length) {
                    if (!hs.contains(currObjArray[j])) {
                        hs.add(currObjArray[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return hs;
    }

    @Override
    public IClause getClause(int n) {
        return this.backing.get(n);
    }

    @Override
    public List<IClause> getClauses() {
        return this.backing;
    }

    public PrintStream getStream() {
        return stream;
    }

    public boolean isEmpty() {
        return this.numberOfClauses() == 0;
    }

    public boolean isSatisfied() {
        int i = 0;
        while (i < this.numberOfClauses()) {
            if (!this.getClause(i).isSatisfied()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Iterator<IClause> iterator() {
        return this.getClauses().iterator();
    }

    public IBooleanVariable newBooleanVariable() throws Exception {
        return BooleanVariable.getBooleanVariable();
    }

    @Override
    public int numberOfClauses() {
        return this.backing.size();
    }

    public int occurrences(IBooleanLiteral bl) throws Exception {
        int count = 0;
        int i = 0;
        while (i < this.numberOfClauses()) {
            IClause c = this.getClause(i);
            int j = 0;
            while (j < c.size()) {
                IBooleanLiteral bq = c.getLiteralAt(j);
                if (bl.equals(bq)) {
                    ++count;
                }
                ++j;
            }
            ++i;
        }
        return count;
    }

    public IProblem or(IProblem p) throws Exception {
        return new Disjunction(this, p);
    }

    public IProblem or(IProblem pfalse, IBooleanVariable b) throws Exception {
        return new Disjunction((IProblem)this, pfalse, b);
    }

    public void removeAllClauses() {
        this.getClauses().clear();
    }

    @Override
    public void removeClause(int n) {
        this.getClauses().remove(n);
    }

    public IProblem resolve(IBooleanVariable b, boolean value) throws Exception {
        IClause[] c = new IClause[this.numberOfClauses()];
        int i = 0;
        while (i < this.numberOfClauses()) {
            c[i] = this.getClause(i).resolve(b, value);
            ++i;
        }
        IProblem ret = Problem.newProblem();
        ret.setClauses(c);
        return ret;
    }

    @Override
    public IProblem resolve(List<IBooleanLiteral> ib) throws Exception {
        IProblem res = (IProblem)this.clone();
        int i = 0;
        while (i < res.numberOfClauses()) {
            IClause c = res.getClause(i);
            int j = 0;
            while (j < ib.size()) {
                if (c == null) break;
                IBooleanLiteral ibcurr = ib.get(j);
                IClause newcl = null;
                try {
                    newcl = c.resolve(ibcurr.getBooleanVariable(), !ibcurr.isBarred());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                c = newcl;
                ++j;
            }
            res.setClause(i, c);
            ++i;
        }
        int pos = 0;
        while (pos < res.size()) {
            if (res.getClause(pos) != null) {
                ++pos;
                continue;
            }
            res.removeClause(pos);
        }
        return res;
    }

    @Override
    public void setClause(int n, IClause cl) {
        this.getClauses().set(n, cl);
    }

    @Override
    public void setClauses(IClause[] c) throws Exception {
        if (c == null || c.length == 0) {
            return;
        }
        this.backing = Arrays.asList(c);
    }

    public void setClauses(List<IClause> list) throws Exception {
        this.removeAllClauses();
        if (list != null) {
            this.backing = list;
        }
    }

    public void setStream(PrintStream stream) {
        Problem.stream = stream;
    }

    @Override
    public int size() {
        return this.getClauses().size();
    }

    @Override
    public boolean solve(ISolver solver) throws Exception {
        List s = this.findModel(solver);
        if (s != null && s.size() > 0) {
            BooleanLiteral.interpret(s);
            return true;
        }
        return false;
    }

    public List<IBooleanLiteral> solveList() throws Exception {
        if (this.isEmpty()) {
            throw new ProblemException("Empty IProblem was passed to method solveList.");
        }
        return this.findModel();
    }

    @Override
    public void sort() throws Exception {
        Object[] ary = this.getClauses().toArray(new IClause[0]);
        Arrays.sort(ary);
        this.setClauses((IClause[])ary);
    }

    public IProblem substitute(IBooleanVariable b, boolean value) throws Exception {
        ArrayList<IClause> h = new ArrayList<IClause>();
        int i = 0;
        while (i < this.numberOfClauses()) {
            IClause cr = this.getClause(i).resolve(b, value);
            if (cr != null && !cr.isMemberOf(h)) {
                h.add(cr);
            }
            ++i;
        }
        Problem res = new Problem();
        Iterator it = h.iterator();
        while (it.hasNext()) {
            res.addClause((IClause)it.next());
        }
        if (res.numberOfClauses() > 0) {
            return res;
        }
        return null;
    }

    public IProblem substitute(Map<IBooleanLiteral, IBooleanLiteral> h) throws Exception {
        int i = 0;
        while (i < this.numberOfClauses()) {
            IClause c = this.getClause(i);
            ((Clause)c).substitute(h);
            ++i;
        }
        return this;
    }

    public IProblem substitute(Object[] b) throws Exception {
        IProblem res = (IProblem)this.clone();
        int i = 0;
        while (i < res.numberOfClauses()) {
            IClause c = res.getClause(i);
            IClause newc = (IClause)c.clone();
            int j = 0;
            while (j < b.length) {
                if (newc == null) break;
                newc = newc.resolve((IBooleanLiteral)b[j]);
                ++j;
            }
            res.setClause(i, newc);
            ++i;
        }
        return res;
    }

    public String toCode() throws ClauseException {
        if (this.size() < 1) {
            return null;
        }
        String ret = ((Clause)this.getClause(0)).toCode();
        int i = 1;
        while (i < this.size()) {
            IClause curr = this.getClause(i);
            ret = String.valueOf(ret) + "+" + curr.toCode();
            ++i;
        }
        return ret;
    }

    public long toFile(String s) {
        File f = new File(s);
        PrintStream fos = null;
        try {
            f.createNewFile();
            fos = new PrintStream(new FileOutputStream(f));
            fos.println(this.toString());
            fos.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return f.length();
    }

    public String toSatSimTable() throws Exception {
        IBooleanLiteral currentLiteral;
        String ret = "{";
        int clauseindex = 0;
        while (clauseindex < this.numberOfClauses() - 1) {
            IClause currentClause = this.getClause(clauseindex);
            ret = String.valueOf(ret) + "{";
            int literalindex = 0;
            while (literalindex < currentClause.size() - 1) {
                IBooleanLiteral currentLiteral2 = currentClause.getLiteralAt(literalindex);
                ret = String.valueOf(ret) + "{" + (currentLiteral2.isBarred() ? 1 : 0) + "," + currentLiteral2.getBooleanVariable().getName().toString() + "},";
                ++literalindex;
            }
            currentLiteral = currentClause.getLiteralAt(currentClause.size() - 1);
            ret = String.valueOf(ret) + "{" + (currentLiteral.isBarred() ? 1 : 0) + "," + currentLiteral.getBooleanVariable().getName().toString() + "}},";
            ++clauseindex;
        }
        IClause currentClause = this.getClause(this.numberOfClauses() - 1);
        ret = String.valueOf(ret) + "{";
        int literalindex = 0;
        while (literalindex < currentClause.size() - 1) {
            currentLiteral = currentClause.getLiteralAt(literalindex);
            ret = String.valueOf(ret) + "{" + (currentLiteral.isBarred() ? 1 : 0) + "," + currentLiteral.getBooleanVariable().getName().toString() + "},";
            ++literalindex;
        }
        IBooleanLiteral currentLiteral3 = currentClause.getLiteralAt(currentClause.size() - 1);
        ret = String.valueOf(ret) + "{" + (currentLiteral3.isBarred() ? 1 : 0) + "," + currentLiteral3.getBooleanVariable().getName().toString() + "}}}";
        ret = ret.replaceAll("$", "");
        ret = ret.replaceAll("\\$", "");
        ret = ret.replaceAll("_", "");
        ret = ret.replaceAll("$", "");
        ret = ret.replaceAll("-", "");
        return ret;
    }

    public String toString() {
        String res = "***************************************";
        res = String.valueOf(res) + "\n*** IProblem-" + problemCount++;
        res = String.valueOf(res) + "\n***************************************";
        int i = 0;
        while (i < this.numberOfClauses()) {
            res = this.getClause(i) != null ? String.valueOf(res) + "\n*** \t" + this.getClause(i).toString() : String.valueOf(res) + "\n*** \tnull";
            ++i;
        }
        res = String.valueOf(res) + "\n***************************************";
        res = String.valueOf(res) + "\n*****\t" + this.numberOfClauses() + " clauses generated.";
        res = String.valueOf(res) + "\n***************************************";
        return res;
    }

    public IProblem toThreeSatProblem() throws Exception {
        if (this.size() == 0) {
            return this;
        }
        IProblem problem = null;
        if (this.getClause(0) != null) {
            problem = ((Clause)this.getClause(0)).ThreeSATProblem();
        }
        int i = 1;
        while (i < this.size()) {
            if (this.getClause(i) != null) {
                problem = new Conjunction(problem, ((Clause)this.getClause(i)).ThreeSATProblem());
            }
            ++i;
        }
        return problem;
    }

    @Override
    public String toXML() {
        String res = "<Problem>\n";
        int i = 0;
        while (i < this.numberOfClauses()) {
            res = String.valueOf(res) + "\t<Clause>\n";
            IBooleanLiteral[] obary = this.getClause(i).toArray();
            int j = 0;
            while (j < obary.length) {
                IBooleanLiteral b = obary[j];
                res = String.valueOf(res) + "\t\t<Literal variable=\"" + b.getBooleanVariable().getName() + "\" barred=\"";
                res = b.isBarred() ? String.valueOf(res) + "true\"/>\n" : String.valueOf(res) + "false\"/>\n";
                ++j;
            }
            res = String.valueOf(res) + "\t</Clause>\n";
            ++i;
        }
        res = String.valueOf(res) + "</Problem>";
        return res;
    }

    public long toXML(String filename) {
        File f = new File(filename);
        PrintStream fos = null;
        try {
            f.createNewFile();
            fos = new PrintStream(new FileOutputStream(f));
            fos.println(this.toXML());
            fos.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return f.length();
    }

    public IProblem unsatisfiedProblem() throws Exception {
        int clauses = this.numberOfClauses();
        if (clauses == 0) {
            return Problem.unsolvableProblem();
        }
        IProblem p = ((Clause)this.getClause(0)).unsatisfiedClause();
        int cl = 1;
        while (cl < clauses) {
            IProblem curr = ((Clause)this.getClause(cl)).unsatisfiedClause();
            p = new Disjunction(p, curr);
            ++cl;
        }
        return p;
    }
}

