/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BooleanVariable;
import bits.Conjunction;
import bits.IBooleanVariable;
import bits.IClause;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.DisjunctionException;
import java.util.ArrayList;
import java.util.List;

public class Disjunction
extends Problem
implements IProblem {
    private static IProblem or(IProblem ptrue, IProblem pfalse, IBooleanVariable b) throws Exception {
        if (pfalse == null) {
            return Disjunction.or(new IProblem[]{ptrue}, new IBooleanVariable[]{b});
        }
        if (ptrue == null) {
            return Disjunction.or(new IProblem[]{pfalse}, new IBooleanVariable[]{b});
        }
        List<IClause> clfalse = pfalse.getClauses();
        ArrayList<IClause> clfalseNew = new ArrayList<IClause>();
        int i = 0;
        while (i < clfalse.size()) {
            IClause q0 = clfalse.get(i);
            IClause q1 = (IClause)q0.clone();
            IClause q2 = q1.or(b);
            clfalseNew.add(q2);
            ++i;
        }
        List<IClause> cltrue = ptrue.getClauses();
        ArrayList<IClause> cltrueNew = new ArrayList<IClause>();
        int i2 = 0;
        while (i2 < cltrue.size()) {
            IClause q0 = cltrue.get(i2);
            IClause q1 = (IClause)q0.clone();
            IClause q2 = q1.orNot(b);
            cltrueNew.add(q2);
            ++i2;
        }
        return new Conjunction(new Problem(clfalseNew), new Problem(cltrueNew));
    }

    private static IProblem or(IProblem[] problemArray) throws Exception {
        if (problemArray == null) {
            throw new DisjunctionException("Null IProblem array passed to or method.");
        }
        int n = problemArray.length;
        if (n == 0) {
            throw new DisjunctionException("IProblem array of zero length passed to or method.");
        }
        if (n == 1) {
            return problemArray[0];
        }
        if (n > 1) {
            IBooleanVariable[] b = new IBooleanVariable[n - 1];
            int i = 0;
            while (i < b.length) {
                b[i] = BooleanVariable.getBooleanVariable();
                ++i;
            }
            return Disjunction.or(problemArray, b);
        }
        return null;
    }

    private static IProblem or(IProblem[] problemArray, IBooleanVariable[] booleanVariableArray) throws Exception {
        if (problemArray == null) {
            throw new DisjunctionException("Null IProblem array passed to or method.");
        }
        if (booleanVariableArray == null) {
            throw new DisjunctionException("Null IBooleanVariable array passed to or method.");
        }
        int numberOfProblems = problemArray.length;
        if (numberOfProblems == 0) {
            throw new DisjunctionException("IProblem array of zero length passed to or method.");
        }
        if (numberOfProblems == 1) {
            return problemArray[0];
        }
        if (numberOfProblems != booleanVariableArray.length + 1) {
            throw new DisjunctionException("problemArray.length != booleanVariableArray.length + 1");
        }
        if (numberOfProblems > 1) {
            IProblem[] r = new IProblem[numberOfProblems - 1];
            r[numberOfProblems - 2] = Disjunction.or(problemArray[numberOfProblems - 2], problemArray[numberOfProblems - 1], booleanVariableArray[numberOfProblems - 2]);
            int i = numberOfProblems - 3;
            while (i >= 0) {
                r[i] = Disjunction.or(problemArray[i], r[i + 1], booleanVariableArray[i]);
                --i;
            }
            return r[0];
        }
        return null;
    }

    public Disjunction(IProblem p) throws Exception {
        this(new IProblem[]{p});
    }

    public Disjunction(IProblem p1, IProblem p2) throws Exception {
        this(new IProblem[]{p1, p2});
    }

    public Disjunction(IProblem ptrue, IProblem pfalse, IBooleanVariable b) throws Exception {
        IProblem p = Disjunction.or(ptrue, pfalse, b);
        if (p != null) {
            this.setClauses(p.getClauses());
        }
    }

    public Disjunction(IProblem p1, IProblem p2, IProblem p3) throws Exception {
        this(new IProblem[]{p1, p2, p3});
    }

    public Disjunction(IProblem p1, IProblem p2, IProblem p3, IProblem p4) throws Exception {
        this(new IProblem[]{p1, p2, p3, p4});
    }

    public Disjunction(IProblem[] problemArray) throws Exception {
        if (problemArray == null) {
            throw new DisjunctionException("Null IProblem array passed to or method.");
        }
        if (problemArray.length == 0) {
            throw new DisjunctionException("IProblem array of zero length passed to or method.");
        }
        IProblem p = Disjunction.or(problemArray);
        if (p != null) {
            this.setClauses(p.getClauses());
        }
    }

    public Disjunction(IProblem[] problemArray, IBooleanVariable[] booleanVariableArray) throws Exception {
        if (problemArray == null) {
            throw new DisjunctionException("Null IProblem array passed to constructor.");
        }
        if (problemArray.length == 0) {
            throw new DisjunctionException("IProblem array of zero length passed to constructor.");
        }
        if (booleanVariableArray == null) {
            throw new DisjunctionException("Null IBooleanVariable array passed to constructor.");
        }
        if (booleanVariableArray.length == 0) {
            throw new DisjunctionException("IBooleanVariable array of zero length passed to constructor.");
        }
        IProblem p = Disjunction.or(problemArray, booleanVariableArray);
        if (p != null) {
            this.setClauses(p.getClauses());
        }
    }
}

